/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.saml2.metadata.AffiliateMember;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.xmlsec.signature.Signature;

public class AffiliationDescriptorImpl
extends AbstractSignableSAMLObject
implements AffiliationDescriptor {
    @Nullable
    private String ownerID;
    @Nullable
    private String id;
    @Nullable
    private Instant validUntil;
    @Nullable
    private Duration cacheDuration;
    @Nullable
    private Extensions extensions;
    @Nonnull
    private final AttributeMap unknownAttributes = new AttributeMap(this);
    @Nonnull
    private final XMLObjectChildrenList<AffiliateMember> members = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<KeyDescriptor> keyDescriptors = new XMLObjectChildrenList(this);

    protected AffiliationDescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public String getOwnerID() {
        return this.ownerID;
    }

    @Override
    public void setOwnerID(@Nullable String newOwnerID) {
        if (newOwnerID != null && newOwnerID.length() > 1024) {
            throw new IllegalArgumentException("Owner ID can not exceed 1024 characters in length");
        }
        this.ownerID = this.prepareForAssignment(this.ownerID, newOwnerID);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        return Instant.now().isBefore(this.validUntil);
    }

    @Override
    @Nullable
    public Instant getValidUntil() {
        return this.validUntil;
    }

    @Override
    public void setValidUntil(@Nullable Instant theValidUntil) {
        this.validUntil = this.prepareForAssignment(this.validUntil, theValidUntil);
    }

    @Override
    @Nullable
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    @Override
    public void setCacheDuration(@Nullable Duration duration) {
        this.cacheDuration = this.prepareForAssignment(this.cacheDuration, duration);
    }

    @Override
    @Nullable
    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(@Nullable Extensions theExtensions) {
        this.extensions = this.prepareForAssignment(this.extensions, theExtensions);
    }

    @Override
    @Nonnull
    @Live
    public List<AffiliateMember> getMembers() {
        return this.members;
    }

    @Override
    @Nonnull
    @Live
    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    @Override
    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Override
    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        Signature sig = this.getSignature();
        if (sig != null) {
            children.add(sig);
        }
        if (this.extensions != null) {
            children.add(this.extensions);
        }
        children.addAll(this.getMembers());
        children.addAll(this.getKeyDescriptors());
        return CollectionSupport.copyToList(children);
    }
}

