/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.ua.UAObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DSTU4145Parameters;
import org.bouncycastle.crypto.general.DSTU4145;
import org.bouncycastle.jcajce.interfaces.DSTU4145PrivateKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145PublicKey;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DSTU4145Util;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvDSTU4145PrivateKey;
import org.bouncycastle.jcajce.provider.ProvDSTU4145PublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import org.bouncycastle.jcajce.spec.DSTU4145PrivateKeySpec;
import org.bouncycastle.jcajce.spec.DSTU4145PublicKeySpec;

class ProvDSTU4145
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.dstu4145.";
    private static final PublicKeyConverter<AsymmetricDSTU4145PublicKey> publicKeyConverter = new PublicKeyConverter<AsymmetricDSTU4145PublicKey>(){

        @Override
        public AsymmetricDSTU4145PublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
            if (publicKey instanceof DSTU4145PublicKey) {
                if (publicKey instanceof ProvDSTU4145PublicKey) {
                    return ((ProvDSTU4145PublicKey)publicKey).getBaseKey();
                }
                return new ProvDSTU4145PublicKey(algorithm, (DSTU4145PublicKey)publicKey).getBaseKey();
            }
            try {
                return new AsymmetricDSTU4145PublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw invalidKeyException;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify DSTU4145 public key: " + exception.getMessage(), exception);
            }
        }
    };
    private static final PrivateKeyConverter<AsymmetricDSTU4145PrivateKey> privateKeyConverter = new PrivateKeyConverter<AsymmetricDSTU4145PrivateKey>(){

        @Override
        public AsymmetricDSTU4145PrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
            if (privateKey instanceof DSTU4145PrivateKey) {
                if (privateKey instanceof ProvDSTU4145PrivateKey) {
                    return ((ProvDSTU4145PrivateKey)privateKey).getBaseKey();
                }
                return new ProvDSTU4145PrivateKey(algorithm, (DSTU4145PrivateKey)privateKey).getBaseKey();
            }
            try {
                return new AsymmetricDSTU4145PrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw invalidKeyException;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify DSTU4145 private key: " + exception.getMessage(), exception);
            }
        }
    };

    ProvDSTU4145() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.DSTU4145", "org.bouncycastle.jcajce.provider.asymmetric.dstu4145.KeyFactorySpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyFactorySpi();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.DSTU-4145-2002", "DSTU4145");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.DSTU4145-3410", "DSTU4145");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.DSTU4145", "org.bouncycastle.jcajce.provider.asymmetric.dstu4145.KeyPairGeneratorSpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGenerator(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.DSTU-4145", "DSTU4145");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.DSTU-4145-2002", "DSTU4145");
        this.registerOid(bouncyCastleFipsProvider, UAObjectIdentifiers.dstu4145le, "DSTU4145", new KeyFactorySpi());
        this.registerOid(bouncyCastleFipsProvider, UAObjectIdentifiers.dstu4145be, "DSTU4145", new KeyFactorySpi());
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.DSTU4145", "org.bouncycastle.jcajce.provider.asymmetric.dstu4145.SignatureSpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new DSTU4145.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, DSTU4145.DSTU4145);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.DSTU-4145", "DSTU4145");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.DSTU-4145-2002", "DSTU4145");
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "GOST3411", "DSTU4145LE", "org.bouncycastle.jcajce.provider.asymmetric.dstu4145.SignatureSpiLe", UAObjectIdentifiers.dstu4145le, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new DSTU4145.LittleEndianSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, DSTU4145.DSTU4145);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.DSTU4145LE", "GOST3411WITHDSTU4145LE");
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "GOST3411", "DSTU4145", "org.bouncycastle.jcajce.provider.asymmetric.dstu4145.SignatureSpiBe", UAObjectIdentifiers.dstu4145be, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new DSTU4145.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, DSTU4145.DSTU4145);
            }
        }));
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        @Override
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(DSTU4145PublicKeySpec.class) && key instanceof DSTU4145PublicKey) {
                DSTU4145PublicKey dSTU4145PublicKey = (DSTU4145PublicKey)key;
                return new DSTU4145PublicKeySpec(dSTU4145PublicKey.getW(), dSTU4145PublicKey.getParams());
            }
            if (clazz.isAssignableFrom(DSTU4145PrivateKeySpec.class) && key instanceof DSTU4145PrivateKey) {
                DSTU4145PrivateKey dSTU4145PrivateKey = (DSTU4145PrivateKey)key;
                return new DSTU4145PrivateKeySpec(dSTU4145PrivateKey.getS(), dSTU4145PrivateKey.getParams());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvDSTU4145PublicKey((AsymmetricDSTU4145PublicKey)publicKeyConverter.convertKey(DSTU4145.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvDSTU4145PrivateKey((AsymmetricDSTU4145PrivateKey)privateKeyConverter.convertKey(DSTU4145.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DSTU4145PrivateKeySpec) {
                return new ProvDSTU4145PrivateKey((Algorithm)DSTU4145.ALGORITHM, (DSTU4145PrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DSTU4145PublicKeySpec) {
                return new ProvDSTU4145PublicKey((Algorithm)DSTU4145.ALGORITHM, (DSTU4145PublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvDSTU4145PrivateKey(new AsymmetricDSTU4145PrivateKey((Algorithm)DSTU4145.ALGORITHM, privateKeyInfo));
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvDSTU4145PublicKey(new AsymmetricDSTU4145PublicKey((Algorithm)DSTU4145.ALGORITHM, subjectPublicKeyInfo));
        }
    }

    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private DSTU4145Parameters params;
        private AsymmetricKeyPairGenerator engine;
        private boolean initialised = false;

        public KeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("DSTU4145");
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        @Override
        public void initialize(int n) {
            this.initialize(n, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            throw new InvalidParameterException("DSTU4145 KeyPairGenerator needs to be initialized with a DSTU4145ParameterSpec");
        }

        private void init(DSTU4145ParameterSpec dSTU4145ParameterSpec, SecureRandom secureRandom) {
            this.params = DSTU4145Util.convertToECParams(dSTU4145ParameterSpec);
            this.engine = new DSTU4145.KeyPairGenerator(new DSTU4145.KeyGenParameters(this.params), secureRandom);
            this.initialised = true;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DSTU4145ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            this.init((DSTU4145ParameterSpec)algorithmParameterSpec, secureRandom);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("DSTU Key Pair Generator not initialised");
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey = (AsymmetricDSTU4145PublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvDSTU4145PublicKey(asymmetricDSTU4145PublicKey), new ProvDSTU4145PrivateKey(asymmetricDSTU4145PrivateKey));
        }
    }
}

