/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DotExpanderProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, DotExpanderProcessor> {
    @Nonnull
    private final String field;
    @Nullable
    private final String path;
    public static final JsonpDeserializer<DotExpanderProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DotExpanderProcessor::setupDotExpanderProcessorDeserializer);

    private DotExpanderProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.path = builder.path;
    }

    public static DotExpanderProcessor of(Function<Builder, ObjectBuilder<DotExpanderProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.DotExpander;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDotExpanderProcessorDeserializer(ObjectDeserializer<Builder> op) {
        DotExpanderProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.path);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DotExpanderProcessor other = (DotExpanderProcessor)o;
        return this.field.equals(other.field) && Objects.equals(this.path, other.path);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DotExpanderProcessor> {
        private String field;
        @Nullable
        private String path;

        public Builder() {
        }

        private Builder(DotExpanderProcessor o) {
            super(o);
            this.field = o.field;
            this.path = o.path;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.path = o.path;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Override
        @Nonnull
        public DotExpanderProcessor build() {
            this._checkSingleUse();
            return new DotExpanderProcessor(this);
        }
    }
}

