/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CurrentNode
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CurrentNode> {
    @Nonnull
    private final Map<String, String> attributes;
    @Nonnull
    private final String id;
    @Nonnull
    private final String name;
    @Nonnull
    private final String transportAddress;
    private final int weightRanking;
    public static final JsonpDeserializer<CurrentNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CurrentNode::setupCurrentNodeDeserializer);

    private CurrentNode(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.weightRanking = ApiTypeHelper.requireNonNull(builder.weightRanking, this, "weightRanking");
    }

    public static CurrentNode of(Function<Builder, ObjectBuilder<CurrentNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final String transportAddress() {
        return this.transportAddress;
    }

    public final int weightRanking() {
        return this.weightRanking;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.attributes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("weight_ranking");
        generator.write(this.weightRanking);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCurrentNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::weightRanking, JsonpDeserializer.integerDeserializer(), "weight_ranking");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.transportAddress.hashCode();
        result = 31 * result + Integer.hashCode(this.weightRanking);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentNode other = (CurrentNode)o;
        return this.attributes.equals(other.attributes) && this.id.equals(other.id) && this.name.equals(other.name) && this.transportAddress.equals(other.transportAddress) && this.weightRanking == other.weightRanking;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CurrentNode> {
        private Map<String, String> attributes;
        private String id;
        private String name;
        private String transportAddress;
        private Integer weightRanking;

        public Builder() {
        }

        private Builder(CurrentNode o) {
            this.attributes = Builder._mapCopy(o.attributes);
            this.id = o.id;
            this.name = o.name;
            this.transportAddress = o.transportAddress;
            this.weightRanking = o.weightRanking;
        }

        private Builder(Builder o) {
            this.attributes = Builder._mapCopy(o.attributes);
            this.id = o.id;
            this.name = o.name;
            this.transportAddress = o.transportAddress;
            this.weightRanking = o.weightRanking;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        @Nonnull
        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Nonnull
        public final Builder weightRanking(int value) {
            this.weightRanking = value;
            return this;
        }

        @Override
        @Nonnull
        public CurrentNode build() {
            this._checkSingleUse();
            return new CurrentNode(this);
        }
    }
}

