/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.RangePropertyBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DateRangeProperty
extends RangePropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, DateRangeProperty> {
    @Nullable
    private final String format;
    public static final JsonpDeserializer<DateRangeProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeProperty::setupDateRangePropertyDeserializer);

    private DateRangeProperty(Builder builder) {
        super(builder);
        this.format = builder.format;
    }

    public static DateRangeProperty of(Function<Builder, ObjectBuilder<DateRangeProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.DateRange;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "date_range");
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDateRangePropertyDeserializer(ObjectDeserializer<Builder> op) {
        DateRangeProperty.setupRangePropertyBaseDeserializer(op);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.format);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRangeProperty other = (DateRangeProperty)o;
        return Objects.equals(this.format, other.format);
    }

    public static class Builder
    extends RangePropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DateRangeProperty> {
        @Nullable
        private String format;

        public Builder() {
        }

        private Builder(DateRangeProperty o) {
            super(o);
            this.format = o.format;
        }

        private Builder(Builder o) {
            super(o);
            this.format = o.format;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Override
        @Nonnull
        public DateRangeProperty build() {
            this._checkSingleUse();
            return new DateRangeProperty(this);
        }
    }
}

