/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IcuFoldingTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, IcuFoldingTokenFilter> {
    @Nonnull
    private final String unicodeSetFilter;
    public static final JsonpDeserializer<IcuFoldingTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuFoldingTokenFilter::setupIcuFoldingTokenFilterDeserializer);

    private IcuFoldingTokenFilter(Builder builder) {
        super(builder);
        this.unicodeSetFilter = ApiTypeHelper.requireNonNull(builder.unicodeSetFilter, this, "unicodeSetFilter");
    }

    public static IcuFoldingTokenFilter of(Function<Builder, ObjectBuilder<IcuFoldingTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuFolding;
    }

    @Nonnull
    public final String unicodeSetFilter() {
        return this.unicodeSetFilter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_folding");
        super.serializeInternal(generator, mapper);
        generator.writeKey("unicode_set_filter");
        generator.write(this.unicodeSetFilter);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIcuFoldingTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        IcuFoldingTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::unicodeSetFilter, JsonpDeserializer.stringDeserializer(), "unicode_set_filter");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.unicodeSetFilter.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcuFoldingTokenFilter other = (IcuFoldingTokenFilter)o;
        return this.unicodeSetFilter.equals(other.unicodeSetFilter);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IcuFoldingTokenFilter> {
        private String unicodeSetFilter;

        public Builder() {
        }

        private Builder(IcuFoldingTokenFilter o) {
            super(o);
            this.unicodeSetFilter = o.unicodeSetFilter;
        }

        private Builder(Builder o) {
            super(o);
            this.unicodeSetFilter = o.unicodeSetFilter;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder unicodeSetFilter(String value) {
            this.unicodeSetFilter = value;
            return this;
        }

        @Override
        @Nonnull
        public IcuFoldingTokenFilter build() {
            this._checkSingleUse();
            return new IcuFoldingTokenFilter(this);
        }
    }
}

