/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

public class ExtendedBounds<T>
implements PlainJsonSerializable,
ToCopyableBuilder<Builder<T>, ExtendedBounds<T>> {
    @Nonnull
    private final T max;
    @Nonnull
    private final T min;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    private ExtendedBounds(Builder<T> builder) {
        this.max = ApiTypeHelper.requireNonNull(((Builder)builder).max, this, "max");
        this.min = ApiTypeHelper.requireNonNull(((Builder)builder).min, this, "min");
        this.tSerializer = ((Builder)builder).tSerializer;
    }

    public static <T> ExtendedBounds<T> of(Function<Builder<T>, ObjectBuilder<ExtendedBounds<T>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final T max() {
        return this.max;
    }

    @Nonnull
    public final T min() {
        return this.min;
    }

    @Nullable
    public final JsonpSerializer<T> tSerializer() {
        return this.tSerializer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max");
        JsonpUtils.serialize(this.max, generator, this.tSerializer, mapper);
        generator.writeKey("min");
        JsonpUtils.serialize(this.min, generator, this.tSerializer, mapper);
    }

    @Override
    @Nonnull
    public Builder<T> toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static <T> Builder builder() {
        return new Builder();
    }

    public static <T> JsonpDeserializer<ExtendedBounds<T>> createExtendedBoundsDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> ExtendedBounds.setupExtendedBoundsDeserializer(op, tDeserializer));
    }

    protected static <T> void setupExtendedBoundsDeserializer(ObjectDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::max, tDeserializer, "max");
        op.add(Builder::min, tDeserializer, "min");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.max.hashCode();
        result = 31 * result + this.min.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedBounds other = (ExtendedBounds)o;
        return this.max.equals(other.max) && this.min.equals(other.min);
    }

    public static class Builder<T>
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder<T>, ExtendedBounds<T>> {
        private T max;
        private T min;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public Builder() {
        }

        private Builder(ExtendedBounds<T> o) {
            this.max = ((ExtendedBounds)o).max;
            this.min = ((ExtendedBounds)o).min;
            this.tSerializer = ((ExtendedBounds)o).tSerializer;
        }

        private Builder(Builder<T> o) {
            this.max = o.max;
            this.min = o.min;
            this.tSerializer = o.tSerializer;
        }

        @Override
        @Nonnull
        public Builder<T> copy() {
            return new Builder<T>(this);
        }

        @Nonnull
        public final Builder<T> max(T value) {
            this.max = value;
            return this;
        }

        @Nonnull
        public final Builder<T> min(T value) {
            this.min = value;
            return this;
        }

        @Nonnull
        public final Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        @Nonnull
        public ExtendedBounds<T> build() {
            this._checkSingleUse();
            return new ExtendedBounds(this);
        }
    }
}

