/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.lucenelib;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenByteKnnVectorQuery;
import org.apache.lucene.search.join.DiversifyingChildrenFloatKnnVectorQuery;
import org.opensearch.knn.index.query.common.QueryUtils;
import org.opensearch.knn.index.query.lucenelib.ExpandNestedDocsQuery;
import org.opensearch.knn.index.query.lucenelib.InternalNestedKnnByteVectoryQuery;
import org.opensearch.knn.index.query.lucenelib.InternalNestedKnnFloatVectoryQuery;

public class NestedKnnVectorQueryFactory {
    public static Query createNestedKnnVectorQuery(String fieldName, byte[] vector, int k, Query filterQuery, BitSetProducer parentFilter, boolean expandNestedDocs) {
        if (expandNestedDocs) {
            return new ExpandNestedDocsQuery.ExpandNestedDocsQueryBuilder().internalNestedKnnVectorQuery(new InternalNestedKnnByteVectoryQuery(fieldName, vector, filterQuery, k, parentFilter)).queryUtils(QueryUtils.getInstance()).build();
        }
        return new DiversifyingChildrenByteKnnVectorQuery(fieldName, vector, filterQuery, k, parentFilter);
    }

    public static Query createNestedKnnVectorQuery(String fieldName, float[] vector, int k, Query filterQuery, BitSetProducer parentFilter, boolean expandNestedDocs) {
        if (expandNestedDocs) {
            return new ExpandNestedDocsQuery.ExpandNestedDocsQueryBuilder().internalNestedKnnVectorQuery(new InternalNestedKnnFloatVectoryQuery(fieldName, vector, filterQuery, k, parentFilter)).queryUtils(QueryUtils.getInstance()).build();
        }
        return new DiversifyingChildrenFloatKnnVectorQuery(fieldName, vector, filterQuery, k, parentFilter);
    }
}

