/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateClose;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateConvertIndexToRemote;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateDelete;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateForceMerge;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateIndexPriority;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateNothing;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateOpen;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateReadOnly;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateReadWrite;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateReplicaCount;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateRollover;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateSnapshot;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateStopReplication;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateTransition;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ValidationResult;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

@OpenForTesting
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ActionValidation;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getJvmService", "()Lorg/opensearch/monitor/jvm/JvmService;", "validate", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ValidationResult;", "actionName", "", "indexName", "opensearch-index-management"})
public class ActionValidation {
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final JvmService jvmService;

    public ActionValidation(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        this.settings = settings;
        this.clusterService = clusterService;
        this.jvmService = jvmService;
    }

    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public JvmService getJvmService() {
        return this.jvmService;
    }

    @NotNull
    public ValidationResult validate(@NotNull String actionName, @NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Validate validation = switch (actionName) {
            case "rollover" -> new ValidateRollover(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "delete" -> new ValidateDelete(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "force_merge" -> new ValidateForceMerge(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "open" -> new ValidateOpen(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "read_only" -> new ValidateReadOnly(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "read_write" -> new ValidateReadWrite(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "replica_count" -> new ValidateReplicaCount(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "snapshot" -> new ValidateSnapshot(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "convert_index_to_remote" -> new ValidateConvertIndexToRemote(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "transition" -> new ValidateTransition(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "close" -> new ValidateClose(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "index_priority" -> new ValidateIndexPriority(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "stop_replication" -> new ValidateStopReplication(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "notification" -> new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "shrink" -> new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "allocation" -> new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            case "rollup" -> new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
            default -> new ValidateNothing(this.getSettings(), this.getClusterService(), this.getJvmService()).execute(indexName);
        };
        return new ValidationResult(String.valueOf(validation.getValidationMessage()), validation.getValidationStatus());
    }
}

