/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.rollup;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.indexstatemanagement.step.rollup.WaitForRollupCompletionStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupAction;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupRequest;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupResponse;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/WaitForRollupCompletionStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "hasRollupFailed", "", "Ljava/lang/Boolean;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processRollupMetadataStatus", "", "rollupJobId", "indexName", "rollupMetadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "processFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "Companion", "opensearch-index-management"})
public final class WaitForRollupCompletionStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private Boolean hasRollupFailed;
    @NotNull
    public static final String name = "wait_for_rollup_completion";
    @NotNull
    public static final String JOB_STOPPED_MESSAGE = "Rollup job was stopped";

    public WaitForRollupCompletionStep() {
        super(name, false, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForRollupCompletionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                managedIndexMetadata = context.getMetadata();
                v1 = managedIndexMetadata.getActionMetaData();
                v2 = v1 != null && (v1 = v1.getActionProperties()) != null ? v1.getRollupId() : (rollupJobId = null);
                if (rollupJobId != null) ** GOTO lbl25
                this.logger.error("No rollup job id passed down");
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForRollupCompletionStep.Companion.getMissingRollupJobMessage(indexName)));
                ** GOTO lbl64
lbl25:
                // 1 sources

                explainRollupRequest = new ExplainRollupRequest(CollectionsKt.listOf((Object)rollupJobId));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = indexName;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)managedIndexMetadata);
                $continuation.L$3 = rollupJobId;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)explainRollupRequest);
                $continuation.label = 1;
                v3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, execute$lambda$0(org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((ExplainRollupRequest)explainRollupRequest), $continuation);
                ** if (v3 != var11_4) goto lbl37
lbl36:
                // 1 sources

                return var11_4;
lbl37:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                explainRollupRequest = (ExplainRollupRequest)$continuation.L$4;
                rollupJobId = (String)$continuation.L$3;
                managedIndexMetadata = (ManagedIndexMetaData)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl48:
                    // 2 sources

                    response = (ExplainRollupResponse)v3;
                    this.logger.info("Received the status for jobs [" + response.getIdsToExplain$opensearch_index_management().keySet() + "]");
                    v4 = response.getIdsToExplain$opensearch_index_management().get(rollupJobId);
                    v5 = metadata = v4 != null ? v4.getMetadata() : null;
                    if ((v5 != null ? v5.getStatus() : null) == null) {
                        this.logger.warn("Job " + rollupJobId + " has not started yet");
                        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForRollupCompletionStep.Companion.getJobProcessingMessage(rollupJobId, indexName)));
                    } else {
                        this.processRollupMetadataStatus(rollupJobId, indexName, metadata);
                    }
                }
                catch (RemoteTransportException e) {
                    this.processFailure(rollupJobId, indexName, (Exception)e);
                }
                catch (Exception e) {
                    this.processFailure(rollupJobId, indexName, e);
                }
lbl64:
                // 5 sources

                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void processRollupMetadataStatus(@NotNull String rollupJobId, @NotNull String indexName, @NotNull RollupMetadata rollupMetadata) {
        Intrinsics.checkNotNullParameter((Object)rollupJobId, (String)"rollupJobId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)rollupMetadata, (String)"rollupMetadata");
        switch (WhenMappings.$EnumSwitchMapping$0[rollupMetadata.getStatus().ordinal()]) {
            case 1: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(rollupJobId, indexName)));
                break;
            }
            case 2: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(rollupJobId, indexName)));
                break;
            }
            case 3: {
                this.stepStatus = Step.StepStatus.FAILED;
                this.hasRollupFailed = true;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)Companion.getJobFailedMessage(rollupJobId, indexName)), TuplesKt.to((Object)"cause", (Object)String.valueOf(rollupMetadata.getFailureReason()))};
                this.info = MapsKt.mapOf((Pair[])pairArray);
                break;
            }
            case 4: {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobCompletionMessage(rollupJobId, indexName)));
                break;
            }
            case 5: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(rollupJobId, indexName)));
                break;
            }
            case 6: {
                this.stepStatus = Step.StepStatus.FAILED;
                this.hasRollupFailed = true;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)Companion.getJobFailedMessage(rollupJobId, indexName)), TuplesKt.to((Object)"cause", (Object)JOB_STOPPED_MESSAGE)};
                this.info = MapsKt.mapOf((Pair[])pairArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void processFailure(@NotNull String rollupJobId, @NotNull String indexName, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)rollupJobId, (String)"rollupJobId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.stepStatus = Step.StepStatus.FAILED;
        String message = Companion.getFailedMessage(rollupJobId, indexName);
        this.logger.error(message, (Throwable)e);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData actionMetaData;
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData2 = currentActionMetaData = currentMetadata.getActionMetaData();
        ActionProperties currentActionProperties = actionMetaData2 != null ? actionMetaData2.getActionProperties() : null;
        ActionMetaData actionMetaData3 = currentActionMetaData;
        if (actionMetaData3 != null) {
            ActionProperties actionProperties = currentActionProperties;
            actionMetaData = ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)false, (int)0, null, actionProperties != null ? ActionProperties.copy$default((ActionProperties)actionProperties, null, null, null, (Boolean)this.hasRollupFailed, null, null, (int)55, null) : null, (int)63, null);
        } else {
            actionMetaData = null;
        }
        ActionMetaData actionMetaData4 = actionMetaData;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData4, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final Unit execute$lambda$0(ExplainRollupRequest $explainRollupRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.execute((ActionType)ExplainRollupAction.Companion.getINSTANCE(), (ActionRequest)$explainRollupRequest, it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/WaitForRollupCompletionStep$Companion;", "", "<init>", "()V", "name", "", "JOB_STOPPED_MESSAGE", "getFailedMessage", "rollupJob", "index", "getJobProcessingMessage", "getJobCompletionMessage", "getJobFailedMessage", "getMissingRollupJobMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to get the status of rollup job [" + rollupJob + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobProcessingMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupJob + "] is still processing [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobCompletionMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupJob + "] completed [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobFailedMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupJob + "] failed [index=" + index2 + "]";
        }

        @NotNull
        public final String getMissingRollupJobMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job was not found [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RollupMetadata.Status.values().length];
            try {
                nArray[RollupMetadata.Status.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.RETRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STOPPED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

