/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ipv6CidrAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ipv6CidrAssociation> {
    private static final SdkField<String> IPV6_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Cidr").getter(Ipv6CidrAssociation.getter(Ipv6CidrAssociation::ipv6Cidr)).setter(Ipv6CidrAssociation.setter(Builder::ipv6Cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Cidr").unmarshallLocationName("ipv6Cidr").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResource").getter(Ipv6CidrAssociation.getter(Ipv6CidrAssociation::associatedResource)).setter(Ipv6CidrAssociation.setter(Builder::associatedResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResource").unmarshallLocationName("associatedResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_FIELD, ASSOCIATED_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ipv6CidrAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipv6Cidr;
    private final String associatedResource;

    private Ipv6CidrAssociation(BuilderImpl builder) {
        this.ipv6Cidr = builder.ipv6Cidr;
        this.associatedResource = builder.associatedResource;
    }

    public final String ipv6Cidr() {
        return this.ipv6Cidr;
    }

    public final String associatedResource() {
        return this.associatedResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6CidrAssociation)) {
            return false;
        }
        Ipv6CidrAssociation other = (Ipv6CidrAssociation)obj;
        return Objects.equals(this.ipv6Cidr(), other.ipv6Cidr()) && Objects.equals(this.associatedResource(), other.associatedResource());
    }

    public final String toString() {
        return ToString.builder((String)"Ipv6CidrAssociation").add("Ipv6Cidr", (Object)this.ipv6Cidr()).add("AssociatedResource", (Object)this.associatedResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6Cidr": {
                return Optional.ofNullable(clazz.cast(this.ipv6Cidr()));
            }
            case "AssociatedResource": {
                return Optional.ofNullable(clazz.cast(this.associatedResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Ipv6Cidr", IPV6_CIDR_FIELD);
        map.put("AssociatedResource", ASSOCIATED_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ipv6CidrAssociation, T> g) {
        return obj -> g.apply((Ipv6CidrAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipv6Cidr;
        private String associatedResource;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6CidrAssociation model) {
            this.ipv6Cidr(model.ipv6Cidr);
            this.associatedResource(model.associatedResource);
        }

        public final String getIpv6Cidr() {
            return this.ipv6Cidr;
        }

        public final void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }

        @Override
        public final Builder ipv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
            return this;
        }

        public final String getAssociatedResource() {
            return this.associatedResource;
        }

        public final void setAssociatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
        }

        @Override
        public final Builder associatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
            return this;
        }

        public Ipv6CidrAssociation build() {
            return new Ipv6CidrAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ipv6CidrAssociation> {
        public Builder ipv6Cidr(String var1);

        public Builder associatedResource(String var1);
    }
}

