/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.StreamUtils;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.models.AccessControlListRule;
import com.microsoft.windowsazure.management.compute.models.AdditionalUnattendContentSettings;
import com.microsoft.windowsazure.management.compute.models.ComponentSetting;
import com.microsoft.windowsazure.management.compute.models.ConfigurationSet;
import com.microsoft.windowsazure.management.compute.models.DataDiskConfiguration;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DnsServer;
import com.microsoft.windowsazure.management.compute.models.DomainJoinCredentials;
import com.microsoft.windowsazure.management.compute.models.DomainJoinProvisioning;
import com.microsoft.windowsazure.management.compute.models.DomainJoinSettings;
import com.microsoft.windowsazure.management.compute.models.EndpointAcl;
import com.microsoft.windowsazure.management.compute.models.IPConfiguration;
import com.microsoft.windowsazure.management.compute.models.InputEndpoint;
import com.microsoft.windowsazure.management.compute.models.LoadBalancer;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbe;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbeTransportProtocol;
import com.microsoft.windowsazure.management.compute.models.NetworkInterface;
import com.microsoft.windowsazure.management.compute.models.OSVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionParameterValue;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionReference;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.SshSettingKeyPair;
import com.microsoft.windowsazure.management.compute.models.SshSettingPublicKey;
import com.microsoft.windowsazure.management.compute.models.SshSettings;
import com.microsoft.windowsazure.management.compute.models.StoredCertificateSettings;
import com.microsoft.windowsazure.management.compute.models.UnattendComponent;
import com.microsoft.windowsazure.management.compute.models.UnattendPassSettings;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCaptureOSImageParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCaptureVMImageParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCreateDeploymentParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineGetRemoteDesktopFileResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineRoleType;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineShutdownParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineShutdownRolesParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineStartRolesParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineUpdateLoadBalancedSetParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineWindowsRemoteManagementListenerType;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementListener;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementSettings;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VirtualMachineOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginCapturingOSImageAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineCaptureOSImageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginCapturingOSImage(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCapturingOSImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureOSImageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getPostCaptureAction() == null) {
            throw new NullPointerException("parameters.PostCaptureAction");
        }
        if (parameters.getProvisioningConfiguration() != null) {
            if (parameters.getProvisioningConfiguration().getAdditionalUnattendContent() != null && parameters.getProvisioningConfiguration().getAdditionalUnattendContent().getUnattendPasses() != null) {
                for (UnattendPassSettings unattendPassesParameterItem : parameters.getProvisioningConfiguration().getAdditionalUnattendContent().getUnattendPasses()) {
                    if (unattendPassesParameterItem.getPassName() == null) {
                        throw new NullPointerException("parameters.ProvisioningConfiguration.AdditionalUnattendContent.UnattendPasses.PassName");
                    }
                    if (unattendPassesParameterItem.getUnattendComponents() == null) continue;
                    for (UnattendComponent unattendComponentsParameterItem : unattendPassesParameterItem.getUnattendComponents()) {
                        if (unattendComponentsParameterItem.getComponentName() == null) {
                            throw new NullPointerException("parameters.ProvisioningConfiguration.AdditionalUnattendContent.UnattendPasses.UnattendComponents.ComponentName");
                        }
                        if (unattendComponentsParameterItem.getUnattendComponentSettings() == null) continue;
                        for (ComponentSetting unattendComponentSettingsParameterItem : unattendComponentsParameterItem.getUnattendComponentSettings()) {
                            if (unattendComponentSettingsParameterItem.getSettingName() != null) continue;
                            throw new NullPointerException("parameters.ProvisioningConfiguration.AdditionalUnattendContent.UnattendPasses.UnattendComponents.UnattendComponentSettings.SettingName");
                        }
                    }
                }
            }
            if (parameters.getProvisioningConfiguration().getDomainJoin() != null && parameters.getProvisioningConfiguration().getDomainJoin().getCredentials() != null) {
                if (parameters.getProvisioningConfiguration().getDomainJoin().getCredentials().getPassword() == null) {
                    throw new NullPointerException("parameters.ProvisioningConfiguration.DomainJoin.Credentials.Password");
                }
                if (parameters.getProvisioningConfiguration().getDomainJoin().getCredentials().getUserName() == null) {
                    throw new NullPointerException("parameters.ProvisioningConfiguration.DomainJoin.Credentials.UserName");
                }
            }
            if (parameters.getProvisioningConfiguration().getHostName() != null && parameters.getProvisioningConfiguration().getHostName().length() < 1) {
                throw new IllegalArgumentException("parameters.ProvisioningConfiguration.HostName");
            }
            if (parameters.getProvisioningConfiguration().getHostName() != null && parameters.getProvisioningConfiguration().getHostName().length() > 64) {
                throw new IllegalArgumentException("parameters.ProvisioningConfiguration.HostName");
            }
            if (parameters.getProvisioningConfiguration().getSshSettings() != null) {
                if (parameters.getProvisioningConfiguration().getSshSettings().getKeyPairs() != null) {
                    for (SshSettingKeyPair keyPairsParameterItem : parameters.getProvisioningConfiguration().getSshSettings().getKeyPairs()) {
                        if (keyPairsParameterItem.getFingerprint() == null) {
                            throw new NullPointerException("parameters.ProvisioningConfiguration.SshSettings.KeyPairs.Fingerprint");
                        }
                        if (keyPairsParameterItem.getPath() != null) continue;
                        throw new NullPointerException("parameters.ProvisioningConfiguration.SshSettings.KeyPairs.Path");
                    }
                }
                if (parameters.getProvisioningConfiguration().getSshSettings().getPublicKeys() != null) {
                    for (SshSettingPublicKey publicKeysParameterItem : parameters.getProvisioningConfiguration().getSshSettings().getPublicKeys()) {
                        if (publicKeysParameterItem.getFingerprint() == null) {
                            throw new NullPointerException("parameters.ProvisioningConfiguration.SshSettings.PublicKeys.Fingerprint");
                        }
                        if (publicKeysParameterItem.getPath() != null) continue;
                        throw new NullPointerException("parameters.ProvisioningConfiguration.SshSettings.PublicKeys.Path");
                    }
                }
            }
            if (parameters.getProvisioningConfiguration().getStoredCertificateSettings() != null) {
                for (StoredCertificateSettings storedCertificateSettingsParameterItem : parameters.getProvisioningConfiguration().getStoredCertificateSettings()) {
                    if (storedCertificateSettingsParameterItem.getStoreName() == null) {
                        throw new NullPointerException("parameters.ProvisioningConfiguration.StoredCertificateSettings.StoreName");
                    }
                    if (storedCertificateSettingsParameterItem.getThumbprint() != null) continue;
                    throw new NullPointerException("parameters.ProvisioningConfiguration.StoredCertificateSettings.Thumbprint");
                }
            }
            if (parameters.getProvisioningConfiguration().getUserName() != null && parameters.getProvisioningConfiguration().getUserName().length() < 1) {
                throw new IllegalArgumentException("parameters.ProvisioningConfiguration.UserName");
            }
            if (parameters.getProvisioningConfiguration().getUserName() != null && parameters.getProvisioningConfiguration().getUserName().length() > 32) {
                throw new IllegalArgumentException("parameters.ProvisioningConfiguration.UserName");
            }
            if (parameters.getProvisioningConfiguration().getUserPassword() != null && parameters.getProvisioningConfiguration().getUserPassword().length() < 6) {
                throw new IllegalArgumentException("parameters.ProvisioningConfiguration.UserPassword");
            }
            if (parameters.getProvisioningConfiguration().getUserPassword() != null && parameters.getProvisioningConfiguration().getUserPassword().length() > 72) {
                throw new IllegalArgumentException("parameters.ProvisioningConfiguration.UserPassword");
            }
            if (parameters.getProvisioningConfiguration().getWindowsRemoteManagement() != null && parameters.getProvisioningConfiguration().getWindowsRemoteManagement().getListeners() != null) {
                for (WindowsRemoteManagementListener listenersParameterItem : parameters.getProvisioningConfiguration().getWindowsRemoteManagement().getListeners()) {
                    if (listenersParameterItem.getListenerType() != null) continue;
                    throw new NullPointerException("parameters.ProvisioningConfiguration.WindowsRemoteManagement.Listeners.ListenerType");
                }
            }
        }
        if (parameters.getTargetImageLabel() == null) {
            throw new NullPointerException("parameters.TargetImageLabel");
        }
        if (parameters.getTargetImageName() == null) {
            throw new NullPointerException("parameters.TargetImageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCapturingOSImageAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        url = url + "/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element captureRoleOperationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CaptureRoleOperation");
        requestDoc.appendChild(captureRoleOperationElement);
        Element operationTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OperationType");
        operationTypeElement.appendChild(requestDoc.createTextNode("CaptureRoleOperation"));
        captureRoleOperationElement.appendChild(operationTypeElement);
        Element postCaptureActionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PostCaptureAction");
        postCaptureActionElement.appendChild(requestDoc.createTextNode(parameters.getPostCaptureAction().toString()));
        captureRoleOperationElement.appendChild(postCaptureActionElement);
        if (parameters.getProvisioningConfiguration() != null) {
            Element provisioningConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProvisioningConfiguration");
            captureRoleOperationElement.appendChild(provisioningConfigurationElement);
            if (parameters.getProvisioningConfiguration().getConfigurationSetType() != null) {
                Element configurationSetTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSetType");
                configurationSetTypeElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getConfigurationSetType()));
                provisioningConfigurationElement.appendChild(configurationSetTypeElement);
            }
            if (parameters.getProvisioningConfiguration().getInputEndpoints() != null && (!(parameters.getProvisioningConfiguration().getInputEndpoints() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getInputEndpoints()).isInitialized())) {
                Element inputEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                for (InputEndpoint inputEndpoint : parameters.getProvisioningConfiguration().getInputEndpoints()) {
                    Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                    inputEndpointsSequenceElement.appendChild(inputEndpointElement);
                    if (inputEndpoint.getLoadBalancedEndpointSetName() != null) {
                        Element loadBalancedEndpointSetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                        loadBalancedEndpointSetNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancedEndpointSetName()));
                        inputEndpointElement.appendChild(loadBalancedEndpointSetNameElement);
                    }
                    if (inputEndpoint.getLocalPort() != null) {
                        Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                        localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLocalPort())));
                        inputEndpointElement.appendChild(localPortElement);
                    }
                    if (inputEndpoint.getName() != null) {
                        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                        nameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getName()));
                        inputEndpointElement.appendChild(nameElement);
                    }
                    if (inputEndpoint.getPort() != null) {
                        Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                        portElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getPort())));
                        inputEndpointElement.appendChild(portElement);
                    }
                    if (inputEndpoint.getLoadBalancerProbe() != null) {
                        Element loadBalancerProbeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                        inputEndpointElement.appendChild(loadBalancerProbeElement);
                        if (inputEndpoint.getLoadBalancerProbe().getPath() != null) {
                            Element pathElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                            pathElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerProbe().getPath()));
                            loadBalancerProbeElement.appendChild(pathElement);
                        }
                        Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                        portElement2.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getPort())));
                        loadBalancerProbeElement.appendChild(portElement2);
                        if (inputEndpoint.getLoadBalancerProbe().getProtocol() != null) {
                            Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                            protocolElement.appendChild(requestDoc.createTextNode(ComputeManagementClientImpl.loadBalancerProbeTransportProtocolToString(inputEndpoint.getLoadBalancerProbe().getProtocol())));
                            loadBalancerProbeElement.appendChild(protocolElement);
                        }
                        if (inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds() != null) {
                            Element intervalInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                            intervalInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds())));
                            loadBalancerProbeElement.appendChild(intervalInSecondsElement);
                        }
                        if (inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds() != null) {
                            Element timeoutInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                            timeoutInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds())));
                            loadBalancerProbeElement.appendChild(timeoutInSecondsElement);
                        }
                    }
                    if (inputEndpoint.getProtocol() != null) {
                        Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                        protocolElement2.appendChild(requestDoc.createTextNode(inputEndpoint.getProtocol()));
                        inputEndpointElement.appendChild(protocolElement2);
                    }
                    if (inputEndpoint.getVirtualIPAddress() != null) {
                        Element vipElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Vip");
                        vipElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPAddress().getHostAddress()));
                        inputEndpointElement.appendChild(vipElement);
                    }
                    if (inputEndpoint.isEnableDirectServerReturn() != null) {
                        Element enableDirectServerReturnElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                        enableDirectServerReturnElement.appendChild(requestDoc.createTextNode(Boolean.toString(inputEndpoint.isEnableDirectServerReturn()).toLowerCase()));
                        inputEndpointElement.appendChild(enableDirectServerReturnElement);
                    }
                    if (inputEndpoint.getLoadBalancerName() != null) {
                        Element loadBalancerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                        loadBalancerNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerName()));
                        inputEndpointElement.appendChild(loadBalancerNameElement);
                    }
                    if (inputEndpoint.getEndpointAcl() != null) {
                        Element endpointAclElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                        inputEndpointElement.appendChild(endpointAclElement);
                        if (inputEndpoint.getEndpointAcl().getRules() != null && (!(inputEndpoint.getEndpointAcl().getRules() instanceof LazyCollection) || ((LazyCollection)inputEndpoint.getEndpointAcl().getRules()).isInitialized())) {
                            Element rulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rules");
                            for (AccessControlListRule rulesItem : inputEndpoint.getEndpointAcl().getRules()) {
                                Element ruleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rule");
                                rulesSequenceElement.appendChild(ruleElement);
                                if (rulesItem.getOrder() != null) {
                                    Element orderElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Order");
                                    orderElement.appendChild(requestDoc.createTextNode(Integer.toString(rulesItem.getOrder())));
                                    ruleElement.appendChild(orderElement);
                                }
                                if (rulesItem.getAction() != null) {
                                    Element actionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Action");
                                    actionElement.appendChild(requestDoc.createTextNode(rulesItem.getAction()));
                                    ruleElement.appendChild(actionElement);
                                }
                                if (rulesItem.getRemoteSubnet() != null) {
                                    Element remoteSubnetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                                    remoteSubnetElement.appendChild(requestDoc.createTextNode(rulesItem.getRemoteSubnet()));
                                    ruleElement.appendChild(remoteSubnetElement);
                                }
                                if (rulesItem.getDescription() == null) continue;
                                Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
                                descriptionElement.appendChild(requestDoc.createTextNode(rulesItem.getDescription()));
                                ruleElement.appendChild(descriptionElement);
                            }
                            endpointAclElement.appendChild(rulesSequenceElement);
                        }
                    }
                    if (inputEndpoint.getIdleTimeoutInMinutes() != null) {
                        Element idleTimeoutInMinutesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                        idleTimeoutInMinutesElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getIdleTimeoutInMinutes())));
                        inputEndpointElement.appendChild(idleTimeoutInMinutesElement);
                    }
                    if (inputEndpoint.getLoadBalancerDistribution() != null) {
                        Element loadBalancerDistributionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                        loadBalancerDistributionElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerDistribution()));
                        inputEndpointElement.appendChild(loadBalancerDistributionElement);
                    }
                    if (inputEndpoint.getVirtualIPName() == null) continue;
                    Element virtualIPNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VirtualIPName");
                    virtualIPNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPName()));
                    inputEndpointElement.appendChild(virtualIPNameElement);
                }
                provisioningConfigurationElement.appendChild(inputEndpointsSequenceElement);
            }
            if (parameters.getProvisioningConfiguration().getSubnetNames() != null && (!(parameters.getProvisioningConfiguration().getSubnetNames() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getSubnetNames()).isInitialized())) {
                Element subnetNamesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetNames");
                for (String string : parameters.getProvisioningConfiguration().getSubnetNames()) {
                    Element subnetNamesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                    subnetNamesItemElement.appendChild(requestDoc.createTextNode(string));
                    subnetNamesSequenceElement.appendChild(subnetNamesItemElement);
                }
                provisioningConfigurationElement.appendChild(subnetNamesSequenceElement);
            }
            if (parameters.getProvisioningConfiguration().getStaticVirtualNetworkIPAddress() != null) {
                Element staticVirtualNetworkIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                staticVirtualNetworkIPAddressElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getStaticVirtualNetworkIPAddress()));
                provisioningConfigurationElement.appendChild(staticVirtualNetworkIPAddressElement);
            }
            if (parameters.getProvisioningConfiguration().getPublicIPs() != null && (!(parameters.getProvisioningConfiguration().getPublicIPs() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getPublicIPs()).isInitialized())) {
                Element publicIPsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIPs");
                for (ConfigurationSet.PublicIP publicIP : parameters.getProvisioningConfiguration().getPublicIPs()) {
                    Element publicIPElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIP");
                    publicIPsSequenceElement.appendChild(publicIPElement);
                    if (publicIP.getName() != null) {
                        Element nameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                        nameElement2.appendChild(requestDoc.createTextNode(publicIP.getName()));
                        publicIPElement.appendChild(nameElement2);
                    }
                    if (publicIP.getIdleTimeoutInMinutes() != null) {
                        Element idleTimeoutInMinutesElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                        idleTimeoutInMinutesElement2.appendChild(requestDoc.createTextNode(Integer.toString(publicIP.getIdleTimeoutInMinutes())));
                        publicIPElement.appendChild(idleTimeoutInMinutesElement2);
                    }
                    if (publicIP.getDomainNameLabel() == null) continue;
                    Element domainNameLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainNameLabel");
                    domainNameLabelElement.appendChild(requestDoc.createTextNode(publicIP.getDomainNameLabel()));
                    publicIPElement.appendChild(domainNameLabelElement);
                }
                provisioningConfigurationElement.appendChild(publicIPsSequenceElement);
            }
            if (parameters.getProvisioningConfiguration().getNetworkInterfaces() != null && (!(parameters.getProvisioningConfiguration().getNetworkInterfaces() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getNetworkInterfaces()).isInitialized())) {
                Element networkInterfacesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                for (NetworkInterface networkInterface : parameters.getProvisioningConfiguration().getNetworkInterfaces()) {
                    Element networkInterfaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterface");
                    networkInterfacesSequenceElement.appendChild(networkInterfaceElement);
                    if (networkInterface.getName() != null) {
                        Element nameElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                        nameElement3.appendChild(requestDoc.createTextNode(networkInterface.getName()));
                        networkInterfaceElement.appendChild(nameElement3);
                    }
                    if (networkInterface.getIPConfigurations() != null && (!(networkInterface.getIPConfigurations() instanceof LazyCollection) || ((LazyCollection)networkInterface.getIPConfigurations()).isInitialized())) {
                        Element iPConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                        for (IPConfiguration iPConfigurationsItem : networkInterface.getIPConfigurations()) {
                            Element iPConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfiguration");
                            iPConfigurationsSequenceElement.appendChild(iPConfigurationElement);
                            if (iPConfigurationsItem.getSubnetName() != null) {
                                Element subnetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                                subnetNameElement.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getSubnetName()));
                                iPConfigurationElement.appendChild(subnetNameElement);
                            }
                            if (iPConfigurationsItem.getStaticVirtualNetworkIPAddress() == null) continue;
                            Element staticVirtualNetworkIPAddressElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                            staticVirtualNetworkIPAddressElement2.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getStaticVirtualNetworkIPAddress()));
                            iPConfigurationElement.appendChild(staticVirtualNetworkIPAddressElement2);
                        }
                        networkInterfaceElement.appendChild(iPConfigurationsSequenceElement);
                    }
                    if (networkInterface.getNetworkSecurityGroup() != null) {
                        Element networkSecurityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                        networkSecurityGroupElement.appendChild(requestDoc.createTextNode(networkInterface.getNetworkSecurityGroup()));
                        networkInterfaceElement.appendChild(networkSecurityGroupElement);
                    }
                    if (networkInterface.getIPForwarding() == null) continue;
                    Element iPForwardingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                    iPForwardingElement.appendChild(requestDoc.createTextNode(networkInterface.getIPForwarding()));
                    networkInterfaceElement.appendChild(iPForwardingElement);
                }
                provisioningConfigurationElement.appendChild(networkInterfacesSequenceElement);
            }
            if (parameters.getProvisioningConfiguration().getNetworkSecurityGroup() != null) {
                Element networkSecurityGroupElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                networkSecurityGroupElement2.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getNetworkSecurityGroup()));
                provisioningConfigurationElement.appendChild(networkSecurityGroupElement2);
            }
            if (parameters.getProvisioningConfiguration().getIPForwarding() != null) {
                Element iPForwardingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                iPForwardingElement2.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getIPForwarding()));
                provisioningConfigurationElement.appendChild(iPForwardingElement2);
            }
            if (parameters.getProvisioningConfiguration().getComputerName() != null) {
                Element computerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComputerName");
                computerNameElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getComputerName()));
                provisioningConfigurationElement.appendChild(computerNameElement);
            }
            if (parameters.getProvisioningConfiguration().getAdminPassword() != null) {
                Element adminPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminPassword");
                adminPasswordElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getAdminPassword()));
                provisioningConfigurationElement.appendChild(adminPasswordElement);
            }
            if (parameters.getProvisioningConfiguration().isResetPasswordOnFirstLogon() != null) {
                Element resetPasswordOnFirstLogonElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResetPasswordOnFirstLogon");
                resetPasswordOnFirstLogonElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.getProvisioningConfiguration().isResetPasswordOnFirstLogon()).toLowerCase()));
                provisioningConfigurationElement.appendChild(resetPasswordOnFirstLogonElement);
            }
            if (parameters.getProvisioningConfiguration().isEnableAutomaticUpdates() != null) {
                Element enableAutomaticUpdatesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableAutomaticUpdates");
                enableAutomaticUpdatesElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.getProvisioningConfiguration().isEnableAutomaticUpdates()).toLowerCase()));
                provisioningConfigurationElement.appendChild(enableAutomaticUpdatesElement);
            }
            if (parameters.getProvisioningConfiguration().getTimeZone() != null) {
                Element timeZoneElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeZone");
                timeZoneElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getTimeZone()));
                provisioningConfigurationElement.appendChild(timeZoneElement);
            }
            if (parameters.getProvisioningConfiguration().getDomainJoin() != null) {
                Element domainJoinElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainJoin");
                provisioningConfigurationElement.appendChild(domainJoinElement);
                if (parameters.getProvisioningConfiguration().getDomainJoin().getCredentials() != null) {
                    Element credentialsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Credentials");
                    domainJoinElement.appendChild(credentialsElement);
                    if (parameters.getProvisioningConfiguration().getDomainJoin().getCredentials().getDomain() != null) {
                        Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Domain");
                        element.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getDomainJoin().getCredentials().getDomain()));
                        credentialsElement.appendChild(element);
                    }
                    Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Username");
                    element.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getDomainJoin().getCredentials().getUserName()));
                    credentialsElement.appendChild(element);
                    Element passwordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Password");
                    passwordElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getDomainJoin().getCredentials().getPassword()));
                    credentialsElement.appendChild(passwordElement);
                }
                if (parameters.getProvisioningConfiguration().getDomainJoin().getDomainToJoin() != null) {
                    Element joinDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "JoinDomain");
                    joinDomainElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getDomainJoin().getDomainToJoin()));
                    domainJoinElement.appendChild(joinDomainElement);
                }
                if (parameters.getProvisioningConfiguration().getDomainJoin().getLdapMachineObjectOU() != null) {
                    Element machineObjectOUElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MachineObjectOU");
                    machineObjectOUElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getDomainJoin().getLdapMachineObjectOU()));
                    domainJoinElement.appendChild(machineObjectOUElement);
                }
                if (parameters.getProvisioningConfiguration().getDomainJoin().getProvisioning() != null) {
                    Element provisioningElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Provisioning");
                    domainJoinElement.appendChild(provisioningElement);
                    if (parameters.getProvisioningConfiguration().getDomainJoin().getProvisioning().getAccountData() != null) {
                        Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountData");
                        element.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getDomainJoin().getProvisioning().getAccountData()));
                        provisioningElement.appendChild(element);
                    }
                }
            }
            if (parameters.getProvisioningConfiguration().getStoredCertificateSettings() != null && (!(parameters.getProvisioningConfiguration().getStoredCertificateSettings() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getStoredCertificateSettings()).isInitialized())) {
                Element storedCertificateSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoredCertificateSettings");
                for (StoredCertificateSettings storedCertificateSettings : parameters.getProvisioningConfiguration().getStoredCertificateSettings()) {
                    Element certificateSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateSetting");
                    storedCertificateSettingsSequenceElement.appendChild(certificateSettingElement);
                    Element storeLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreLocation");
                    storeLocationElement.appendChild(requestDoc.createTextNode("LocalMachine"));
                    certificateSettingElement.appendChild(storeLocationElement);
                    Element storeNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreName");
                    storeNameElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getStoreName()));
                    certificateSettingElement.appendChild(storeNameElement);
                    Element thumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Thumbprint");
                    thumbprintElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getThumbprint()));
                    certificateSettingElement.appendChild(thumbprintElement);
                }
                provisioningConfigurationElement.appendChild(storedCertificateSettingsSequenceElement);
            }
            if (parameters.getProvisioningConfiguration().getWindowsRemoteManagement() != null) {
                Element winRMElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WinRM");
                provisioningConfigurationElement.appendChild(winRMElement);
                if (parameters.getProvisioningConfiguration().getWindowsRemoteManagement().getListeners() != null && (!(parameters.getProvisioningConfiguration().getWindowsRemoteManagement().getListeners() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getWindowsRemoteManagement().getListeners()).isInitialized())) {
                    Element listenersSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listeners");
                    for (WindowsRemoteManagementListener listenersItem : parameters.getProvisioningConfiguration().getWindowsRemoteManagement().getListeners()) {
                        Element listenerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listener");
                        listenersSequenceElement.appendChild(listenerElement);
                        if (listenersItem.getCertificateThumbprint() != null) {
                            Element certificateThumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateThumbprint");
                            certificateThumbprintElement.appendChild(requestDoc.createTextNode(listenersItem.getCertificateThumbprint()));
                            listenerElement.appendChild(certificateThumbprintElement);
                        }
                        Element protocolElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                        protocolElement3.appendChild(requestDoc.createTextNode(listenersItem.getListenerType().toString()));
                        listenerElement.appendChild(protocolElement3);
                    }
                    winRMElement.appendChild(listenersSequenceElement);
                }
            }
            if (parameters.getProvisioningConfiguration().getAdminUserName() != null) {
                Element adminUsernameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminUsername");
                adminUsernameElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getAdminUserName()));
                provisioningConfigurationElement.appendChild(adminUsernameElement);
            }
            if (parameters.getProvisioningConfiguration().getAdditionalUnattendContent() != null) {
                Element additionalUnattendContentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdditionalUnattendContent");
                provisioningConfigurationElement.appendChild(additionalUnattendContentElement);
                if (parameters.getProvisioningConfiguration().getAdditionalUnattendContent().getUnattendPasses() != null && (!(parameters.getProvisioningConfiguration().getAdditionalUnattendContent().getUnattendPasses() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getAdditionalUnattendContent().getUnattendPasses()).isInitialized())) {
                    Element passesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Passes");
                    for (UnattendPassSettings passesItem : parameters.getProvisioningConfiguration().getAdditionalUnattendContent().getUnattendPasses()) {
                        Element unattendPassElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendPass");
                        passesSequenceElement.appendChild(unattendPassElement);
                        Element passNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PassName");
                        passNameElement.appendChild(requestDoc.createTextNode(passesItem.getPassName()));
                        unattendPassElement.appendChild(passNameElement);
                        if (passesItem.getUnattendComponents() == null || passesItem.getUnattendComponents() instanceof LazyCollection && !((LazyCollection)passesItem.getUnattendComponents()).isInitialized()) continue;
                        Element componentsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Components");
                        for (UnattendComponent componentsItem : passesItem.getUnattendComponents()) {
                            Element unattendComponentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendComponent");
                            componentsSequenceElement.appendChild(unattendComponentElement);
                            Element componentNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentName");
                            componentNameElement.appendChild(requestDoc.createTextNode(componentsItem.getComponentName()));
                            unattendComponentElement.appendChild(componentNameElement);
                            if (componentsItem.getUnattendComponentSettings() == null || componentsItem.getUnattendComponentSettings() instanceof LazyCollection && !((LazyCollection)componentsItem.getUnattendComponentSettings()).isInitialized()) continue;
                            Element componentSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSettings");
                            for (ComponentSetting componentSettingsItem : componentsItem.getUnattendComponentSettings()) {
                                Element componentSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSetting");
                                componentSettingsSequenceElement.appendChild(componentSettingElement);
                                Element settingNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SettingName");
                                settingNameElement.appendChild(requestDoc.createTextNode(componentSettingsItem.getSettingName()));
                                componentSettingElement.appendChild(settingNameElement);
                                if (componentSettingsItem.getContent() == null) continue;
                                Element contentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Content");
                                contentElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])componentSettingsItem.getContent().getBytes())));
                                componentSettingElement.appendChild(contentElement);
                            }
                            unattendComponentElement.appendChild(componentSettingsSequenceElement);
                        }
                        unattendPassElement.appendChild(componentsSequenceElement);
                    }
                    additionalUnattendContentElement.appendChild(passesSequenceElement);
                }
            }
            if (parameters.getProvisioningConfiguration().getHostName() != null) {
                Element hostNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostName");
                hostNameElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getHostName()));
                provisioningConfigurationElement.appendChild(hostNameElement);
            }
            if (parameters.getProvisioningConfiguration().getUserName() != null) {
                Element userNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserName");
                userNameElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getUserName()));
                provisioningConfigurationElement.appendChild(userNameElement);
            }
            if (parameters.getProvisioningConfiguration().getUserPassword() != null) {
                Element userPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserPassword");
                userPasswordElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getUserPassword()));
                provisioningConfigurationElement.appendChild(userPasswordElement);
            }
            if (parameters.getProvisioningConfiguration().isDisableSshPasswordAuthentication() != null) {
                Element disableSshPasswordAuthenticationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DisableSshPasswordAuthentication");
                disableSshPasswordAuthenticationElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.getProvisioningConfiguration().isDisableSshPasswordAuthentication()).toLowerCase()));
                provisioningConfigurationElement.appendChild(disableSshPasswordAuthenticationElement);
            }
            if (parameters.getProvisioningConfiguration().getSshSettings() != null) {
                Element sSHElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SSH");
                provisioningConfigurationElement.appendChild(sSHElement);
                if (parameters.getProvisioningConfiguration().getSshSettings().getPublicKeys() != null && (!(parameters.getProvisioningConfiguration().getSshSettings().getPublicKeys() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getSshSettings().getPublicKeys()).isInitialized())) {
                    Element publicKeysSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKeys");
                    for (SshSettingPublicKey publicKeysItem : parameters.getProvisioningConfiguration().getSshSettings().getPublicKeys()) {
                        Element publicKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKey");
                        publicKeysSequenceElement.appendChild(publicKeyElement);
                        Element fingerprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                        fingerprintElement.appendChild(requestDoc.createTextNode(publicKeysItem.getFingerprint()));
                        publicKeyElement.appendChild(fingerprintElement);
                        Element pathElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                        pathElement2.appendChild(requestDoc.createTextNode(publicKeysItem.getPath()));
                        publicKeyElement.appendChild(pathElement2);
                    }
                    sSHElement.appendChild(publicKeysSequenceElement);
                }
                if (parameters.getProvisioningConfiguration().getSshSettings().getKeyPairs() != null && (!(parameters.getProvisioningConfiguration().getSshSettings().getKeyPairs() instanceof LazyCollection) || ((LazyCollection)parameters.getProvisioningConfiguration().getSshSettings().getKeyPairs()).isInitialized())) {
                    Element keyPairsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPairs");
                    for (SshSettingKeyPair keyPairsItem : parameters.getProvisioningConfiguration().getSshSettings().getKeyPairs()) {
                        Element keyPairElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPair");
                        keyPairsSequenceElement.appendChild(keyPairElement);
                        Element fingerprintElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                        fingerprintElement2.appendChild(requestDoc.createTextNode(keyPairsItem.getFingerprint()));
                        keyPairElement.appendChild(fingerprintElement2);
                        Element pathElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                        pathElement3.appendChild(requestDoc.createTextNode(keyPairsItem.getPath()));
                        keyPairElement.appendChild(pathElement3);
                    }
                    sSHElement.appendChild(keyPairsSequenceElement);
                }
            }
            if (parameters.getProvisioningConfiguration().getCustomData() != null) {
                Element customDataElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CustomData");
                customDataElement.appendChild(requestDoc.createTextNode(parameters.getProvisioningConfiguration().getCustomData()));
                provisioningConfigurationElement.appendChild(customDataElement);
            }
        }
        Element targetImageLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TargetImageLabel");
        targetImageLabelElement.appendChild(requestDoc.createTextNode(parameters.getTargetImageLabel()));
        captureRoleOperationElement.appendChild(targetImageLabelElement);
        Element targetImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TargetImageName");
        targetImageNameElement.appendChild(requestDoc.createTextNode(parameters.getTargetImageName()));
        captureRoleOperationElement.appendChild(targetImageNameElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginCapturingVMImageAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineCaptureVMImageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginCapturingVMImage(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCapturingVMImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureVMImageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCapturingVMImageAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        url = url + "/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element captureRoleAsVMImageOperationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CaptureRoleAsVMImageOperation");
        requestDoc.appendChild(captureRoleAsVMImageOperationElement);
        Element operationTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OperationType");
        operationTypeElement.appendChild(requestDoc.createTextNode("CaptureRoleAsVMImageOperation"));
        captureRoleAsVMImageOperationElement.appendChild(operationTypeElement);
        if (parameters.getOSState() != null) {
            Element oSStateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSState");
            oSStateElement.appendChild(requestDoc.createTextNode(parameters.getOSState()));
            captureRoleAsVMImageOperationElement.appendChild(oSStateElement);
        }
        if (parameters.getVMImageName() != null) {
            Element vMImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImageName");
            vMImageNameElement.appendChild(requestDoc.createTextNode(parameters.getVMImageName()));
            captureRoleAsVMImageOperationElement.appendChild(vMImageNameElement);
        }
        if (parameters.getVMImageLabel() != null) {
            Element vMImageLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImageLabel");
            vMImageLabelElement.appendChild(requestDoc.createTextNode(parameters.getVMImageLabel()));
            captureRoleAsVMImageOperationElement.appendChild(vMImageLabelElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginCreatingAsync(final String serviceName, final String deploymentName, final VirtualMachineCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginCreating(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreating(String serviceName, String deploymentName, VirtualMachineCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        OperationResponse operationResponse;
        CloseableHttpResponse closeableHttpResponse;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfigurationSets() != null) {
            for (ConfigurationSet configurationSetsParameterItem : parameters.getConfigurationSets()) {
                if (configurationSetsParameterItem.getAdditionalUnattendContent() != null && configurationSetsParameterItem.getAdditionalUnattendContent().getUnattendPasses() != null) {
                    for (UnattendPassSettings unattendPassesParameterItem : configurationSetsParameterItem.getAdditionalUnattendContent().getUnattendPasses()) {
                        if (unattendPassesParameterItem.getPassName() == null) {
                            throw new NullPointerException("parameters.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.PassName");
                        }
                        if (unattendPassesParameterItem.getUnattendComponents() == null) continue;
                        for (UnattendComponent unattendComponentsParameterItem : unattendPassesParameterItem.getUnattendComponents()) {
                            if (unattendComponentsParameterItem.getComponentName() == null) {
                                throw new NullPointerException("parameters.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.UnattendComponents.ComponentName");
                            }
                            if (unattendComponentsParameterItem.getUnattendComponentSettings() == null) continue;
                            for (ComponentSetting unattendComponentSettingsParameterItem : unattendComponentsParameterItem.getUnattendComponentSettings()) {
                                if (unattendComponentSettingsParameterItem.getSettingName() != null) continue;
                                throw new NullPointerException("parameters.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.UnattendComponents.UnattendComponentSettings.SettingName");
                            }
                        }
                    }
                }
                if (configurationSetsParameterItem.getDomainJoin() != null && configurationSetsParameterItem.getDomainJoin().getCredentials() != null) {
                    if (configurationSetsParameterItem.getDomainJoin().getCredentials().getPassword() == null) {
                        throw new NullPointerException("parameters.ConfigurationSets.DomainJoin.Credentials.Password");
                    }
                    if (configurationSetsParameterItem.getDomainJoin().getCredentials().getUserName() == null) {
                        throw new NullPointerException("parameters.ConfigurationSets.DomainJoin.Credentials.UserName");
                    }
                }
                if (configurationSetsParameterItem.getHostName() != null && configurationSetsParameterItem.getHostName().length() < 1) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.HostName");
                }
                if (configurationSetsParameterItem.getHostName() != null && configurationSetsParameterItem.getHostName().length() > 64) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.HostName");
                }
                if (configurationSetsParameterItem.getSshSettings() != null) {
                    if (configurationSetsParameterItem.getSshSettings().getKeyPairs() != null) {
                        for (SshSettingKeyPair keyPairsParameterItem : configurationSetsParameterItem.getSshSettings().getKeyPairs()) {
                            if (keyPairsParameterItem.getFingerprint() == null) {
                                throw new NullPointerException("parameters.ConfigurationSets.SshSettings.KeyPairs.Fingerprint");
                            }
                            if (keyPairsParameterItem.getPath() != null) continue;
                            throw new NullPointerException("parameters.ConfigurationSets.SshSettings.KeyPairs.Path");
                        }
                    }
                    if (configurationSetsParameterItem.getSshSettings().getPublicKeys() != null) {
                        for (SshSettingPublicKey publicKeysParameterItem : configurationSetsParameterItem.getSshSettings().getPublicKeys()) {
                            if (publicKeysParameterItem.getFingerprint() == null) {
                                throw new NullPointerException("parameters.ConfigurationSets.SshSettings.PublicKeys.Fingerprint");
                            }
                            if (publicKeysParameterItem.getPath() != null) continue;
                            throw new NullPointerException("parameters.ConfigurationSets.SshSettings.PublicKeys.Path");
                        }
                    }
                }
                if (configurationSetsParameterItem.getStoredCertificateSettings() != null) {
                    for (StoredCertificateSettings storedCertificateSettingsParameterItem : configurationSetsParameterItem.getStoredCertificateSettings()) {
                        if (storedCertificateSettingsParameterItem.getStoreName() == null) {
                            throw new NullPointerException("parameters.ConfigurationSets.StoredCertificateSettings.StoreName");
                        }
                        if (storedCertificateSettingsParameterItem.getThumbprint() != null) continue;
                        throw new NullPointerException("parameters.ConfigurationSets.StoredCertificateSettings.Thumbprint");
                    }
                }
                if (configurationSetsParameterItem.getUserName() != null && configurationSetsParameterItem.getUserName().length() < 1) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserName");
                }
                if (configurationSetsParameterItem.getUserName() != null && configurationSetsParameterItem.getUserName().length() > 32) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserName");
                }
                if (configurationSetsParameterItem.getUserPassword() != null && configurationSetsParameterItem.getUserPassword().length() < 6) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserPassword");
                }
                if (configurationSetsParameterItem.getUserPassword() != null && configurationSetsParameterItem.getUserPassword().length() > 72) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserPassword");
                }
                if (configurationSetsParameterItem.getWindowsRemoteManagement() == null || configurationSetsParameterItem.getWindowsRemoteManagement().getListeners() == null) continue;
                for (WindowsRemoteManagementListener listenersParameterItem : configurationSetsParameterItem.getWindowsRemoteManagement().getListeners()) {
                    if (listenersParameterItem.getListenerType() != null) continue;
                    throw new NullPointerException("parameters.ConfigurationSets.WindowsRemoteManagement.Listeners.ListenerType");
                }
            }
        }
        if (parameters.getRoleName() == null) {
            throw new NullPointerException("parameters.RoleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roles";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element persistentVMRoleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PersistentVMRole");
        requestDoc.appendChild(persistentVMRoleElement);
        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
        roleNameElement.appendChild(requestDoc.createTextNode(parameters.getRoleName()));
        persistentVMRoleElement.appendChild(roleNameElement);
        Element roleTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleType");
        roleTypeElement.appendChild(requestDoc.createTextNode("PersistentVMRole"));
        persistentVMRoleElement.appendChild(roleTypeElement);
        if (parameters.getConfigurationSets() != null && (!(parameters.getConfigurationSets() instanceof LazyCollection) || ((LazyCollection)parameters.getConfigurationSets()).isInitialized())) {
            Element configurationSetsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSets");
            for (ConfigurationSet configurationSetsItem : parameters.getConfigurationSets()) {
                Element configurationSetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSet");
                configurationSetsSequenceElement.appendChild(configurationSetElement);
                if (configurationSetsItem.getConfigurationSetType() != null) {
                    Element configurationSetTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSetType");
                    configurationSetTypeElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getConfigurationSetType()));
                    configurationSetElement.appendChild(configurationSetTypeElement);
                }
                if (configurationSetsItem.getInputEndpoints() != null && (!(configurationSetsItem.getInputEndpoints() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getInputEndpoints()).isInitialized())) {
                    Element inputEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                    for (InputEndpoint inputEndpoint : configurationSetsItem.getInputEndpoints()) {
                        Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                        inputEndpointsSequenceElement.appendChild(inputEndpointElement);
                        if (inputEndpoint.getLoadBalancedEndpointSetName() != null) {
                            Element loadBalancedEndpointSetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                            loadBalancedEndpointSetNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancedEndpointSetName()));
                            inputEndpointElement.appendChild(loadBalancedEndpointSetNameElement);
                        }
                        if (inputEndpoint.getLocalPort() != null) {
                            Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                            localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLocalPort())));
                            inputEndpointElement.appendChild(localPortElement);
                        }
                        if (inputEndpoint.getName() != null) {
                            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getName()));
                            inputEndpointElement.appendChild(nameElement);
                        }
                        if (inputEndpoint.getPort() != null) {
                            Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                            portElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getPort())));
                            inputEndpointElement.appendChild(portElement);
                        }
                        if (inputEndpoint.getLoadBalancerProbe() != null) {
                            Element loadBalancerProbeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                            inputEndpointElement.appendChild(loadBalancerProbeElement);
                            if (inputEndpoint.getLoadBalancerProbe().getPath() != null) {
                                Element pathElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                                pathElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerProbe().getPath()));
                                loadBalancerProbeElement.appendChild(pathElement);
                            }
                            Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                            portElement2.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getPort())));
                            loadBalancerProbeElement.appendChild(portElement2);
                            if (inputEndpoint.getLoadBalancerProbe().getProtocol() != null) {
                                Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                                protocolElement.appendChild(requestDoc.createTextNode(ComputeManagementClientImpl.loadBalancerProbeTransportProtocolToString(inputEndpoint.getLoadBalancerProbe().getProtocol())));
                                loadBalancerProbeElement.appendChild(protocolElement);
                            }
                            if (inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds() != null) {
                                Element intervalInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                                intervalInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds())));
                                loadBalancerProbeElement.appendChild(intervalInSecondsElement);
                            }
                            if (inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds() != null) {
                                Element timeoutInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                                timeoutInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds())));
                                loadBalancerProbeElement.appendChild(timeoutInSecondsElement);
                            }
                        }
                        if (inputEndpoint.getProtocol() != null) {
                            Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                            protocolElement2.appendChild(requestDoc.createTextNode(inputEndpoint.getProtocol()));
                            inputEndpointElement.appendChild(protocolElement2);
                        }
                        if (inputEndpoint.getVirtualIPAddress() != null) {
                            Element vipElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Vip");
                            vipElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPAddress().getHostAddress()));
                            inputEndpointElement.appendChild(vipElement);
                        }
                        if (inputEndpoint.isEnableDirectServerReturn() != null) {
                            Element enableDirectServerReturnElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                            enableDirectServerReturnElement.appendChild(requestDoc.createTextNode(Boolean.toString(inputEndpoint.isEnableDirectServerReturn()).toLowerCase()));
                            inputEndpointElement.appendChild(enableDirectServerReturnElement);
                        }
                        if (inputEndpoint.getLoadBalancerName() != null) {
                            Element loadBalancerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                            loadBalancerNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerName()));
                            inputEndpointElement.appendChild(loadBalancerNameElement);
                        }
                        if (inputEndpoint.getEndpointAcl() != null) {
                            Element endpointAclElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                            inputEndpointElement.appendChild(endpointAclElement);
                            if (inputEndpoint.getEndpointAcl().getRules() != null && (!(inputEndpoint.getEndpointAcl().getRules() instanceof LazyCollection) || ((LazyCollection)inputEndpoint.getEndpointAcl().getRules()).isInitialized())) {
                                Element rulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rules");
                                for (AccessControlListRule rulesItem : inputEndpoint.getEndpointAcl().getRules()) {
                                    Element ruleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rule");
                                    rulesSequenceElement.appendChild(ruleElement);
                                    if (rulesItem.getOrder() != null) {
                                        Element orderElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Order");
                                        orderElement.appendChild(requestDoc.createTextNode(Integer.toString(rulesItem.getOrder())));
                                        ruleElement.appendChild(orderElement);
                                    }
                                    if (rulesItem.getAction() != null) {
                                        Element actionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Action");
                                        actionElement.appendChild(requestDoc.createTextNode(rulesItem.getAction()));
                                        ruleElement.appendChild(actionElement);
                                    }
                                    if (rulesItem.getRemoteSubnet() != null) {
                                        Element remoteSubnetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                                        remoteSubnetElement.appendChild(requestDoc.createTextNode(rulesItem.getRemoteSubnet()));
                                        ruleElement.appendChild(remoteSubnetElement);
                                    }
                                    if (rulesItem.getDescription() == null) continue;
                                    Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
                                    descriptionElement.appendChild(requestDoc.createTextNode(rulesItem.getDescription()));
                                    ruleElement.appendChild(descriptionElement);
                                }
                                endpointAclElement.appendChild(rulesSequenceElement);
                            }
                        }
                        if (inputEndpoint.getIdleTimeoutInMinutes() != null) {
                            Element idleTimeoutInMinutesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                            idleTimeoutInMinutesElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getIdleTimeoutInMinutes())));
                            inputEndpointElement.appendChild(idleTimeoutInMinutesElement);
                        }
                        if (inputEndpoint.getLoadBalancerDistribution() != null) {
                            Element loadBalancerDistributionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                            loadBalancerDistributionElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerDistribution()));
                            inputEndpointElement.appendChild(loadBalancerDistributionElement);
                        }
                        if (inputEndpoint.getVirtualIPName() == null) continue;
                        Element virtualIPNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VirtualIPName");
                        virtualIPNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPName()));
                        inputEndpointElement.appendChild(virtualIPNameElement);
                    }
                    configurationSetElement.appendChild(inputEndpointsSequenceElement);
                }
                if (configurationSetsItem.getSubnetNames() != null && (!(configurationSetsItem.getSubnetNames() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSubnetNames()).isInitialized())) {
                    Element subnetNamesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetNames");
                    for (String string : configurationSetsItem.getSubnetNames()) {
                        Element subnetNamesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                        subnetNamesItemElement.appendChild(requestDoc.createTextNode(string));
                        subnetNamesSequenceElement.appendChild(subnetNamesItemElement);
                    }
                    configurationSetElement.appendChild(subnetNamesSequenceElement);
                }
                if (configurationSetsItem.getStaticVirtualNetworkIPAddress() != null) {
                    Element staticVirtualNetworkIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                    staticVirtualNetworkIPAddressElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getStaticVirtualNetworkIPAddress()));
                    configurationSetElement.appendChild(staticVirtualNetworkIPAddressElement);
                }
                if (configurationSetsItem.getPublicIPs() != null && (!(configurationSetsItem.getPublicIPs() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getPublicIPs()).isInitialized())) {
                    Element publicIPsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIPs");
                    for (ConfigurationSet.PublicIP publicIP : configurationSetsItem.getPublicIPs()) {
                        Element publicIPElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIP");
                        publicIPsSequenceElement.appendChild(publicIPElement);
                        if (publicIP.getName() != null) {
                            Element nameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement2.appendChild(requestDoc.createTextNode(publicIP.getName()));
                            publicIPElement.appendChild(nameElement2);
                        }
                        if (publicIP.getIdleTimeoutInMinutes() != null) {
                            Element idleTimeoutInMinutesElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                            idleTimeoutInMinutesElement2.appendChild(requestDoc.createTextNode(Integer.toString(publicIP.getIdleTimeoutInMinutes())));
                            publicIPElement.appendChild(idleTimeoutInMinutesElement2);
                        }
                        if (publicIP.getDomainNameLabel() == null) continue;
                        Element domainNameLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainNameLabel");
                        domainNameLabelElement.appendChild(requestDoc.createTextNode(publicIP.getDomainNameLabel()));
                        publicIPElement.appendChild(domainNameLabelElement);
                    }
                    configurationSetElement.appendChild(publicIPsSequenceElement);
                }
                if (configurationSetsItem.getNetworkInterfaces() != null && (!(configurationSetsItem.getNetworkInterfaces() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getNetworkInterfaces()).isInitialized())) {
                    Element networkInterfacesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                    for (NetworkInterface networkInterface : configurationSetsItem.getNetworkInterfaces()) {
                        Element networkInterfaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterface");
                        networkInterfacesSequenceElement.appendChild(networkInterfaceElement);
                        if (networkInterface.getName() != null) {
                            Element nameElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement3.appendChild(requestDoc.createTextNode(networkInterface.getName()));
                            networkInterfaceElement.appendChild(nameElement3);
                        }
                        if (networkInterface.getIPConfigurations() != null && (!(networkInterface.getIPConfigurations() instanceof LazyCollection) || ((LazyCollection)networkInterface.getIPConfigurations()).isInitialized())) {
                            Element iPConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                            for (IPConfiguration iPConfigurationsItem : networkInterface.getIPConfigurations()) {
                                Element iPConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfiguration");
                                iPConfigurationsSequenceElement.appendChild(iPConfigurationElement);
                                if (iPConfigurationsItem.getSubnetName() != null) {
                                    Element subnetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                                    subnetNameElement.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getSubnetName()));
                                    iPConfigurationElement.appendChild(subnetNameElement);
                                }
                                if (iPConfigurationsItem.getStaticVirtualNetworkIPAddress() == null) continue;
                                Element staticVirtualNetworkIPAddressElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                staticVirtualNetworkIPAddressElement2.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getStaticVirtualNetworkIPAddress()));
                                iPConfigurationElement.appendChild(staticVirtualNetworkIPAddressElement2);
                            }
                            networkInterfaceElement.appendChild(iPConfigurationsSequenceElement);
                        }
                        if (networkInterface.getNetworkSecurityGroup() != null) {
                            Element networkSecurityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                            networkSecurityGroupElement.appendChild(requestDoc.createTextNode(networkInterface.getNetworkSecurityGroup()));
                            networkInterfaceElement.appendChild(networkSecurityGroupElement);
                        }
                        if (networkInterface.getIPForwarding() == null) continue;
                        Element iPForwardingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                        iPForwardingElement.appendChild(requestDoc.createTextNode(networkInterface.getIPForwarding()));
                        networkInterfaceElement.appendChild(iPForwardingElement);
                    }
                    configurationSetElement.appendChild(networkInterfacesSequenceElement);
                }
                if (configurationSetsItem.getNetworkSecurityGroup() != null) {
                    Element networkSecurityGroupElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                    networkSecurityGroupElement2.appendChild(requestDoc.createTextNode(configurationSetsItem.getNetworkSecurityGroup()));
                    configurationSetElement.appendChild(networkSecurityGroupElement2);
                }
                if (configurationSetsItem.getIPForwarding() != null) {
                    Element iPForwardingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                    iPForwardingElement2.appendChild(requestDoc.createTextNode(configurationSetsItem.getIPForwarding()));
                    configurationSetElement.appendChild(iPForwardingElement2);
                }
                if (configurationSetsItem.getComputerName() != null) {
                    Element computerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComputerName");
                    computerNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getComputerName()));
                    configurationSetElement.appendChild(computerNameElement);
                }
                if (configurationSetsItem.getAdminPassword() != null) {
                    Element adminPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminPassword");
                    adminPasswordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getAdminPassword()));
                    configurationSetElement.appendChild(adminPasswordElement);
                }
                if (configurationSetsItem.isResetPasswordOnFirstLogon() != null) {
                    Element resetPasswordOnFirstLogonElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResetPasswordOnFirstLogon");
                    resetPasswordOnFirstLogonElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isResetPasswordOnFirstLogon()).toLowerCase()));
                    configurationSetElement.appendChild(resetPasswordOnFirstLogonElement);
                }
                if (configurationSetsItem.isEnableAutomaticUpdates() != null) {
                    Element enableAutomaticUpdatesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableAutomaticUpdates");
                    enableAutomaticUpdatesElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isEnableAutomaticUpdates()).toLowerCase()));
                    configurationSetElement.appendChild(enableAutomaticUpdatesElement);
                }
                if (configurationSetsItem.getTimeZone() != null) {
                    Element timeZoneElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeZone");
                    timeZoneElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getTimeZone()));
                    configurationSetElement.appendChild(timeZoneElement);
                }
                if (configurationSetsItem.getDomainJoin() != null) {
                    Element domainJoinElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainJoin");
                    configurationSetElement.appendChild(domainJoinElement);
                    if (configurationSetsItem.getDomainJoin().getCredentials() != null) {
                        Element credentialsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Credentials");
                        domainJoinElement.appendChild(credentialsElement);
                        if (configurationSetsItem.getDomainJoin().getCredentials().getDomain() != null) {
                            Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Domain");
                            element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getDomain()));
                            credentialsElement.appendChild(element);
                        }
                        Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Username");
                        element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getUserName()));
                        credentialsElement.appendChild(element);
                        Element passwordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Password");
                        passwordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getPassword()));
                        credentialsElement.appendChild(passwordElement);
                    }
                    if (configurationSetsItem.getDomainJoin().getDomainToJoin() != null) {
                        Element joinDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "JoinDomain");
                        joinDomainElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getDomainToJoin()));
                        domainJoinElement.appendChild(joinDomainElement);
                    }
                    if (configurationSetsItem.getDomainJoin().getLdapMachineObjectOU() != null) {
                        Element machineObjectOUElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MachineObjectOU");
                        machineObjectOUElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getLdapMachineObjectOU()));
                        domainJoinElement.appendChild(machineObjectOUElement);
                    }
                    if (configurationSetsItem.getDomainJoin().getProvisioning() != null) {
                        Element provisioningElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Provisioning");
                        domainJoinElement.appendChild(provisioningElement);
                        if (configurationSetsItem.getDomainJoin().getProvisioning().getAccountData() != null) {
                            Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountData");
                            element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getProvisioning().getAccountData()));
                            provisioningElement.appendChild(element);
                        }
                    }
                }
                if (configurationSetsItem.getStoredCertificateSettings() != null && (!(configurationSetsItem.getStoredCertificateSettings() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getStoredCertificateSettings()).isInitialized())) {
                    Element storedCertificateSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoredCertificateSettings");
                    for (StoredCertificateSettings storedCertificateSettings : configurationSetsItem.getStoredCertificateSettings()) {
                        Element certificateSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateSetting");
                        storedCertificateSettingsSequenceElement.appendChild(certificateSettingElement);
                        Element storeLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreLocation");
                        storeLocationElement.appendChild(requestDoc.createTextNode("LocalMachine"));
                        certificateSettingElement.appendChild(storeLocationElement);
                        Element storeNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreName");
                        storeNameElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getStoreName()));
                        certificateSettingElement.appendChild(storeNameElement);
                        Element thumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Thumbprint");
                        thumbprintElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getThumbprint()));
                        certificateSettingElement.appendChild(thumbprintElement);
                    }
                    configurationSetElement.appendChild(storedCertificateSettingsSequenceElement);
                }
                if (configurationSetsItem.getWindowsRemoteManagement() != null) {
                    Element winRMElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WinRM");
                    configurationSetElement.appendChild(winRMElement);
                    if (configurationSetsItem.getWindowsRemoteManagement().getListeners() != null && (!(configurationSetsItem.getWindowsRemoteManagement().getListeners() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getWindowsRemoteManagement().getListeners()).isInitialized())) {
                        Element listenersSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listeners");
                        for (WindowsRemoteManagementListener listenersItem : configurationSetsItem.getWindowsRemoteManagement().getListeners()) {
                            Element listenerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listener");
                            listenersSequenceElement.appendChild(listenerElement);
                            if (listenersItem.getCertificateThumbprint() != null) {
                                Element certificateThumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateThumbprint");
                                certificateThumbprintElement.appendChild(requestDoc.createTextNode(listenersItem.getCertificateThumbprint()));
                                listenerElement.appendChild(certificateThumbprintElement);
                            }
                            Element protocolElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                            protocolElement3.appendChild(requestDoc.createTextNode(listenersItem.getListenerType().toString()));
                            listenerElement.appendChild(protocolElement3);
                        }
                        winRMElement.appendChild(listenersSequenceElement);
                    }
                }
                if (configurationSetsItem.getAdminUserName() != null) {
                    Element adminUsernameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminUsername");
                    adminUsernameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getAdminUserName()));
                    configurationSetElement.appendChild(adminUsernameElement);
                }
                if (configurationSetsItem.getAdditionalUnattendContent() != null) {
                    Element additionalUnattendContentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdditionalUnattendContent");
                    configurationSetElement.appendChild(additionalUnattendContentElement);
                    if (configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses() != null && (!(configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses()).isInitialized())) {
                        Element passesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Passes");
                        for (UnattendPassSettings passesItem : configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses()) {
                            Element unattendPassElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendPass");
                            passesSequenceElement.appendChild(unattendPassElement);
                            Element passNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PassName");
                            passNameElement.appendChild(requestDoc.createTextNode(passesItem.getPassName()));
                            unattendPassElement.appendChild(passNameElement);
                            if (passesItem.getUnattendComponents() == null || passesItem.getUnattendComponents() instanceof LazyCollection && !((LazyCollection)passesItem.getUnattendComponents()).isInitialized()) continue;
                            Element componentsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Components");
                            for (UnattendComponent componentsItem : passesItem.getUnattendComponents()) {
                                Element unattendComponentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendComponent");
                                componentsSequenceElement.appendChild(unattendComponentElement);
                                Element componentNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentName");
                                componentNameElement.appendChild(requestDoc.createTextNode(componentsItem.getComponentName()));
                                unattendComponentElement.appendChild(componentNameElement);
                                if (componentsItem.getUnattendComponentSettings() == null || componentsItem.getUnattendComponentSettings() instanceof LazyCollection && !((LazyCollection)componentsItem.getUnattendComponentSettings()).isInitialized()) continue;
                                Element componentSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSettings");
                                for (ComponentSetting componentSettingsItem : componentsItem.getUnattendComponentSettings()) {
                                    Element componentSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSetting");
                                    componentSettingsSequenceElement.appendChild(componentSettingElement);
                                    Element settingNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SettingName");
                                    settingNameElement.appendChild(requestDoc.createTextNode(componentSettingsItem.getSettingName()));
                                    componentSettingElement.appendChild(settingNameElement);
                                    if (componentSettingsItem.getContent() == null) continue;
                                    Element contentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Content");
                                    contentElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])componentSettingsItem.getContent().getBytes())));
                                    componentSettingElement.appendChild(contentElement);
                                }
                                unattendComponentElement.appendChild(componentSettingsSequenceElement);
                            }
                            unattendPassElement.appendChild(componentsSequenceElement);
                        }
                        additionalUnattendContentElement.appendChild(passesSequenceElement);
                    }
                }
                if (configurationSetsItem.getHostName() != null) {
                    Element hostNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostName");
                    hostNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getHostName()));
                    configurationSetElement.appendChild(hostNameElement);
                }
                if (configurationSetsItem.getUserName() != null) {
                    Element userNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserName");
                    userNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getUserName()));
                    configurationSetElement.appendChild(userNameElement);
                }
                if (configurationSetsItem.getUserPassword() != null) {
                    Element userPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserPassword");
                    userPasswordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getUserPassword()));
                    configurationSetElement.appendChild(userPasswordElement);
                }
                if (configurationSetsItem.isDisableSshPasswordAuthentication() != null) {
                    Element disableSshPasswordAuthenticationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DisableSshPasswordAuthentication");
                    disableSshPasswordAuthenticationElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isDisableSshPasswordAuthentication()).toLowerCase()));
                    configurationSetElement.appendChild(disableSshPasswordAuthenticationElement);
                }
                if (configurationSetsItem.getSshSettings() != null) {
                    Element sSHElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SSH");
                    configurationSetElement.appendChild(sSHElement);
                    if (configurationSetsItem.getSshSettings().getPublicKeys() != null && (!(configurationSetsItem.getSshSettings().getPublicKeys() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSshSettings().getPublicKeys()).isInitialized())) {
                        Element publicKeysSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKeys");
                        for (SshSettingPublicKey publicKeysItem : configurationSetsItem.getSshSettings().getPublicKeys()) {
                            Element publicKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKey");
                            publicKeysSequenceElement.appendChild(publicKeyElement);
                            Element fingerprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                            fingerprintElement.appendChild(requestDoc.createTextNode(publicKeysItem.getFingerprint()));
                            publicKeyElement.appendChild(fingerprintElement);
                            Element pathElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                            pathElement2.appendChild(requestDoc.createTextNode(publicKeysItem.getPath()));
                            publicKeyElement.appendChild(pathElement2);
                        }
                        sSHElement.appendChild(publicKeysSequenceElement);
                    }
                    if (configurationSetsItem.getSshSettings().getKeyPairs() != null && (!(configurationSetsItem.getSshSettings().getKeyPairs() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSshSettings().getKeyPairs()).isInitialized())) {
                        Element keyPairsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPairs");
                        for (SshSettingKeyPair keyPairsItem : configurationSetsItem.getSshSettings().getKeyPairs()) {
                            Element keyPairElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPair");
                            keyPairsSequenceElement.appendChild(keyPairElement);
                            Element fingerprintElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                            fingerprintElement2.appendChild(requestDoc.createTextNode(keyPairsItem.getFingerprint()));
                            keyPairElement.appendChild(fingerprintElement2);
                            Element pathElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                            pathElement3.appendChild(requestDoc.createTextNode(keyPairsItem.getPath()));
                            keyPairElement.appendChild(pathElement3);
                        }
                        sSHElement.appendChild(keyPairsSequenceElement);
                    }
                }
                if (configurationSetsItem.getCustomData() == null) continue;
                Element customDataElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CustomData");
                customDataElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getCustomData()));
                configurationSetElement.appendChild(customDataElement);
            }
            persistentVMRoleElement.appendChild(configurationSetsSequenceElement);
        }
        if (parameters.getResourceExtensionReferences() != null && (!(parameters.getResourceExtensionReferences() instanceof LazyCollection) || ((LazyCollection)parameters.getResourceExtensionReferences()).isInitialized())) {
            Element resourceExtensionReferencesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionReferences");
            for (ResourceExtensionReference resourceExtensionReferencesItem : parameters.getResourceExtensionReferences()) {
                Element resourceExtensionReferenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference");
                resourceExtensionReferencesSequenceElement.appendChild(resourceExtensionReferenceElement);
                if (resourceExtensionReferencesItem.getReferenceName() != null) {
                    Element referenceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReferenceName");
                    referenceNameElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getReferenceName()));
                    resourceExtensionReferenceElement.appendChild(referenceNameElement);
                }
                if (resourceExtensionReferencesItem.getPublisher() != null) {
                    Element publisherElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Publisher");
                    publisherElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getPublisher()));
                    resourceExtensionReferenceElement.appendChild(publisherElement);
                }
                if (resourceExtensionReferencesItem.getName() != null) {
                    Element nameElement4 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement4.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getName()));
                    resourceExtensionReferenceElement.appendChild(nameElement4);
                }
                if (resourceExtensionReferencesItem.getVersion() != null) {
                    Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
                    versionElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getVersion()));
                    resourceExtensionReferenceElement.appendChild(versionElement);
                }
                if (resourceExtensionReferencesItem.getResourceExtensionParameterValues() != null && (!(resourceExtensionReferencesItem.getResourceExtensionParameterValues() instanceof LazyCollection) || ((LazyCollection)resourceExtensionReferencesItem.getResourceExtensionParameterValues()).isInitialized())) {
                    Element resourceExtensionParameterValuesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValues");
                    for (ResourceExtensionParameterValue resourceExtensionParameterValue : resourceExtensionReferencesItem.getResourceExtensionParameterValues()) {
                        Element resourceExtensionParameterValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue");
                        resourceExtensionParameterValuesSequenceElement.appendChild(resourceExtensionParameterValueElement);
                        if (resourceExtensionParameterValue.getKey() != null) {
                            Element keyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Key");
                            keyElement.appendChild(requestDoc.createTextNode(resourceExtensionParameterValue.getKey()));
                            resourceExtensionParameterValueElement.appendChild(keyElement);
                        }
                        if (resourceExtensionParameterValue.getValue() != null) {
                            Element valueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                            valueElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])resourceExtensionParameterValue.getValue().getBytes())));
                            resourceExtensionParameterValueElement.appendChild(valueElement);
                        }
                        if (resourceExtensionParameterValue.getType() == null) continue;
                        Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
                        typeElement.appendChild(requestDoc.createTextNode(resourceExtensionParameterValue.getType()));
                        resourceExtensionParameterValueElement.appendChild(typeElement);
                    }
                    resourceExtensionReferenceElement.appendChild(resourceExtensionParameterValuesSequenceElement);
                }
                if (resourceExtensionReferencesItem.getState() != null) {
                    Element stateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "State");
                    stateElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getState()));
                    resourceExtensionReferenceElement.appendChild(stateElement);
                }
                if (resourceExtensionReferencesItem.isForceUpdate() == null) continue;
                Element forceUpdateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ForceUpdate");
                forceUpdateElement.appendChild(requestDoc.createTextNode(Boolean.toString(resourceExtensionReferencesItem.isForceUpdate()).toLowerCase()));
                resourceExtensionReferenceElement.appendChild(forceUpdateElement);
            }
            persistentVMRoleElement.appendChild(resourceExtensionReferencesSequenceElement);
        }
        if (parameters.getVMImageName() != null) {
            Element vMImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImageName");
            vMImageNameElement.appendChild(requestDoc.createTextNode(parameters.getVMImageName()));
            persistentVMRoleElement.appendChild(vMImageNameElement);
        }
        if (parameters.getMediaLocation() != null) {
            Element mediaLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLocation");
            mediaLocationElement.appendChild(requestDoc.createTextNode(parameters.getMediaLocation().toString()));
            persistentVMRoleElement.appendChild(mediaLocationElement);
        }
        if (parameters.getAvailabilitySetName() != null) {
            Element availabilitySetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AvailabilitySetName");
            availabilitySetNameElement.appendChild(requestDoc.createTextNode(parameters.getAvailabilitySetName()));
            persistentVMRoleElement.appendChild(availabilitySetNameElement);
        }
        if (parameters.getDataVirtualHardDisks() != null && (!(parameters.getDataVirtualHardDisks() instanceof LazyCollection) || ((LazyCollection)parameters.getDataVirtualHardDisks()).isInitialized())) {
            Element dataVirtualHardDisksSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisks");
            for (DataVirtualHardDisk dataVirtualHardDisksItem : parameters.getDataVirtualHardDisks()) {
                Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
                dataVirtualHardDisksSequenceElement.appendChild(dataVirtualHardDiskElement);
                if (dataVirtualHardDisksItem.getHostCaching() != null) {
                    Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                    hostCachingElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getHostCaching()));
                    dataVirtualHardDiskElement.appendChild(hostCachingElement);
                }
                if (dataVirtualHardDisksItem.getLabel() != null) {
                    Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
                    diskLabelElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getLabel()));
                    dataVirtualHardDiskElement.appendChild(diskLabelElement);
                }
                if (dataVirtualHardDisksItem.getName() != null) {
                    Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
                    diskNameElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getName()));
                    dataVirtualHardDiskElement.appendChild(diskNameElement);
                }
                if (dataVirtualHardDisksItem.getLogicalUnitNumber() != null) {
                    Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
                    lunElement.appendChild(requestDoc.createTextNode(Integer.toString(dataVirtualHardDisksItem.getLogicalUnitNumber())));
                    dataVirtualHardDiskElement.appendChild(lunElement);
                }
                if (dataVirtualHardDisksItem.getLogicalDiskSizeInGB() != null) {
                    Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                    logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(dataVirtualHardDisksItem.getLogicalDiskSizeInGB())));
                    dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
                }
                if (dataVirtualHardDisksItem.getMediaLink() != null) {
                    Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
                    mediaLinkElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getMediaLink().toString()));
                    dataVirtualHardDiskElement.appendChild(mediaLinkElement);
                }
                if (dataVirtualHardDisksItem.getSourceMediaLink() != null) {
                    Element sourceMediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
                    sourceMediaLinkElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getSourceMediaLink().toString()));
                    dataVirtualHardDiskElement.appendChild(sourceMediaLinkElement);
                }
                if (dataVirtualHardDisksItem.getIOType() == null) continue;
                Element iOTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IOType");
                iOTypeElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getIOType()));
                dataVirtualHardDiskElement.appendChild(iOTypeElement);
            }
            persistentVMRoleElement.appendChild(dataVirtualHardDisksSequenceElement);
        }
        if (parameters.getOSVirtualHardDisk() != null) {
            Element oSVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSVirtualHardDisk");
            persistentVMRoleElement.appendChild(oSVirtualHardDiskElement);
            if (parameters.getOSVirtualHardDisk().getHostCaching() != null) {
                Element hostCachingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                hostCachingElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getHostCaching()));
                oSVirtualHardDiskElement.appendChild(hostCachingElement2);
            }
            if (parameters.getOSVirtualHardDisk().getLabel() != null) {
                Element diskLabelElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
                diskLabelElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getLabel()));
                oSVirtualHardDiskElement.appendChild(diskLabelElement2);
            }
            if (parameters.getOSVirtualHardDisk().getName() != null) {
                Element diskNameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
                diskNameElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getName()));
                oSVirtualHardDiskElement.appendChild(diskNameElement2);
            }
            if (parameters.getOSVirtualHardDisk().getMediaLink() != null) {
                Element mediaLinkElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
                mediaLinkElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getMediaLink().toString()));
                oSVirtualHardDiskElement.appendChild(mediaLinkElement2);
            }
            if (parameters.getOSVirtualHardDisk().getSourceImageName() != null) {
                Element sourceImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceImageName");
                sourceImageNameElement.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getSourceImageName()));
                oSVirtualHardDiskElement.appendChild(sourceImageNameElement);
            }
            if (parameters.getOSVirtualHardDisk().getOperatingSystem() != null) {
                Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
                osElement.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getOperatingSystem()));
                oSVirtualHardDiskElement.appendChild(osElement);
            }
            if (parameters.getOSVirtualHardDisk().getRemoteSourceImageLink() != null) {
                Element remoteSourceImageLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSourceImageLink");
                remoteSourceImageLinkElement.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getRemoteSourceImageLink().toString()));
                oSVirtualHardDiskElement.appendChild(remoteSourceImageLinkElement);
            }
            if (parameters.getOSVirtualHardDisk().getIOType() != null) {
                Element iOTypeElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IOType");
                iOTypeElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getIOType()));
                oSVirtualHardDiskElement.appendChild(iOTypeElement2);
            }
            if (parameters.getOSVirtualHardDisk().getResizedSizeInGB() != null) {
                Element resizedSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResizedSizeInGB");
                resizedSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getOSVirtualHardDisk().getResizedSizeInGB())));
                oSVirtualHardDiskElement.appendChild(resizedSizeInGBElement);
            }
        }
        if (parameters.getRoleSize() != null) {
            Element roleSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleSize");
            roleSizeElement.appendChild(requestDoc.createTextNode(parameters.getRoleSize()));
            persistentVMRoleElement.appendChild(roleSizeElement);
        }
        if (parameters.isProvisionGuestAgent() != null) {
            Element provisionGuestAgentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProvisionGuestAgent");
            provisionGuestAgentElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isProvisionGuestAgent()).toLowerCase()));
            persistentVMRoleElement.appendChild(provisionGuestAgentElement);
        }
        if (parameters.getVMImageInput() != null) {
            Element vMImageInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImageInput");
            persistentVMRoleElement.appendChild(vMImageInputElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        Object var22_39 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            operationResponse = result;
        }
        catch (Throwable throwable) {
            if (var22_39 != null && var22_39.getEntity() != null) {
                var22_39.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return operationResponse;
    }

    @Override
    public Future<OperationResponse> beginCreatingDeploymentAsync(final String serviceName, final VirtualMachineCreateDeploymentParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginCreatingDeployment(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreatingDeployment(String serviceName, VirtualMachineCreateDeploymentParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDeploymentSlot() == null) {
            throw new NullPointerException("parameters.DeploymentSlot");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getRoles() == null) {
            throw new NullPointerException("parameters.Roles");
        }
        if (parameters.getRoles() != null) {
            for (Role rolesParameterItem : parameters.getRoles()) {
                if (rolesParameterItem.getConfigurationSets() == null) continue;
                for (ConfigurationSet configurationSetsParameterItem : rolesParameterItem.getConfigurationSets()) {
                    if (configurationSetsParameterItem.getAdditionalUnattendContent() != null && configurationSetsParameterItem.getAdditionalUnattendContent().getUnattendPasses() != null) {
                        for (UnattendPassSettings unattendPassesParameterItem : configurationSetsParameterItem.getAdditionalUnattendContent().getUnattendPasses()) {
                            if (unattendPassesParameterItem.getPassName() == null) {
                                throw new NullPointerException("parameters.Roles.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.PassName");
                            }
                            if (unattendPassesParameterItem.getUnattendComponents() == null) continue;
                            for (UnattendComponent unattendComponentsParameterItem : unattendPassesParameterItem.getUnattendComponents()) {
                                if (unattendComponentsParameterItem.getComponentName() == null) {
                                    throw new NullPointerException("parameters.Roles.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.UnattendComponents.ComponentName");
                                }
                                if (unattendComponentsParameterItem.getUnattendComponentSettings() == null) continue;
                                for (ComponentSetting unattendComponentSettingsParameterItem : unattendComponentsParameterItem.getUnattendComponentSettings()) {
                                    if (unattendComponentSettingsParameterItem.getSettingName() != null) continue;
                                    throw new NullPointerException("parameters.Roles.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.UnattendComponents.UnattendComponentSettings.SettingName");
                                }
                            }
                        }
                    }
                    if (configurationSetsParameterItem.getDomainJoin() != null && configurationSetsParameterItem.getDomainJoin().getCredentials() != null) {
                        if (configurationSetsParameterItem.getDomainJoin().getCredentials().getPassword() == null) {
                            throw new NullPointerException("parameters.Roles.ConfigurationSets.DomainJoin.Credentials.Password");
                        }
                        if (configurationSetsParameterItem.getDomainJoin().getCredentials().getUserName() == null) {
                            throw new NullPointerException("parameters.Roles.ConfigurationSets.DomainJoin.Credentials.UserName");
                        }
                    }
                    if (configurationSetsParameterItem.getHostName() != null && configurationSetsParameterItem.getHostName().length() < 1) {
                        throw new IllegalArgumentException("parameters.Roles.ConfigurationSets.HostName");
                    }
                    if (configurationSetsParameterItem.getHostName() != null && configurationSetsParameterItem.getHostName().length() > 64) {
                        throw new IllegalArgumentException("parameters.Roles.ConfigurationSets.HostName");
                    }
                    if (configurationSetsParameterItem.getSshSettings() != null) {
                        if (configurationSetsParameterItem.getSshSettings().getKeyPairs() != null) {
                            for (SshSettingKeyPair keyPairsParameterItem : configurationSetsParameterItem.getSshSettings().getKeyPairs()) {
                                if (keyPairsParameterItem.getFingerprint() == null) {
                                    throw new NullPointerException("parameters.Roles.ConfigurationSets.SshSettings.KeyPairs.Fingerprint");
                                }
                                if (keyPairsParameterItem.getPath() != null) continue;
                                throw new NullPointerException("parameters.Roles.ConfigurationSets.SshSettings.KeyPairs.Path");
                            }
                        }
                        if (configurationSetsParameterItem.getSshSettings().getPublicKeys() != null) {
                            for (SshSettingPublicKey publicKeysParameterItem : configurationSetsParameterItem.getSshSettings().getPublicKeys()) {
                                if (publicKeysParameterItem.getFingerprint() == null) {
                                    throw new NullPointerException("parameters.Roles.ConfigurationSets.SshSettings.PublicKeys.Fingerprint");
                                }
                                if (publicKeysParameterItem.getPath() != null) continue;
                                throw new NullPointerException("parameters.Roles.ConfigurationSets.SshSettings.PublicKeys.Path");
                            }
                        }
                    }
                    if (configurationSetsParameterItem.getStoredCertificateSettings() != null) {
                        for (StoredCertificateSettings storedCertificateSettingsParameterItem : configurationSetsParameterItem.getStoredCertificateSettings()) {
                            if (storedCertificateSettingsParameterItem.getStoreName() == null) {
                                throw new NullPointerException("parameters.Roles.ConfigurationSets.StoredCertificateSettings.StoreName");
                            }
                            if (storedCertificateSettingsParameterItem.getThumbprint() != null) continue;
                            throw new NullPointerException("parameters.Roles.ConfigurationSets.StoredCertificateSettings.Thumbprint");
                        }
                    }
                    if (configurationSetsParameterItem.getUserName() != null && configurationSetsParameterItem.getUserName().length() < 1) {
                        throw new IllegalArgumentException("parameters.Roles.ConfigurationSets.UserName");
                    }
                    if (configurationSetsParameterItem.getUserName() != null && configurationSetsParameterItem.getUserName().length() > 32) {
                        throw new IllegalArgumentException("parameters.Roles.ConfigurationSets.UserName");
                    }
                    if (configurationSetsParameterItem.getUserPassword() != null && configurationSetsParameterItem.getUserPassword().length() < 6) {
                        throw new IllegalArgumentException("parameters.Roles.ConfigurationSets.UserPassword");
                    }
                    if (configurationSetsParameterItem.getUserPassword() != null && configurationSetsParameterItem.getUserPassword().length() > 72) {
                        throw new IllegalArgumentException("parameters.Roles.ConfigurationSets.UserPassword");
                    }
                    if (configurationSetsParameterItem.getWindowsRemoteManagement() == null || configurationSetsParameterItem.getWindowsRemoteManagement().getListeners() == null) continue;
                    for (WindowsRemoteManagementListener listenersParameterItem : configurationSetsParameterItem.getWindowsRemoteManagement().getListeners()) {
                        if (listenersParameterItem.getListenerType() != null) continue;
                        throw new NullPointerException("parameters.Roles.ConfigurationSets.WindowsRemoteManagement.Listeners.ListenerType");
                    }
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingDeploymentAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element deploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Deployment");
        requestDoc.appendChild(deploymentElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        deploymentElement.appendChild(nameElement);
        Element deploymentSlotElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DeploymentSlot");
        deploymentSlotElement.appendChild(requestDoc.createTextNode(parameters.getDeploymentSlot().toString()));
        deploymentElement.appendChild(deploymentSlotElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        deploymentElement.appendChild(labelElement);
        if (!(parameters.getRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getRoles()).isInitialized()) {
            Element roleListSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleList");
            for (Role role : parameters.getRoles()) {
                Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                roleListSequenceElement.appendChild(roleElement);
                if (role.getRoleName() != null) {
                    Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                    roleNameElement.appendChild(requestDoc.createTextNode(role.getRoleName()));
                    roleElement.appendChild(roleNameElement);
                }
                if (role.getOSVersion() != null) {
                    Element osVersionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OsVersion");
                    osVersionElement.appendChild(requestDoc.createTextNode(role.getOSVersion()));
                    roleElement.appendChild(osVersionElement);
                }
                if (role.getRoleType() != null) {
                    Element roleTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleType");
                    roleTypeElement.appendChild(requestDoc.createTextNode(role.getRoleType()));
                    roleElement.appendChild(roleTypeElement);
                }
                if (role.getConfigurationSets() != null && (!(role.getConfigurationSets() instanceof LazyCollection) || ((LazyCollection)role.getConfigurationSets()).isInitialized())) {
                    Element configurationSetsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSets");
                    for (ConfigurationSet configurationSetsItem : role.getConfigurationSets()) {
                        Element configurationSetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSet");
                        configurationSetsSequenceElement.appendChild(configurationSetElement);
                        if (configurationSetsItem.getConfigurationSetType() != null) {
                            Element configurationSetTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSetType");
                            configurationSetTypeElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getConfigurationSetType()));
                            configurationSetElement.appendChild(configurationSetTypeElement);
                        }
                        if (configurationSetsItem.getInputEndpoints() != null && (!(configurationSetsItem.getInputEndpoints() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getInputEndpoints()).isInitialized())) {
                            Element inputEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                            for (InputEndpoint inputEndpoint : configurationSetsItem.getInputEndpoints()) {
                                Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                                inputEndpointsSequenceElement.appendChild(inputEndpointElement);
                                if (inputEndpoint.getLoadBalancedEndpointSetName() != null) {
                                    Element loadBalancedEndpointSetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                                    loadBalancedEndpointSetNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancedEndpointSetName()));
                                    inputEndpointElement.appendChild(loadBalancedEndpointSetNameElement);
                                }
                                if (inputEndpoint.getLocalPort() != null) {
                                    Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                                    localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLocalPort())));
                                    inputEndpointElement.appendChild(localPortElement);
                                }
                                if (inputEndpoint.getName() != null) {
                                    Element nameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                                    nameElement2.appendChild(requestDoc.createTextNode(inputEndpoint.getName()));
                                    inputEndpointElement.appendChild(nameElement2);
                                }
                                if (inputEndpoint.getPort() != null) {
                                    Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                                    portElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getPort())));
                                    inputEndpointElement.appendChild(portElement);
                                }
                                if (inputEndpoint.getLoadBalancerProbe() != null) {
                                    Element loadBalancerProbeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                                    inputEndpointElement.appendChild(loadBalancerProbeElement);
                                    if (inputEndpoint.getLoadBalancerProbe().getPath() != null) {
                                        Element pathElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                                        pathElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerProbe().getPath()));
                                        loadBalancerProbeElement.appendChild(pathElement);
                                    }
                                    Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                                    portElement2.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getPort())));
                                    loadBalancerProbeElement.appendChild(portElement2);
                                    if (inputEndpoint.getLoadBalancerProbe().getProtocol() != null) {
                                        Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                                        protocolElement.appendChild(requestDoc.createTextNode(ComputeManagementClientImpl.loadBalancerProbeTransportProtocolToString(inputEndpoint.getLoadBalancerProbe().getProtocol())));
                                        loadBalancerProbeElement.appendChild(protocolElement);
                                    }
                                    if (inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds() != null) {
                                        Element intervalInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                                        intervalInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds())));
                                        loadBalancerProbeElement.appendChild(intervalInSecondsElement);
                                    }
                                    if (inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds() != null) {
                                        Element timeoutInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                                        timeoutInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds())));
                                        loadBalancerProbeElement.appendChild(timeoutInSecondsElement);
                                    }
                                }
                                if (inputEndpoint.getProtocol() != null) {
                                    Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                                    protocolElement2.appendChild(requestDoc.createTextNode(inputEndpoint.getProtocol()));
                                    inputEndpointElement.appendChild(protocolElement2);
                                }
                                if (inputEndpoint.getVirtualIPAddress() != null) {
                                    Element vipElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Vip");
                                    vipElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPAddress().getHostAddress()));
                                    inputEndpointElement.appendChild(vipElement);
                                }
                                if (inputEndpoint.isEnableDirectServerReturn() != null) {
                                    Element enableDirectServerReturnElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                                    enableDirectServerReturnElement.appendChild(requestDoc.createTextNode(Boolean.toString(inputEndpoint.isEnableDirectServerReturn()).toLowerCase()));
                                    inputEndpointElement.appendChild(enableDirectServerReturnElement);
                                }
                                if (inputEndpoint.getLoadBalancerName() != null) {
                                    Element loadBalancerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                                    loadBalancerNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerName()));
                                    inputEndpointElement.appendChild(loadBalancerNameElement);
                                }
                                if (inputEndpoint.getEndpointAcl() != null) {
                                    Element endpointAclElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                                    inputEndpointElement.appendChild(endpointAclElement);
                                    if (inputEndpoint.getEndpointAcl().getRules() != null && (!(inputEndpoint.getEndpointAcl().getRules() instanceof LazyCollection) || ((LazyCollection)inputEndpoint.getEndpointAcl().getRules()).isInitialized())) {
                                        Element rulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rules");
                                        for (AccessControlListRule rulesItem : inputEndpoint.getEndpointAcl().getRules()) {
                                            Element ruleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rule");
                                            rulesSequenceElement.appendChild(ruleElement);
                                            if (rulesItem.getOrder() != null) {
                                                Element orderElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Order");
                                                orderElement.appendChild(requestDoc.createTextNode(Integer.toString(rulesItem.getOrder())));
                                                ruleElement.appendChild(orderElement);
                                            }
                                            if (rulesItem.getAction() != null) {
                                                Element actionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Action");
                                                actionElement.appendChild(requestDoc.createTextNode(rulesItem.getAction()));
                                                ruleElement.appendChild(actionElement);
                                            }
                                            if (rulesItem.getRemoteSubnet() != null) {
                                                Element remoteSubnetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                                                remoteSubnetElement.appendChild(requestDoc.createTextNode(rulesItem.getRemoteSubnet()));
                                                ruleElement.appendChild(remoteSubnetElement);
                                            }
                                            if (rulesItem.getDescription() == null) continue;
                                            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
                                            descriptionElement.appendChild(requestDoc.createTextNode(rulesItem.getDescription()));
                                            ruleElement.appendChild(descriptionElement);
                                        }
                                        endpointAclElement.appendChild(rulesSequenceElement);
                                    }
                                }
                                if (inputEndpoint.getIdleTimeoutInMinutes() != null) {
                                    Element idleTimeoutInMinutesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                    idleTimeoutInMinutesElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getIdleTimeoutInMinutes())));
                                    inputEndpointElement.appendChild(idleTimeoutInMinutesElement);
                                }
                                if (inputEndpoint.getLoadBalancerDistribution() != null) {
                                    Element loadBalancerDistributionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                                    loadBalancerDistributionElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerDistribution()));
                                    inputEndpointElement.appendChild(loadBalancerDistributionElement);
                                }
                                if (inputEndpoint.getVirtualIPName() == null) continue;
                                Element virtualIPNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VirtualIPName");
                                virtualIPNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPName()));
                                inputEndpointElement.appendChild(virtualIPNameElement);
                            }
                            configurationSetElement.appendChild(inputEndpointsSequenceElement);
                        }
                        if (configurationSetsItem.getSubnetNames() != null && (!(configurationSetsItem.getSubnetNames() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSubnetNames()).isInitialized())) {
                            Element subnetNamesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetNames");
                            for (String string : configurationSetsItem.getSubnetNames()) {
                                Element subnetNamesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                                subnetNamesItemElement.appendChild(requestDoc.createTextNode(string));
                                subnetNamesSequenceElement.appendChild(subnetNamesItemElement);
                            }
                            configurationSetElement.appendChild(subnetNamesSequenceElement);
                        }
                        if (configurationSetsItem.getStaticVirtualNetworkIPAddress() != null) {
                            Element staticVirtualNetworkIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                            staticVirtualNetworkIPAddressElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getStaticVirtualNetworkIPAddress()));
                            configurationSetElement.appendChild(staticVirtualNetworkIPAddressElement);
                        }
                        if (configurationSetsItem.getPublicIPs() != null && (!(configurationSetsItem.getPublicIPs() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getPublicIPs()).isInitialized())) {
                            Element publicIPsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIPs");
                            for (ConfigurationSet.PublicIP publicIP : configurationSetsItem.getPublicIPs()) {
                                Element publicIPElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIP");
                                publicIPsSequenceElement.appendChild(publicIPElement);
                                if (publicIP.getName() != null) {
                                    Element nameElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                                    nameElement3.appendChild(requestDoc.createTextNode(publicIP.getName()));
                                    publicIPElement.appendChild(nameElement3);
                                }
                                if (publicIP.getIdleTimeoutInMinutes() != null) {
                                    Element idleTimeoutInMinutesElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                    idleTimeoutInMinutesElement2.appendChild(requestDoc.createTextNode(Integer.toString(publicIP.getIdleTimeoutInMinutes())));
                                    publicIPElement.appendChild(idleTimeoutInMinutesElement2);
                                }
                                if (publicIP.getDomainNameLabel() == null) continue;
                                Element domainNameLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainNameLabel");
                                domainNameLabelElement.appendChild(requestDoc.createTextNode(publicIP.getDomainNameLabel()));
                                publicIPElement.appendChild(domainNameLabelElement);
                            }
                            configurationSetElement.appendChild(publicIPsSequenceElement);
                        }
                        if (configurationSetsItem.getNetworkInterfaces() != null && (!(configurationSetsItem.getNetworkInterfaces() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getNetworkInterfaces()).isInitialized())) {
                            Element networkInterfacesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                            for (NetworkInterface networkInterface : configurationSetsItem.getNetworkInterfaces()) {
                                Element networkInterfaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterface");
                                networkInterfacesSequenceElement.appendChild(networkInterfaceElement);
                                if (networkInterface.getName() != null) {
                                    Element nameElement4 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                                    nameElement4.appendChild(requestDoc.createTextNode(networkInterface.getName()));
                                    networkInterfaceElement.appendChild(nameElement4);
                                }
                                if (networkInterface.getIPConfigurations() != null && (!(networkInterface.getIPConfigurations() instanceof LazyCollection) || ((LazyCollection)networkInterface.getIPConfigurations()).isInitialized())) {
                                    Element iPConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                                    for (IPConfiguration iPConfigurationsItem : networkInterface.getIPConfigurations()) {
                                        Element iPConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfiguration");
                                        iPConfigurationsSequenceElement.appendChild(iPConfigurationElement);
                                        if (iPConfigurationsItem.getSubnetName() != null) {
                                            Element subnetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                                            subnetNameElement.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getSubnetName()));
                                            iPConfigurationElement.appendChild(subnetNameElement);
                                        }
                                        if (iPConfigurationsItem.getStaticVirtualNetworkIPAddress() == null) continue;
                                        Element staticVirtualNetworkIPAddressElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                        staticVirtualNetworkIPAddressElement2.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getStaticVirtualNetworkIPAddress()));
                                        iPConfigurationElement.appendChild(staticVirtualNetworkIPAddressElement2);
                                    }
                                    networkInterfaceElement.appendChild(iPConfigurationsSequenceElement);
                                }
                                if (networkInterface.getNetworkSecurityGroup() != null) {
                                    Element networkSecurityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                                    networkSecurityGroupElement.appendChild(requestDoc.createTextNode(networkInterface.getNetworkSecurityGroup()));
                                    networkInterfaceElement.appendChild(networkSecurityGroupElement);
                                }
                                if (networkInterface.getIPForwarding() == null) continue;
                                Element iPForwardingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                                iPForwardingElement.appendChild(requestDoc.createTextNode(networkInterface.getIPForwarding()));
                                networkInterfaceElement.appendChild(iPForwardingElement);
                            }
                            configurationSetElement.appendChild(networkInterfacesSequenceElement);
                        }
                        if (configurationSetsItem.getNetworkSecurityGroup() != null) {
                            Element networkSecurityGroupElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                            networkSecurityGroupElement2.appendChild(requestDoc.createTextNode(configurationSetsItem.getNetworkSecurityGroup()));
                            configurationSetElement.appendChild(networkSecurityGroupElement2);
                        }
                        if (configurationSetsItem.getIPForwarding() != null) {
                            Element iPForwardingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                            iPForwardingElement2.appendChild(requestDoc.createTextNode(configurationSetsItem.getIPForwarding()));
                            configurationSetElement.appendChild(iPForwardingElement2);
                        }
                        if (configurationSetsItem.getComputerName() != null) {
                            Element computerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComputerName");
                            computerNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getComputerName()));
                            configurationSetElement.appendChild(computerNameElement);
                        }
                        if (configurationSetsItem.getAdminPassword() != null) {
                            Element adminPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminPassword");
                            adminPasswordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getAdminPassword()));
                            configurationSetElement.appendChild(adminPasswordElement);
                        }
                        if (configurationSetsItem.isResetPasswordOnFirstLogon() != null) {
                            Element resetPasswordOnFirstLogonElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResetPasswordOnFirstLogon");
                            resetPasswordOnFirstLogonElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isResetPasswordOnFirstLogon()).toLowerCase()));
                            configurationSetElement.appendChild(resetPasswordOnFirstLogonElement);
                        }
                        if (configurationSetsItem.isEnableAutomaticUpdates() != null) {
                            Element enableAutomaticUpdatesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableAutomaticUpdates");
                            enableAutomaticUpdatesElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isEnableAutomaticUpdates()).toLowerCase()));
                            configurationSetElement.appendChild(enableAutomaticUpdatesElement);
                        }
                        if (configurationSetsItem.getTimeZone() != null) {
                            Element timeZoneElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeZone");
                            timeZoneElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getTimeZone()));
                            configurationSetElement.appendChild(timeZoneElement);
                        }
                        if (configurationSetsItem.getDomainJoin() != null) {
                            Element domainJoinElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainJoin");
                            configurationSetElement.appendChild(domainJoinElement);
                            if (configurationSetsItem.getDomainJoin().getCredentials() != null) {
                                Element credentialsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Credentials");
                                domainJoinElement.appendChild(credentialsElement);
                                if (configurationSetsItem.getDomainJoin().getCredentials().getDomain() != null) {
                                    Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Domain");
                                    element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getDomain()));
                                    credentialsElement.appendChild(element);
                                }
                                Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Username");
                                element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getUserName()));
                                credentialsElement.appendChild(element);
                                Element passwordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Password");
                                passwordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getPassword()));
                                credentialsElement.appendChild(passwordElement);
                            }
                            if (configurationSetsItem.getDomainJoin().getDomainToJoin() != null) {
                                Element joinDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "JoinDomain");
                                joinDomainElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getDomainToJoin()));
                                domainJoinElement.appendChild(joinDomainElement);
                            }
                            if (configurationSetsItem.getDomainJoin().getLdapMachineObjectOU() != null) {
                                Element machineObjectOUElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MachineObjectOU");
                                machineObjectOUElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getLdapMachineObjectOU()));
                                domainJoinElement.appendChild(machineObjectOUElement);
                            }
                            if (configurationSetsItem.getDomainJoin().getProvisioning() != null) {
                                Element provisioningElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Provisioning");
                                domainJoinElement.appendChild(provisioningElement);
                                if (configurationSetsItem.getDomainJoin().getProvisioning().getAccountData() != null) {
                                    Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountData");
                                    element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getProvisioning().getAccountData()));
                                    provisioningElement.appendChild(element);
                                }
                            }
                        }
                        if (configurationSetsItem.getStoredCertificateSettings() != null && (!(configurationSetsItem.getStoredCertificateSettings() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getStoredCertificateSettings()).isInitialized())) {
                            Element storedCertificateSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoredCertificateSettings");
                            for (StoredCertificateSettings storedCertificateSettings : configurationSetsItem.getStoredCertificateSettings()) {
                                Element certificateSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateSetting");
                                storedCertificateSettingsSequenceElement.appendChild(certificateSettingElement);
                                Element storeLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreLocation");
                                storeLocationElement.appendChild(requestDoc.createTextNode("LocalMachine"));
                                certificateSettingElement.appendChild(storeLocationElement);
                                Element storeNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreName");
                                storeNameElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getStoreName()));
                                certificateSettingElement.appendChild(storeNameElement);
                                Element thumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Thumbprint");
                                thumbprintElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getThumbprint()));
                                certificateSettingElement.appendChild(thumbprintElement);
                            }
                            configurationSetElement.appendChild(storedCertificateSettingsSequenceElement);
                        }
                        if (configurationSetsItem.getWindowsRemoteManagement() != null) {
                            Element winRMElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WinRM");
                            configurationSetElement.appendChild(winRMElement);
                            if (configurationSetsItem.getWindowsRemoteManagement().getListeners() != null && (!(configurationSetsItem.getWindowsRemoteManagement().getListeners() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getWindowsRemoteManagement().getListeners()).isInitialized())) {
                                Element listenersSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listeners");
                                for (WindowsRemoteManagementListener listenersItem : configurationSetsItem.getWindowsRemoteManagement().getListeners()) {
                                    Element listenerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listener");
                                    listenersSequenceElement.appendChild(listenerElement);
                                    if (listenersItem.getCertificateThumbprint() != null) {
                                        Element certificateThumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateThumbprint");
                                        certificateThumbprintElement.appendChild(requestDoc.createTextNode(listenersItem.getCertificateThumbprint()));
                                        listenerElement.appendChild(certificateThumbprintElement);
                                    }
                                    Element protocolElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                                    protocolElement3.appendChild(requestDoc.createTextNode(listenersItem.getListenerType().toString()));
                                    listenerElement.appendChild(protocolElement3);
                                }
                                winRMElement.appendChild(listenersSequenceElement);
                            }
                        }
                        if (configurationSetsItem.getAdminUserName() != null) {
                            Element adminUsernameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminUsername");
                            adminUsernameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getAdminUserName()));
                            configurationSetElement.appendChild(adminUsernameElement);
                        }
                        if (configurationSetsItem.getAdditionalUnattendContent() != null) {
                            Element additionalUnattendContentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdditionalUnattendContent");
                            configurationSetElement.appendChild(additionalUnattendContentElement);
                            if (configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses() != null && (!(configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses()).isInitialized())) {
                                Element passesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Passes");
                                for (UnattendPassSettings passesItem : configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses()) {
                                    Element unattendPassElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendPass");
                                    passesSequenceElement.appendChild(unattendPassElement);
                                    Element passNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PassName");
                                    passNameElement.appendChild(requestDoc.createTextNode(passesItem.getPassName()));
                                    unattendPassElement.appendChild(passNameElement);
                                    if (passesItem.getUnattendComponents() == null || passesItem.getUnattendComponents() instanceof LazyCollection && !((LazyCollection)passesItem.getUnattendComponents()).isInitialized()) continue;
                                    Element componentsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Components");
                                    for (UnattendComponent componentsItem : passesItem.getUnattendComponents()) {
                                        Element unattendComponentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendComponent");
                                        componentsSequenceElement.appendChild(unattendComponentElement);
                                        Element componentNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentName");
                                        componentNameElement.appendChild(requestDoc.createTextNode(componentsItem.getComponentName()));
                                        unattendComponentElement.appendChild(componentNameElement);
                                        if (componentsItem.getUnattendComponentSettings() == null || componentsItem.getUnattendComponentSettings() instanceof LazyCollection && !((LazyCollection)componentsItem.getUnattendComponentSettings()).isInitialized()) continue;
                                        Element componentSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSettings");
                                        for (ComponentSetting componentSettingsItem : componentsItem.getUnattendComponentSettings()) {
                                            Element componentSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSetting");
                                            componentSettingsSequenceElement.appendChild(componentSettingElement);
                                            Element settingNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SettingName");
                                            settingNameElement.appendChild(requestDoc.createTextNode(componentSettingsItem.getSettingName()));
                                            componentSettingElement.appendChild(settingNameElement);
                                            if (componentSettingsItem.getContent() == null) continue;
                                            Element contentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Content");
                                            contentElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])componentSettingsItem.getContent().getBytes())));
                                            componentSettingElement.appendChild(contentElement);
                                        }
                                        unattendComponentElement.appendChild(componentSettingsSequenceElement);
                                    }
                                    unattendPassElement.appendChild(componentsSequenceElement);
                                }
                                additionalUnattendContentElement.appendChild(passesSequenceElement);
                            }
                        }
                        if (configurationSetsItem.getHostName() != null) {
                            Element hostNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostName");
                            hostNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getHostName()));
                            configurationSetElement.appendChild(hostNameElement);
                        }
                        if (configurationSetsItem.getUserName() != null) {
                            Element userNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserName");
                            userNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getUserName()));
                            configurationSetElement.appendChild(userNameElement);
                        }
                        if (configurationSetsItem.getUserPassword() != null) {
                            Element userPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserPassword");
                            userPasswordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getUserPassword()));
                            configurationSetElement.appendChild(userPasswordElement);
                        }
                        if (configurationSetsItem.isDisableSshPasswordAuthentication() != null) {
                            Element disableSshPasswordAuthenticationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DisableSshPasswordAuthentication");
                            disableSshPasswordAuthenticationElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isDisableSshPasswordAuthentication()).toLowerCase()));
                            configurationSetElement.appendChild(disableSshPasswordAuthenticationElement);
                        }
                        if (configurationSetsItem.getSshSettings() != null) {
                            Element sSHElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SSH");
                            configurationSetElement.appendChild(sSHElement);
                            if (configurationSetsItem.getSshSettings().getPublicKeys() != null && (!(configurationSetsItem.getSshSettings().getPublicKeys() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSshSettings().getPublicKeys()).isInitialized())) {
                                Element publicKeysSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKeys");
                                for (SshSettingPublicKey publicKeysItem : configurationSetsItem.getSshSettings().getPublicKeys()) {
                                    Element publicKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKey");
                                    publicKeysSequenceElement.appendChild(publicKeyElement);
                                    Element fingerprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                                    fingerprintElement.appendChild(requestDoc.createTextNode(publicKeysItem.getFingerprint()));
                                    publicKeyElement.appendChild(fingerprintElement);
                                    Element pathElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                                    pathElement2.appendChild(requestDoc.createTextNode(publicKeysItem.getPath()));
                                    publicKeyElement.appendChild(pathElement2);
                                }
                                sSHElement.appendChild(publicKeysSequenceElement);
                            }
                            if (configurationSetsItem.getSshSettings().getKeyPairs() != null && (!(configurationSetsItem.getSshSettings().getKeyPairs() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSshSettings().getKeyPairs()).isInitialized())) {
                                Element keyPairsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPairs");
                                for (SshSettingKeyPair keyPairsItem : configurationSetsItem.getSshSettings().getKeyPairs()) {
                                    Element keyPairElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPair");
                                    keyPairsSequenceElement.appendChild(keyPairElement);
                                    Element fingerprintElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                                    fingerprintElement2.appendChild(requestDoc.createTextNode(keyPairsItem.getFingerprint()));
                                    keyPairElement.appendChild(fingerprintElement2);
                                    Element pathElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                                    pathElement3.appendChild(requestDoc.createTextNode(keyPairsItem.getPath()));
                                    keyPairElement.appendChild(pathElement3);
                                }
                                sSHElement.appendChild(keyPairsSequenceElement);
                            }
                        }
                        if (configurationSetsItem.getCustomData() == null) continue;
                        Element customDataElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CustomData");
                        customDataElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getCustomData()));
                        configurationSetElement.appendChild(customDataElement);
                    }
                    roleElement.appendChild(configurationSetsSequenceElement);
                }
                if (role.getResourceExtensionReferences() != null && (!(role.getResourceExtensionReferences() instanceof LazyCollection) || ((LazyCollection)role.getResourceExtensionReferences()).isInitialized())) {
                    Element resourceExtensionReferencesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionReferences");
                    for (ResourceExtensionReference resourceExtensionReferencesItem : role.getResourceExtensionReferences()) {
                        Element resourceExtensionReferenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference");
                        resourceExtensionReferencesSequenceElement.appendChild(resourceExtensionReferenceElement);
                        if (resourceExtensionReferencesItem.getReferenceName() != null) {
                            Element referenceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReferenceName");
                            referenceNameElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getReferenceName()));
                            resourceExtensionReferenceElement.appendChild(referenceNameElement);
                        }
                        if (resourceExtensionReferencesItem.getPublisher() != null) {
                            Element publisherElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Publisher");
                            publisherElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getPublisher()));
                            resourceExtensionReferenceElement.appendChild(publisherElement);
                        }
                        if (resourceExtensionReferencesItem.getName() != null) {
                            Element nameElement5 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement5.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getName()));
                            resourceExtensionReferenceElement.appendChild(nameElement5);
                        }
                        if (resourceExtensionReferencesItem.getVersion() != null) {
                            Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
                            versionElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getVersion()));
                            resourceExtensionReferenceElement.appendChild(versionElement);
                        }
                        if (resourceExtensionReferencesItem.getResourceExtensionParameterValues() != null && (!(resourceExtensionReferencesItem.getResourceExtensionParameterValues() instanceof LazyCollection) || ((LazyCollection)resourceExtensionReferencesItem.getResourceExtensionParameterValues()).isInitialized())) {
                            Element resourceExtensionParameterValuesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValues");
                            for (ResourceExtensionParameterValue resourceExtensionParameterValue : resourceExtensionReferencesItem.getResourceExtensionParameterValues()) {
                                Element resourceExtensionParameterValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue");
                                resourceExtensionParameterValuesSequenceElement.appendChild(resourceExtensionParameterValueElement);
                                if (resourceExtensionParameterValue.getKey() != null) {
                                    Element keyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Key");
                                    keyElement.appendChild(requestDoc.createTextNode(resourceExtensionParameterValue.getKey()));
                                    resourceExtensionParameterValueElement.appendChild(keyElement);
                                }
                                if (resourceExtensionParameterValue.getValue() != null) {
                                    Element valueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                                    valueElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])resourceExtensionParameterValue.getValue().getBytes())));
                                    resourceExtensionParameterValueElement.appendChild(valueElement);
                                }
                                if (resourceExtensionParameterValue.getType() == null) continue;
                                Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
                                typeElement.appendChild(requestDoc.createTextNode(resourceExtensionParameterValue.getType()));
                                resourceExtensionParameterValueElement.appendChild(typeElement);
                            }
                            resourceExtensionReferenceElement.appendChild(resourceExtensionParameterValuesSequenceElement);
                        }
                        if (resourceExtensionReferencesItem.getState() != null) {
                            Element stateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "State");
                            stateElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getState()));
                            resourceExtensionReferenceElement.appendChild(stateElement);
                        }
                        if (resourceExtensionReferencesItem.isForceUpdate() == null) continue;
                        Element forceUpdateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ForceUpdate");
                        forceUpdateElement.appendChild(requestDoc.createTextNode(Boolean.toString(resourceExtensionReferencesItem.isForceUpdate()).toLowerCase()));
                        resourceExtensionReferenceElement.appendChild(forceUpdateElement);
                    }
                    roleElement.appendChild(resourceExtensionReferencesSequenceElement);
                }
                if (role.getVMImageName() != null) {
                    Element vMImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImageName");
                    vMImageNameElement.appendChild(requestDoc.createTextNode(role.getVMImageName()));
                    roleElement.appendChild(vMImageNameElement);
                }
                if (role.getMediaLocation() != null) {
                    Element mediaLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLocation");
                    mediaLocationElement.appendChild(requestDoc.createTextNode(role.getMediaLocation().toString()));
                    roleElement.appendChild(mediaLocationElement);
                }
                if (role.getAvailabilitySetName() != null) {
                    Element availabilitySetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AvailabilitySetName");
                    availabilitySetNameElement.appendChild(requestDoc.createTextNode(role.getAvailabilitySetName()));
                    roleElement.appendChild(availabilitySetNameElement);
                }
                if (role.getDataVirtualHardDisks() != null && (!(role.getDataVirtualHardDisks() instanceof LazyCollection) || ((LazyCollection)role.getDataVirtualHardDisks()).isInitialized())) {
                    Element dataVirtualHardDisksSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisks");
                    for (DataVirtualHardDisk dataVirtualHardDisksItem : role.getDataVirtualHardDisks()) {
                        Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
                        dataVirtualHardDisksSequenceElement.appendChild(dataVirtualHardDiskElement);
                        if (dataVirtualHardDisksItem.getHostCaching() != null) {
                            Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                            hostCachingElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getHostCaching()));
                            dataVirtualHardDiskElement.appendChild(hostCachingElement);
                        }
                        if (dataVirtualHardDisksItem.getLabel() != null) {
                            Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
                            diskLabelElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getLabel()));
                            dataVirtualHardDiskElement.appendChild(diskLabelElement);
                        }
                        if (dataVirtualHardDisksItem.getName() != null) {
                            Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
                            diskNameElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getName()));
                            dataVirtualHardDiskElement.appendChild(diskNameElement);
                        }
                        if (dataVirtualHardDisksItem.getLogicalUnitNumber() != null) {
                            Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
                            lunElement.appendChild(requestDoc.createTextNode(Integer.toString(dataVirtualHardDisksItem.getLogicalUnitNumber())));
                            dataVirtualHardDiskElement.appendChild(lunElement);
                        }
                        if (dataVirtualHardDisksItem.getLogicalDiskSizeInGB() != null) {
                            Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                            logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(dataVirtualHardDisksItem.getLogicalDiskSizeInGB())));
                            dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
                        }
                        if (dataVirtualHardDisksItem.getMediaLink() != null) {
                            Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
                            mediaLinkElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getMediaLink().toString()));
                            dataVirtualHardDiskElement.appendChild(mediaLinkElement);
                        }
                        if (dataVirtualHardDisksItem.getSourceMediaLink() != null) {
                            Element sourceMediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
                            sourceMediaLinkElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getSourceMediaLink().toString()));
                            dataVirtualHardDiskElement.appendChild(sourceMediaLinkElement);
                        }
                        if (dataVirtualHardDisksItem.getIOType() == null) continue;
                        Element iOTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IOType");
                        iOTypeElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getIOType()));
                        dataVirtualHardDiskElement.appendChild(iOTypeElement);
                    }
                    roleElement.appendChild(dataVirtualHardDisksSequenceElement);
                }
                if (role.getLabel() != null) {
                    Element labelElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
                    labelElement2.appendChild(requestDoc.createTextNode(role.getLabel()));
                    roleElement.appendChild(labelElement2);
                }
                if (role.getOSVirtualHardDisk() != null) {
                    Element oSVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSVirtualHardDisk");
                    roleElement.appendChild(oSVirtualHardDiskElement);
                    if (role.getOSVirtualHardDisk().getHostCaching() != null) {
                        Element hostCachingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                        hostCachingElement2.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getHostCaching()));
                        oSVirtualHardDiskElement.appendChild(hostCachingElement2);
                    }
                    if (role.getOSVirtualHardDisk().getLabel() != null) {
                        Element diskLabelElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
                        diskLabelElement2.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getLabel()));
                        oSVirtualHardDiskElement.appendChild(diskLabelElement2);
                    }
                    if (role.getOSVirtualHardDisk().getName() != null) {
                        Element diskNameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
                        diskNameElement2.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getName()));
                        oSVirtualHardDiskElement.appendChild(diskNameElement2);
                    }
                    if (role.getOSVirtualHardDisk().getMediaLink() != null) {
                        Element mediaLinkElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
                        mediaLinkElement2.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getMediaLink().toString()));
                        oSVirtualHardDiskElement.appendChild(mediaLinkElement2);
                    }
                    if (role.getOSVirtualHardDisk().getSourceImageName() != null) {
                        Element sourceImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceImageName");
                        sourceImageNameElement.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getSourceImageName()));
                        oSVirtualHardDiskElement.appendChild(sourceImageNameElement);
                    }
                    if (role.getOSVirtualHardDisk().getOperatingSystem() != null) {
                        Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
                        osElement.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getOperatingSystem()));
                        oSVirtualHardDiskElement.appendChild(osElement);
                    }
                    if (role.getOSVirtualHardDisk().getRemoteSourceImageLink() != null) {
                        Element remoteSourceImageLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSourceImageLink");
                        remoteSourceImageLinkElement.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getRemoteSourceImageLink().toString()));
                        oSVirtualHardDiskElement.appendChild(remoteSourceImageLinkElement);
                    }
                    if (role.getOSVirtualHardDisk().getIOType() != null) {
                        Element iOTypeElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IOType");
                        iOTypeElement2.appendChild(requestDoc.createTextNode(role.getOSVirtualHardDisk().getIOType()));
                        oSVirtualHardDiskElement.appendChild(iOTypeElement2);
                    }
                    if (role.getOSVirtualHardDisk().getResizedSizeInGB() != null) {
                        Element resizedSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResizedSizeInGB");
                        resizedSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(role.getOSVirtualHardDisk().getResizedSizeInGB())));
                        oSVirtualHardDiskElement.appendChild(resizedSizeInGBElement);
                    }
                }
                if (role.getRoleSize() != null) {
                    Element roleSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleSize");
                    roleSizeElement.appendChild(requestDoc.createTextNode(role.getRoleSize()));
                    roleElement.appendChild(roleSizeElement);
                }
                if (role.getDefaultWinRmCertificateThumbprint() != null) {
                    Element defaultWinRmCertificateThumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DefaultWinRmCertificateThumbprint");
                    defaultWinRmCertificateThumbprintElement.appendChild(requestDoc.createTextNode(role.getDefaultWinRmCertificateThumbprint()));
                    roleElement.appendChild(defaultWinRmCertificateThumbprintElement);
                }
                if (role.isProvisionGuestAgent() != null) {
                    Element provisionGuestAgentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProvisionGuestAgent");
                    provisionGuestAgentElement.appendChild(requestDoc.createTextNode(Boolean.toString(role.isProvisionGuestAgent()).toLowerCase()));
                    roleElement.appendChild(provisionGuestAgentElement);
                }
                if (role.getVMImageInput() == null) continue;
                Element vMImageInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VMImageInput");
                roleElement.appendChild(vMImageInputElement);
                if (role.getVMImageInput().getOSDiskConfiguration() != null) {
                    Element oSDiskConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSDiskConfiguration");
                    vMImageInputElement.appendChild(oSDiskConfigurationElement);
                    if (role.getVMImageInput().getOSDiskConfiguration().getResizedSizeInGB() != null) {
                        Element resizedSizeInGBElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResizedSizeInGB");
                        resizedSizeInGBElement2.appendChild(requestDoc.createTextNode(Integer.toString(role.getVMImageInput().getOSDiskConfiguration().getResizedSizeInGB())));
                        oSDiskConfigurationElement.appendChild(resizedSizeInGBElement2);
                    }
                }
                if (role.getVMImageInput().getDataDiskConfigurations() == null || role.getVMImageInput().getDataDiskConfigurations() instanceof LazyCollection && !((LazyCollection)role.getVMImageInput().getDataDiskConfigurations()).isInitialized()) continue;
                Element dataDiskConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataDiskConfigurations");
                for (DataDiskConfiguration dataDiskConfigurationsItem : role.getVMImageInput().getDataDiskConfigurations()) {
                    Element dataDiskConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataDiskConfiguration");
                    dataDiskConfigurationsSequenceElement.appendChild(dataDiskConfigurationElement);
                    if (dataDiskConfigurationsItem.getDiskName() != null) {
                        Element nameElement6 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                        nameElement6.appendChild(requestDoc.createTextNode(dataDiskConfigurationsItem.getDiskName()));
                        dataDiskConfigurationElement.appendChild(nameElement6);
                    }
                    if (dataDiskConfigurationsItem.getResizedSizeInGB() == null) continue;
                    Element resizedSizeInGBElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResizedSizeInGB");
                    resizedSizeInGBElement3.appendChild(requestDoc.createTextNode(Integer.toString(dataDiskConfigurationsItem.getResizedSizeInGB())));
                    dataDiskConfigurationElement.appendChild(resizedSizeInGBElement3);
                }
                vMImageInputElement.appendChild(dataDiskConfigurationsSequenceElement);
            }
            deploymentElement.appendChild(roleListSequenceElement);
        }
        if (parameters.getVirtualNetworkName() != null) {
            Element virtualNetworkNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VirtualNetworkName");
            virtualNetworkNameElement.appendChild(requestDoc.createTextNode(parameters.getVirtualNetworkName()));
            deploymentElement.appendChild(virtualNetworkNameElement);
        }
        if (parameters.getDnsSettings() != null) {
            Element dnsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Dns");
            deploymentElement.appendChild(dnsElement);
            if (parameters.getDnsSettings().getDnsServers() != null && (!(parameters.getDnsSettings().getDnsServers() instanceof LazyCollection) || ((LazyCollection)parameters.getDnsSettings().getDnsServers()).isInitialized())) {
                Element dnsServersSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DnsServers");
                for (DnsServer dnsServersItem : parameters.getDnsSettings().getDnsServers()) {
                    Element dnsServerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DnsServer");
                    dnsServersSequenceElement.appendChild(dnsServerElement);
                    if (dnsServersItem.getName() != null) {
                        Element nameElement7 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                        nameElement7.appendChild(requestDoc.createTextNode(dnsServersItem.getName()));
                        dnsServerElement.appendChild(nameElement7);
                    }
                    if (dnsServersItem.getAddress() == null) continue;
                    Element addressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Address");
                    addressElement.appendChild(requestDoc.createTextNode(dnsServersItem.getAddress().getHostAddress()));
                    dnsServerElement.appendChild(addressElement);
                }
                dnsElement.appendChild(dnsServersSequenceElement);
            }
        }
        if (parameters.getReservedIPName() != null) {
            Element reservedIPNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReservedIPName");
            reservedIPNameElement.appendChild(requestDoc.createTextNode(parameters.getReservedIPName()));
            deploymentElement.appendChild(reservedIPNameElement);
        }
        if (parameters.getLoadBalancers() != null && (!(parameters.getLoadBalancers() instanceof LazyCollection) || ((LazyCollection)parameters.getLoadBalancers()).isInitialized())) {
            Element loadBalancersSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancers");
            for (LoadBalancer loadBalancer : parameters.getLoadBalancers()) {
                Element loadBalancerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancer");
                loadBalancersSequenceElement.appendChild(loadBalancerElement);
                if (loadBalancer.getName() != null) {
                    Element nameElement8 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement8.appendChild(requestDoc.createTextNode(loadBalancer.getName()));
                    loadBalancerElement.appendChild(nameElement8);
                }
                if (loadBalancer.getFrontendIPConfiguration() == null) continue;
                Element frontendIpConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "FrontendIpConfiguration");
                loadBalancerElement.appendChild(frontendIpConfigurationElement);
                if (loadBalancer.getFrontendIPConfiguration().getType() != null) {
                    Element typeElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
                    typeElement2.appendChild(requestDoc.createTextNode(loadBalancer.getFrontendIPConfiguration().getType()));
                    frontendIpConfigurationElement.appendChild(typeElement2);
                }
                if (loadBalancer.getFrontendIPConfiguration().getSubnetName() != null) {
                    Element subnetNameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                    subnetNameElement2.appendChild(requestDoc.createTextNode(loadBalancer.getFrontendIPConfiguration().getSubnetName()));
                    frontendIpConfigurationElement.appendChild(subnetNameElement2);
                }
                if (loadBalancer.getFrontendIPConfiguration().getStaticVirtualNetworkIPAddress() == null) continue;
                Element staticVirtualNetworkIPAddressElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                staticVirtualNetworkIPAddressElement3.appendChild(requestDoc.createTextNode(loadBalancer.getFrontendIPConfiguration().getStaticVirtualNetworkIPAddress().getHostAddress()));
                frontendIpConfigurationElement.appendChild(staticVirtualNetworkIPAddressElement3);
            }
            deploymentElement.appendChild(loadBalancersSequenceElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            Iterator<Object> iterator = result;
            return iterator;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginDeleting(serviceName, deploymentName, virtualMachineName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeleting(String serviceName, String deploymentName, String virtualMachineName, boolean deleteFromStorage) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roles/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (deleteFromStorage) {
            queryParameters.add("comp=media");
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginRestartingAsync(final String serviceName, final String deploymentName, final String virtualMachineName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginRestarting(serviceName, deploymentName, virtualMachineName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRestarting(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRestartingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        url = url + "/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = "<RestartRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>RestartRoleOperation</OperationType></RestartRoleOperation>";
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginShutdownAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineShutdownParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginShutdown(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginShutdown(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineShutdownParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginShutdownAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        url = url + "/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element shutdownRoleOperationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ShutdownRoleOperation");
        requestDoc.appendChild(shutdownRoleOperationElement);
        Element operationTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OperationType");
        operationTypeElement.appendChild(requestDoc.createTextNode("ShutdownRoleOperation"));
        shutdownRoleOperationElement.appendChild(operationTypeElement);
        if (parameters.getPostShutdownAction() != null) {
            Element postShutdownActionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PostShutdownAction");
            postShutdownActionElement.appendChild(requestDoc.createTextNode(parameters.getPostShutdownAction().toString()));
            shutdownRoleOperationElement.appendChild(postShutdownActionElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginShuttingDownRolesAsync(final String serviceName, final String deploymentName, final VirtualMachineShutdownRolesParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginShuttingDownRoles(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginShuttingDownRoles(String serviceName, String deploymentName, VirtualMachineShutdownRolesParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginShuttingDownRolesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/Roles/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element shutdownRolesOperationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ShutdownRolesOperation");
        requestDoc.appendChild(shutdownRolesOperationElement);
        Element operationTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OperationType");
        operationTypeElement.appendChild(requestDoc.createTextNode("ShutdownRolesOperation"));
        shutdownRolesOperationElement.appendChild(operationTypeElement);
        if (parameters.getRoles() != null && (!(parameters.getRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getRoles()).isInitialized())) {
            Element rolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Roles");
            for (String rolesItem : parameters.getRoles()) {
                Element rolesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                rolesItemElement.appendChild(requestDoc.createTextNode(rolesItem));
                rolesSequenceElement.appendChild(rolesItemElement);
            }
            shutdownRolesOperationElement.appendChild(rolesSequenceElement);
        }
        if (parameters.getPostShutdownAction() != null) {
            Element postShutdownActionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PostShutdownAction");
            postShutdownActionElement.appendChild(requestDoc.createTextNode(parameters.getPostShutdownAction().toString()));
            shutdownRolesOperationElement.appendChild(postShutdownActionElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginStartingAsync(final String serviceName, final String deploymentName, final String virtualMachineName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginStarting(serviceName, deploymentName, virtualMachineName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginStarting(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginStartingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        url = url + "/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = "<StartRoleOperation xmlns=\"http://schemas.microsoft.com/windowsazure\"><OperationType>StartRoleOperation</OperationType></StartRoleOperation>";
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginStartingRolesAsync(final String serviceName, final String deploymentName, final VirtualMachineStartRolesParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginStartingRoles(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginStartingRoles(String serviceName, String deploymentName, VirtualMachineStartRolesParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginStartingRolesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/Roles/Operations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element startRolesOperationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StartRolesOperation");
        requestDoc.appendChild(startRolesOperationElement);
        Element operationTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OperationType");
        operationTypeElement.appendChild(requestDoc.createTextNode("StartRolesOperation"));
        startRolesOperationElement.appendChild(operationTypeElement);
        if (parameters.getRoles() != null && (!(parameters.getRoles() instanceof LazyCollection) || ((LazyCollection)parameters.getRoles()).isInitialized())) {
            Element rolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Roles");
            for (String rolesItem : parameters.getRoles()) {
                Element rolesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                rolesItemElement.appendChild(requestDoc.createTextNode(rolesItem));
                rolesSequenceElement.appendChild(rolesItemElement);
            }
            startRolesOperationElement.appendChild(rolesSequenceElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpdatingAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginUpdating(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpdating(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfigurationSets() != null) {
            for (ConfigurationSet configurationSetsParameterItem : parameters.getConfigurationSets()) {
                if (configurationSetsParameterItem.getAdditionalUnattendContent() != null && configurationSetsParameterItem.getAdditionalUnattendContent().getUnattendPasses() != null) {
                    for (UnattendPassSettings unattendPassesParameterItem : configurationSetsParameterItem.getAdditionalUnattendContent().getUnattendPasses()) {
                        if (unattendPassesParameterItem.getPassName() == null) {
                            throw new NullPointerException("parameters.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.PassName");
                        }
                        if (unattendPassesParameterItem.getUnattendComponents() == null) continue;
                        for (UnattendComponent unattendComponentsParameterItem : unattendPassesParameterItem.getUnattendComponents()) {
                            if (unattendComponentsParameterItem.getComponentName() == null) {
                                throw new NullPointerException("parameters.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.UnattendComponents.ComponentName");
                            }
                            if (unattendComponentsParameterItem.getUnattendComponentSettings() == null) continue;
                            for (ComponentSetting unattendComponentSettingsParameterItem : unattendComponentsParameterItem.getUnattendComponentSettings()) {
                                if (unattendComponentSettingsParameterItem.getSettingName() != null) continue;
                                throw new NullPointerException("parameters.ConfigurationSets.AdditionalUnattendContent.UnattendPasses.UnattendComponents.UnattendComponentSettings.SettingName");
                            }
                        }
                    }
                }
                if (configurationSetsParameterItem.getDomainJoin() != null && configurationSetsParameterItem.getDomainJoin().getCredentials() != null) {
                    if (configurationSetsParameterItem.getDomainJoin().getCredentials().getPassword() == null) {
                        throw new NullPointerException("parameters.ConfigurationSets.DomainJoin.Credentials.Password");
                    }
                    if (configurationSetsParameterItem.getDomainJoin().getCredentials().getUserName() == null) {
                        throw new NullPointerException("parameters.ConfigurationSets.DomainJoin.Credentials.UserName");
                    }
                }
                if (configurationSetsParameterItem.getHostName() != null && configurationSetsParameterItem.getHostName().length() < 1) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.HostName");
                }
                if (configurationSetsParameterItem.getHostName() != null && configurationSetsParameterItem.getHostName().length() > 64) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.HostName");
                }
                if (configurationSetsParameterItem.getSshSettings() != null) {
                    if (configurationSetsParameterItem.getSshSettings().getKeyPairs() != null) {
                        for (SshSettingKeyPair keyPairsParameterItem : configurationSetsParameterItem.getSshSettings().getKeyPairs()) {
                            if (keyPairsParameterItem.getFingerprint() == null) {
                                throw new NullPointerException("parameters.ConfigurationSets.SshSettings.KeyPairs.Fingerprint");
                            }
                            if (keyPairsParameterItem.getPath() != null) continue;
                            throw new NullPointerException("parameters.ConfigurationSets.SshSettings.KeyPairs.Path");
                        }
                    }
                    if (configurationSetsParameterItem.getSshSettings().getPublicKeys() != null) {
                        for (SshSettingPublicKey publicKeysParameterItem : configurationSetsParameterItem.getSshSettings().getPublicKeys()) {
                            if (publicKeysParameterItem.getFingerprint() == null) {
                                throw new NullPointerException("parameters.ConfigurationSets.SshSettings.PublicKeys.Fingerprint");
                            }
                            if (publicKeysParameterItem.getPath() != null) continue;
                            throw new NullPointerException("parameters.ConfigurationSets.SshSettings.PublicKeys.Path");
                        }
                    }
                }
                if (configurationSetsParameterItem.getStoredCertificateSettings() != null) {
                    for (StoredCertificateSettings storedCertificateSettingsParameterItem : configurationSetsParameterItem.getStoredCertificateSettings()) {
                        if (storedCertificateSettingsParameterItem.getStoreName() == null) {
                            throw new NullPointerException("parameters.ConfigurationSets.StoredCertificateSettings.StoreName");
                        }
                        if (storedCertificateSettingsParameterItem.getThumbprint() != null) continue;
                        throw new NullPointerException("parameters.ConfigurationSets.StoredCertificateSettings.Thumbprint");
                    }
                }
                if (configurationSetsParameterItem.getUserName() != null && configurationSetsParameterItem.getUserName().length() < 1) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserName");
                }
                if (configurationSetsParameterItem.getUserName() != null && configurationSetsParameterItem.getUserName().length() > 32) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserName");
                }
                if (configurationSetsParameterItem.getUserPassword() != null && configurationSetsParameterItem.getUserPassword().length() < 6) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserPassword");
                }
                if (configurationSetsParameterItem.getUserPassword() != null && configurationSetsParameterItem.getUserPassword().length() > 72) {
                    throw new IllegalArgumentException("parameters.ConfigurationSets.UserPassword");
                }
                if (configurationSetsParameterItem.getWindowsRemoteManagement() == null || configurationSetsParameterItem.getWindowsRemoteManagement().getListeners() == null) continue;
                for (WindowsRemoteManagementListener listenersParameterItem : configurationSetsParameterItem.getWindowsRemoteManagement().getListeners()) {
                    if (listenersParameterItem.getListenerType() != null) continue;
                    throw new NullPointerException("parameters.ConfigurationSets.WindowsRemoteManagement.Listeners.ListenerType");
                }
            }
        }
        if (parameters.getOSVirtualHardDisk() == null) {
            throw new NullPointerException("parameters.OSVirtualHardDisk");
        }
        if (parameters.getRoleName() == null) {
            throw new NullPointerException("parameters.RoleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roles/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element persistentVMRoleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PersistentVMRole");
        requestDoc.appendChild(persistentVMRoleElement);
        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
        roleNameElement.appendChild(requestDoc.createTextNode(parameters.getRoleName()));
        persistentVMRoleElement.appendChild(roleNameElement);
        Element roleTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleType");
        roleTypeElement.appendChild(requestDoc.createTextNode("PersistentVMRole"));
        persistentVMRoleElement.appendChild(roleTypeElement);
        if (parameters.getConfigurationSets() != null && (!(parameters.getConfigurationSets() instanceof LazyCollection) || ((LazyCollection)parameters.getConfigurationSets()).isInitialized())) {
            Element configurationSetsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSets");
            for (ConfigurationSet configurationSetsItem : parameters.getConfigurationSets()) {
                Element configurationSetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSet");
                configurationSetsSequenceElement.appendChild(configurationSetElement);
                if (configurationSetsItem.getConfigurationSetType() != null) {
                    Element configurationSetTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ConfigurationSetType");
                    configurationSetTypeElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getConfigurationSetType()));
                    configurationSetElement.appendChild(configurationSetTypeElement);
                }
                if (configurationSetsItem.getInputEndpoints() != null && (!(configurationSetsItem.getInputEndpoints() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getInputEndpoints()).isInitialized())) {
                    Element inputEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                    for (InputEndpoint inputEndpoint : configurationSetsItem.getInputEndpoints()) {
                        Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                        inputEndpointsSequenceElement.appendChild(inputEndpointElement);
                        if (inputEndpoint.getLoadBalancedEndpointSetName() != null) {
                            Element loadBalancedEndpointSetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                            loadBalancedEndpointSetNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancedEndpointSetName()));
                            inputEndpointElement.appendChild(loadBalancedEndpointSetNameElement);
                        }
                        if (inputEndpoint.getLocalPort() != null) {
                            Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                            localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLocalPort())));
                            inputEndpointElement.appendChild(localPortElement);
                        }
                        if (inputEndpoint.getName() != null) {
                            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getName()));
                            inputEndpointElement.appendChild(nameElement);
                        }
                        if (inputEndpoint.getPort() != null) {
                            Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                            portElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getPort())));
                            inputEndpointElement.appendChild(portElement);
                        }
                        if (inputEndpoint.getLoadBalancerProbe() != null) {
                            Element loadBalancerProbeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                            inputEndpointElement.appendChild(loadBalancerProbeElement);
                            if (inputEndpoint.getLoadBalancerProbe().getPath() != null) {
                                Element pathElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                                pathElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerProbe().getPath()));
                                loadBalancerProbeElement.appendChild(pathElement);
                            }
                            Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                            portElement2.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getPort())));
                            loadBalancerProbeElement.appendChild(portElement2);
                            if (inputEndpoint.getLoadBalancerProbe().getProtocol() != null) {
                                Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                                protocolElement.appendChild(requestDoc.createTextNode(ComputeManagementClientImpl.loadBalancerProbeTransportProtocolToString(inputEndpoint.getLoadBalancerProbe().getProtocol())));
                                loadBalancerProbeElement.appendChild(protocolElement);
                            }
                            if (inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds() != null) {
                                Element intervalInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                                intervalInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getIntervalInSeconds())));
                                loadBalancerProbeElement.appendChild(intervalInSecondsElement);
                            }
                            if (inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds() != null) {
                                Element timeoutInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                                timeoutInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getLoadBalancerProbe().getTimeoutInSeconds())));
                                loadBalancerProbeElement.appendChild(timeoutInSecondsElement);
                            }
                        }
                        if (inputEndpoint.getProtocol() != null) {
                            Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                            protocolElement2.appendChild(requestDoc.createTextNode(inputEndpoint.getProtocol()));
                            inputEndpointElement.appendChild(protocolElement2);
                        }
                        if (inputEndpoint.getVirtualIPAddress() != null) {
                            Element vipElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Vip");
                            vipElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPAddress().getHostAddress()));
                            inputEndpointElement.appendChild(vipElement);
                        }
                        if (inputEndpoint.isEnableDirectServerReturn() != null) {
                            Element enableDirectServerReturnElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                            enableDirectServerReturnElement.appendChild(requestDoc.createTextNode(Boolean.toString(inputEndpoint.isEnableDirectServerReturn()).toLowerCase()));
                            inputEndpointElement.appendChild(enableDirectServerReturnElement);
                        }
                        if (inputEndpoint.getLoadBalancerName() != null) {
                            Element loadBalancerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                            loadBalancerNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerName()));
                            inputEndpointElement.appendChild(loadBalancerNameElement);
                        }
                        if (inputEndpoint.getEndpointAcl() != null) {
                            Element endpointAclElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                            inputEndpointElement.appendChild(endpointAclElement);
                            if (inputEndpoint.getEndpointAcl().getRules() != null && (!(inputEndpoint.getEndpointAcl().getRules() instanceof LazyCollection) || ((LazyCollection)inputEndpoint.getEndpointAcl().getRules()).isInitialized())) {
                                Element rulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rules");
                                for (AccessControlListRule rulesItem : inputEndpoint.getEndpointAcl().getRules()) {
                                    Element ruleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rule");
                                    rulesSequenceElement.appendChild(ruleElement);
                                    if (rulesItem.getOrder() != null) {
                                        Element orderElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Order");
                                        orderElement.appendChild(requestDoc.createTextNode(Integer.toString(rulesItem.getOrder())));
                                        ruleElement.appendChild(orderElement);
                                    }
                                    if (rulesItem.getAction() != null) {
                                        Element actionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Action");
                                        actionElement.appendChild(requestDoc.createTextNode(rulesItem.getAction()));
                                        ruleElement.appendChild(actionElement);
                                    }
                                    if (rulesItem.getRemoteSubnet() != null) {
                                        Element remoteSubnetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                                        remoteSubnetElement.appendChild(requestDoc.createTextNode(rulesItem.getRemoteSubnet()));
                                        ruleElement.appendChild(remoteSubnetElement);
                                    }
                                    if (rulesItem.getDescription() == null) continue;
                                    Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
                                    descriptionElement.appendChild(requestDoc.createTextNode(rulesItem.getDescription()));
                                    ruleElement.appendChild(descriptionElement);
                                }
                                endpointAclElement.appendChild(rulesSequenceElement);
                            }
                        }
                        if (inputEndpoint.getIdleTimeoutInMinutes() != null) {
                            Element idleTimeoutInMinutesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                            idleTimeoutInMinutesElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpoint.getIdleTimeoutInMinutes())));
                            inputEndpointElement.appendChild(idleTimeoutInMinutesElement);
                        }
                        if (inputEndpoint.getLoadBalancerDistribution() != null) {
                            Element loadBalancerDistributionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                            loadBalancerDistributionElement.appendChild(requestDoc.createTextNode(inputEndpoint.getLoadBalancerDistribution()));
                            inputEndpointElement.appendChild(loadBalancerDistributionElement);
                        }
                        if (inputEndpoint.getVirtualIPName() == null) continue;
                        Element virtualIPNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VirtualIPName");
                        virtualIPNameElement.appendChild(requestDoc.createTextNode(inputEndpoint.getVirtualIPName()));
                        inputEndpointElement.appendChild(virtualIPNameElement);
                    }
                    configurationSetElement.appendChild(inputEndpointsSequenceElement);
                }
                if (configurationSetsItem.getSubnetNames() != null && (!(configurationSetsItem.getSubnetNames() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSubnetNames()).isInitialized())) {
                    Element subnetNamesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetNames");
                    for (String string : configurationSetsItem.getSubnetNames()) {
                        Element subnetNamesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                        subnetNamesItemElement.appendChild(requestDoc.createTextNode(string));
                        subnetNamesSequenceElement.appendChild(subnetNamesItemElement);
                    }
                    configurationSetElement.appendChild(subnetNamesSequenceElement);
                }
                if (configurationSetsItem.getStaticVirtualNetworkIPAddress() != null) {
                    Element staticVirtualNetworkIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                    staticVirtualNetworkIPAddressElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getStaticVirtualNetworkIPAddress()));
                    configurationSetElement.appendChild(staticVirtualNetworkIPAddressElement);
                }
                if (configurationSetsItem.getPublicIPs() != null && (!(configurationSetsItem.getPublicIPs() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getPublicIPs()).isInitialized())) {
                    Element publicIPsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIPs");
                    for (ConfigurationSet.PublicIP publicIP : configurationSetsItem.getPublicIPs()) {
                        Element publicIPElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicIP");
                        publicIPsSequenceElement.appendChild(publicIPElement);
                        if (publicIP.getName() != null) {
                            Element nameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement2.appendChild(requestDoc.createTextNode(publicIP.getName()));
                            publicIPElement.appendChild(nameElement2);
                        }
                        if (publicIP.getIdleTimeoutInMinutes() != null) {
                            Element idleTimeoutInMinutesElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                            idleTimeoutInMinutesElement2.appendChild(requestDoc.createTextNode(Integer.toString(publicIP.getIdleTimeoutInMinutes())));
                            publicIPElement.appendChild(idleTimeoutInMinutesElement2);
                        }
                        if (publicIP.getDomainNameLabel() == null) continue;
                        Element domainNameLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainNameLabel");
                        domainNameLabelElement.appendChild(requestDoc.createTextNode(publicIP.getDomainNameLabel()));
                        publicIPElement.appendChild(domainNameLabelElement);
                    }
                    configurationSetElement.appendChild(publicIPsSequenceElement);
                }
                if (configurationSetsItem.getNetworkInterfaces() != null && (!(configurationSetsItem.getNetworkInterfaces() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getNetworkInterfaces()).isInitialized())) {
                    Element networkInterfacesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                    for (NetworkInterface networkInterface : configurationSetsItem.getNetworkInterfaces()) {
                        Element networkInterfaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkInterface");
                        networkInterfacesSequenceElement.appendChild(networkInterfaceElement);
                        if (networkInterface.getName() != null) {
                            Element nameElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                            nameElement3.appendChild(requestDoc.createTextNode(networkInterface.getName()));
                            networkInterfaceElement.appendChild(nameElement3);
                        }
                        if (networkInterface.getIPConfigurations() != null && (!(networkInterface.getIPConfigurations() instanceof LazyCollection) || ((LazyCollection)networkInterface.getIPConfigurations()).isInitialized())) {
                            Element iPConfigurationsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                            for (IPConfiguration iPConfigurationsItem : networkInterface.getIPConfigurations()) {
                                Element iPConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPConfiguration");
                                iPConfigurationsSequenceElement.appendChild(iPConfigurationElement);
                                if (iPConfigurationsItem.getSubnetName() != null) {
                                    Element subnetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubnetName");
                                    subnetNameElement.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getSubnetName()));
                                    iPConfigurationElement.appendChild(subnetNameElement);
                                }
                                if (iPConfigurationsItem.getStaticVirtualNetworkIPAddress() == null) continue;
                                Element staticVirtualNetworkIPAddressElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                staticVirtualNetworkIPAddressElement2.appendChild(requestDoc.createTextNode(iPConfigurationsItem.getStaticVirtualNetworkIPAddress()));
                                iPConfigurationElement.appendChild(staticVirtualNetworkIPAddressElement2);
                            }
                            networkInterfaceElement.appendChild(iPConfigurationsSequenceElement);
                        }
                        if (networkInterface.getNetworkSecurityGroup() != null) {
                            Element networkSecurityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                            networkSecurityGroupElement.appendChild(requestDoc.createTextNode(networkInterface.getNetworkSecurityGroup()));
                            networkInterfaceElement.appendChild(networkSecurityGroupElement);
                        }
                        if (networkInterface.getIPForwarding() == null) continue;
                        Element iPForwardingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                        iPForwardingElement.appendChild(requestDoc.createTextNode(networkInterface.getIPForwarding()));
                        networkInterfaceElement.appendChild(iPForwardingElement);
                    }
                    configurationSetElement.appendChild(networkInterfacesSequenceElement);
                }
                if (configurationSetsItem.getNetworkSecurityGroup() != null) {
                    Element networkSecurityGroupElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                    networkSecurityGroupElement2.appendChild(requestDoc.createTextNode(configurationSetsItem.getNetworkSecurityGroup()));
                    configurationSetElement.appendChild(networkSecurityGroupElement2);
                }
                if (configurationSetsItem.getIPForwarding() != null) {
                    Element iPForwardingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IPForwarding");
                    iPForwardingElement2.appendChild(requestDoc.createTextNode(configurationSetsItem.getIPForwarding()));
                    configurationSetElement.appendChild(iPForwardingElement2);
                }
                if (configurationSetsItem.getComputerName() != null) {
                    Element computerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComputerName");
                    computerNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getComputerName()));
                    configurationSetElement.appendChild(computerNameElement);
                }
                if (configurationSetsItem.getAdminPassword() != null) {
                    Element adminPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminPassword");
                    adminPasswordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getAdminPassword()));
                    configurationSetElement.appendChild(adminPasswordElement);
                }
                if (configurationSetsItem.isResetPasswordOnFirstLogon() != null) {
                    Element resetPasswordOnFirstLogonElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResetPasswordOnFirstLogon");
                    resetPasswordOnFirstLogonElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isResetPasswordOnFirstLogon()).toLowerCase()));
                    configurationSetElement.appendChild(resetPasswordOnFirstLogonElement);
                }
                if (configurationSetsItem.isEnableAutomaticUpdates() != null) {
                    Element enableAutomaticUpdatesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableAutomaticUpdates");
                    enableAutomaticUpdatesElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isEnableAutomaticUpdates()).toLowerCase()));
                    configurationSetElement.appendChild(enableAutomaticUpdatesElement);
                }
                if (configurationSetsItem.getTimeZone() != null) {
                    Element timeZoneElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeZone");
                    timeZoneElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getTimeZone()));
                    configurationSetElement.appendChild(timeZoneElement);
                }
                if (configurationSetsItem.getDomainJoin() != null) {
                    Element domainJoinElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DomainJoin");
                    configurationSetElement.appendChild(domainJoinElement);
                    if (configurationSetsItem.getDomainJoin().getCredentials() != null) {
                        Element credentialsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Credentials");
                        domainJoinElement.appendChild(credentialsElement);
                        if (configurationSetsItem.getDomainJoin().getCredentials().getDomain() != null) {
                            Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Domain");
                            element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getDomain()));
                            credentialsElement.appendChild(element);
                        }
                        Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Username");
                        element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getUserName()));
                        credentialsElement.appendChild(element);
                        Element passwordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Password");
                        passwordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getCredentials().getPassword()));
                        credentialsElement.appendChild(passwordElement);
                    }
                    if (configurationSetsItem.getDomainJoin().getDomainToJoin() != null) {
                        Element joinDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "JoinDomain");
                        joinDomainElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getDomainToJoin()));
                        domainJoinElement.appendChild(joinDomainElement);
                    }
                    if (configurationSetsItem.getDomainJoin().getLdapMachineObjectOU() != null) {
                        Element machineObjectOUElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MachineObjectOU");
                        machineObjectOUElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getLdapMachineObjectOU()));
                        domainJoinElement.appendChild(machineObjectOUElement);
                    }
                    if (configurationSetsItem.getDomainJoin().getProvisioning() != null) {
                        Element provisioningElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Provisioning");
                        domainJoinElement.appendChild(provisioningElement);
                        if (configurationSetsItem.getDomainJoin().getProvisioning().getAccountData() != null) {
                            Element element = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountData");
                            element.appendChild(requestDoc.createTextNode(configurationSetsItem.getDomainJoin().getProvisioning().getAccountData()));
                            provisioningElement.appendChild(element);
                        }
                    }
                }
                if (configurationSetsItem.getStoredCertificateSettings() != null && (!(configurationSetsItem.getStoredCertificateSettings() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getStoredCertificateSettings()).isInitialized())) {
                    Element storedCertificateSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoredCertificateSettings");
                    for (StoredCertificateSettings storedCertificateSettings : configurationSetsItem.getStoredCertificateSettings()) {
                        Element certificateSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateSetting");
                        storedCertificateSettingsSequenceElement.appendChild(certificateSettingElement);
                        Element storeLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreLocation");
                        storeLocationElement.appendChild(requestDoc.createTextNode("LocalMachine"));
                        certificateSettingElement.appendChild(storeLocationElement);
                        Element storeNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreName");
                        storeNameElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getStoreName()));
                        certificateSettingElement.appendChild(storeNameElement);
                        Element thumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Thumbprint");
                        thumbprintElement.appendChild(requestDoc.createTextNode(storedCertificateSettings.getThumbprint()));
                        certificateSettingElement.appendChild(thumbprintElement);
                    }
                    configurationSetElement.appendChild(storedCertificateSettingsSequenceElement);
                }
                if (configurationSetsItem.getWindowsRemoteManagement() != null) {
                    Element winRMElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WinRM");
                    configurationSetElement.appendChild(winRMElement);
                    if (configurationSetsItem.getWindowsRemoteManagement().getListeners() != null && (!(configurationSetsItem.getWindowsRemoteManagement().getListeners() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getWindowsRemoteManagement().getListeners()).isInitialized())) {
                        Element listenersSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listeners");
                        for (WindowsRemoteManagementListener listenersItem : configurationSetsItem.getWindowsRemoteManagement().getListeners()) {
                            Element listenerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Listener");
                            listenersSequenceElement.appendChild(listenerElement);
                            if (listenersItem.getCertificateThumbprint() != null) {
                                Element certificateThumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CertificateThumbprint");
                                certificateThumbprintElement.appendChild(requestDoc.createTextNode(listenersItem.getCertificateThumbprint()));
                                listenerElement.appendChild(certificateThumbprintElement);
                            }
                            Element protocolElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                            protocolElement3.appendChild(requestDoc.createTextNode(listenersItem.getListenerType().toString()));
                            listenerElement.appendChild(protocolElement3);
                        }
                        winRMElement.appendChild(listenersSequenceElement);
                    }
                }
                if (configurationSetsItem.getAdminUserName() != null) {
                    Element adminUsernameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdminUsername");
                    adminUsernameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getAdminUserName()));
                    configurationSetElement.appendChild(adminUsernameElement);
                }
                if (configurationSetsItem.getAdditionalUnattendContent() != null) {
                    Element additionalUnattendContentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AdditionalUnattendContent");
                    configurationSetElement.appendChild(additionalUnattendContentElement);
                    if (configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses() != null && (!(configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses()).isInitialized())) {
                        Element passesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Passes");
                        for (UnattendPassSettings passesItem : configurationSetsItem.getAdditionalUnattendContent().getUnattendPasses()) {
                            Element unattendPassElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendPass");
                            passesSequenceElement.appendChild(unattendPassElement);
                            Element passNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PassName");
                            passNameElement.appendChild(requestDoc.createTextNode(passesItem.getPassName()));
                            unattendPassElement.appendChild(passNameElement);
                            if (passesItem.getUnattendComponents() == null || passesItem.getUnattendComponents() instanceof LazyCollection && !((LazyCollection)passesItem.getUnattendComponents()).isInitialized()) continue;
                            Element componentsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Components");
                            for (UnattendComponent componentsItem : passesItem.getUnattendComponents()) {
                                Element unattendComponentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UnattendComponent");
                                componentsSequenceElement.appendChild(unattendComponentElement);
                                Element componentNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentName");
                                componentNameElement.appendChild(requestDoc.createTextNode(componentsItem.getComponentName()));
                                unattendComponentElement.appendChild(componentNameElement);
                                if (componentsItem.getUnattendComponentSettings() == null || componentsItem.getUnattendComponentSettings() instanceof LazyCollection && !((LazyCollection)componentsItem.getUnattendComponentSettings()).isInitialized()) continue;
                                Element componentSettingsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSettings");
                                for (ComponentSetting componentSettingsItem : componentsItem.getUnattendComponentSettings()) {
                                    Element componentSettingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ComponentSetting");
                                    componentSettingsSequenceElement.appendChild(componentSettingElement);
                                    Element settingNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SettingName");
                                    settingNameElement.appendChild(requestDoc.createTextNode(componentSettingsItem.getSettingName()));
                                    componentSettingElement.appendChild(settingNameElement);
                                    if (componentSettingsItem.getContent() == null) continue;
                                    Element contentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Content");
                                    contentElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])componentSettingsItem.getContent().getBytes())));
                                    componentSettingElement.appendChild(contentElement);
                                }
                                unattendComponentElement.appendChild(componentSettingsSequenceElement);
                            }
                            unattendPassElement.appendChild(componentsSequenceElement);
                        }
                        additionalUnattendContentElement.appendChild(passesSequenceElement);
                    }
                }
                if (configurationSetsItem.getHostName() != null) {
                    Element hostNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostName");
                    hostNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getHostName()));
                    configurationSetElement.appendChild(hostNameElement);
                }
                if (configurationSetsItem.getUserName() != null) {
                    Element userNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserName");
                    userNameElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getUserName()));
                    configurationSetElement.appendChild(userNameElement);
                }
                if (configurationSetsItem.getUserPassword() != null) {
                    Element userPasswordElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UserPassword");
                    userPasswordElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getUserPassword()));
                    configurationSetElement.appendChild(userPasswordElement);
                }
                if (configurationSetsItem.isDisableSshPasswordAuthentication() != null) {
                    Element disableSshPasswordAuthenticationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DisableSshPasswordAuthentication");
                    disableSshPasswordAuthenticationElement.appendChild(requestDoc.createTextNode(Boolean.toString(configurationSetsItem.isDisableSshPasswordAuthentication()).toLowerCase()));
                    configurationSetElement.appendChild(disableSshPasswordAuthenticationElement);
                }
                if (configurationSetsItem.getSshSettings() != null) {
                    Element sSHElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SSH");
                    configurationSetElement.appendChild(sSHElement);
                    if (configurationSetsItem.getSshSettings().getPublicKeys() != null && (!(configurationSetsItem.getSshSettings().getPublicKeys() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSshSettings().getPublicKeys()).isInitialized())) {
                        Element publicKeysSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKeys");
                        for (SshSettingPublicKey publicKeysItem : configurationSetsItem.getSshSettings().getPublicKeys()) {
                            Element publicKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicKey");
                            publicKeysSequenceElement.appendChild(publicKeyElement);
                            Element fingerprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                            fingerprintElement.appendChild(requestDoc.createTextNode(publicKeysItem.getFingerprint()));
                            publicKeyElement.appendChild(fingerprintElement);
                            Element pathElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                            pathElement2.appendChild(requestDoc.createTextNode(publicKeysItem.getPath()));
                            publicKeyElement.appendChild(pathElement2);
                        }
                        sSHElement.appendChild(publicKeysSequenceElement);
                    }
                    if (configurationSetsItem.getSshSettings().getKeyPairs() != null && (!(configurationSetsItem.getSshSettings().getKeyPairs() instanceof LazyCollection) || ((LazyCollection)configurationSetsItem.getSshSettings().getKeyPairs()).isInitialized())) {
                        Element keyPairsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPairs");
                        for (SshSettingKeyPair keyPairsItem : configurationSetsItem.getSshSettings().getKeyPairs()) {
                            Element keyPairElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyPair");
                            keyPairsSequenceElement.appendChild(keyPairElement);
                            Element fingerprintElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Fingerprint");
                            fingerprintElement2.appendChild(requestDoc.createTextNode(keyPairsItem.getFingerprint()));
                            keyPairElement.appendChild(fingerprintElement2);
                            Element pathElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                            pathElement3.appendChild(requestDoc.createTextNode(keyPairsItem.getPath()));
                            keyPairElement.appendChild(pathElement3);
                        }
                        sSHElement.appendChild(keyPairsSequenceElement);
                    }
                }
                if (configurationSetsItem.getCustomData() == null) continue;
                Element customDataElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CustomData");
                customDataElement.appendChild(requestDoc.createTextNode(configurationSetsItem.getCustomData()));
                configurationSetElement.appendChild(customDataElement);
            }
            persistentVMRoleElement.appendChild(configurationSetsSequenceElement);
        }
        if (parameters.getResourceExtensionReferences() != null && (!(parameters.getResourceExtensionReferences() instanceof LazyCollection) || ((LazyCollection)parameters.getResourceExtensionReferences()).isInitialized())) {
            Element resourceExtensionReferencesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionReferences");
            for (ResourceExtensionReference resourceExtensionReferencesItem : parameters.getResourceExtensionReferences()) {
                Element resourceExtensionReferenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference");
                resourceExtensionReferencesSequenceElement.appendChild(resourceExtensionReferenceElement);
                if (resourceExtensionReferencesItem.getReferenceName() != null) {
                    Element referenceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReferenceName");
                    referenceNameElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getReferenceName()));
                    resourceExtensionReferenceElement.appendChild(referenceNameElement);
                }
                if (resourceExtensionReferencesItem.getPublisher() != null) {
                    Element publisherElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Publisher");
                    publisherElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getPublisher()));
                    resourceExtensionReferenceElement.appendChild(publisherElement);
                }
                if (resourceExtensionReferencesItem.getName() != null) {
                    Element nameElement4 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement4.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getName()));
                    resourceExtensionReferenceElement.appendChild(nameElement4);
                }
                if (resourceExtensionReferencesItem.getVersion() != null) {
                    Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
                    versionElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getVersion()));
                    resourceExtensionReferenceElement.appendChild(versionElement);
                }
                if (resourceExtensionReferencesItem.getResourceExtensionParameterValues() != null && (!(resourceExtensionReferencesItem.getResourceExtensionParameterValues() instanceof LazyCollection) || ((LazyCollection)resourceExtensionReferencesItem.getResourceExtensionParameterValues()).isInitialized())) {
                    Element resourceExtensionParameterValuesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValues");
                    for (ResourceExtensionParameterValue resourceExtensionParameterValue : resourceExtensionReferencesItem.getResourceExtensionParameterValues()) {
                        Element resourceExtensionParameterValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue");
                        resourceExtensionParameterValuesSequenceElement.appendChild(resourceExtensionParameterValueElement);
                        if (resourceExtensionParameterValue.getKey() != null) {
                            Element keyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Key");
                            keyElement.appendChild(requestDoc.createTextNode(resourceExtensionParameterValue.getKey()));
                            resourceExtensionParameterValueElement.appendChild(keyElement);
                        }
                        if (resourceExtensionParameterValue.getValue() != null) {
                            Element valueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                            valueElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])resourceExtensionParameterValue.getValue().getBytes())));
                            resourceExtensionParameterValueElement.appendChild(valueElement);
                        }
                        if (resourceExtensionParameterValue.getType() == null) continue;
                        Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
                        typeElement.appendChild(requestDoc.createTextNode(resourceExtensionParameterValue.getType()));
                        resourceExtensionParameterValueElement.appendChild(typeElement);
                    }
                    resourceExtensionReferenceElement.appendChild(resourceExtensionParameterValuesSequenceElement);
                }
                if (resourceExtensionReferencesItem.getState() != null) {
                    Element stateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "State");
                    stateElement.appendChild(requestDoc.createTextNode(resourceExtensionReferencesItem.getState()));
                    resourceExtensionReferenceElement.appendChild(stateElement);
                }
                if (resourceExtensionReferencesItem.isForceUpdate() == null) continue;
                Element forceUpdateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ForceUpdate");
                forceUpdateElement.appendChild(requestDoc.createTextNode(Boolean.toString(resourceExtensionReferencesItem.isForceUpdate()).toLowerCase()));
                resourceExtensionReferenceElement.appendChild(forceUpdateElement);
            }
            persistentVMRoleElement.appendChild(resourceExtensionReferencesSequenceElement);
        }
        if (parameters.getAvailabilitySetName() != null) {
            Element availabilitySetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AvailabilitySetName");
            availabilitySetNameElement.appendChild(requestDoc.createTextNode(parameters.getAvailabilitySetName()));
            persistentVMRoleElement.appendChild(availabilitySetNameElement);
        }
        if (parameters.getDataVirtualHardDisks() != null && (!(parameters.getDataVirtualHardDisks() instanceof LazyCollection) || ((LazyCollection)parameters.getDataVirtualHardDisks()).isInitialized())) {
            Element dataVirtualHardDisksSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisks");
            for (DataVirtualHardDisk dataVirtualHardDisksItem : parameters.getDataVirtualHardDisks()) {
                Element dataVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk");
                dataVirtualHardDisksSequenceElement.appendChild(dataVirtualHardDiskElement);
                if (dataVirtualHardDisksItem.getHostCaching() != null) {
                    Element hostCachingElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
                    hostCachingElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getHostCaching()));
                    dataVirtualHardDiskElement.appendChild(hostCachingElement);
                }
                if (dataVirtualHardDisksItem.getLabel() != null) {
                    Element diskLabelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
                    diskLabelElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getLabel()));
                    dataVirtualHardDiskElement.appendChild(diskLabelElement);
                }
                if (dataVirtualHardDisksItem.getName() != null) {
                    Element diskNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
                    diskNameElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getName()));
                    dataVirtualHardDiskElement.appendChild(diskNameElement);
                }
                if (dataVirtualHardDisksItem.getLogicalUnitNumber() != null) {
                    Element lunElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Lun");
                    lunElement.appendChild(requestDoc.createTextNode(Integer.toString(dataVirtualHardDisksItem.getLogicalUnitNumber())));
                    dataVirtualHardDiskElement.appendChild(lunElement);
                }
                if (dataVirtualHardDisksItem.getLogicalDiskSizeInGB() != null) {
                    Element logicalDiskSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                    logicalDiskSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(dataVirtualHardDisksItem.getLogicalDiskSizeInGB())));
                    dataVirtualHardDiskElement.appendChild(logicalDiskSizeInGBElement);
                }
                if (dataVirtualHardDisksItem.getMediaLink() != null) {
                    Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
                    mediaLinkElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getMediaLink().toString()));
                    dataVirtualHardDiskElement.appendChild(mediaLinkElement);
                }
                if (dataVirtualHardDisksItem.getSourceMediaLink() != null) {
                    Element sourceMediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
                    sourceMediaLinkElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getSourceMediaLink().toString()));
                    dataVirtualHardDiskElement.appendChild(sourceMediaLinkElement);
                }
                if (dataVirtualHardDisksItem.getIOType() == null) continue;
                Element iOTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IOType");
                iOTypeElement.appendChild(requestDoc.createTextNode(dataVirtualHardDisksItem.getIOType()));
                dataVirtualHardDiskElement.appendChild(iOTypeElement);
            }
            persistentVMRoleElement.appendChild(dataVirtualHardDisksSequenceElement);
        }
        Element oSVirtualHardDiskElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSVirtualHardDisk");
        persistentVMRoleElement.appendChild(oSVirtualHardDiskElement);
        if (parameters.getOSVirtualHardDisk().getHostCaching() != null) {
            Element hostCachingElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostCaching");
            hostCachingElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getHostCaching()));
            oSVirtualHardDiskElement.appendChild(hostCachingElement2);
        }
        if (parameters.getOSVirtualHardDisk().getLabel() != null) {
            Element diskLabelElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskLabel");
            diskLabelElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getLabel()));
            oSVirtualHardDiskElement.appendChild(diskLabelElement2);
        }
        if (parameters.getOSVirtualHardDisk().getName() != null) {
            Element diskNameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DiskName");
            diskNameElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getName()));
            oSVirtualHardDiskElement.appendChild(diskNameElement2);
        }
        if (parameters.getOSVirtualHardDisk().getMediaLink() != null) {
            Element mediaLinkElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
            mediaLinkElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getMediaLink().toString()));
            oSVirtualHardDiskElement.appendChild(mediaLinkElement2);
        }
        if (parameters.getOSVirtualHardDisk().getSourceImageName() != null) {
            Element sourceImageNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceImageName");
            sourceImageNameElement.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getSourceImageName()));
            oSVirtualHardDiskElement.appendChild(sourceImageNameElement);
        }
        if (parameters.getOSVirtualHardDisk().getOperatingSystem() != null) {
            Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
            osElement.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getOperatingSystem()));
            oSVirtualHardDiskElement.appendChild(osElement);
        }
        if (parameters.getOSVirtualHardDisk().getRemoteSourceImageLink() != null) {
            Element remoteSourceImageLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSourceImageLink");
            remoteSourceImageLinkElement.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getRemoteSourceImageLink().toString()));
            oSVirtualHardDiskElement.appendChild(remoteSourceImageLinkElement);
        }
        if (parameters.getOSVirtualHardDisk().getIOType() != null) {
            Element iOTypeElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IOType");
            iOTypeElement2.appendChild(requestDoc.createTextNode(parameters.getOSVirtualHardDisk().getIOType()));
            oSVirtualHardDiskElement.appendChild(iOTypeElement2);
        }
        if (parameters.getOSVirtualHardDisk().getResizedSizeInGB() != null) {
            Element resizedSizeInGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ResizedSizeInGB");
            resizedSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getOSVirtualHardDisk().getResizedSizeInGB())));
            oSVirtualHardDiskElement.appendChild(resizedSizeInGBElement);
        }
        if (parameters.getRoleSize() != null) {
            Element roleSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleSize");
            roleSizeElement.appendChild(requestDoc.createTextNode(parameters.getRoleSize()));
            persistentVMRoleElement.appendChild(roleSizeElement);
        }
        if (parameters.isProvisionGuestAgent() != null) {
            Element provisionGuestAgentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProvisionGuestAgent");
            provisionGuestAgentElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isProvisionGuestAgent()).toLowerCase()));
            persistentVMRoleElement.appendChild(provisionGuestAgentElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity stringEntity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)stringEntity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpdatingLoadBalancedEndpointSetAsync(final String serviceName, final String deploymentName, final VirtualMachineUpdateLoadBalancedSetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginUpdatingLoadBalancedEndpointSet(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpdatingLoadBalancedEndpointSet(String serviceName, String deploymentName, VirtualMachineUpdateLoadBalancedSetParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLoadBalancedEndpoints() != null) {
            for (VirtualMachineUpdateLoadBalancedSetParameters.InputEndpoint loadBalancedEndpointsParameterItem : parameters.getLoadBalancedEndpoints()) {
                if (loadBalancedEndpointsParameterItem.getLoadBalancedEndpointSetName() != null) continue;
                throw new NullPointerException("parameters.LoadBalancedEndpoints.LoadBalancedEndpointSetName");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpdatingLoadBalancedEndpointSetAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("comp=UpdateLbSet");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element loadBalancedEndpointListElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointList");
        requestDoc.appendChild(loadBalancedEndpointListElement);
        if (parameters.getLoadBalancedEndpoints() != null && (!(parameters.getLoadBalancedEndpoints() instanceof LazyCollection) || ((LazyCollection)parameters.getLoadBalancedEndpoints()).isInitialized())) {
            for (VirtualMachineUpdateLoadBalancedSetParameters.InputEndpoint loadBalancedEndpointsItem : parameters.getLoadBalancedEndpoints()) {
                Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                loadBalancedEndpointListElement.appendChild(inputEndpointElement);
                Element loadBalancedEndpointSetNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                loadBalancedEndpointSetNameElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getLoadBalancedEndpointSetName()));
                inputEndpointElement.appendChild(loadBalancedEndpointSetNameElement);
                if (loadBalancedEndpointsItem.getLocalPort() != null) {
                    Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                    localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(loadBalancedEndpointsItem.getLocalPort())));
                    inputEndpointElement.appendChild(localPortElement);
                }
                if (loadBalancedEndpointsItem.getName() != null) {
                    Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getName()));
                    inputEndpointElement.appendChild(nameElement);
                }
                if (loadBalancedEndpointsItem.getPort() != null) {
                    Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                    portElement.appendChild(requestDoc.createTextNode(Integer.toString(loadBalancedEndpointsItem.getPort())));
                    inputEndpointElement.appendChild(portElement);
                }
                if (loadBalancedEndpointsItem.getLoadBalancerProbe() != null) {
                    Element loadBalancerProbeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                    inputEndpointElement.appendChild(loadBalancerProbeElement);
                    if (loadBalancedEndpointsItem.getLoadBalancerProbe().getPath() != null) {
                        Element pathElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Path");
                        pathElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getLoadBalancerProbe().getPath()));
                        loadBalancerProbeElement.appendChild(pathElement);
                    }
                    Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                    portElement2.appendChild(requestDoc.createTextNode(Integer.toString(loadBalancedEndpointsItem.getLoadBalancerProbe().getPort())));
                    loadBalancerProbeElement.appendChild(portElement2);
                    if (loadBalancedEndpointsItem.getLoadBalancerProbe().getProtocol() != null) {
                        Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                        protocolElement.appendChild(requestDoc.createTextNode(ComputeManagementClientImpl.loadBalancerProbeTransportProtocolToString(loadBalancedEndpointsItem.getLoadBalancerProbe().getProtocol())));
                        loadBalancerProbeElement.appendChild(protocolElement);
                    }
                    if (loadBalancedEndpointsItem.getLoadBalancerProbe().getIntervalInSeconds() != null) {
                        Element intervalInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                        intervalInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(loadBalancedEndpointsItem.getLoadBalancerProbe().getIntervalInSeconds())));
                        loadBalancerProbeElement.appendChild(intervalInSecondsElement);
                    }
                    if (loadBalancedEndpointsItem.getLoadBalancerProbe().getTimeoutInSeconds() != null) {
                        Element timeoutInSecondsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                        timeoutInSecondsElement.appendChild(requestDoc.createTextNode(Integer.toString(loadBalancedEndpointsItem.getLoadBalancerProbe().getTimeoutInSeconds())));
                        loadBalancerProbeElement.appendChild(timeoutInSecondsElement);
                    }
                }
                if (loadBalancedEndpointsItem.getProtocol() != null) {
                    Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                    protocolElement2.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getProtocol()));
                    inputEndpointElement.appendChild(protocolElement2);
                }
                if (loadBalancedEndpointsItem.getVirtualIPAddress() != null) {
                    Element vipElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Vip");
                    vipElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getVirtualIPAddress().getHostAddress()));
                    inputEndpointElement.appendChild(vipElement);
                }
                if (loadBalancedEndpointsItem.isEnableDirectServerReturn() != null) {
                    Element enableDirectServerReturnElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                    enableDirectServerReturnElement.appendChild(requestDoc.createTextNode(Boolean.toString(loadBalancedEndpointsItem.isEnableDirectServerReturn()).toLowerCase()));
                    inputEndpointElement.appendChild(enableDirectServerReturnElement);
                }
                Element endpointAclElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                inputEndpointElement.appendChild(endpointAclElement);
                if (loadBalancedEndpointsItem.getRules() != null && (!(loadBalancedEndpointsItem.getRules() instanceof LazyCollection) || ((LazyCollection)loadBalancedEndpointsItem.getRules()).isInitialized())) {
                    Element rulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rules");
                    for (AccessControlListRule rulesItem : loadBalancedEndpointsItem.getRules()) {
                        Element ruleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Rule");
                        rulesSequenceElement.appendChild(ruleElement);
                        if (rulesItem.getOrder() != null) {
                            Element orderElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Order");
                            orderElement.appendChild(requestDoc.createTextNode(Integer.toString(rulesItem.getOrder())));
                            ruleElement.appendChild(orderElement);
                        }
                        if (rulesItem.getAction() != null) {
                            Element actionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Action");
                            actionElement.appendChild(requestDoc.createTextNode(rulesItem.getAction()));
                            ruleElement.appendChild(actionElement);
                        }
                        if (rulesItem.getRemoteSubnet() != null) {
                            Element remoteSubnetElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                            remoteSubnetElement.appendChild(requestDoc.createTextNode(rulesItem.getRemoteSubnet()));
                            ruleElement.appendChild(remoteSubnetElement);
                        }
                        if (rulesItem.getDescription() == null) continue;
                        Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
                        descriptionElement.appendChild(requestDoc.createTextNode(rulesItem.getDescription()));
                        ruleElement.appendChild(descriptionElement);
                    }
                    endpointAclElement.appendChild(rulesSequenceElement);
                }
                if (loadBalancedEndpointsItem.getLoadBalancerName() != null) {
                    Element loadBalancerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                    loadBalancerNameElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getLoadBalancerName()));
                    inputEndpointElement.appendChild(loadBalancerNameElement);
                }
                if (loadBalancedEndpointsItem.getIdleTimeoutInMinutes() != null) {
                    Element idleTimeoutInMinutesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                    idleTimeoutInMinutesElement.appendChild(requestDoc.createTextNode(Integer.toString(loadBalancedEndpointsItem.getIdleTimeoutInMinutes())));
                    inputEndpointElement.appendChild(idleTimeoutInMinutesElement);
                }
                if (loadBalancedEndpointsItem.getLoadBalancerDistribution() != null) {
                    Element loadBalancerDistributionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                    loadBalancerDistributionElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getLoadBalancerDistribution()));
                    inputEndpointElement.appendChild(loadBalancerDistributionElement);
                }
                if (loadBalancedEndpointsItem.getVirtualIPName() == null) continue;
                Element virtualIPNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "VirtualIPName");
                virtualIPNameElement.appendChild(requestDoc.createTextNode(loadBalancedEndpointsItem.getVirtualIPName()));
                inputEndpointElement.appendChild(virtualIPNameElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> captureOSImageAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineCaptureOSImageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.captureOSImage(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse captureOSImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureOSImageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"captureOSImageAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginCapturingOSImageAsync(serviceName, deploymentName, virtualMachineName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> captureVMImageAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineCaptureVMImageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.captureVMImage(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse captureVMImage(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineCaptureVMImageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"captureVMImageAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginCapturingVMImageAsync(serviceName, deploymentName, virtualMachineName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createAsync(final String serviceName, final String deploymentName, final VirtualMachineCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.create(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse create(String serviceName, String deploymentName, VirtualMachineCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginCreatingAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createDeploymentAsync(final String serviceName, final VirtualMachineCreateDeploymentParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.createDeployment(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse createDeployment(String serviceName, VirtualMachineCreateDeploymentParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createDeploymentAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginCreatingDeploymentAsync(serviceName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.delete(serviceName, deploymentName, virtualMachineName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse delete(String serviceName, String deploymentName, String virtualMachineName, boolean deleteFromStorage) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginDeletingAsync(serviceName, deploymentName, virtualMachineName, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualMachineGetResponse> getAsync(final String serviceName, final String deploymentName, final String virtualMachineName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineGetResponse>(){

            @Override
            public VirtualMachineGetResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.get(serviceName, deploymentName, virtualMachineName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineGetResponse get(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roles/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element persistentVMRoleElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"PersistentVMRole");
                if (persistentVMRoleElement != null) {
                    Element oSVirtualHardDiskElement;
                    Element dataVirtualHardDisksSequenceElement;
                    Element configurationSetsSequenceElement;
                    Element defaultWinRmCertificateThumbprintElement;
                    Element roleSizeElement;
                    Element availabilitySetNameElement;
                    Element roleTypeElement;
                    Element osVersionElement;
                    Element roleNameElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                    if (roleNameElement != null) {
                        String roleNameInstance = roleNameElement.getTextContent();
                        result.setRoleName(roleNameInstance);
                    }
                    if ((osVersionElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OsVersion")) != null) {
                        String osVersionInstance = osVersionElement.getTextContent();
                        result.setOsVersion(osVersionInstance);
                    }
                    if ((roleTypeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleType")) != null && roleTypeElement.getTextContent() != null && !roleTypeElement.getTextContent().isEmpty()) {
                        VirtualMachineRoleType roleTypeInstance = VirtualMachineRoleType.valueOf(roleTypeElement.getTextContent());
                        result.setRoleType(roleTypeInstance);
                    }
                    if ((availabilitySetNameElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailabilitySetName")) != null) {
                        String availabilitySetNameInstance = availabilitySetNameElement.getTextContent();
                        result.setAvailabilitySetName(availabilitySetNameInstance);
                    }
                    if ((roleSizeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize")) != null) {
                        String roleSizeInstance = roleSizeElement.getTextContent();
                        result.setRoleSize(roleSizeInstance);
                    }
                    if ((defaultWinRmCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DefaultWinRmCertificateThumbprint")) != null) {
                        String defaultWinRmCertificateThumbprintInstance = defaultWinRmCertificateThumbprintElement.getTextContent();
                        result.setDefaultWinRmCertificateThumbprint(defaultWinRmCertificateThumbprintInstance);
                    }
                    if ((configurationSetsSequenceElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSets")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").size(); ++i1) {
                            Element customDataElement;
                            Element sSHElement;
                            Element disableSshPasswordAuthenticationElement;
                            Element userPasswordElement;
                            Element userNameElement;
                            Element hostNameElement;
                            Element additionalUnattendContentElement;
                            Element adminUsernameElement;
                            Element winRMElement;
                            Element storedCertificateSettingsSequenceElement;
                            Element domainJoinElement;
                            Element timeZoneElement;
                            Element enableAutomaticUpdatesElement;
                            Element resetPasswordOnFirstLogonElement;
                            Element adminPasswordElement;
                            Element computerNameElement;
                            Element iPForwardingElement2;
                            Element networkSecurityGroupElement2;
                            Element networkInterfacesSequenceElement;
                            Element publicIPsSequenceElement;
                            Element staticVirtualNetworkIPAddressElement;
                            Element subnetNamesSequenceElement;
                            Element inputEndpointsSequenceElement;
                            Element configurationSetsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").get(i1);
                            ConfigurationSet configurationSetInstance = new ConfigurationSet();
                            result.getConfigurationSets().add(configurationSetInstance);
                            Element configurationSetTypeElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSetType");
                            if (configurationSetTypeElement != null) {
                                String configurationSetTypeInstance = configurationSetTypeElement.getTextContent();
                                configurationSetInstance.setConfigurationSetType(configurationSetTypeInstance);
                            }
                            if ((inputEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoints")) != null) {
                                for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").size(); ++i2) {
                                    Element virtualIPNameElement;
                                    Element loadBalancerDistributionElement;
                                    Element idleTimeoutInMinutesElement;
                                    Element endpointAclElement;
                                    Element loadBalancerNameElement;
                                    Element enableDirectServerReturnElement;
                                    Element vipElement;
                                    Element protocolElement2;
                                    Element loadBalancerProbeElement;
                                    Element portElement;
                                    Element nameElement;
                                    Element localPortElement;
                                    Element inputEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").get(i2);
                                    InputEndpoint inputEndpointInstance = new InputEndpoint();
                                    configurationSetInstance.getInputEndpoints().add(inputEndpointInstance);
                                    Element loadBalancedEndpointSetNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancedEndpointSetName");
                                    if (loadBalancedEndpointSetNameElement != null) {
                                        String loadBalancedEndpointSetNameInstance = loadBalancedEndpointSetNameElement.getTextContent();
                                        inputEndpointInstance.setLoadBalancedEndpointSetName(loadBalancedEndpointSetNameInstance);
                                    }
                                    if ((localPortElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort")) != null && localPortElement.getTextContent() != null && !localPortElement.getTextContent().isEmpty()) {
                                        int localPortInstance = DatatypeConverter.parseInt((String)localPortElement.getTextContent());
                                        inputEndpointInstance.setLocalPort(localPortInstance);
                                    }
                                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                        String nameInstance = nameElement.getTextContent();
                                        inputEndpointInstance.setName(nameInstance);
                                    }
                                    if ((portElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null && portElement.getTextContent() != null && !portElement.getTextContent().isEmpty()) {
                                        int portInstance = DatatypeConverter.parseInt((String)portElement.getTextContent());
                                        inputEndpointInstance.setPort(portInstance);
                                    }
                                    if ((loadBalancerProbeElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerProbe")) != null) {
                                        Element timeoutInSecondsElement;
                                        Element intervalInSecondsElement;
                                        Element protocolElement;
                                        Element portElement2;
                                        LoadBalancerProbe loadBalancerProbeInstance = new LoadBalancerProbe();
                                        inputEndpointInstance.setLoadBalancerProbe(loadBalancerProbeInstance);
                                        Element pathElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path");
                                        if (pathElement != null) {
                                            String pathInstance = pathElement.getTextContent();
                                            loadBalancerProbeInstance.setPath(pathInstance);
                                        }
                                        if ((portElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null) {
                                            int portInstance2 = DatatypeConverter.parseInt((String)portElement2.getTextContent());
                                            loadBalancerProbeInstance.setPort(portInstance2);
                                        }
                                        if ((protocolElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null && protocolElement.getTextContent() != null && !protocolElement.getTextContent().isEmpty()) {
                                            LoadBalancerProbeTransportProtocol protocolInstance = ComputeManagementClientImpl.parseLoadBalancerProbeTransportProtocol(protocolElement.getTextContent());
                                            loadBalancerProbeInstance.setProtocol(protocolInstance);
                                        }
                                        if ((intervalInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IntervalInSeconds")) != null && intervalInSecondsElement.getTextContent() != null && !intervalInSecondsElement.getTextContent().isEmpty()) {
                                            int intervalInSecondsInstance = DatatypeConverter.parseInt((String)intervalInSecondsElement.getTextContent());
                                            loadBalancerProbeInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                        }
                                        if ((timeoutInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeoutInSeconds")) != null && timeoutInSecondsElement.getTextContent() != null && !timeoutInSecondsElement.getTextContent().isEmpty()) {
                                            int timeoutInSecondsInstance = DatatypeConverter.parseInt((String)timeoutInSecondsElement.getTextContent());
                                            loadBalancerProbeInstance.setTimeoutInSeconds(timeoutInSecondsInstance);
                                        }
                                    }
                                    if ((protocolElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                        String protocolInstance2 = protocolElement2.getTextContent();
                                        inputEndpointInstance.setProtocol(protocolInstance2);
                                    }
                                    if ((vipElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) != null) {
                                        InetAddress vipInstance = InetAddress.getByName(vipElement.getTextContent());
                                        inputEndpointInstance.setVirtualIPAddress(vipInstance);
                                    }
                                    if ((enableDirectServerReturnElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableDirectServerReturn")) != null && enableDirectServerReturnElement.getTextContent() != null && !enableDirectServerReturnElement.getTextContent().isEmpty()) {
                                        boolean enableDirectServerReturnInstance = DatatypeConverter.parseBoolean((String)enableDirectServerReturnElement.getTextContent().toLowerCase());
                                        inputEndpointInstance.setEnableDirectServerReturn(enableDirectServerReturnInstance);
                                    }
                                    if ((loadBalancerNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerName")) != null) {
                                        String loadBalancerNameInstance = loadBalancerNameElement.getTextContent();
                                        inputEndpointInstance.setLoadBalancerName(loadBalancerNameInstance);
                                    }
                                    if ((endpointAclElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndpointAcl")) != null) {
                                        EndpointAcl endpointAclInstance = new EndpointAcl();
                                        inputEndpointInstance.setEndpointAcl(endpointAclInstance);
                                        Element rulesSequenceElement = XmlUtility.getElementByTagNameNS((Node)endpointAclElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rules");
                                        if (rulesSequenceElement != null) {
                                            for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").size(); ++i3) {
                                                Element descriptionElement;
                                                Element remoteSubnetElement;
                                                Element actionElement;
                                                Element rulesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").get(i3);
                                                AccessControlListRule ruleInstance = new AccessControlListRule();
                                                endpointAclInstance.getRules().add(ruleInstance);
                                                Element orderElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Order");
                                                if (orderElement != null && orderElement.getTextContent() != null && !orderElement.getTextContent().isEmpty()) {
                                                    int orderInstance = DatatypeConverter.parseInt((String)orderElement.getTextContent());
                                                    ruleInstance.setOrder(orderInstance);
                                                }
                                                if ((actionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Action")) != null) {
                                                    String actionInstance = actionElement.getTextContent();
                                                    ruleInstance.setAction(actionInstance);
                                                }
                                                if ((remoteSubnetElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSubnet")) != null) {
                                                    String remoteSubnetInstance = remoteSubnetElement.getTextContent();
                                                    ruleInstance.setRemoteSubnet(remoteSubnetInstance);
                                                }
                                                if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) == null) continue;
                                                String descriptionInstance = descriptionElement.getTextContent();
                                                ruleInstance.setDescription(descriptionInstance);
                                            }
                                        }
                                    }
                                    if ((idleTimeoutInMinutesElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement.getTextContent() != null && !idleTimeoutInMinutesElement.getTextContent().isEmpty()) {
                                        int idleTimeoutInMinutesInstance = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement.getTextContent());
                                        inputEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                    }
                                    if ((loadBalancerDistributionElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerDistribution")) != null) {
                                        String loadBalancerDistributionInstance = loadBalancerDistributionElement.getTextContent();
                                        inputEndpointInstance.setLoadBalancerDistribution(loadBalancerDistributionInstance);
                                    }
                                    if ((virtualIPNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIPName")) == null) continue;
                                    String virtualIPNameInstance = virtualIPNameElement.getTextContent();
                                    inputEndpointInstance.setVirtualIPName(virtualIPNameInstance);
                                }
                            }
                            if ((subnetNamesSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetNames")) != null) {
                                for (int i4 = 0; i4 < XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").size(); ++i4) {
                                    Element subnetNamesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").get(i4);
                                    configurationSetInstance.getSubnetNames().add(subnetNamesElement.getTextContent());
                                }
                            }
                            if ((staticVirtualNetworkIPAddressElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) != null) {
                                String staticVirtualNetworkIPAddressInstance = staticVirtualNetworkIPAddressElement.getTextContent();
                                configurationSetInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance);
                            }
                            if ((publicIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIPs")) != null) {
                                for (int i5 = 0; i5 < XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").size(); ++i5) {
                                    Element domainNameLabelElement;
                                    Element idleTimeoutInMinutesElement2;
                                    Element publicIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicIP").get(i5);
                                    ConfigurationSet.PublicIP publicIPInstance = new ConfigurationSet.PublicIP();
                                    configurationSetInstance.getPublicIPs().add(publicIPInstance);
                                    Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                    if (nameElement2 != null) {
                                        String nameInstance2 = nameElement2.getTextContent();
                                        publicIPInstance.setName(nameInstance2);
                                    }
                                    if ((idleTimeoutInMinutesElement2 = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IdleTimeoutInMinutes")) != null && idleTimeoutInMinutesElement2.getTextContent() != null && !idleTimeoutInMinutesElement2.getTextContent().isEmpty()) {
                                        int idleTimeoutInMinutesInstance2 = DatatypeConverter.parseInt((String)idleTimeoutInMinutesElement2.getTextContent());
                                        publicIPInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    if ((domainNameLabelElement = XmlUtility.getElementByTagNameNS((Node)publicIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainNameLabel")) == null) continue;
                                    String domainNameLabelInstance = domainNameLabelElement.getTextContent();
                                    publicIPInstance.setDomainNameLabel(domainNameLabelInstance);
                                }
                            }
                            if ((networkInterfacesSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterfaces")) != null) {
                                for (int i6 = 0; i6 < XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").size(); ++i6) {
                                    Element iPForwardingElement;
                                    Element networkSecurityGroupElement;
                                    Element iPConfigurationsSequenceElement;
                                    Element networkInterfacesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)networkInterfacesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkInterface").get(i6);
                                    NetworkInterface networkInterfaceInstance = new NetworkInterface();
                                    configurationSetInstance.getNetworkInterfaces().add(networkInterfaceInstance);
                                    Element nameElement3 = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                    if (nameElement3 != null) {
                                        String nameInstance3 = nameElement3.getTextContent();
                                        networkInterfaceInstance.setName(nameInstance3);
                                    }
                                    if ((iPConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfigurations")) != null) {
                                        for (int i7 = 0; i7 < XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").size(); ++i7) {
                                            Element staticVirtualNetworkIPAddressElement2;
                                            Element iPConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)iPConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPConfiguration").get(i7);
                                            IPConfiguration iPConfigurationInstance = new IPConfiguration();
                                            networkInterfaceInstance.getIPConfigurations().add(iPConfigurationInstance);
                                            Element subnetNameElement = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName");
                                            if (subnetNameElement != null) {
                                                String subnetNameInstance = subnetNameElement.getTextContent();
                                                iPConfigurationInstance.setSubnetName(subnetNameInstance);
                                            }
                                            if ((staticVirtualNetworkIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)iPConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) == null) continue;
                                            String staticVirtualNetworkIPAddressInstance2 = staticVirtualNetworkIPAddressElement2.getTextContent();
                                            iPConfigurationInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance2);
                                        }
                                    }
                                    if ((networkSecurityGroupElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) != null) {
                                        String networkSecurityGroupInstance = networkSecurityGroupElement.getTextContent();
                                        networkInterfaceInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    }
                                    if ((iPForwardingElement = XmlUtility.getElementByTagNameNS((Node)networkInterfacesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPForwarding")) == null) continue;
                                    String iPForwardingInstance = iPForwardingElement.getTextContent();
                                    networkInterfaceInstance.setIPForwarding(iPForwardingInstance);
                                }
                            }
                            if ((networkSecurityGroupElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NetworkSecurityGroup")) != null) {
                                String networkSecurityGroupInstance2 = networkSecurityGroupElement2.getTextContent();
                                configurationSetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance2);
                            }
                            if ((iPForwardingElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IPForwarding")) != null) {
                                String iPForwardingInstance2 = iPForwardingElement2.getTextContent();
                                configurationSetInstance.setIPForwarding(iPForwardingInstance2);
                            }
                            if ((computerNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComputerName")) != null) {
                                String computerNameInstance = computerNameElement.getTextContent();
                                configurationSetInstance.setComputerName(computerNameInstance);
                            }
                            if ((adminPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminPassword")) != null) {
                                String adminPasswordInstance = adminPasswordElement.getTextContent();
                                configurationSetInstance.setAdminPassword(adminPasswordInstance);
                            }
                            if ((resetPasswordOnFirstLogonElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResetPasswordOnFirstLogon")) != null && resetPasswordOnFirstLogonElement.getTextContent() != null && !resetPasswordOnFirstLogonElement.getTextContent().isEmpty()) {
                                boolean resetPasswordOnFirstLogonInstance = DatatypeConverter.parseBoolean((String)resetPasswordOnFirstLogonElement.getTextContent().toLowerCase());
                                configurationSetInstance.setResetPasswordOnFirstLogon(resetPasswordOnFirstLogonInstance);
                            }
                            if ((enableAutomaticUpdatesElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableAutomaticUpdates")) != null && enableAutomaticUpdatesElement.getTextContent() != null && !enableAutomaticUpdatesElement.getTextContent().isEmpty()) {
                                boolean enableAutomaticUpdatesInstance = DatatypeConverter.parseBoolean((String)enableAutomaticUpdatesElement.getTextContent().toLowerCase());
                                configurationSetInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                            }
                            if ((timeZoneElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeZone")) != null) {
                                String timeZoneInstance = timeZoneElement.getTextContent();
                                configurationSetInstance.setTimeZone(timeZoneInstance);
                            }
                            if ((domainJoinElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainJoin")) != null) {
                                Element provisioningElement;
                                Element machineObjectOUElement;
                                Element joinDomainElement;
                                DomainJoinSettings domainJoinInstance = new DomainJoinSettings();
                                configurationSetInstance.setDomainJoin(domainJoinInstance);
                                Element credentialsElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Credentials");
                                if (credentialsElement != null) {
                                    Element passwordElement;
                                    Element usernameElement;
                                    DomainJoinCredentials credentialsInstance = new DomainJoinCredentials();
                                    domainJoinInstance.setCredentials(credentialsInstance);
                                    Element domainElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Domain");
                                    if (domainElement != null) {
                                        String domainInstance = domainElement.getTextContent();
                                        credentialsInstance.setDomain(domainInstance);
                                    }
                                    if ((usernameElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Username")) != null) {
                                        String usernameInstance = usernameElement.getTextContent();
                                        credentialsInstance.setUserName(usernameInstance);
                                    }
                                    if ((passwordElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Password")) != null) {
                                        String passwordInstance = passwordElement.getTextContent();
                                        credentialsInstance.setPassword(passwordInstance);
                                    }
                                }
                                if ((joinDomainElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"JoinDomain")) != null) {
                                    String joinDomainInstance = joinDomainElement.getTextContent();
                                    domainJoinInstance.setDomainToJoin(joinDomainInstance);
                                }
                                if ((machineObjectOUElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MachineObjectOU")) != null) {
                                    String machineObjectOUInstance = machineObjectOUElement.getTextContent();
                                    domainJoinInstance.setLdapMachineObjectOU(machineObjectOUInstance);
                                }
                                if ((provisioningElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Provisioning")) != null) {
                                    DomainJoinProvisioning provisioningInstance = new DomainJoinProvisioning();
                                    domainJoinInstance.setProvisioning(provisioningInstance);
                                    Element accountDataElement = XmlUtility.getElementByTagNameNS((Node)provisioningElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountData");
                                    if (accountDataElement != null) {
                                        String accountDataInstance = accountDataElement.getTextContent();
                                        provisioningInstance.setAccountData(accountDataInstance);
                                    }
                                }
                            }
                            if ((storedCertificateSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoredCertificateSettings")) != null) {
                                for (int i8 = 0; i8 < XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").size(); ++i8) {
                                    Element thumbprintElement;
                                    Element storeNameElement;
                                    Element storedCertificateSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").get(i8);
                                    StoredCertificateSettings certificateSettingInstance = new StoredCertificateSettings();
                                    configurationSetInstance.getStoredCertificateSettings().add(certificateSettingInstance);
                                    Element storeLocationElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreLocation");
                                    if (storeLocationElement != null) {
                                        // empty if block
                                    }
                                    if ((storeNameElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreName")) != null) {
                                        String storeNameInstance = storeNameElement.getTextContent();
                                        certificateSettingInstance.setStoreName(storeNameInstance);
                                    }
                                    if ((thumbprintElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Thumbprint")) == null) continue;
                                    String thumbprintInstance = thumbprintElement.getTextContent();
                                    certificateSettingInstance.setThumbprint(thumbprintInstance);
                                }
                            }
                            if ((winRMElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"WinRM")) != null) {
                                WindowsRemoteManagementSettings winRMInstance = new WindowsRemoteManagementSettings();
                                configurationSetInstance.setWindowsRemoteManagement(winRMInstance);
                                Element listenersSequenceElement = XmlUtility.getElementByTagNameNS((Node)winRMElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listeners");
                                if (listenersSequenceElement != null) {
                                    for (int i9 = 0; i9 < XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").size(); ++i9) {
                                        Element certificateThumbprintElement;
                                        Element listenersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").get(i9);
                                        WindowsRemoteManagementListener listenerInstance = new WindowsRemoteManagementListener();
                                        winRMInstance.getListeners().add(listenerInstance);
                                        Element protocolElement3 = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol");
                                        if (protocolElement3 != null && protocolElement3.getTextContent() != null && !protocolElement3.getTextContent().isEmpty()) {
                                            VirtualMachineWindowsRemoteManagementListenerType protocolInstance3 = VirtualMachineWindowsRemoteManagementListenerType.valueOf(protocolElement3.getTextContent());
                                            listenerInstance.setListenerType(protocolInstance3);
                                        }
                                        if ((certificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateThumbprint")) == null) continue;
                                        String certificateThumbprintInstance = certificateThumbprintElement.getTextContent();
                                        listenerInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                    }
                                }
                            }
                            if ((adminUsernameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminUsername")) != null) {
                                String adminUsernameInstance = adminUsernameElement.getTextContent();
                                configurationSetInstance.setAdminUserName(adminUsernameInstance);
                            }
                            if ((additionalUnattendContentElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdditionalUnattendContent")) != null) {
                                AdditionalUnattendContentSettings additionalUnattendContentInstance = new AdditionalUnattendContentSettings();
                                configurationSetInstance.setAdditionalUnattendContent(additionalUnattendContentInstance);
                                Element passesSequenceElement = XmlUtility.getElementByTagNameNS((Node)additionalUnattendContentElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Passes");
                                if (passesSequenceElement != null) {
                                    for (int i10 = 0; i10 < XmlUtility.getElementsByTagNameNS((Node)passesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendPass").size(); ++i10) {
                                        Element componentsSequenceElement;
                                        Element passesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)passesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendPass").get(i10);
                                        UnattendPassSettings unattendPassInstance = new UnattendPassSettings();
                                        additionalUnattendContentInstance.getUnattendPasses().add(unattendPassInstance);
                                        Element passNameElement = XmlUtility.getElementByTagNameNS((Node)passesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PassName");
                                        if (passNameElement != null) {
                                            String passNameInstance = passNameElement.getTextContent();
                                            unattendPassInstance.setPassName(passNameInstance);
                                        }
                                        if ((componentsSequenceElement = XmlUtility.getElementByTagNameNS((Node)passesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Components")) == null) continue;
                                        for (int i11 = 0; i11 < XmlUtility.getElementsByTagNameNS((Node)componentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendComponent").size(); ++i11) {
                                            Element componentSettingsSequenceElement;
                                            Element componentsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)componentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UnattendComponent").get(i11);
                                            UnattendComponent unattendComponentInstance = new UnattendComponent();
                                            unattendPassInstance.getUnattendComponents().add(unattendComponentInstance);
                                            Element componentNameElement = XmlUtility.getElementByTagNameNS((Node)componentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentName");
                                            if (componentNameElement != null) {
                                                String componentNameInstance = componentNameElement.getTextContent();
                                                unattendComponentInstance.setComponentName(componentNameInstance);
                                            }
                                            if ((componentSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)componentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSettings")) == null) continue;
                                            for (int i12 = 0; i12 < XmlUtility.getElementsByTagNameNS((Node)componentSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSetting").size(); ++i12) {
                                                Element contentElement;
                                                Element componentSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)componentSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComponentSetting").get(i12);
                                                ComponentSetting componentSettingInstance = new ComponentSetting();
                                                unattendComponentInstance.getUnattendComponentSettings().add(componentSettingInstance);
                                                Element settingNameElement = XmlUtility.getElementByTagNameNS((Node)componentSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SettingName");
                                                if (settingNameElement != null) {
                                                    String settingNameInstance = settingNameElement.getTextContent();
                                                    componentSettingInstance.setSettingName(settingNameInstance);
                                                }
                                                if ((contentElement = XmlUtility.getElementByTagNameNS((Node)componentSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Content")) == null) continue;
                                                String contentInstance = contentElement.getTextContent() != null ? new String(Base64.decode((String)contentElement.getTextContent())) : null;
                                                componentSettingInstance.setContent(contentInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            if ((hostNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                String hostNameInstance = hostNameElement.getTextContent();
                                configurationSetInstance.setHostName(hostNameInstance);
                            }
                            if ((userNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserName")) != null) {
                                String userNameInstance = userNameElement.getTextContent();
                                configurationSetInstance.setUserName(userNameInstance);
                            }
                            if ((userPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserPassword")) != null) {
                                String userPasswordInstance = userPasswordElement.getTextContent();
                                configurationSetInstance.setUserPassword(userPasswordInstance);
                            }
                            if ((disableSshPasswordAuthenticationElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisableSshPasswordAuthentication")) != null && disableSshPasswordAuthenticationElement.getTextContent() != null && !disableSshPasswordAuthenticationElement.getTextContent().isEmpty()) {
                                boolean disableSshPasswordAuthenticationInstance = DatatypeConverter.parseBoolean((String)disableSshPasswordAuthenticationElement.getTextContent().toLowerCase());
                                configurationSetInstance.setDisableSshPasswordAuthentication(disableSshPasswordAuthenticationInstance);
                            }
                            if ((sSHElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SSH")) != null) {
                                Element keyPairsSequenceElement;
                                SshSettings sSHInstance = new SshSettings();
                                configurationSetInstance.setSshSettings(sSHInstance);
                                Element publicKeysSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKeys");
                                if (publicKeysSequenceElement != null) {
                                    for (int i13 = 0; i13 < XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").size(); ++i13) {
                                        Element pathElement2;
                                        Element publicKeysElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").get(i13);
                                        SshSettingPublicKey publicKeyInstance = new SshSettingPublicKey();
                                        sSHInstance.getPublicKeys().add(publicKeyInstance);
                                        Element fingerprintElement = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                        if (fingerprintElement != null) {
                                            String fingerprintInstance = fingerprintElement.getTextContent();
                                            publicKeyInstance.setFingerprint(fingerprintInstance);
                                        }
                                        if ((pathElement2 = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                        String pathInstance2 = pathElement2.getTextContent();
                                        publicKeyInstance.setPath(pathInstance2);
                                    }
                                }
                                if ((keyPairsSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPairs")) != null) {
                                    for (int i14 = 0; i14 < XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").size(); ++i14) {
                                        Element pathElement3;
                                        Element keyPairsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").get(i14);
                                        SshSettingKeyPair keyPairInstance = new SshSettingKeyPair();
                                        sSHInstance.getKeyPairs().add(keyPairInstance);
                                        Element fingerprintElement2 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                        if (fingerprintElement2 != null) {
                                            String fingerprintInstance2 = fingerprintElement2.getTextContent();
                                            keyPairInstance.setFingerprint(fingerprintInstance2);
                                        }
                                        if ((pathElement3 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                        String pathInstance3 = pathElement3.getTextContent();
                                        keyPairInstance.setPath(pathInstance3);
                                    }
                                }
                            }
                            if ((customDataElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CustomData")) == null) continue;
                            String customDataInstance = customDataElement.getTextContent();
                            configurationSetInstance.setCustomData(customDataInstance);
                        }
                    }
                    if ((dataVirtualHardDisksSequenceElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisks")) != null) {
                        for (int i15 = 0; i15 < XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").size(); ++i15) {
                            Element iOTypeElement;
                            Element sourceMediaLinkElement;
                            Element mediaLinkElement;
                            Element logicalDiskSizeInGBElement;
                            Element lunElement;
                            Element diskNameElement;
                            Element diskLabelElement;
                            Element dataVirtualHardDisksElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").get(i15);
                            DataVirtualHardDisk dataVirtualHardDiskInstance = new DataVirtualHardDisk();
                            result.getDataVirtualHardDisks().add(dataVirtualHardDiskInstance);
                            Element hostCachingElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                            if (hostCachingElement != null) {
                                String hostCachingInstance = hostCachingElement.getTextContent();
                                dataVirtualHardDiskInstance.setHostCaching(hostCachingInstance);
                            }
                            if ((diskLabelElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                String diskLabelInstance = diskLabelElement.getTextContent();
                                dataVirtualHardDiskInstance.setLabel(diskLabelInstance);
                            }
                            if ((diskNameElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                String diskNameInstance = diskNameElement.getTextContent();
                                dataVirtualHardDiskInstance.setName(diskNameInstance);
                            }
                            if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && lunElement.getTextContent() != null && !lunElement.getTextContent().isEmpty()) {
                                int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                dataVirtualHardDiskInstance.setLogicalUnitNumber(lunInstance);
                            }
                            if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null && logicalDiskSizeInGBElement.getTextContent() != null && !logicalDiskSizeInGBElement.getTextContent().isEmpty()) {
                                int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                                dataVirtualHardDiskInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                            }
                            if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                dataVirtualHardDiskInstance.setMediaLink(mediaLinkInstance);
                            }
                            if ((sourceMediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceMediaLink")) != null) {
                                URI sourceMediaLinkInstance = new URI(sourceMediaLinkElement.getTextContent());
                                dataVirtualHardDiskInstance.setSourceMediaLink(sourceMediaLinkInstance);
                            }
                            if ((iOTypeElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) == null) continue;
                            String iOTypeInstance = iOTypeElement.getTextContent();
                            dataVirtualHardDiskInstance.setIOType(iOTypeInstance);
                        }
                    }
                    if ((oSVirtualHardDiskElement = XmlUtility.getElementByTagNameNS((Node)persistentVMRoleElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSVirtualHardDisk")) != null) {
                        Element resizedSizeInGBElement;
                        Element iOTypeElement2;
                        Element remoteSourceImageLinkElement;
                        Element osElement;
                        Element sourceImageNameElement;
                        Element mediaLinkElement2;
                        Element diskNameElement2;
                        Element diskLabelElement2;
                        OSVirtualHardDisk oSVirtualHardDiskInstance = new OSVirtualHardDisk();
                        result.setOSVirtualHardDisk(oSVirtualHardDiskInstance);
                        Element hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                        if (hostCachingElement2 != null) {
                            String hostCachingInstance2 = hostCachingElement2.getTextContent();
                            oSVirtualHardDiskInstance.setHostCaching(hostCachingInstance2);
                        }
                        if ((diskLabelElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                            String diskLabelInstance2 = diskLabelElement2.getTextContent();
                            oSVirtualHardDiskInstance.setLabel(diskLabelInstance2);
                        }
                        if ((diskNameElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                            String diskNameInstance2 = diskNameElement2.getTextContent();
                            oSVirtualHardDiskInstance.setName(diskNameInstance2);
                        }
                        if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                            URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                            oSVirtualHardDiskInstance.setMediaLink(mediaLinkInstance2);
                        }
                        if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                            String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                            oSVirtualHardDiskInstance.setSourceImageName(sourceImageNameInstance);
                        }
                        if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                            String osInstance = osElement.getTextContent();
                            oSVirtualHardDiskInstance.setOperatingSystem(osInstance);
                        }
                        if ((remoteSourceImageLinkElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSourceImageLink")) != null) {
                            URI remoteSourceImageLinkInstance = new URI(remoteSourceImageLinkElement.getTextContent());
                            oSVirtualHardDiskInstance.setRemoteSourceImageLink(remoteSourceImageLinkInstance);
                        }
                        if ((iOTypeElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IOType")) != null) {
                            String iOTypeInstance2 = iOTypeElement2.getTextContent();
                            oSVirtualHardDiskInstance.setIOType(iOTypeInstance2);
                        }
                        if ((resizedSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResizedSizeInGB")) != null && resizedSizeInGBElement.getTextContent() != null && !resizedSizeInGBElement.getTextContent().isEmpty()) {
                            int resizedSizeInGBInstance = DatatypeConverter.parseInt((String)resizedSizeInGBElement.getTextContent());
                            oSVirtualHardDiskInstance.setResizedSizeInGB(resizedSizeInGBInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineGetResponse virtualMachineGetResponse = result;
            return virtualMachineGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineGetRemoteDesktopFileResponse> getRemoteDesktopFileAsync(final String serviceName, final String deploymentName, final String virtualMachineName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineGetRemoteDesktopFileResponse>(){

            @Override
            public VirtualMachineGetRemoteDesktopFileResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.getRemoteDesktopFile(serviceName, deploymentName, virtualMachineName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineGetRemoteDesktopFileResponse getRemoteDesktopFile(String serviceName, String deploymentName, String virtualMachineName) throws IOException, ServiceException {
        String baseUrl;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (virtualMachineName == null) {
            throw new NullPointerException("virtualMachineName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getRemoteDesktopFileAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(virtualMachineName, "UTF-8");
        url = url + "/ModelFile";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("FileType=RDP");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineGetRemoteDesktopFileResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineGetRemoteDesktopFileResponse();
                result.setRemoteDesktopFile(StreamUtils.toString((InputStream)responseContent).getBytes("UTF-8"));
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineGetRemoteDesktopFileResponse virtualMachineGetRemoteDesktopFileResponse = result;
            return virtualMachineGetRemoteDesktopFileResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> restartAsync(final String serviceName, final String deploymentName, final String virtualMachineName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.restart(serviceName, deploymentName, virtualMachineName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse restart(String serviceName, String deploymentName, String virtualMachineName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"restartAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginRestartingAsync(serviceName, deploymentName, virtualMachineName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> shutdownAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineShutdownParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.shutdown(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse shutdown(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineShutdownParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"shutdownAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginShutdownAsync(serviceName, deploymentName, virtualMachineName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> shutdownRolesAsync(final String serviceName, final String deploymentName, final VirtualMachineShutdownRolesParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.shutdownRoles(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse shutdownRoles(String serviceName, String deploymentName, VirtualMachineShutdownRolesParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"shutdownRolesAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginShuttingDownRolesAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> startAsync(final String serviceName, final String deploymentName, final String virtualMachineName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.start(serviceName, deploymentName, virtualMachineName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse start(String serviceName, String deploymentName, String virtualMachineName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"startAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginStartingAsync(serviceName, deploymentName, virtualMachineName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> startRolesAsync(final String serviceName, final String deploymentName, final VirtualMachineStartRolesParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.startRoles(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse startRoles(String serviceName, String deploymentName, VirtualMachineStartRolesParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"startRolesAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginStartingRolesAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> updateAsync(final String serviceName, final String deploymentName, final String virtualMachineName, final VirtualMachineUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.update(serviceName, deploymentName, virtualMachineName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse update(String serviceName, String deploymentName, String virtualMachineName, VirtualMachineUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("virtualMachineName", virtualMachineName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginUpdatingAsync(serviceName, deploymentName, virtualMachineName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> updateLoadBalancedEndpointSetAsync(final String serviceName, final String deploymentName, final VirtualMachineUpdateLoadBalancedSetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.updateLoadBalancedEndpointSet(serviceName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse updateLoadBalancedEndpointSet(String serviceName, String deploymentName, VirtualMachineUpdateLoadBalancedSetParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateLoadBalancedEndpointSetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachinesOperations().beginUpdatingLoadBalancedEndpointSetAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

