var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });

// src/atn/LexerActionType.ts
var LexerActionType = {
  /** The type of a {@link LexerChannelAction} action. */
  CHANNEL: 0,
  /** The type of a {@link LexerCustomAction} action */
  CUSTOM: 1,
  /** The type of a {@link LexerModeAction} action. */
  MODE: 2,
  /** The type of a {@link LexerMoreAction} action. */
  MORE: 3,
  /** The type of a {@link LexerPopModeAction} action. */
  POP_MODE: 4,
  /** The type of a {@link LexerPushModeAction} action. */
  PUSH_MODE: 5,
  /** The type of a {@link LexerSkipAction} action. */
  SKIP: 6,
  /** The type of a {@link LexerTypeAction} action. */
  TYPE: 7
};

// src/utils/MurmurHash.ts
var c1 = 3432918353;
var c2 = 461845907;
var r1 = 15;
var r2 = 13;
var m = 5;
var n = 3864292196;
var MurmurHash = class _MurmurHash {
  static {
    __name(this, "MurmurHash");
  }
  static defaultSeed = 701;
  constructor() {
  }
  /**
   * Initialize the hash using the specified {@code seed}.
   *
   * @param seed the seed
   *
   * @returns the intermediate hash value
   */
  static initialize(seed = _MurmurHash.defaultSeed) {
    return seed;
  }
  static updateFromComparable(hash, value) {
    return this.update(hash, value?.hashCode() ?? 0);
  }
  /**
   * Update the intermediate hash value for the next input {@code value}.
   *
   * @param hash The intermediate hash value.
   * @param value the value to add to the current hash.
   *
   * @returns the updated intermediate hash value
   */
  static update(hash, value) {
    value = Math.imul(value, c1);
    value = value << r1 | value >>> 32 - r1;
    value = Math.imul(value, c2);
    hash = hash ^ value;
    hash = hash << r2 | hash >>> 32 - r2;
    hash = Math.imul(hash, m) + n;
    return hash;
  }
  /**
   * Apply the final computation steps to the intermediate value {@code hash}
   * to form the final result of the MurmurHash 3 hash function.
   *
   * @param hash The intermediate hash value.
   * @param entryCount The number of values added to the hash.
   *
   * @returns the final hash result
   */
  static finish(hash, entryCount) {
    hash ^= entryCount * 4;
    hash ^= hash >>> 16;
    hash = Math.imul(hash, 2246822507);
    hash ^= hash >>> 13;
    hash = Math.imul(hash, 3266489909);
    hash ^= hash >>> 16;
    return hash;
  }
  /**
   * An all-in-one convenience method to compute a hash for a single value.
   *
   * @param value The value to hash.
   * @param seed The seed for the hash value.
   *
   * @returns The computed hash.
   */
  static hashCode(value, seed) {
    return _MurmurHash.finish(_MurmurHash.update(seed ?? _MurmurHash.defaultSeed, value), 1);
  }
};

// src/atn/LexerCustomAction.ts
var LexerCustomAction = class _LexerCustomAction {
  static {
    __name(this, "LexerCustomAction");
  }
  ruleIndex;
  actionIndex;
  actionType;
  isPositionDependent = true;
  cachedHashCode;
  /**
   * Constructs a custom lexer action with the specified rule and action indexes.
   *
   * @param ruleIndex The rule index to use for calls to {@link Recognizer.action}.
   * @param actionIndex The action index to use for calls to {@link Recognizer.action}.
   */
  constructor(ruleIndex, actionIndex) {
    this.actionType = LexerActionType.CUSTOM;
    this.ruleIndex = ruleIndex;
    this.actionIndex = actionIndex;
  }
  /**
   * Custom actions are implemented by calling {@link Lexer.action} with the
   * appropriate rule and action indexes.
   */
  execute(lexer) {
    lexer.action(null, this.ruleIndex, this.actionIndex);
  }
  hashCode() {
    if (this.cachedHashCode === void 0) {
      let hash = MurmurHash.initialize();
      hash = MurmurHash.update(hash, this.actionType);
      hash = MurmurHash.update(hash, this.ruleIndex);
      hash = MurmurHash.update(hash, this.actionIndex);
      this.cachedHashCode = MurmurHash.finish(hash, 3);
    }
    return this.cachedHashCode;
  }
  equals(other) {
    if (this === other) {
      return true;
    }
    if (!(other instanceof _LexerCustomAction)) {
      return false;
    }
    return this.ruleIndex === other.ruleIndex && this.actionIndex === other.actionIndex;
  }
};
export {
  LexerCustomAction
};
