function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../../common';
import { EuiTitle } from '../../title';
import { EuiText } from '../../text';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
var paddingSizeToClassNameMap = {
  xxxs: 'euiDescribedFormGroup__fieldPadding--xxxsmall',
  xxs: 'euiDescribedFormGroup__fieldPadding--xxsmall',
  xs: 'euiDescribedFormGroup__fieldPadding--xsmall',
  s: 'euiDescribedFormGroup__fieldPadding--small',
  m: 'euiDescribedFormGroup__fieldPadding--medium',
  l: 'euiDescribedFormGroup__fieldPadding--large'
};
export var PADDING_SIZES = keysOf(paddingSizeToClassNameMap);
export var EuiDescribedFormGroup = function EuiDescribedFormGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'xs' : _ref$titleSize,
    title = _ref.title,
    description = _ref.description,
    descriptionFlexItemProps = _ref.descriptionFlexItemProps,
    fieldFlexItemProps = _ref.fieldFlexItemProps,
    rest = _objectWithoutProperties(_ref, ["children", "className", "gutterSize", "fullWidth", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"]);
  var classes = classNames('euiDescribedFormGroup', {
    'euiDescribedFormGroup--fullWidth': fullWidth
  }, className);
  var fieldClasses = classNames('euiDescribedFormGroup__fields', paddingSizeToClassNameMap[titleSize], fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;
  if (description) {
    renderedDescription = /*#__PURE__*/React.createElement(EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDescribedFormGroup__description"
    }, description);
  }
  return /*#__PURE__*/React.createElement("div", _extends({
    role: "group",
    className: classes
  }, rest), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: gutterSize
  }, /*#__PURE__*/React.createElement(EuiFlexItem, descriptionFlexItemProps, /*#__PURE__*/React.createElement(EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), /*#__PURE__*/React.createElement(EuiFlexItem, _extends({}, fieldFlexItemProps, {
    className: fieldClasses
  }), children)));
};
EuiDescribedFormGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
       * One or more `EuiFormRow`s
       */
  children: PropTypes.node,
  /**
       * Passed to `EuiFlexGroup`
       */
  gutterSize: PropTypes.oneOf(["none", "xs", "s", "m", "l", "xl"]),
  fullWidth: PropTypes.bool,
  /**
       * For better accessibility, it's recommended the use of HTML headings
       */
  title: PropTypes.element.isRequired,
  titleSize: PropTypes.oneOf(["xxxs", "xxs", "xs", "s", "m", "l"]),
  /**
       * Added as a child of `EuiText`
       */
  description: PropTypes.node,
  /**
       * For customizing the field container. Extended from `EuiFlexItem`
       */
  descriptionFlexItemProps: PropTypes.any,
  fieldFlexItemProps: PropTypes.any
};