"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipAnchorSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var picked_shapes_1 = require("./picked_shapes");
function getCurrentPointerPosition(state) {
    return state.interactions.pointer.current.position;
}
exports.getTooltipAnchorSelector = create_selector_1.createCustomCachedSelector([picked_shapes_1.getPickedShapes, compute_chart_dimensions_1.computeChartDimensionsSelector, getCurrentPointerPosition], function (shapes, chartDimensions, position) {
    if (Array.isArray(shapes) && shapes.length > 0) {
        var firstShape = shapes[0];
        return {
            x: firstShape.x + chartDimensions.left,
            width: firstShape.width,
            y: firstShape.y - chartDimensions.top,
            height: firstShape.height,
        };
    }
    return {
        x: position.x,
        width: 0,
        y: position.y,
        height: 0,
    };
});
//# sourceMappingURL=get_tooltip_anchor.js.map