// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/* Before Node.js v11 the crypto module did not support
 * a method to PEM format a ECDH key.  It has always supported
 * producing such keys: `crypto.createECDH`.  But formatting
 * these keys as a PEM for use in `crypto.Sign` and
 * `crypto.Verify` has not been possible in native `crypto`.
 * As Node.js v6, v8, and v10 reach end of life, this code
 * can be deleted.
 */
// @ts-ignore
import asn from 'asn1.js';
const Rfc5915Key = asn.define('Rfc5915Key', function () {
    this.seq().obj(this.key('version').int(), this.key('privateKey').octstr(), this.key('parameters').optional().explicit(0).objid({
        '1 2 840 10045 3 1 7': 'prime256v1',
        '1 3 132 0 34': 'secp384r1',
    }), this.key('publicKey').optional().explicit(1).bitstr());
});
const SpkiKey = asn.define('SpkiKey', function () {
    this.seq().obj(this.key('algorithmIdentifier')
        .seq()
        .obj(this.key('publicKeyType').objid({
        '1 2 840 10045 2 1': 'EC',
    }), this.key('parameters').objid({
        '1 2 840 10045 3 1 7': 'prime256v1',
        '1 3 132 0 34': 'secp384r1',
    })), this.key('publicKey').bitstr());
});
export function publicKeyPem(curve, publicKey) {
    const buff = SpkiKey.encode({
        algorithmIdentifier: {
            publicKeyType: 'EC',
            parameters: curve,
        },
        publicKey: { data: publicKey },
    }, 'der');
    return [
        '-----BEGIN PUBLIC KEY-----',
        ...chunk64(buff),
        '-----END PUBLIC KEY-----',
        '',
    ].join('\n');
}
export function privateKeyPem(curve, privateKey, publicKey) {
    const buff = Rfc5915Key.encode({
        version: 1,
        privateKey: privateKey,
        parameters: curve,
        publicKey: { data: publicKey },
    }, 'der');
    return [
        '-----BEGIN EC PRIVATE KEY-----',
        ...chunk64(buff),
        '-----END EC PRIVATE KEY-----',
        '',
    ].join('\n');
}
export function chunk64(buff) {
    const chunkSize = 64;
    const str = buff.toString('base64');
    const numChunks = Math.ceil(str.length / chunkSize);
    const chunks = new Array(numChunks);
    for (let i = 0, o = 0; i < numChunks; ++i, o += chunkSize) {
        chunks[i] = str.slice(o, o + chunkSize);
    }
    return chunks;
}
//# sourceMappingURL=data:application/json;base64,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