/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.TaskState;

public abstract class TimeSeriesTask
implements ToXContentObject,
Writeable {
    public static final String TASK_ID_FIELD = "task_id";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String STARTED_BY_FIELD = "started_by";
    public static final String STOPPED_BY_FIELD = "stopped_by";
    public static final String ERROR_FIELD = "error";
    public static final String STATE_FIELD = "state";
    public static final String TASK_PROGRESS_FIELD = "task_progress";
    public static final String INIT_PROGRESS_FIELD = "init_progress";
    public static final String CURRENT_PIECE_FIELD = "current_piece";
    public static final String EXECUTION_START_TIME_FIELD = "execution_start_time";
    public static final String EXECUTION_END_TIME_FIELD = "execution_end_time";
    public static final String IS_LATEST_FIELD = "is_latest";
    public static final String TASK_TYPE_FIELD = "task_type";
    public static final String CHECKPOINT_ID_FIELD = "checkpoint_id";
    public static final String COORDINATING_NODE_FIELD = "coordinating_node";
    public static final String WORKER_NODE_FIELD = "worker_node";
    public static final String ENTITY_FIELD = "entity";
    public static final String PARENT_TASK_ID_FIELD = "parent_task_id";
    public static final String ESTIMATED_MINUTES_LEFT_FIELD = "estimated_minutes_left";
    public static final String USER_FIELD = "user";
    public static final String HISTORICAL_TASK_PREFIX = "HISTORICAL";
    public static final String RUN_ONCE_TASK_PREFIX = "RUN_ONCE";
    public static final String REAL_TIME_TASK_PREFIX = "REALTIME";
    protected String configId = null;
    protected String taskId = null;
    protected Instant lastUpdateTime = null;
    protected String startedBy = null;
    protected String stoppedBy = null;
    protected String error = null;
    protected String state = null;
    protected Float taskProgress = null;
    protected Float initProgress = null;
    protected Instant currentPiece = null;
    protected Instant executionStartTime = null;
    protected Instant executionEndTime = null;
    protected Boolean isLatest = null;
    protected String taskType = null;
    protected String checkpointId = null;
    protected String coordinatingNode = null;
    protected String workerNode = null;
    protected Entity entity = null;
    protected String parentTaskId = null;
    protected Integer estimatedMinutesLeft = null;
    protected User user = null;

    public boolean isHistoricalTask() {
        return this.taskType.startsWith(HISTORICAL_TASK_PREFIX);
    }

    public boolean isRunOnceTask() {
        return this.taskType.startsWith(RUN_ONCE_TASK_PREFIX);
    }

    public boolean isRealTimeTask() {
        return this.taskType.startsWith(REAL_TIME_TASK_PREFIX);
    }

    public String getConfigLevelTaskId() {
        return this.getParentTaskId() != null ? this.getParentTaskId() : this.getTaskId();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getStoppedBy() {
        return this.stoppedBy;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Float getTaskProgress() {
        return this.taskProgress;
    }

    public Float getInitProgress() {
        return this.initProgress;
    }

    public Instant getCurrentPiece() {
        return this.currentPiece;
    }

    public Instant getExecutionStartTime() {
        return this.executionStartTime;
    }

    public Instant getExecutionEndTime() {
        return this.executionEndTime;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getCheckpointId() {
        return this.checkpointId;
    }

    public String getCoordinatingNode() {
        return this.coordinatingNode;
    }

    public String getWorkerNode() {
        return this.workerNode;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public Integer getEstimatedMinutesLeft() {
        return this.estimatedMinutesLeft;
    }

    public User getUser() {
        return this.user;
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setLatest(Boolean latest) {
        this.isLatest = latest;
    }

    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean isDone() {
        return !TaskState.NOT_ENDED_STATES.contains(this.getState());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.startedBy != null) {
            builder.field(STARTED_BY_FIELD, this.startedBy);
        }
        if (this.stoppedBy != null) {
            builder.field(STOPPED_BY_FIELD, this.stoppedBy);
        }
        if (this.error != null) {
            builder.field(ERROR_FIELD, this.error);
        }
        if (this.state != null) {
            builder.field(STATE_FIELD, this.state);
        }
        if (this.taskProgress != null) {
            builder.field(TASK_PROGRESS_FIELD, this.taskProgress);
        }
        if (this.initProgress != null) {
            builder.field(INIT_PROGRESS_FIELD, this.initProgress);
        }
        if (this.currentPiece != null) {
            builder.field(CURRENT_PIECE_FIELD, this.currentPiece.toEpochMilli());
        }
        if (this.executionStartTime != null) {
            builder.field(EXECUTION_START_TIME_FIELD, this.executionStartTime.toEpochMilli());
        }
        if (this.executionEndTime != null) {
            builder.field(EXECUTION_END_TIME_FIELD, this.executionEndTime.toEpochMilli());
        }
        if (this.isLatest != null) {
            builder.field(IS_LATEST_FIELD, this.isLatest);
        }
        if (this.taskType != null) {
            builder.field(TASK_TYPE_FIELD, this.taskType);
        }
        if (this.checkpointId != null) {
            builder.field(CHECKPOINT_ID_FIELD, this.checkpointId);
        }
        if (this.coordinatingNode != null) {
            builder.field(COORDINATING_NODE_FIELD, this.coordinatingNode);
        }
        if (this.workerNode != null) {
            builder.field(WORKER_NODE_FIELD, this.workerNode);
        }
        if (this.entity != null) {
            builder.field(ENTITY_FIELD, (ToXContent)this.entity);
        }
        if (this.parentTaskId != null) {
            builder.field(PARENT_TASK_ID_FIELD, this.parentTaskId);
        }
        if (this.estimatedMinutesLeft != null) {
            builder.field(ESTIMATED_MINUTES_LEFT_FIELD, this.estimatedMinutesLeft);
        }
        if (this.user != null) {
            builder.field(USER_FIELD, (ToXContent)this.user);
        }
        return builder;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesTask that = (TimeSeriesTask)o;
        return Objects.equal((Object)this.getConfigId(), (Object)that.getConfigId()) && Objects.equal((Object)this.getTaskId(), (Object)that.getTaskId()) && Objects.equal((Object)this.getLastUpdateTime(), (Object)that.getLastUpdateTime()) && Objects.equal((Object)this.getStartedBy(), (Object)that.getStartedBy()) && Objects.equal((Object)this.getStoppedBy(), (Object)that.getStoppedBy()) && Objects.equal((Object)this.getError(), (Object)that.getError()) && Objects.equal((Object)this.getState(), (Object)that.getState()) && Objects.equal((Object)this.getTaskProgress(), (Object)that.getTaskProgress()) && Objects.equal((Object)this.getInitProgress(), (Object)that.getInitProgress()) && Objects.equal((Object)this.getCurrentPiece(), (Object)that.getCurrentPiece()) && Objects.equal((Object)this.getExecutionStartTime(), (Object)that.getExecutionStartTime()) && Objects.equal((Object)this.getExecutionEndTime(), (Object)that.getExecutionEndTime()) && Objects.equal((Object)this.isLatest(), (Object)that.isLatest()) && Objects.equal((Object)this.getTaskType(), (Object)that.getTaskType()) && Objects.equal((Object)this.getCheckpointId(), (Object)that.getCheckpointId()) && Objects.equal((Object)this.getCoordinatingNode(), (Object)that.getCoordinatingNode()) && Objects.equal((Object)this.getWorkerNode(), (Object)that.getWorkerNode()) && Objects.equal((Object)this.getEntity(), (Object)that.getEntity()) && Objects.equal((Object)this.getParentTaskId(), (Object)that.getParentTaskId()) && Objects.equal((Object)this.getEstimatedMinutesLeft(), (Object)that.getEstimatedMinutesLeft()) && Objects.equal((Object)this.getUser(), (Object)that.getUser());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskId, this.lastUpdateTime, this.startedBy, this.stoppedBy, this.error, this.state, this.taskProgress, this.initProgress, this.currentPiece, this.executionStartTime, this.executionEndTime, this.isLatest, this.taskType, this.checkpointId, this.coordinatingNode, this.workerNode, this.entity, this.parentTaskId, this.estimatedMinutesLeft, this.user});
    }

    public abstract boolean isHistoricalEntityTask();

    public String getEntityModelId() {
        return this.entity == null ? null : (String)this.entity.getModelId(this.configId).orElse(null);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String configId = null;
        protected String taskId = null;
        protected String taskType = null;
        protected String state = null;
        protected Float taskProgress = null;
        protected Float initProgress = null;
        protected Instant currentPiece = null;
        protected Instant executionStartTime = null;
        protected Instant executionEndTime = null;
        protected Boolean isLatest = null;
        protected String error = null;
        protected String checkpointId = null;
        protected Instant lastUpdateTime = null;
        protected String startedBy = null;
        protected String stoppedBy = null;
        protected String coordinatingNode = null;
        protected String workerNode = null;
        protected Entity entity = null;
        protected String parentTaskId;
        protected Integer estimatedMinutesLeft;
        protected User user = null;

        public T configId(String configId) {
            this.configId = configId;
            return (T)this;
        }

        public T taskId(String taskId) {
            this.taskId = taskId;
            return (T)this;
        }

        public T lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return (T)this;
        }

        public T startedBy(String startedBy) {
            this.startedBy = startedBy;
            return (T)this;
        }

        public T stoppedBy(String stoppedBy) {
            this.stoppedBy = stoppedBy;
            return (T)this;
        }

        public T error(String error) {
            this.error = error;
            return (T)this;
        }

        public T state(String state) {
            this.state = state;
            return (T)this;
        }

        public T taskProgress(Float taskProgress) {
            this.taskProgress = taskProgress;
            return (T)this;
        }

        public T initProgress(Float initProgress) {
            this.initProgress = initProgress;
            return (T)this;
        }

        public T currentPiece(Instant currentPiece) {
            this.currentPiece = currentPiece;
            return (T)this;
        }

        public T executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return (T)this;
        }

        public T executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return (T)this;
        }

        public T isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return (T)this;
        }

        public T taskType(String taskType) {
            this.taskType = taskType;
            return (T)this;
        }

        public T checkpointId(String checkpointId) {
            this.checkpointId = checkpointId;
            return (T)this;
        }

        public T coordinatingNode(String coordinatingNode) {
            this.coordinatingNode = coordinatingNode;
            return (T)this;
        }

        public T workerNode(String workerNode) {
            this.workerNode = workerNode;
            return (T)this;
        }

        public T entity(Entity entity) {
            this.entity = entity;
            return (T)this;
        }

        public T parentTaskId(String parentTaskId) {
            this.parentTaskId = parentTaskId;
            return (T)this;
        }

        public T estimatedMinutesLeft(Integer estimatedMinutesLeft) {
            this.estimatedMinutesLeft = estimatedMinutesLeft;
            return (T)this;
        }

        public T user(User user) {
            this.user = user;
            return (T)this;
        }
    }
}

