/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandlerv2;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.actionv2.GetMonitorV2Action;
import org.opensearch.alerting.actionv2.GetMonitorV2Request;
import org.opensearch.alerting.resthandlerv2.RestGetMonitorV2ActionKt;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/alerting/resthandlerv2/RestGetMonitorV2Action;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-alerting"})
public final class RestGetMonitorV2Action
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "get_monitor_v2_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.MONITOR_V2_BASE_URI + "/{monitor_id}"), new RestHandler.Route(RestRequest.Method.HEAD, AlertingPlugin.MONITOR_V2_BASE_URI + "/{monitor_id}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestGetMonitorV2ActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_V2_BASE_URI + "/{monitor_id}");
        String monitorV2Id = request.param("monitor_id");
        if (monitorV2Id == null || ((CharSequence)monitorV2Id).length() == 0) {
            throw new IllegalArgumentException("No MonitorV2 ID provided");
        }
        if (monitorV2Id.length() != 20) {
            throw new IllegalArgumentException("MonitorV2 ID provided does not have correct length");
        }
        FetchSourceContext srcContext = RestHandlerUtilsKt.context(request);
        if (request.method() == RestRequest.Method.HEAD) {
            srcContext = FetchSourceContext.DO_NOT_FETCH_SOURCE;
        }
        GetMonitorV2Request getMonitorV2Request = new GetMonitorV2Request(monitorV2Id, RestActions.parseVersion((RestRequest)request), srcContext);
        return arg_0 -> RestGetMonitorV2Action.prepareRequest$lambda$0(client, getMonitorV2Request, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, GetMonitorV2Request $getMonitorV2Request, RestChannel channel) {
        $client.execute((ActionType)GetMonitorV2Action.Companion.getINSTANCE(), (ActionRequest)$getMonitorV2Request, (ActionListener)new RestToXContentListener(channel));
    }
}

