/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.util.ShapeValuesPredicate;

public class CompositeVerifyQuery
extends Query {
    private final Query indexQuery;
    private final ShapeValuesPredicate predicateValueSource;

    public CompositeVerifyQuery(Query indexQuery, ShapeValuesPredicate predicateValueSource) {
        this.indexQuery = indexQuery;
        this.predicateValueSource = predicateValueSource;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.indexQuery.rewrite(indexSearcher);
        if (rewritten != this.indexQuery) {
            return new CompositeVerifyQuery(rewritten, this.predicateValueSource);
        }
        return super.rewrite(indexSearcher);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((CompositeVerifyQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(CompositeVerifyQuery other) {
        return this.indexQuery.equals((Object)other.indexQuery) && this.predicateValueSource.equals(other.predicateValueSource);
    }

    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.indexQuery.hashCode();
        result = 31 * result + this.predicateValueSource.hashCode();
        return result;
    }

    public String toString(String field) {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.indexQuery.toString(field) + ", " + String.valueOf(this.predicateValueSource) + ")";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight indexQueryWeight = this.indexQuery.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
        return new ConstantScoreWeight(this, boost){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Scorer indexQueryScorer = indexQueryWeight.scorer(context);
                if (indexQueryScorer == null) {
                    return null;
                }
                TwoPhaseIterator predFuncValues = CompositeVerifyQuery.this.predicateValueSource.iterator(context, indexQueryScorer.iterator());
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, predFuncValues);
                return new Weight.DefaultScorerSupplier((Scorer)scorer);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return CompositeVerifyQuery.this.predicateValueSource.isCacheable(ctx);
            }
        };
    }
}

