/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.autotagging;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rule.RuleUtils;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.RuleValidator;

public class Rule
implements Writeable,
ToXContentObject {
    private final String id;
    private final String description;
    private final FeatureType featureType;
    private final Map<Attribute, Set<String>> attributeMap;
    private final String featureValue;
    private final String updatedAt;
    private final RuleValidator ruleValidator;
    public static final String ID_STRING = "id";
    public static final String DESCRIPTION_STRING = "description";
    public static final String UPDATED_AT_STRING = "updated_at";

    public Rule(String id, String description, Map<Attribute, Set<String>> attributeMap, FeatureType featureType, String featureValue, String updatedAt) {
        this.id = id;
        this.description = description;
        this.featureType = featureType;
        this.attributeMap = attributeMap;
        this.featureValue = featureValue;
        this.updatedAt = updatedAt;
        this.ruleValidator = new RuleValidator(id, description, attributeMap, featureValue, updatedAt, featureType);
        this.ruleValidator.validate();
    }

    public Rule(StreamInput in) throws IOException {
        this.id = in.readString();
        this.description = in.readString();
        this.featureType = FeatureType.from(in);
        this.attributeMap = in.readMap(i -> Attribute.from(i, this.featureType), i -> new HashSet(i.readStringList()));
        this.featureValue = in.readString();
        this.updatedAt = in.readString();
        this.ruleValidator = new RuleValidator(this.id, this.description, this.attributeMap, this.featureValue, this.updatedAt, this.featureType);
        this.ruleValidator.validate();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.description);
        this.featureType.writeTo(out);
        out.writeMap(this.attributeMap, (output, attribute) -> attribute.writeTo(output), StreamOutput::writeStringCollection);
        out.writeString(this.featureValue);
        out.writeString(this.updatedAt);
    }

    public static Rule fromXContent(XContentParser parser, FeatureType featureType) throws IOException {
        return Builder.fromXContent(parser, featureType).build();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFeatureValue() {
        return this.featureValue;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public Map<Attribute, Set<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_STRING, this.id);
        builder.field(DESCRIPTION_STRING, this.description);
        for (Map.Entry<Attribute, Set<String>> entry : this.attributeMap.entrySet()) {
            entry.getKey().toXContentWriteAttributeValues(builder, entry.getValue());
        }
        builder.field(this.featureType.getName(), this.featureValue);
        builder.field(UPDATED_AT_STRING, this.updatedAt);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule that = (Rule)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.featureValue, that.featureValue) && Objects.equals(this.featureType, that.featureType) && Objects.equals(this.attributeMap, that.attributeMap) && Objects.equals(this.ruleValidator, that.ruleValidator) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.featureValue, this.featureType, this.attributeMap, this.updatedAt);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String description;
        private Map<Attribute, Set<String>> attributeMap;
        private FeatureType featureType;
        private String featureValue;
        private String updatedAt;

        private Builder() {
        }

        public static Builder fromXContent(XContentParser parser, FeatureType featureType) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            Builder builder = Rule.builder();
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new XContentParseException("Expected START_OBJECT token but found [" + parser.currentName() + "]");
            }
            HashMap<Attribute, Set<String>> attributeMap1 = new HashMap<Attribute, Set<String>>();
            String fieldName = "";
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (fieldName.equals(Rule.ID_STRING)) {
                        builder.id(parser.text());
                        continue;
                    }
                    if (fieldName.equals(Rule.DESCRIPTION_STRING)) {
                        builder.description(parser.text());
                        continue;
                    }
                    if (fieldName.equals(Rule.UPDATED_AT_STRING)) {
                        builder.updatedAt(parser.text());
                        continue;
                    }
                    if (!fieldName.equals(featureType.getName())) continue;
                    builder.featureType(featureType);
                    builder.featureValue(parser.text());
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.START_OBJECT) continue;
                Builder.fromXContentParseAttribute(parser, fieldName, featureType, attributeMap1);
            }
            return builder.attributeMap(attributeMap1);
        }

        private static void fromXContentParseAttribute(XContentParser parser, String fieldName, FeatureType featureType, Map<Attribute, Set<String>> attributeMap) throws IOException {
            Attribute attribute = featureType.getAttributeFromName(fieldName);
            if (attribute == null) {
                throw new XContentParseException(fieldName + " is not a valid attribute within the " + featureType.getName() + " feature.");
            }
            attributeMap.put(attribute, attribute.fromXContentParseAttributeValues(parser));
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder id() {
            if (this.description == null || this.featureType == null || this.attributeMap == null || this.featureValue == null) {
                throw new IllegalStateException("Cannot compute ID: required fields are missing.");
            }
            this.id = RuleUtils.computeRuleHash(this.description, this.featureType, this.attributeMap, this.featureValue);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder featureValue(String featureValue) {
            this.featureValue = featureValue;
            return this;
        }

        public Builder attributeMap(Map<Attribute, Set<String>> attributeMap) {
            this.attributeMap = attributeMap;
            return this;
        }

        public Builder featureType(FeatureType featureType) {
            this.featureType = featureType;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Rule build() {
            return new Rule(this.id, this.description, this.attributeMap, this.featureType, this.featureValue, this.updatedAt);
        }

        public String getFeatureValue() {
            return this.featureValue;
        }

        public Map<Attribute, Set<String>> getAttributeMap() {
            return this.attributeMap;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

