/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.RuleValidator;

@ExperimentalApi
public class GetRuleRequest
extends ActionRequest {
    private final String id;
    private final Map<String, Set<String>> attributeFilters;
    private final String searchAfter;
    private final FeatureType featureType;

    public GetRuleRequest(String id, Map<String, Set<String>> attributeFilters, String searchAfter, FeatureType featureType) {
        this.id = id;
        this.attributeFilters = attributeFilters;
        this.searchAfter = searchAfter;
        this.featureType = featureType;
    }

    public GetRuleRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.featureType = FeatureType.from(in);
        this.attributeFilters = in.readMap(StreamInput::readString, i -> new HashSet(i.readStringList()));
        this.searchAfter = in.readOptionalString();
    }

    public ActionRequestValidationException validate() {
        if (RuleValidator.isEmpty(this.id)) {
            throw new IllegalArgumentException("id cannot be empty.");
        }
        if (RuleValidator.isEmpty(this.searchAfter)) {
            throw new IllegalArgumentException("search_after cannot be empty.");
        }
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        this.featureType.writeTo(out);
        out.writeMap(this.attributeFilters, StreamOutput::writeString, StreamOutput::writeStringCollection);
        out.writeOptionalString(this.searchAfter);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Set<String>> getAttributeFilters() {
        return this.attributeFilters;
    }

    public String getSearchAfter() {
        return this.searchAfter;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }
}

