/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.time;

import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import org.opensearch.common.time.OpenSearchDateTimeFormatter;

final class RFC3339CompatibleDateTimeFormatter
extends OpenSearchDateTimeFormatter {
    public static final char DATE_SEPARATOR = '-';
    public static final char TIME_SEPARATOR = ':';
    public static final char SEPARATOR_UPPER = 'T';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char SEPARATOR_LOWER = 't';
    private static final char SEPARATOR_SPACE = ' ';
    private static final char FRACTION_SEPARATOR_1 = '.';
    private static final char FRACTION_SEPARATOR_2 = ',';
    private static final char ZULU_UPPER = 'Z';
    private static final char ZULU_LOWER = 'z';
    private ZoneId zone;

    public RFC3339CompatibleDateTimeFormatter(String pattern) {
        super(pattern);
    }

    public RFC3339CompatibleDateTimeFormatter(DateTimeFormatter formatter) {
        super(formatter);
    }

    public RFC3339CompatibleDateTimeFormatter(DateTimeFormatter formatter, ZoneId zone) {
        super(formatter);
        this.zone = zone;
    }

    @Override
    public OpenSearchDateTimeFormatter withZone(ZoneId zoneId) {
        return new RFC3339CompatibleDateTimeFormatter(this.getFormatter().withZone(zoneId), zoneId);
    }

    @Override
    public OpenSearchDateTimeFormatter withLocale(Locale locale) {
        return new RFC3339CompatibleDateTimeFormatter(this.getFormatter().withLocale(locale));
    }

    @Override
    public Object parseObject(String text, ParsePosition pos) {
        try {
            return this.parse(text);
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    @Override
    public TemporalAccessor parse(String dateTime) {
        OffsetDateTime parsedDatetime = this.parse(dateTime, new ParsePosition(0));
        return this.zone == null ? parsedDatetime : parsedDatetime.atZoneSameInstant(this.zone);
    }

    public OffsetDateTime parse(String date, ParsePosition pos) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        int len = date.length() - pos.getIndex();
        if (len <= 0) {
            throw new DateTimeParseException("out of bound parse position", date, pos.getIndex());
        }
        char[] chars = date.substring(pos.getIndex()).toCharArray();
        int years = RFC3339CompatibleDateTimeFormatter.getYear(chars, pos);
        if (4 == len) {
            return OffsetDateTime.of(years, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        }
        RFC3339CompatibleDateTimeFormatter.consumeChar(chars, pos, '-');
        int months = RFC3339CompatibleDateTimeFormatter.getMonth(chars, pos);
        if (7 == len) {
            return OffsetDateTime.of(years, months, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        }
        RFC3339CompatibleDateTimeFormatter.consumeChar(chars, pos, '-');
        int days = RFC3339CompatibleDateTimeFormatter.getDay(chars, pos);
        if (10 == len) {
            return OffsetDateTime.of(years, months, days, 0, 0, 0, 0, ZoneOffset.UTC);
        }
        RFC3339CompatibleDateTimeFormatter.consumeChar(chars, pos, 'T', 't', ' ');
        int hours = RFC3339CompatibleDateTimeFormatter.getHour(chars, pos);
        RFC3339CompatibleDateTimeFormatter.consumeChar(chars, pos, ':');
        int minutes = RFC3339CompatibleDateTimeFormatter.getMinute(chars, pos);
        if (16 == len) {
            throw new DateTimeParseException("No timezone offset information", new String(chars), pos.getIndex());
        }
        return RFC3339CompatibleDateTimeFormatter.handleTime(chars, pos, years, months, days, hours, minutes);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static int digit(char c) {
        return c - 48;
    }

    private static int readInt(char[] strNum, ParsePosition pos, int n) {
        int start = pos.getIndex();
        int end = start + n;
        if (end > strNum.length) {
            pos.setErrorIndex(end);
            throw new DateTimeParseException("Unexpected end of expression at position " + strNum.length, new String(strNum), end);
        }
        int result = 0;
        for (int i = start; i < end; ++i) {
            char c = strNum[i];
            if (!RFC3339CompatibleDateTimeFormatter.isDigit(c)) {
                pos.setErrorIndex(i);
                throw new DateTimeParseException("Character " + c + " is not a digit", new String(strNum), i);
            }
            int digit = RFC3339CompatibleDateTimeFormatter.digit(c);
            result = result * 10 + digit;
        }
        pos.setIndex(end);
        return result;
    }

    private static int readIntUnchecked(char[] strNum, ParsePosition pos, int n) {
        int start = pos.getIndex();
        int end = start + n;
        int result = 0;
        for (int i = start; i < end; ++i) {
            char c = strNum[i];
            int digit = RFC3339CompatibleDateTimeFormatter.digit(c);
            result = result * 10 + digit;
        }
        pos.setIndex(end);
        return result;
    }

    private static int getHour(char[] chars, ParsePosition pos) {
        return RFC3339CompatibleDateTimeFormatter.readInt(chars, pos, 2);
    }

    private static int getMinute(char[] chars, ParsePosition pos) {
        return RFC3339CompatibleDateTimeFormatter.readInt(chars, pos, 2);
    }

    private static int getDay(char[] chars, ParsePosition pos) {
        return RFC3339CompatibleDateTimeFormatter.readInt(chars, pos, 2);
    }

    private static boolean isValidOffset(char[] chars, int offset) {
        return offset < chars.length;
    }

    private static void consumeChar(char[] chars, ParsePosition pos, char expected) {
        int offset = pos.getIndex();
        if (!RFC3339CompatibleDateTimeFormatter.isValidOffset(chars, offset)) {
            throw new DateTimeParseException("Unexpected end of input", new String(chars), offset);
        }
        if (chars[offset] != expected) {
            throw new DateTimeParseException("Expected character " + expected + " at position " + offset, new String(chars), offset);
        }
        pos.setIndex(offset + 1);
    }

    private static void consumeNextChar(char[] chars, ParsePosition pos) {
        int offset = pos.getIndex();
        if (!RFC3339CompatibleDateTimeFormatter.isValidOffset(chars, offset)) {
            throw new DateTimeParseException("Unexpected end of input", new String(chars), offset);
        }
        pos.setIndex(offset + 1);
    }

    private static boolean checkPositionContains(char[] chars, ParsePosition pos, char ... expected) {
        int offset = pos.getIndex();
        if (offset >= chars.length) {
            throw new DateTimeParseException("Unexpected end of input", new String(chars), offset);
        }
        boolean found = false;
        for (char e : expected) {
            if (chars[offset] != e) continue;
            found = true;
            break;
        }
        return found;
    }

    private static void consumeChar(char[] chars, ParsePosition pos, char ... expected) {
        int offset = pos.getIndex();
        if (offset >= chars.length) {
            throw new DateTimeParseException("Unexpected end of input", new String(chars), offset);
        }
        boolean found = false;
        for (char e : expected) {
            if (chars[offset] != e) continue;
            found = true;
            pos.setIndex(offset + 1);
            break;
        }
        if (!found) {
            throw new DateTimeParseException("Expected character " + Arrays.toString(expected) + " at position " + offset, new String(chars), offset);
        }
    }

    private static void assertNoMoreChars(char[] chars, ParsePosition pos) {
        if (chars.length > pos.getIndex()) {
            throw new DateTimeParseException("Trailing junk data after position " + pos.getIndex(), new String(chars), pos.getIndex());
        }
    }

    private static ZoneOffset parseTimezone(char[] chars, ParsePosition pos) {
        int offset = pos.getIndex();
        int left = chars.length - offset;
        if (RFC3339CompatibleDateTimeFormatter.checkPositionContains(chars, pos, 'z', 'Z')) {
            RFC3339CompatibleDateTimeFormatter.consumeNextChar(chars, pos);
            RFC3339CompatibleDateTimeFormatter.assertNoMoreChars(chars, pos);
            return ZoneOffset.UTC;
        }
        if (left != 6) {
            throw new DateTimeParseException("Invalid timezone offset", new String(chars, offset, left), offset);
        }
        char sign = chars[offset];
        RFC3339CompatibleDateTimeFormatter.consumeNextChar(chars, pos);
        int hours = RFC3339CompatibleDateTimeFormatter.getHour(chars, pos);
        RFC3339CompatibleDateTimeFormatter.consumeChar(chars, pos, ':');
        int minutes = RFC3339CompatibleDateTimeFormatter.getMinute(chars, pos);
        if (sign == '-') {
            if (hours == 0 && minutes == 0) {
                throw new DateTimeParseException("Unknown 'Local Offset Convention' date-time not allowed", new String(chars), offset);
            }
            hours = -hours;
            minutes = -minutes;
        } else if (sign != '+') {
            throw new DateTimeParseException("Invalid character starting at position " + offset, new String(chars), offset);
        }
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private static OffsetDateTime handleTime(char[] chars, ParsePosition pos, int year, int month, int day, int hour, int minute) {
        switch (chars[pos.getIndex()]) {
            case ':': {
                RFC3339CompatibleDateTimeFormatter.consumeChar(chars, pos, ':');
                return RFC3339CompatibleDateTimeFormatter.handleSeconds(year, month, day, hour, minute, chars, pos);
            }
            case '+': 
            case '-': 
            case 'Z': 
            case 'z': {
                ZoneOffset zoneOffset = RFC3339CompatibleDateTimeFormatter.parseTimezone(chars, pos);
                return OffsetDateTime.of(year, month, day, hour, minute, 0, 0, zoneOffset);
            }
        }
        throw new DateTimeParseException("Unexpected character  at position " + pos.getIndex(), new String(chars), pos.getIndex());
    }

    private static int getMonth(char[] chars, ParsePosition pos) {
        return RFC3339CompatibleDateTimeFormatter.readInt(chars, pos, 2);
    }

    private static int getYear(char[] chars, ParsePosition pos) {
        return RFC3339CompatibleDateTimeFormatter.readInt(chars, pos, 4);
    }

    private static int getSeconds(char[] chars, ParsePosition pos) {
        return RFC3339CompatibleDateTimeFormatter.readInt(chars, pos, 2);
    }

    private static int getFractions(char[] chars, ParsePosition pos, int len) {
        int fractions = RFC3339CompatibleDateTimeFormatter.readIntUnchecked(chars, pos, len);
        switch (len) {
            case 0: {
                throw new DateTimeParseException("Must have at least 1 fraction digit", new String(chars), pos.getIndex());
            }
            case 1: {
                return fractions * 100000000;
            }
            case 2: {
                return fractions * 10000000;
            }
            case 3: {
                return fractions * 1000000;
            }
            case 4: {
                return fractions * 100000;
            }
            case 5: {
                return fractions * 10000;
            }
            case 6: {
                return fractions * 1000;
            }
            case 7: {
                return fractions * 100;
            }
            case 8: {
                return fractions * 10;
            }
        }
        return fractions;
    }

    public static int indexOfNonDigit(char[] text, int offset) {
        for (int i = offset; i < text.length; ++i) {
            if (RFC3339CompatibleDateTimeFormatter.isDigit(text[i])) continue;
            return i;
        }
        return -1;
    }

    public static void consumeDigits(char[] text, ParsePosition pos) {
        int idx = RFC3339CompatibleDateTimeFormatter.indexOfNonDigit(text, pos.getIndex());
        if (idx == -1) {
            pos.setErrorIndex(text.length);
        } else {
            pos.setIndex(idx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OffsetDateTime handleSeconds(int year, int month, int day, int hour, int minute, char[] chars, ParsePosition pos) {
        int seconds = RFC3339CompatibleDateTimeFormatter.getSeconds(chars, pos);
        int currPos = pos.getIndex();
        int remaining = chars.length - currPos;
        if (remaining == 0) {
            throw new DateTimeParseException("No timezone offset information", new String(chars), pos.getIndex());
        }
        ZoneOffset offset = null;
        int fractions = 0;
        if (remaining == 1 && RFC3339CompatibleDateTimeFormatter.checkPositionContains(chars, pos, 'z', 'Z')) {
            RFC3339CompatibleDateTimeFormatter.consumeNextChar(chars, pos);
            offset = ZoneOffset.UTC;
            RFC3339CompatibleDateTimeFormatter.assertNoMoreChars(chars, pos);
            return OffsetDateTime.of(year, month, day, hour, minute, seconds, fractions, offset);
        } else if (remaining >= 1 && RFC3339CompatibleDateTimeFormatter.checkPositionContains(chars, pos, '.', ',')) {
            RFC3339CompatibleDateTimeFormatter.consumeNextChar(chars, pos);
            ParsePosition initPosition = new ParsePosition(pos.getIndex());
            RFC3339CompatibleDateTimeFormatter.consumeDigits(chars, pos);
            if (pos.getErrorIndex() != -1) throw new DateTimeParseException("No timezone offset information", new String(chars), pos.getIndex());
            int len = pos.getIndex() - initPosition.getIndex();
            fractions = RFC3339CompatibleDateTimeFormatter.getFractions(chars, initPosition, len);
            offset = RFC3339CompatibleDateTimeFormatter.parseTimezone(chars, pos);
            return OffsetDateTime.of(year, month, day, hour, minute, seconds, fractions, offset);
        } else {
            if (remaining < 1 || !RFC3339CompatibleDateTimeFormatter.checkPositionContains(chars, pos, '+', '-')) throw new DateTimeParseException("Unexpected character at position " + pos.getIndex(), new String(chars), pos.getIndex());
            offset = RFC3339CompatibleDateTimeFormatter.parseTimezone(chars, pos);
        }
        return OffsetDateTime.of(year, month, day, hour, minute, seconds, fractions, offset);
    }
}

