/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.WrappingProcessor;
import org.opensearch.script.ScriptService;

public final class ForEachProcessor
extends AbstractProcessor
implements WrappingProcessor {
    public static final String TYPE = "foreach";
    private final String field;
    private final Processor processor;
    private final boolean ignoreMissing;

    ForEachProcessor(String tag, String description, String field, Processor processor, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.processor = processor;
        this.ignoreMissing = ignoreMissing;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        List values = (List)ingestDocument.getFieldValue(this.field, List.class, this.ignoreMissing);
        if (values == null) {
            if (this.ignoreMissing) {
                handler.accept(ingestDocument, null);
            } else {
                handler.accept(null, new IllegalArgumentException("field [" + this.field + "] is null, cannot loop over its elements."));
            }
        } else {
            this.innerExecute(0, new ArrayList(values), new ArrayList<Object>(values.size()), ingestDocument, handler);
        }
    }

    void innerExecute(int index, List<?> values, List<Object> newValues, IngestDocument document, BiConsumer<IngestDocument, Exception> handler) {
        while (index < values.size()) {
            AtomicBoolean shouldContinueHere = new AtomicBoolean();
            Object value = values.get(index);
            Object previousValue = document.getIngestMetadata().put("_value", value);
            int nextIndex = index + 1;
            this.processor.execute(document, (result, e) -> {
                newValues.add(document.getIngestMetadata().put("_value", previousValue));
                if (e != null || result == null) {
                    handler.accept((IngestDocument)result, (Exception)e);
                } else if (shouldContinueHere.getAndSet(true)) {
                    this.innerExecute(nextIndex, values, newValues, document, handler);
                }
            });
            if (!shouldContinueHere.getAndSet(true)) {
                return;
            }
            ++index;
        }
        if (index == values.size()) {
            document.setFieldValue(this.field, new ArrayList<Object>(newValues));
            handler.accept(document, null);
        }
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    public Processor getInnerProcessor() {
        return this.processor;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public ForEachProcessor create(Map<String, Processor.Factory> factories, String tag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            Map processorConfig = ConfigurationUtils.readMap((String)ForEachProcessor.TYPE, (String)tag, config, (String)"processor");
            Set entries = processorConfig.entrySet();
            if (entries.size() != 1) {
                throw ConfigurationUtils.newConfigurationException((String)ForEachProcessor.TYPE, (String)tag, (String)"processor", (String)"Must specify exactly one processor type");
            }
            Map.Entry entry = entries.iterator().next();
            Processor processor = ConfigurationUtils.readProcessor(factories, (ScriptService)this.scriptService, (String)((String)entry.getKey()), (Map)((Map)entry.getValue()));
            return new ForEachProcessor(tag, description, field, processor, ignoreMissing);
        }
    }
}

