/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.Analysis;
import org.tartarus.snowball.SnowballStemmer;
import org.tartarus.snowball.ext.DutchStemmer;

public class DutchStemTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet exclusions;

    DutchStemTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.exclusions = Analysis.parseStemExclusion((Settings)settings, (CharArraySet)CharArraySet.EMPTY_SET);
    }

    public TokenStream create(TokenStream tokenStream) {
        tokenStream = new SetKeywordMarkerFilter(tokenStream, this.exclusions);
        return new SnowballFilter(tokenStream, (SnowballStemmer)new DutchStemmer());
    }
}

