/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingNearestChildrenKnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.BitSet;

public class DiversifyingNearestChildrenKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BitSetProducer parentsFilter;

    public DiversifyingNearestChildrenKnnCollectorManager(int k, BitSetProducer parentsFilter, IndexSearcher indexSearcher) {
        this.k = k;
        this.parentsFilter = parentsFilter;
    }

    public KnnCollector newCollector(int visitedLimit, KnnSearchStrategy searchStrategy, LeafReaderContext context) throws IOException {
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return null;
        }
        return new DiversifyingNearestChildrenKnnCollector(this.k, visitedLimit, searchStrategy, parentBitSet);
    }

    public KnnCollector newOptimisticCollector(int visitedLimit, KnnSearchStrategy searchStrategy, LeafReaderContext context, int k) throws IOException {
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return null;
        }
        return new DiversifyingNearestChildrenKnnCollector(k, visitedLimit, searchStrategy, parentBitSet);
    }

    public boolean isOptimistic() {
        return true;
    }
}

