/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderEvent;

public class StoreSyncEvent
implements ProviderEvent {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final boolean removed;
    private final ComponentModel model;

    private StoreSyncEvent(KeycloakSession session, RealmModel realm, boolean removed) {
        this(session, realm, null, removed);
    }

    private StoreSyncEvent(KeycloakSession session, RealmModel realm, ComponentModel model, boolean removed) {
        this.session = session;
        this.realm = realm;
        this.model = model;
        this.removed = removed;
    }

    public static void fire(KeycloakSession session, RealmModel realm, boolean removed) {
        session.getKeycloakSessionFactory().publish((ProviderEvent)new StoreSyncEvent(session, realm, removed));
    }

    public static void fire(KeycloakSession session, RealmModel realm, ComponentModel model, boolean removed) {
        session.getKeycloakSessionFactory().publish((ProviderEvent)new StoreSyncEvent(session, realm, model, removed));
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ComponentModel getModel() {
        return this.model;
    }

    public boolean getRemoved() {
        return this.removed;
    }
}

