/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JSlider;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;
import org.jsampler.view.JSFileFilter;
import org.jsampler.view.std.StdI18n;

public class StdUtils {
    private StdUtils() {
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public static JComboBox createEnhancedComboBox() {
        final JComboBox jComboBox = new JComboBox();
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getSelectedItem() == null) {
                    jComboBox.setToolTipText(null);
                    return;
                }
                String string = jComboBox.getSelectedItem().toString();
                if (string.length() < 15) {
                    jComboBox.setToolTipText(null);
                } else {
                    jComboBox.setToolTipText(string);
                }
            }
        });
        return jComboBox;
    }

    public static JComboBox createPathComboBox() {
        JComboBox jComboBox = StdUtils.createEnhancedComboBox();
        jComboBox.setEditable(true);
        return jComboBox;
    }

    public static void updateRecentElements(String string, String string2) {
        String[] stringArray = StdUtils.preferences().getStringListProperty(string);
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        for (String string3 : stringArray) {
            if (string2.equals(string3)) continue;
            vector.add(string3);
        }
        if (vector.size() > 12) {
            vector.setSize(12);
        }
        stringArray = vector.toArray(new String[vector.size()]);
        StdUtils.preferences().setStringListProperty(string, stringArray);
    }

    public static boolean checkDesktopSupported() {
        if (Desktop.isDesktopSupported()) {
            return true;
        }
        String string = StdI18n.i18n.getError("StdUtils.DesktopApiNotSupported");
        HF.showErrorMessage(string, (Component)CC.getMainFrame());
        return false;
    }

    public static void browse(String string) {
        if (!StdUtils.checkDesktopSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void mail(String string) {
        if (!StdUtils.checkDesktopSupported()) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            Desktop.getDesktop().mail(new URI(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Rectangle getWindowBounds(String string) {
        String string2 = string + ".windowSizeAndLocation";
        string2 = CC.preferences().getStringProperty(string2, null);
        if (string2 == null) {
            return null;
        }
        try {
            int n = string2.indexOf(44);
            int n2 = Integer.parseInt(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(44);
            int n3 = Integer.parseInt(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(44);
            int n4 = Integer.parseInt(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            int n5 = Integer.parseInt(string2);
            return new Rectangle(n2, n3, n4, n5);
        }
        catch (Exception exception) {
            String string3 = string;
            string3 = string3 + ": Parsing of window size and location string failed";
            CC.getLogger().log(Level.INFO, string3, exception);
            return null;
        }
    }

    public static void saveWindowBounds(String string, Rectangle rectangle) {
        if (rectangle.width < 50 || rectangle.height < 50 || rectangle.x < rectangle.width * -1 || rectangle.y < 0) {
            CC.getLogger().warning("Invalid window size or location");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rectangle.x).append(',').append(rectangle.y).append(',');
        stringBuffer.append(rectangle.width).append(',').append(rectangle.height);
        String string2 = string + ".windowSizeAndLocation";
        CC.preferences().setStringProperty(string2, stringBuffer.toString());
    }

    public static File showOpenLscpFileChooser() {
        return StdUtils.showLscpFileChooser(true);
    }

    public static File showOpenLscpFileChooser(Window window) {
        return StdUtils.showLscpFileChooser(true, window);
    }

    public static File showSaveLscpFileChooser() {
        return StdUtils.showLscpFileChooser(false);
    }

    public static File showSaveLscpFileChooser(Window window) {
        return StdUtils.showLscpFileChooser(false, window);
    }

    private static File showLscpFileChooser(boolean bl) {
        return StdUtils.showLscpFileChooser(bl, CC.getMainFrame());
    }

    private static File showLscpFileChooser(boolean bl, Window window) {
        return StdUtils.showFileChooser(bl, window, false, new JSFileFilter.Lscp(), "lastScriptLocation");
    }

    public static File showSaveMidiMapsChooser() {
        JSFileFilter.MidiMaps midiMaps = new JSFileFilter.MidiMaps();
        JSFileFilter[] jSFileFilterArray = new JSFileFilter[]{new JSFileFilter.Lscp(), new JSFileFilter.Text(), new JSFileFilter.Html(), new JSFileFilter.Rgd()};
        return StdUtils.showFileChooser(false, CC.getMainFrame(), false, midiMaps, jSFileFilterArray, "lastScriptLocation");
    }

    public static File showOpenInstrumentFileChooser(Window window) {
        return StdUtils.showFileChooser(true, window, false, null, "lastInstrumentLocation");
    }

    public static File showOpenDirectoryChooser(Window window, String string) {
        return StdUtils.showFileChooser(true, window, true, null, string);
    }

    private static File showFileChooser(boolean bl, Window window, boolean bl2, JSFileFilter jSFileFilter, String string) {
        JSFileFilter[] jSFileFilterArray;
        JSFileFilter[] jSFileFilterArray2 = jSFileFilterArray = jSFileFilter == null ? new JSFileFilter[]{} : new JSFileFilter[1];
        if (jSFileFilter != null) {
            jSFileFilterArray[0] = jSFileFilter;
        }
        return StdUtils.showFileChooser(bl, window, bl2, jSFileFilter, jSFileFilterArray, string);
    }

    private static File showFileChooser(boolean bl, Window window, boolean bl2, JSFileFilter jSFileFilter, JSFileFilter[] jSFileFilterArray, String string) {
        Object object;
        File file;
        block13: {
            int n;
            String string2;
            block12: {
                boolean bl3 = StdUtils.preferences().getBoolProperty("nativeFileChoosers");
                string2 = null;
                if (string != null) {
                    string2 = StdUtils.preferences().getStringProperty(string);
                }
                file = null;
                if (!bl3 || !CC.isMacOS()) break block12;
                if (bl2) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                }
                object = window instanceof Frame ? new FileDialog((Frame)window) : (window instanceof Dialog ? new FileDialog((Dialog)window) : new FileDialog(CC.getMainFrame()));
                ((FileDialog)object).setDirectory(string2);
                ((FileDialog)object).setMode(bl ? 0 : 1);
                if (jSFileFilter != null) {
                    ((FileDialog)object).setFilenameFilter(jSFileFilter);
                }
                ((Dialog)object).setVisible(true);
                if (bl2) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                }
                if (((FileDialog)object).getFile() == null) break block13;
                file = new File(new File(((FileDialog)object).getDirectory()), ((FileDialog)object).getFile());
                break block13;
            }
            object = new JFileChooser(string2);
            for (JSFileFilter jSFileFilter2 : jSFileFilterArray) {
                ((JFileChooser)object).addChoosableFileFilter(jSFileFilter2);
            }
            if (jSFileFilterArray.length > 0) {
                ((JFileChooser)object).setFileFilter(jSFileFilterArray[0]);
            }
            if (bl2) {
                ((JFileChooser)object).setFileSelectionMode(1);
            }
            if ((n = bl ? ((JFileChooser)object).showOpenDialog(window) : ((JFileChooser)object).showSaveDialog(window)) == 0) {
                file = ((JFileChooser)object).getSelectedFile();
            }
            if (n == 0 && !bl) {
                FileFilter fileFilter = ((JFileChooser)object).getFileFilter();
                for (JSFileFilter jSFileFilter3 : jSFileFilterArray) {
                    String string3;
                    if (jSFileFilter3 != fileFilter) continue;
                    String string4 = file.getName().toLowerCase();
                    if (string4.endsWith(string3 = jSFileFilter3.getExtension().toLowerCase())) break;
                    string4 = file.getAbsolutePath() + jSFileFilter3.getExtension();
                    file = new File(string4);
                    break;
                }
            }
        }
        if (file == null) {
            return null;
        }
        object = file.getParent();
        if (object != null && string != null) {
            StdUtils.preferences().setStringProperty(string, (String)object);
        }
        return file;
    }

    public static JSlider createVolumeSlider() {
        return new VolumeSlider();
    }

    private static class VolumeSlider
    extends JSlider {
        private Popup popup = null;
        private final JToolTip tip = new JToolTip();
        private static NumberFormat numberFormat = NumberFormat.getInstance();

        VolumeSlider() {
            super(0, 100, 100);
            numberFormat.setMaximumFractionDigits(1);
            boolean bl = CC.getViewConfig().isMeasurementUnitDecibel();
            if (bl) {
                this.tip.setTipText(StdI18n.i18n.getLabel("StdUtils.volumeDecibels", "-30.0"));
            } else {
                this.tip.setTipText(StdI18n.i18n.getLabel("StdUtils.volume", "100"));
            }
            this.tip.setPreferredSize(this.tip.getPreferredSize());
            this.tip.setMinimumSize(this.tip.getPreferredSize());
            this.tip.setComponent(this);
            this.tip.setTipText(StdI18n.i18n.getLabel("StdUtils.volume", 0));
            this.updateVolumeInfo();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (popup != null) {
                        popup.hide();
                        popup = null;
                    }
                    if (!this.isEnabled()) {
                        return;
                    }
                    Point point = this.getLocationOnScreen();
                    PopupFactory popupFactory = PopupFactory.getSharedInstance();
                    popup = popupFactory.getPopup(this, tip, point.x, point.y - 22);
                    popup.show();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (popup != null) {
                        popup.hide();
                        popup = null;
                    }
                }
            });
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    this.updateVolumeInfo();
                }
            });
            String string = "volMeasurementUnitDecibel";
            StdUtils.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = CC.getViewConfig().isMeasurementUnitDecibel();
                    tip.setPreferredSize(null);
                    String string = bl ? StdI18n.i18n.getLabel("StdUtils.volumeDecibels", "-30.0") : StdI18n.i18n.getLabel("StdUtils.volume", "100");
                    tip.setTipText(string);
                    tip.setPreferredSize(tip.getPreferredSize());
                    tip.setMinimumSize(tip.getPreferredSize());
                    this.updateVolumeInfo();
                }
            });
        }

        private void updateVolumeInfo() {
            String string;
            if (CC.getViewConfig().isMeasurementUnitDecibel()) {
                double d = HF.percentsToDecibels(this.getValue());
                string = StdI18n.i18n.getLabel("StdUtils.volumeDecibels", numberFormat.format(d));
            } else {
                string = StdI18n.i18n.getLabel("StdUtils.volume", this.getValue());
            }
            this.setToolTipText(string);
            this.tip.setTipText(string);
            this.tip.repaint();
        }
    }
}

