/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.MidiInstrument;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.event.MidiInstrumentEvent;
import org.jsampler.event.MidiInstrumentListener;
import org.jsampler.event.MidiInstrumentMapEvent;
import org.jsampler.event.MidiInstrumentMapListener;
import org.jsampler.view.std.JSEditMidiInstrumentDlg;
import org.jsampler.view.std.JSMidiBankChooser;
import org.jsampler.view.std.JSOverrideInstrumentsConfirmDlg;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.MidiInstrumentInfo;

public class JSMidiInstrumentTree
extends JTree {
    private DefaultTreeModel model;
    private MidiInstrumentMap midiInstrumentMap;
    private final ContextMenu contextMenu;
    private final EventHandler eventHandler = new EventHandler();

    public JSMidiInstrumentTree() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    return;
                }
                JSMidiInstrumentTree.this.setSelectionPath(JSMidiInstrumentTree.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (mouseEvent.getClickCount() > 1) {
                    JSMidiInstrumentTree.this.editSelectedInstrument();
                }
            }
        });
        this.setMidiInstrumentMap(null);
        this.getSelectionModel().setSelectionMode(1);
        this.contextMenu = new ContextMenu();
        this.addMouseListener(this.contextMenu);
        this.addTreeSelectionListener(this.getHandler());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSMidiInstrumentTree.this.removeSelectedInstrumentOrBank();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(0).put(keyStroke, "removeSelectedInstrumentOrBank");
        this.getActionMap().put("removeSelectedInstrumentOrBank", abstractAction);
        String string = "firstMidiBankNumber";
        CC.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSMidiInstrumentTree.this.model.reload();
            }
        });
        string = "firstMidiProgramNumber";
        CC.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSMidiInstrumentTree.this.model.reload();
                JSMidiInstrumentTree.this.contextMenu.updateChangeProgramMenu();
            }
        });
    }

    public MidiInstrumentMap getMidiInstrumentMap() {
        return this.midiInstrumentMap;
    }

    public void setMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        if (this.getMidiInstrumentMap() != null) {
            for (MidiInstrument midiInstrument : this.getMidiInstrumentMap().getAllMidiInstruments()) {
                midiInstrument.removeMidiInstrumentListener(this.getHandler());
            }
            this.getMidiInstrumentMap().removeMidiInstrumentMapListener(this.getHandler());
        }
        this.midiInstrumentMap = midiInstrumentMap;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(){

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public Object getUserObject() {
                return "/";
            }
        };
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        if (midiInstrumentMap != null) {
            for (MidiInstrument midiInstrument : midiInstrumentMap.getAllMidiInstruments()) {
                this.mapInstrument(midiInstrument);
                midiInstrument.addMidiInstrumentListener(this.getHandler());
            }
            midiInstrumentMap.addMidiInstrumentMapListener(this.getHandler());
        }
        this.setEnabled(midiInstrumentMap != null);
        this.setModel(this.model);
    }

    public void mapInstrument(MidiInstrument midiInstrument) {
        MidiBank midiBank = new MidiBank(midiInstrument.getInfo().getMidiBank());
        DefaultMutableTreeNode defaultMutableTreeNode = this.findBank(midiBank);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new BankTreeNode(midiBank);
            this.model.insertNodeInto(defaultMutableTreeNode, (DefaultMutableTreeNode)this.model.getRoot(), this.findBankPosition(midiBank.getId()));
        }
        this.model.insertNodeInto(new InstrTreeNode(midiInstrument), defaultMutableTreeNode, this.removeProgram(defaultMutableTreeNode, midiInstrument.getInfo().getMidiProgram()));
    }

    public void unmapInstrument(MidiInstrument midiInstrument) {
        MidiBank midiBank = new MidiBank(midiInstrument.getInfo().getMidiBank());
        DefaultMutableTreeNode defaultMutableTreeNode = this.findBank(midiBank);
        if (defaultMutableTreeNode == null) {
            throw new IllegalArgumentException("Missing MIDI bank: " + midiBank.getId());
        }
        this.removeProgram(defaultMutableTreeNode, midiInstrument.getInfo().getMidiProgram());
        if (defaultMutableTreeNode.getChildCount() == 0) {
            this.model.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    public MidiInstrument getSelectedInstrument() {
        if (this.getSelectionCount() == 0) {
            return null;
        }
        Object object = this.getSelectionPath().getLastPathComponent();
        if (!(object instanceof InstrTreeNode)) {
            return null;
        }
        object = ((InstrTreeNode)object).getUserObject();
        return (MidiInstrument)object;
    }

    public MidiBank getSelectedMidiBank() {
        if (this.getSelectionCount() == 0) {
            return null;
        }
        Object object = this.getSelectionPath().getLastPathComponent();
        if (!(object instanceof BankTreeNode)) {
            return null;
        }
        BankTreeNode bankTreeNode = (BankTreeNode)object;
        return (MidiBank)bankTreeNode.getUserObject();
    }

    public void removeSelectedInstrumentOrBank() {
        if (this.getSelectionCount() == 0) {
            return;
        }
        Object object = this.getSelectionPath().getLastPathComponent();
        if (object instanceof InstrTreeNode) {
            object = ((InstrTreeNode)object).getUserObject();
            this.removeInstrument((MidiInstrument)object);
        } else if (object instanceof BankTreeNode) {
            BankTreeNode bankTreeNode = (BankTreeNode)object;
            int n = bankTreeNode.getChildCount();
            if (n > 1) {
                String string = StdI18n.i18n.getMessage("JSMidiInstrumentTree.removeInstruments?", n);
                if (!HF.showYesNoDialog(CC.getMainFrame(), string)) {
                    return;
                }
            }
            for (int i = n - 1; i >= 0; --i) {
                object = ((InstrTreeNode)bankTreeNode.getChildAt(i)).getUserObject();
                this.removeInstrument((MidiInstrument)object);
            }
        }
    }

    private void removeInstrument(MidiInstrument midiInstrument) {
        MidiInstrumentInfo midiInstrumentInfo = midiInstrument.getInfo();
        CC.getSamplerModel().unmapBackendMidiInstrument(midiInstrumentInfo.getMapId(), midiInstrumentInfo.getMidiBank(), midiInstrumentInfo.getMidiProgram());
    }

    private int findBankPosition(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            MidiBank midiBank = (MidiBank)defaultMutableTreeNode2.getUserObject();
            if (midiBank.getId() <= n) continue;
            return i;
        }
        return defaultMutableTreeNode.getChildCount();
    }

    private int removeProgram(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            MidiInstrument midiInstrument = (MidiInstrument)defaultMutableTreeNode2.getUserObject();
            if (midiInstrument.getInfo().getMidiProgram() == n) {
                this.model.removeNodeFromParent(defaultMutableTreeNode2);
                return i;
            }
            if (midiInstrument.getInfo().getMidiProgram() <= n) continue;
            return i;
        }
        return defaultMutableTreeNode.getChildCount();
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode2.getUserObject().equals(object)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private DefaultMutableTreeNode findBank(Object object) {
        return this.findNode((DefaultMutableTreeNode)this.model.getRoot(), object);
    }

    private DefaultMutableTreeNode findInstrument(Object object) {
        if (object == null || !(object instanceof MidiInstrument)) {
            return null;
        }
        MidiInstrument midiInstrument = (MidiInstrument)object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.findBank(new MidiBank(midiInstrument.getInfo().getMidiBank()));
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return this.findNode(defaultMutableTreeNode, object);
    }

    private void editSelectedInstrument() {
        MidiInstrument midiInstrument = this.getSelectedInstrument();
        if (midiInstrument == null) {
            return;
        }
        JSEditMidiInstrumentDlg jSEditMidiInstrumentDlg = new JSEditMidiInstrumentDlg(midiInstrument.getInfo());
        jSEditMidiInstrumentDlg.setVisible(true);
        if (jSEditMidiInstrumentDlg.isCancelled()) {
            return;
        }
        MidiInstrumentInfo midiInstrumentInfo = jSEditMidiInstrumentDlg.getInstrument();
        CC.getSamplerModel().mapBackendMidiInstrument(midiInstrumentInfo.getMapId(), midiInstrumentInfo.getMidiBank(), midiInstrumentInfo.getMidiProgram(), midiInstrumentInfo);
    }

    private void copyMidiBankTo() {
        this.copyOrMoveMidiBankTo(true);
    }

    private void moveMidiBankTo() {
        this.copyOrMoveMidiBankTo(false);
    }

    private void copyOrMoveMidiBankTo(boolean bl) {
        MidiBank midiBank = this.getSelectedMidiBank();
        if (midiBank == null) {
            return;
        }
        JSMidiBankChooser jSMidiBankChooser = new JSMidiBankChooser();
        if (bl) {
            jSMidiBankChooser.setTitle(StdI18n.i18n.getLabel("JSMidiInstrumentTree.copyTo"));
        } else {
            jSMidiBankChooser.setTitle(StdI18n.i18n.getLabel("JSMidiInstrumentTree.moveTo"));
        }
        jSMidiBankChooser.setSelectedMidiInstrumentMap(this.getMidiInstrumentMap());
        jSMidiBankChooser.setVisible(true);
        if (jSMidiBankChooser.isCancelled()) {
            return;
        }
        MidiInstrumentMap midiInstrumentMap = jSMidiBankChooser.getSelectedMidiInstrumentMap();
        if (midiInstrumentMap == null) {
            HF.showErrorMessage(StdI18n.i18n.getMessage("JSMidiInstrumentTree.noMap!"), this);
            return;
        }
        if (jSMidiBankChooser.getMidiBank() == midiBank.getId() && midiInstrumentMap.getMapId() == this.getMidiInstrumentMap().getMapId()) {
            String string = "JSMidiInstrumentTree.sameSourceAndDestination!";
            HF.showErrorMessage(StdI18n.i18n.getMessage(string), this);
            return;
        }
        MidiInstrument[] midiInstrumentArray = this.getMidiInstrumentMap().getMidiInstruments(midiBank.getId());
        int n = midiInstrumentMap.getMapId();
        int n2 = jSMidiBankChooser.getMidiBank();
        Vector<MidiInstrument> vector = new Vector<MidiInstrument>();
        for (MidiInstrument object : midiInstrumentArray) {
            MidiInstrument midiInstrument = midiInstrumentMap.getMidiInstrument(n2, object.getInfo().getMidiProgram());
            if (midiInstrument == null) continue;
            vector.add(midiInstrument);
        }
        if (!vector.isEmpty()) {
            Object[] objectArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                int n3 = CC.getViewConfig().getFirstMidiProgramNumber();
                int n4 = ((MidiInstrument)vector.get(i)).getInfo().getMidiProgram();
                objectArray[i] = n3 + n4 + ". " + ((MidiInstrument)vector.get(i)).getName();
            }
            JSOverrideInstrumentsConfirmDlg jSOverrideInstrumentsConfirmDlg = new JSOverrideInstrumentsConfirmDlg((String[])objectArray);
            jSOverrideInstrumentsConfirmDlg.setVisible(true);
            if (jSOverrideInstrumentsConfirmDlg.isCancelled()) {
                return;
            }
        }
        for (MidiInstrument midiInstrument : midiInstrumentArray) {
            int n3 = midiInstrument.getInfo().getMidiProgram();
            CC.getSamplerModel().mapBackendMidiInstrument(n, n2, n3, midiInstrument.getInfo());
        }
        if (bl) {
            return;
        }
        n = this.getMidiInstrumentMap().getMapId();
        n2 = midiBank.getId();
        for (MidiInstrument midiInstrument : midiInstrumentArray) {
            int n4 = midiInstrument.getInfo().getMidiProgram();
            CC.getSamplerModel().unmapBackendMidiInstrument(n, n2, n4);
        }
    }

    private void copyMidiInstrumentTo() {
        this.copyOrMoveMidiInstrumentTo(true);
    }

    private void moveMidiInstrumentTo() {
        this.copyOrMoveMidiInstrumentTo(false);
    }

    private void copyOrMoveMidiInstrumentTo(boolean bl) {
        int n;
        MidiInstrument midiInstrument = this.getSelectedInstrument();
        if (midiInstrument == null) {
            return;
        }
        JSMidiBankChooser jSMidiBankChooser = new JSMidiBankChooser();
        if (bl) {
            jSMidiBankChooser.setTitle(StdI18n.i18n.getLabel("JSMidiInstrumentTree.copyTo"));
        } else {
            jSMidiBankChooser.setTitle(StdI18n.i18n.getLabel("JSMidiInstrumentTree.moveTo"));
        }
        jSMidiBankChooser.setSelectedMidiInstrumentMap(this.getMidiInstrumentMap());
        jSMidiBankChooser.setVisible(true);
        if (jSMidiBankChooser.isCancelled()) {
            return;
        }
        MidiInstrumentMap midiInstrumentMap = jSMidiBankChooser.getSelectedMidiInstrumentMap();
        if (midiInstrumentMap == null) {
            HF.showErrorMessage(StdI18n.i18n.getMessage("JSMidiInstrumentTree.noMap!"), this);
            return;
        }
        int n2 = midiInstrument.getInfo().getMidiBank();
        if (jSMidiBankChooser.getMidiBank() == n2 && midiInstrumentMap.getMapId() == this.getMidiInstrumentMap().getMapId()) {
            String string = "JSMidiInstrumentTree.sameSourceAndDestination!";
            HF.showErrorMessage(StdI18n.i18n.getMessage(string), this);
            return;
        }
        int n3 = midiInstrumentMap.getMapId();
        int n4 = jSMidiBankChooser.getMidiBank();
        MidiInstrument midiInstrument2 = midiInstrumentMap.getMidiInstrument(n4, n = midiInstrument.getInfo().getMidiProgram());
        if (midiInstrument2 != null) {
            String[] stringArray = new String[1];
            int n5 = CC.getViewConfig().getFirstMidiProgramNumber();
            stringArray[0] = n5 + n + ". " + midiInstrument2.getName();
            JSOverrideInstrumentsConfirmDlg jSOverrideInstrumentsConfirmDlg = new JSOverrideInstrumentsConfirmDlg(stringArray);
            jSOverrideInstrumentsConfirmDlg.setVisible(true);
            if (jSOverrideInstrumentsConfirmDlg.isCancelled()) {
                return;
            }
        }
        CC.getSamplerModel().mapBackendMidiInstrument(n3, n4, n, midiInstrument.getInfo());
        if (bl) {
            return;
        }
        n3 = this.getMidiInstrumentMap().getMapId();
        CC.getSamplerModel().unmapBackendMidiInstrument(n3, n2, n);
    }

    private void moveSelectedInstrumentUp() {
        MidiInstrument midiInstrument = this.getSelectedInstrument();
        if (midiInstrument == null) {
            return;
        }
        this.moveSelectedInstrument(midiInstrument.getInfo().getMidiProgram() - 1);
    }

    private void moveSelectedInstrumentDown() {
        MidiInstrument midiInstrument = this.getSelectedInstrument();
        if (midiInstrument == null) {
            return;
        }
        this.moveSelectedInstrument(midiInstrument.getInfo().getMidiProgram() + 1);
    }

    private void moveSelectedInstrument(int n) {
        if (n < 0 || n > 127) {
            return;
        }
        MidiInstrument midiInstrument = this.getSelectedInstrument();
        if (midiInstrument == null) {
            return;
        }
        int n2 = midiInstrument.getInfo().getMidiBank();
        int n3 = midiInstrument.getInfo().getMidiProgram();
        MidiInstrument midiInstrument2 = this.getMidiInstrumentMap().getMidiInstrument(n2, n);
        if (midiInstrument2 != null) {
            String[] stringArray = new String[1];
            int n4 = CC.getViewConfig().getFirstMidiProgramNumber();
            stringArray[0] = n4 + n + ". " + midiInstrument2.getName();
            JSOverrideInstrumentsConfirmDlg jSOverrideInstrumentsConfirmDlg = new JSOverrideInstrumentsConfirmDlg(stringArray);
            jSOverrideInstrumentsConfirmDlg.setVisible(true);
            if (jSOverrideInstrumentsConfirmDlg.isCancelled()) {
                return;
            }
        }
        int n5 = this.getMidiInstrumentMap().getMapId();
        CC.getSamplerModel().mapBackendMidiInstrument(n5, n2, n, midiInstrument.getInfo());
        CC.getSamplerModel().unmapBackendMidiInstrument(n5, n2, n3);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    class ContextMenu
    extends MouseAdapter {
        private final JPopupMenu bankMenu = new JPopupMenu();
        private final JPopupMenu instrumentMenu = new JPopupMenu();
        private final JMenu changeProgramMenu = new JMenu(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.changeProgram"));
        private final JMenuItem miMoveInstrumentUp = new JMenuItem(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.moveUp"));
        private final JMenuItem miMoveInstrumentDown = new JMenuItem(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.moveDown"));
        private final JMenu programGroup1Menu = new JMenu();
        private final JMenu programGroup2Menu = new JMenu();
        private final JMenu programGroup3Menu = new JMenu();
        private final JMenu programGroup4Menu = new JMenu();
        private final JMenu programGroup5Menu = new JMenu();
        private final JMenu programGroup6Menu = new JMenu();
        private final JMenu programGroup7Menu = new JMenu();
        private final JMenu programGroup8Menu = new JMenu();

        ContextMenu() {
            JMenuItem jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.moveTo"));
            this.bankMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.moveMidiBankTo();
                }
            });
            jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.copyTo"));
            this.bankMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.copyMidiBankTo();
                }
            });
            this.bankMenu.addSeparator();
            jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.delete"));
            this.bankMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.removeSelectedInstrumentOrBank();
                }
            });
            jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.edit"));
            this.instrumentMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.editSelectedInstrument();
                }
            });
            this.instrumentMenu.addSeparator();
            jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.moveTo"));
            this.instrumentMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.moveMidiInstrumentTo();
                }
            });
            jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("JSMidiInstrumentTree.ContextMenu.copyTo"));
            this.instrumentMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.copyMidiInstrumentTo();
                }
            });
            this.instrumentMenu.add(this.changeProgramMenu);
            this.changeProgramMenu.add(this.miMoveInstrumentUp);
            this.miMoveInstrumentUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.moveSelectedInstrumentUp();
                }
            });
            this.changeProgramMenu.add(this.miMoveInstrumentDown);
            this.miMoveInstrumentDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.moveSelectedInstrumentDown();
                }
            });
            this.changeProgramMenu.addSeparator();
            this.changeProgramMenu.add(this.programGroup1Menu);
            this.addProgramMenuItems(this.programGroup1Menu, 0, 15);
            this.changeProgramMenu.add(this.programGroup2Menu);
            this.addProgramMenuItems(this.programGroup2Menu, 16, 31);
            this.changeProgramMenu.add(this.programGroup3Menu);
            this.addProgramMenuItems(this.programGroup3Menu, 32, 47);
            this.changeProgramMenu.add(this.programGroup4Menu);
            this.addProgramMenuItems(this.programGroup4Menu, 48, 63);
            this.changeProgramMenu.add(this.programGroup5Menu);
            this.addProgramMenuItems(this.programGroup5Menu, 64, 79);
            this.changeProgramMenu.add(this.programGroup6Menu);
            this.addProgramMenuItems(this.programGroup6Menu, 80, 95);
            this.changeProgramMenu.add(this.programGroup7Menu);
            this.addProgramMenuItems(this.programGroup7Menu, 96, 111);
            this.changeProgramMenu.add(this.programGroup8Menu);
            this.addProgramMenuItems(this.programGroup8Menu, 112, 127);
            this.instrumentMenu.addSeparator();
            this.updateChangeProgramMenu();
            jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.delete"));
            this.instrumentMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSMidiInstrumentTree.this.removeSelectedInstrumentOrBank();
                }
            });
        }

        private void addProgramMenuItems(JMenu jMenu, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                jMenu.add(new ProgramMenuItem(i));
            }
        }

        private void updateChangeProgramMenu() {
            this.updateProgramGroupMenu(this.programGroup1Menu, 0, 15);
            this.updateProgramGroupMenu(this.programGroup2Menu, 16, 31);
            this.updateProgramGroupMenu(this.programGroup3Menu, 32, 47);
            this.updateProgramGroupMenu(this.programGroup4Menu, 48, 63);
            this.updateProgramGroupMenu(this.programGroup5Menu, 64, 79);
            this.updateProgramGroupMenu(this.programGroup6Menu, 80, 95);
            this.updateProgramGroupMenu(this.programGroup7Menu, 96, 111);
            this.updateProgramGroupMenu(this.programGroup8Menu, 112, 127);
        }

        private void updateProgramGroupMenu(JMenu jMenu, int n, int n2) {
            int n3 = CC.getViewConfig().getFirstMidiProgramNumber();
            String string = "JSMidiInstrumentTree.ContextMenu.programGroup";
            String string2 = "(" + (n3 + n) + "-" + (n3 + n2) + ")";
            jMenu.setText(StdI18n.i18n.getMenuLabel(string, string2));
            this.updateProgramGroupMenuItems(jMenu);
        }

        private void updateProgramGroupMenuItems(JMenu jMenu) {
            for (int i = 0; i < jMenu.getItemCount(); ++i) {
                ((ProgramMenuItem)jMenu.getItem(i)).updateProgramNumber();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        void show(MouseEvent mouseEvent) {
            if (JSMidiInstrumentTree.this.getSelectionCount() == 0) {
                return;
            }
            if (JSMidiInstrumentTree.this.getSelectedInstrument() != null) {
                this.instrumentMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.bankMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private class ProgramMenuItem
        extends JMenuItem
        implements ActionListener {
            int program;

            ProgramMenuItem(int n) {
                this.program = n;
                this.updateProgramNumber();
                this.addActionListener(this);
            }

            public void updateProgramNumber() {
                int n = CC.getViewConfig().getFirstMidiProgramNumber();
                this.setText(String.valueOf(n + this.program));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSMidiInstrumentTree.this.moveSelectedInstrument(this.program);
            }
        }
    }

    private class EventHandler
    implements MidiInstrumentListener,
    MidiInstrumentMapListener,
    TreeSelectionListener {
        private EventHandler() {
        }

        @Override
        public void instrumentInfoChanged(MidiInstrumentEvent midiInstrumentEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = JSMidiInstrumentTree.this.findInstrument(midiInstrumentEvent.getSource());
            if (defaultMutableTreeNode != null) {
                JSMidiInstrumentTree.this.model.nodeChanged(defaultMutableTreeNode);
            }
        }

        @Override
        public void nameChanged(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        }

        @Override
        public void instrumentAdded(MidiInstrumentMapEvent midiInstrumentMapEvent) {
            midiInstrumentMapEvent.getInstrument().addMidiInstrumentListener(JSMidiInstrumentTree.this.getHandler());
            JSMidiInstrumentTree.this.mapInstrument(midiInstrumentMapEvent.getInstrument());
        }

        @Override
        public void instrumentRemoved(MidiInstrumentMapEvent midiInstrumentMapEvent) {
            JSMidiInstrumentTree.this.unmapInstrument(midiInstrumentMapEvent.getInstrument());
            midiInstrumentMapEvent.getInstrument().removeMidiInstrumentListener(JSMidiInstrumentTree.this.getHandler());
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            MidiInstrument midiInstrument = JSMidiInstrumentTree.this.getSelectedInstrument();
            if (midiInstrument != null) {
                int n = midiInstrument.getInfo().getMidiProgram();
                JSMidiInstrumentTree.this.contextMenu.miMoveInstrumentDown.setEnabled(n < 127);
                JSMidiInstrumentTree.this.contextMenu.miMoveInstrumentUp.setEnabled(n > 0);
            }
        }
    }

    protected class InstrTreeNode
    extends DefaultMutableTreeNode {
        InstrTreeNode(Object object) {
            super(object);
        }

        @Override
        public void setUserObject(Object object) {
            if (object instanceof MidiInstrument) {
                super.setUserObject(object);
                return;
            }
            CC.getLogger().info("MidiInstrumentTree: editing not supported");
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    protected class BankTreeNode
    extends DefaultMutableTreeNode {
        BankTreeNode(Object object) {
            super(object);
        }

        @Override
        public void setUserObject(Object object) {
            if (object instanceof MidiBank) {
                super.setUserObject(object);
                return;
            }
            CC.getLogger().info("MidiInstrumentTree: editing not supported");
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    private class MidiBank {
        private int id;

        MidiBank(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof MidiBank)) {
                return false;
            }
            return this.getId() == ((MidiBank)object).getId();
        }

        public String toString() {
            int n = CC.getViewConfig().getFirstMidiBankNumber();
            return StdI18n.i18n.getLabel("JSMidiInstrumentTree.MidiBank.name", n + this.id);
        }
    }
}

