/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import org.jsampler.CC;
import org.jsampler.DefaultOrchestraModel;
import org.jsampler.HF;
import org.jsampler.OrchestraInstrument;
import org.jsampler.view.InstrumentTableModel;

public class InstrumentTable
extends JTable {
    private boolean performingDnD = false;

    public InstrumentTable() {
        this(new InstrumentTableModel(new DefaultOrchestraModel()));
    }

    public InstrumentTable(InstrumentTableModel instrumentTableModel) {
        super(instrumentTableModel);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                int n = 1024;
                if ((mouseEvent.getModifiersEx() & n) != n) {
                    return;
                }
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
                InstrumentTable.this.performingDnD = true;
            }
        });
        this.setTransferHandler(new TransferHandler("instrument"){

            @Override
            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                if (InstrumentTable.this.isPerformingDnD()) {
                    return false;
                }
                return super.canImport(jComponent, dataFlavorArray);
            }

            @Override
            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                InstrumentTable.this.performingDnD = false;
            }
        });
        this.installKeyboardListeners();
    }

    private void installKeyboardListeners() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(0).put(keyStroke, "clearSelection");
        this.getActionMap().put("clearSelection", new Actions("clearSelection"));
        keyStroke = KeyStroke.getKeyStroke(38, 9);
        this.getInputMap(0).put(keyStroke, "moveInstrumentOnTop");
        this.getActionMap().put("moveInstrumentOnTop", new Actions("moveInstrumentOnTop"));
        keyStroke = KeyStroke.getKeyStroke(38, 8);
        this.getInputMap(0).put(keyStroke, "moveInstrumentUp");
        this.getActionMap().put("moveInstrumentUp", new Actions("moveInstrumentUp"));
        keyStroke = KeyStroke.getKeyStroke(40, 8);
        this.getInputMap(0).put(keyStroke, "moveInstrumentDown");
        this.getActionMap().put("moveInstrumentDown", new Actions("moveInstrumentDown"));
        keyStroke = KeyStroke.getKeyStroke(40, 9);
        this.getInputMap(0).put(keyStroke, "moveInstrumentAtBottom");
        this.getActionMap().put("moveInstrumentAtBottom", new Actions("moveInstrumentAtBottom"));
    }

    @Override
    public InstrumentTableModel getModel() {
        return (InstrumentTableModel)super.getModel();
    }

    public void setModel(InstrumentTableModel instrumentTableModel) {
        super.setModel(instrumentTableModel);
    }

    public OrchestraInstrument getSelectedInstrument() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getModel().getOrchestraModel().getInstrument(n);
    }

    public void setSelectedInstrument(OrchestraInstrument orchestraInstrument) {
        int n = this.getModel().getOrchestraModel().getInstrumentIndex(orchestraInstrument);
        if (n < 0) {
            this.clearSelection();
            return;
        }
        this.setRowSelectionInterval(n, n);
    }

    public String getInstrument() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getModel().getOrchestraModel().getInstrument(n).getDnDString();
    }

    public void setInstrument(String string) {
        if (!OrchestraInstrument.isDnDString(string)) {
            return;
        }
        OrchestraInstrument orchestraInstrument = new OrchestraInstrument();
        try {
            orchestraInstrument.setDnDString(string);
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            return;
        }
        int n = this.getModel().getOrchestraModel().getInstrumentIndex(this.getSelectedInstrument());
        if (n < 0) {
            this.getModel().getOrchestraModel().addInstrument(orchestraInstrument);
        } else {
            this.getModel().getOrchestraModel().insertInstrument(orchestraInstrument, n);
        }
        this.setSelectedInstrument(orchestraInstrument);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        if (tableCellRenderer instanceof JComponent) {
            String string = this.getModel().getOrchestraModel().getInstrument(n).getDescription();
            if (string != null && string.length() == 0) {
                string = null;
            }
            ((JComponent)((Object)tableCellRenderer)).setToolTipText(string);
        }
        return tableCellRenderer;
    }

    public boolean isPerformingDnD() {
        return this.performingDnD;
    }

    private class Actions
    extends AbstractAction {
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String MOVE_ON_TOP = "moveInstrumentOnTop";
        private static final String MOVE_UP = "moveInstrumentUp";
        private static final String MOVE_DOWN = "moveInstrumentDown";
        private static final String MOVE_AT_BOTTOM = "moveInstrumentAtBottom";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getValue("Name").toString();
            if (string == CLEAR_SELECTION) {
                InstrumentTable.this.clearSelection();
            } else if (string == MOVE_ON_TOP) {
                OrchestraInstrument orchestraInstrument = InstrumentTable.this.getSelectedInstrument();
                InstrumentTable.this.getModel().getOrchestraModel().moveInstrumentOnTop(orchestraInstrument);
                InstrumentTable.this.setSelectedInstrument(orchestraInstrument);
            } else if (string == MOVE_UP) {
                OrchestraInstrument orchestraInstrument = InstrumentTable.this.getSelectedInstrument();
                InstrumentTable.this.getModel().getOrchestraModel().moveInstrumentUp(orchestraInstrument);
                InstrumentTable.this.setSelectedInstrument(orchestraInstrument);
            } else if (string == MOVE_DOWN) {
                OrchestraInstrument orchestraInstrument = InstrumentTable.this.getSelectedInstrument();
                InstrumentTable.this.getModel().getOrchestraModel().moveInstrumentDown(orchestraInstrument);
                InstrumentTable.this.setSelectedInstrument(orchestraInstrument);
            } else if (string == MOVE_AT_BOTTOM) {
                OrchestraInstrument orchestraInstrument = InstrumentTable.this.getSelectedInstrument();
                InstrumentTable.this.getModel().getOrchestraModel().moveInstrumentAtBottom(orchestraInstrument);
                InstrumentTable.this.setSelectedInstrument(orchestraInstrument);
            }
        }
    }
}

