/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import net.sf.juife.wizard.WizardPage;
import org.jsampler.CC;
import org.jsampler.task.Channel;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.NewChannelWizardModel;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.SamplerEngine;

class ConfirmationWizardPage
extends WizardPage {
    private MidiInputDevice midiDev = null;
    private MidiPort midiPort = null;
    private int midiChannel = -1;
    private AudioOutputDevice audioDev = null;
    private SamplerEngine engine = null;
    private String instrFile = null;
    private int instrIndex;
    private final JLabel lInfo = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lInfo"));
    private final JLabel lMidiDevice = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lMidiDevice"));
    private final JLabel lMidiPort = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lMidiPort"));
    private final JLabel lMidiChannel = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lMidiChannel"));
    private final JLabel lEngine = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lEngine"));
    private final JLabel lInstrFile = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lInstrFile"));
    private final JLabel lInstrIndex = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lInstrIndex"));
    private final JLabel lAudioDevice = new JLabel(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.lAudioDevice"));
    private final JTextField tfMidiDevice = new EnhancedTextField();
    private final JTextField tfMidiPort = new EnhancedTextField();
    private final JTextField tfMidiChannel = new EnhancedTextField();
    private final JTextField tfEngine = new EnhancedTextField();
    private final JTextField tfInstrFile = new EnhancedTextField();
    private final JTextField tfInstrIndex = new EnhancedTextField();
    private final JTextField tfAudioDevice = new EnhancedTextField();

    ConfirmationWizardPage() {
        super(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.subtitle"), "", WizardPage.Type.CONFIRMATION_PAGE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lMidiDevice, gridBagConstraints);
        this.add(this.lMidiDevice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lMidiPort, gridBagConstraints);
        this.add(this.lMidiPort);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lMidiChannel, gridBagConstraints);
        this.add(this.lMidiChannel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lEngine, gridBagConstraints);
        this.add(this.lEngine);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.lInstrFile, gridBagConstraints);
        this.add(this.lInstrFile);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.lInstrIndex, gridBagConstraints);
        this.add(this.lInstrIndex);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.lAudioDevice, gridBagConstraints);
        this.add(this.lAudioDevice);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfMidiDevice, gridBagConstraints);
        this.add(this.tfMidiDevice);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.tfMidiPort, gridBagConstraints);
        this.add(this.tfMidiPort);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.tfMidiChannel, gridBagConstraints);
        this.add(this.tfMidiChannel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.tfEngine, gridBagConstraints);
        this.add(this.tfEngine);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.tfInstrFile, gridBagConstraints);
        this.add(this.tfInstrFile);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.tfInstrIndex, gridBagConstraints);
        this.add(this.tfInstrIndex);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.tfAudioDevice, gridBagConstraints);
        this.add(this.tfAudioDevice);
        this.lInfo.setFont(this.lInfo.getFont().deriveFont(0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(12, 3, 17, 3);
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.lInfo, gridBagConstraints);
        this.add(this.lInfo);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
    }

    @Override
    public void preinitPage() {
        NewChannelWizardModel newChannelWizardModel = (NewChannelWizardModel)this.getWizardModel();
        this.setMidiDevice(newChannelWizardModel.getSelectedMidiDevice());
        if (newChannelWizardModel.getCustomMidiSettings()) {
            this.setMidiPort(newChannelWizardModel.getSelectedMidiPort());
            this.setMidiChannel(newChannelWizardModel.getSelectedMidiChannel());
        } else {
            MidiInputDevice midiInputDevice = newChannelWizardModel.getSelectedMidiDevice();
            if (midiInputDevice == null) {
                this.setMidiPort(null);
            } else if (midiInputDevice.getMidiPorts().length < 1) {
                this.setMidiPort(null);
            } else {
                this.setMidiPort(midiInputDevice.getMidiPort(0));
            }
            this.setMidiChannel(-1);
        }
        this.setEngine(newChannelWizardModel.getSelectedEngine());
        this.setAudioDevice(newChannelWizardModel.getSelectedAudioDevice());
        this.setInstrumentFile(newChannelWizardModel.getSelectedFile());
        this.setInstrumentIndex(newChannelWizardModel.getInstrumentIndex());
    }

    @Override
    public boolean mayFinish() {
        final Channel.Add add = new Channel.Add();
        add.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (add.doneWithErrors()) {
                    return;
                }
                ConfirmationWizardPage.this.doIt((Integer)add.getResult());
            }
        });
        CC.getTaskQueue().add(add);
        return true;
    }

    private void doIt(int n) {
        MidiInputDevice midiInputDevice;
        if (this.getEngine() != null) {
            CC.getTaskQueue().add(new Channel.LoadEngine(this.getEngine().getName(), n));
        }
        if ((midiInputDevice = this.getMidiDevice()) != null) {
            int n2;
            CC.getTaskQueue().add(new Channel.SetMidiInputChannel(n, midiInputDevice.getDeviceId()));
            if (this.getMidiPort() != null) {
                n2 = -1;
                for (int i = 0; i < midiInputDevice.getMidiPortCount(); ++i) {
                    if (midiInputDevice.getMidiPort(i) != this.getMidiPort()) continue;
                    n2 = i;
                    break;
                }
                if (n2 != -1) {
                    CC.getTaskQueue().add(new Channel.SetMidiInputPort(n, n2));
                }
            }
            n2 = this.getMidiChannel() == -1 ? -1 : this.getMidiChannel() - 1;
            CC.getTaskQueue().add(new Channel.SetMidiInputChannel(n, n2));
        }
        if (this.getAudioDevice() != null) {
            CC.getTaskQueue().add(new Channel.SetAudioOutputDevice(n, this.getAudioDevice().getDeviceId()));
        }
        if (this.getInstrumentFile().length() > 0) {
            CC.getTaskQueue().add(new Channel.LoadInstrument(this.getInstrumentFile(), this.getInstrumentIndex(), n));
        }
    }

    public AudioOutputDevice getAudioDevice() {
        return this.audioDev;
    }

    public void setAudioDevice(AudioOutputDevice audioOutputDevice) {
        this.audioDev = audioOutputDevice;
        if (audioOutputDevice == null) {
            this.tfAudioDevice.setText(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.notSpecified"));
        } else {
            this.tfAudioDevice.setText(audioOutputDevice.getDeviceId() + " (" + audioOutputDevice.getDriverName() + ")");
        }
    }

    public SamplerEngine getEngine() {
        return this.engine;
    }

    public void setEngine(SamplerEngine samplerEngine) {
        this.engine = samplerEngine;
        if (samplerEngine == null) {
            this.tfEngine.setText(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.notSpecified"));
        } else {
            this.tfEngine.setText(samplerEngine.getName() + " (" + samplerEngine.getDescription() + ")");
        }
    }

    public String getInstrumentFile() {
        return this.instrFile;
    }

    public void setInstrumentFile(String string) {
        this.instrFile = string;
        if (string.length() == 0) {
            this.tfInstrFile.setText(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.notSpecified"));
        } else {
            this.tfInstrFile.setText(string);
        }
    }

    public int getInstrumentIndex() {
        return this.instrIndex;
    }

    public void setInstrumentIndex(int n) {
        this.instrIndex = n;
        this.tfInstrIndex.setText(String.valueOf(n));
    }

    public int getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(int n) {
        this.midiChannel = n;
        this.tfMidiChannel.setText(n == -1 ? "All" : String.valueOf(n));
    }

    public MidiInputDevice getMidiDevice() {
        return this.midiDev;
    }

    public void setMidiDevice(MidiInputDevice midiInputDevice) {
        this.midiDev = midiInputDevice;
        if (midiInputDevice == null) {
            this.tfMidiDevice.setText(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.notSpecified"));
        } else {
            this.tfMidiDevice.setText(midiInputDevice.getDeviceId() + " (" + midiInputDevice.getDriverName() + ")");
        }
    }

    public MidiPort getMidiPort() {
        return this.midiPort;
    }

    public void setMidiPort(MidiPort midiPort) {
        this.midiPort = midiPort;
        if (midiPort == null) {
            this.tfMidiPort.setText(ClassicI18n.i18n.getLabel("ConfirmationWizardPage.notSpecified"));
        } else {
            this.tfMidiPort.setText(midiPort.getName());
        }
    }

    private class EnhancedTextField
    extends JTextField {
        EnhancedTextField() {
            this.setEditable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

