/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public abstract class JSFileFilter
extends FileFilter
implements FilenameFilter {
    private final String[] fileExts;

    public JSFileFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("fileExt must be non-null");
        }
        this.fileExts = new String[1];
        this.fileExts[0] = string;
    }

    public JSFileFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("fileExts must be non-null");
        }
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("fileExts length can't be zero");
        }
        this.fileExts = stringArray;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.acceptFile(file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.acceptFile(string);
    }

    public String getExtension() {
        return this.fileExts[0];
    }

    protected boolean acceptFile(String string) {
        boolean bl = false;
        for (String string2 : this.fileExts) {
            bl = bl || this.acceptFile(string, string2);
        }
        return bl;
    }

    private boolean acceptFile(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        string = string.substring(n);
        return string.equalsIgnoreCase(string2);
    }

    public static class MidiMaps
    extends JSFileFilter {
        private static final String[] exts = new String[]{".lscp", ".txt", ".html", "rgd"};

        public MidiMaps() {
            super(exts);
        }

        @Override
        public String getDescription() {
            return "Midi Instrument Maps";
        }
    }

    public static class Rgd
    extends JSFileFilter {
        public Rgd() {
            super(".rgd");
        }

        @Override
        public String getDescription() {
            return "Rosegarden Device File (*.rgd)";
        }
    }

    public static class Html
    extends JSFileFilter {
        public Html() {
            super(".html");
        }

        @Override
        public String getDescription() {
            return "Web Pages (*.html)";
        }
    }

    public static class Text
    extends JSFileFilter {
        public Text() {
            super(".txt");
        }

        @Override
        public String getDescription() {
            return "Text Files (*.txt)";
        }
    }

    public static class Lscp
    extends JSFileFilter {
        public Lscp() {
            super(".lscp");
        }

        @Override
        public String getDescription() {
            return "LSCP Script Files (*.lscp)";
        }
    }
}

