/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Decrease the image size by cropping the image by an itk::Size at both the upper and lower bounds of the largest possible region.


CropImageFilter changes the image boundary of an image by removing pixels outside the
target region. The target region is not specified in advance, but
calculated in BeforeThreadedGenerateData() .

This filter uses ExtractImageFilter to perform the cropping.
See:
 itk::simple::Crop for the procedural interface

 itk::CropImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCropImageFilter.h
*/
public class CropImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CropImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CropImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CropImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CropImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CropImageFilter::~CropImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CropImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CropImageFilter::CropImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CropImageFilter() {
    this(SimpleITKJNI.new_CropImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CropImageFilter::SetLowerBoundaryCropSize(std::vector&lt; unsigned int &gt; LowerBoundaryCropSize)

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public  void setLowerBoundaryCropSize(VectorUInt32 LowerBoundaryCropSize) {
    SimpleITKJNI.CropImageFilter_setLowerBoundaryCropSize(swigCPtr, this, VectorUInt32.getCPtr(LowerBoundaryCropSize), LowerBoundaryCropSize);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::CropImageFilter::GetLowerBoundaryCropSize() const

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public  VectorUInt32 getLowerBoundaryCropSize() {
    return new VectorUInt32(SimpleITKJNI.CropImageFilter_getLowerBoundaryCropSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::CropImageFilter::SetUpperBoundaryCropSize(std::vector&lt; unsigned int &gt; UpperBoundaryCropSize)

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public  void setUpperBoundaryCropSize(VectorUInt32 UpperBoundaryCropSize) {
    SimpleITKJNI.CropImageFilter_setUpperBoundaryCropSize(swigCPtr, this, VectorUInt32.getCPtr(UpperBoundaryCropSize), UpperBoundaryCropSize);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::CropImageFilter::GetUpperBoundaryCropSize() const

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public  VectorUInt32 getUpperBoundaryCropSize() {
    return new VectorUInt32(SimpleITKJNI.CropImageFilter_getUpperBoundaryCropSize(swigCPtr, this), true);
  }

  /**
std::string itk::simple::CropImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CropImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CropImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CropImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CropImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.CropImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
