/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleDaemonStartupIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.gradle"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleDaemonStartupIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDaemonStartupIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/GradleDaemonStartupIssueChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1563#2:116\n1634#2,3:117\n*S KotlinDebug\n*F\n+ 1 GradleDaemonStartupIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/GradleDaemonStartupIssueChecker\n*L\n101#1:116\n101#1:117,3\n*E\n"})
final class GradleDaemonStartupIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String gradleVmOptions;
        CharSequence charSequence;
        Object object;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String rootCauseText = rootCause.toString();
        if (!StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.api.GradleException: Unable to start the daemon process.", (boolean)false, (int)2, null)) {
            return null;
        }
        StringBuilder quickFixDescription = new StringBuilder();
        ArrayList<BuildIssueQuickFix> quickFixes = new ArrayList<BuildIssueQuickFix>();
        String[] stringArray = new String[]{"gradle.properties"};
        Path projectGradleProperties = Paths.get(issueData.getProjectPath(), stringArray);
        Intrinsics.checkNotNull((Object)projectGradleProperties);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(projectGradleProperties, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(projectGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in project root directory\n");
            quickFixes.add((BuildIssueQuickFix)openFileQuickFix);
        }
        if ((object = issueData.getBuildEnvironment()) == null || (object = object.getGradle()) == null || (object = object.getGradleUserHome()) == null) {
            object = GradleUserHomeUtil.gradleUserHomeDir();
        }
        BuildEnvironment gradleUserHomeDir2 = object;
        String[] stringArray2 = new String[]{"gradle.properties"};
        Path commonGradleProperties = Paths.get(gradleUserHomeDir2.getPath(), stringArray2);
        Intrinsics.checkNotNull((Object)commonGradleProperties);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isRegularFile(commonGradleProperties, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(commonGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in GRADLE_USER_HOME directory\n");
            quickFixes.add((BuildIssueQuickFix)openFileQuickFix);
        }
        if (!((charSequence = (CharSequence)(gradleVmOptions = GradleSystemSettings.getInstance().getGradleVmOptions())) == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix())) {
            GradleSettingsQuickFix gradleSettingsFix = new GradleSettingsQuickFix(issueData.getProjectPath(), true, (arg_0, arg_1) -> GradleDaemonStartupIssueChecker.check$lambda$0(gradleVmOptions, arg_0, arg_1), GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            quickFixes.add(gradleSettingsFix);
            quickFixDescription.append(" - <a href=\"" + gradleSettingsFix.getId() + "\">IDE Gradle VM options</a> \n");
        }
        StringBuilder issueDescription = new StringBuilder(rootCause.getMessage());
        if (((CharSequence)quickFixDescription).length() > 0) {
            issueDescription.append("\n-----------------------\n");
            issueDescription.append("Check the JVM arguments defined for the gradle process in:\n");
            issueDescription.append((CharSequence)quickFixDescription);
        }
        String string = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String description = string;
        String string2 = BuildConsoleUtils.getMessageTitle((String)description);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessageTitle(...)");
        String title = string2;
        return new BuildIssue(title, description, quickFixes){
            private final String title;
            private final String description;
            private final ArrayList<BuildIssueQuickFix> quickFixes;
            {
                this.title = $title;
                this.description = $description;
                this.quickFixes = $quickFixes;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public ArrayList<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public Navigatable getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (location == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)failureCause, (Object)"startup failed:")) {
            Integer[] integerArray;
            List list;
            String string;
            String string2;
            String string3 = StringKt.nullize$default((String)StringsKt.substringAfter((String)message, (String)"> startup failed:", (String)""), (boolean)false, (int)1, null);
            if (string3 == null || (string3 = ((Object)StringsKt.trimStart((CharSequence)string3)).toString()) == null || (string3 = StringsKt.substringBefore$default((String)string3, (String)"\n", null, (int)2, null)) == null) {
                return false;
            }
            String locationLine = string3;
            Object object = location.getFile();
            if (object == null || (object = ((File)object).getPath()) == null) {
                object = "";
            }
            if ((string2 = StringKt.nullize$default((String)StringsKt.substringAfter((String)locationLine, (String)("'" + (String)object + "': " + (location.getStartLine() + 1) + ": "), (String)""), (boolean)false, (int)1, null)) == null || (string = StringsKt.substringBeforeLast$default((String)string2, (String)" @ ", null, (int)2, null)) == null) {
                return false;
            }
            String failedStartupReason = string;
            String locationPart = StringsKt.substringAfterLast$default((String)locationLine, (String)" @ ", null, (int)2, null);
            Pattern pattern = GradleConsoleFilter.LINE_AND_COLUMN_PATTERN;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"LINE_AND_COLUMN_PATTERN");
            Pattern pattern2 = pattern;
            MatchResult matchResult = new Regex(pattern2).matchEntire((CharSequence)locationPart);
            Object object2 = matchResult;
            if (object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = CollectionsKt.drop((Iterable)((Iterable)object2), (int)1)) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string4 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Integer.parseInt((String)it));
                }
                list = (List)destination$iv$iv;
            } else {
                integerArray = new Integer[]{location.getStartLine() + 1, 0};
                list = CollectionsKt.listOf((Object[])integerArray);
            }
            List values = list;
            int line = ((Number)values.get(0)).intValue() - 1;
            int column = ((Number)values.get(1)).intValue();
            MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
            integerArray = new FilePosition(location.getFile(), line, column);
            messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentEventId, failedStartupReason, message, kind, (FilePosition)integerArray){});
            return true;
        }
        return false;
    }

    private static final boolean check$lambda$0(String $gradleVmOptions, GradleProjectSettings gradleProjectSettings, GradleProjectSettings gradleProjectSettings2) {
        Intrinsics.checkNotNullParameter((Object)((Object)gradleProjectSettings), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)((Object)gradleProjectSettings2), (String)"<unused var>");
        return !Intrinsics.areEqual((Object)$gradleVmOptions, (Object)GradleSystemSettings.getInstance().getGradleVmOptions());
    }
}

