/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TableHeaderAddon;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTableHeader
extends JTableHeader
implements TableColumnModelExtListener {
    private static final Logger LOG = Logger.getLogger(JXTableHeader.class.getName());
    @Deprecated
    private SortGestureRecognizer sortGestureRecognizer;
    private PropertyChangeListener tablePropertyChangeListener;
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel columnModel) {
        super(columnModel);
    }

    @Override
    public void setTable(JTable table) {
        this.uninstallTable();
        super.setTable(table);
        this.installTable();
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    protected void installTable() {
        this.updateEnabledFromTable();
        if (this.getTable() == null) {
            return;
        }
        this.getTable().addPropertyChangeListener(this.getTablePropertyChangeListener());
    }

    protected void updateEnabledFromTable() {
        this.setEnabled(this.getTable() != null ? this.getTable().isEnabled() : true);
    }

    protected void uninstallTable() {
        if (this.getTable() == null) {
            return;
        }
        this.getTable().removePropertyChangeListener(this.getTablePropertyChangeListener());
    }

    @Override
    public void columnPropertyChange(PropertyChangeEvent event) {
        if (this.isColumnEvent(event)) {
            return;
        }
        this.resizeAndRepaint();
    }

    protected boolean isColumnEvent(PropertyChangeEvent event) {
        return "width".equals(event.getPropertyName()) || "preferredWidth".equals(event.getPropertyName()) || "visible".equals(event.getPropertyName());
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String columnToolTipText = this.getColumnToolTipText(event);
        return columnToolTipText != null ? columnToolTipText : super.getToolTipText(event);
    }

    protected String getColumnToolTipText(MouseEvent event) {
        if (this.getXTable() == null) {
            return null;
        }
        int column2 = this.columnAtPoint(event.getPoint());
        if (column2 < 0) {
            return null;
        }
        TableColumnExt columnExt = this.getXTable().getColumnExt(column2);
        return columnExt != null ? columnExt.getToolTipText() : null;
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public TableCellRenderer getCellRenderer(int columnIndex) {
        TableCellRenderer renderer = this.getColumnModel().getColumn(columnIndex).getHeaderRenderer();
        return renderer != null ? renderer : this.getDefaultRenderer();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref = this.getPreferredSize(pref);
        pref.height = this.getMinimumHeight(pref.height);
        return pref;
    }

    protected Dimension getPreferredSize(Dimension pref) {
        int height = pref.height;
        for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
            TableCellRenderer renderer = this.getCellRenderer(i2);
            Component comp = renderer.getTableCellRendererComponent(this.table, this.getColumnModel().getColumn(i2).getHeaderValue(), false, false, -1, i2);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        pref.height = height;
        return pref;
    }

    protected int getMinimumHeight(int height) {
        if (height == 0) {
            TableCellRenderer renderer = this.getDefaultRenderer();
            Component comp = renderer.getTableCellRendererComponent(this.getTable(), "dummy", false, false, -1, -1);
            height = comp.getPreferredSize().height;
        }
        return height;
    }

    @Override
    public void setDraggedColumn(TableColumn column2) {
        if (this.getDraggedColumn() == column2) {
            return;
        }
        TableColumn old = this.getDraggedColumn();
        super.setDraggedColumn(column2);
        this.firePropertyChange("draggedColumn", old, this.getDraggedColumn());
    }

    @Override
    public void setResizingColumn(TableColumn aColumn) {
        if (this.getResizingColumn() == aColumn) {
            return;
        }
        TableColumn old = this.getResizingColumn();
        super.setResizingColumn(aColumn);
        this.firePropertyChange("resizingColumn", old, this.getResizingColumn());
    }

    @Override
    public void setDraggedDistance(int distance) {
        int old = this.getDraggedDistance();
        super.setDraggedDistance(distance);
        this.firePropertyChange("draggedDistance", old, this.getDraggedDistance());
        if (!this.getAutoscrolls() || this.getXTable() == null) {
            return;
        }
        TableColumn column2 = this.getDraggedColumn();
        if (column2 != null) {
            this.getXTable().scrollColumnToVisible(this.getViewIndexForColumn(column2));
        }
    }

    @Override
    public TableColumn getDraggedColumn() {
        return this.isVisible(this.draggedColumn) ? this.draggedColumn : null;
    }

    private boolean isVisible(TableColumn column2) {
        return this.getViewIndexForColumn(column2) >= 0;
    }

    private int getViewIndexForColumn(TableColumn aColumn) {
        if (aColumn == null) {
            return -1;
        }
        TableColumnModel cm = this.getColumnModel();
        for (int column2 = 0; column2 < cm.getColumnCount(); ++column2) {
            if (cm.getColumn(column2) != aColumn) continue;
            return column2;
        }
        return -1;
    }

    protected PropertyChangeListener getTablePropertyChangeListener() {
        if (this.tablePropertyChangeListener == null) {
            this.tablePropertyChangeListener = this.createTablePropertyChangeListener();
        }
        return this.tablePropertyChangeListener;
    }

    protected PropertyChangeListener createTablePropertyChangeListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    JXTableHeader.this.updateEnabledFromTable();
                }
            }
        };
        return l;
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    @Deprecated
    public SortGestureRecognizer getSortGestureRecognizer() {
        if (this.sortGestureRecognizer == null) {
            this.sortGestureRecognizer = this.createSortGestureRecognizer();
        }
        return this.sortGestureRecognizer;
    }

    @Deprecated
    public void setSortGestureRecognizer(SortGestureRecognizer recognizer) {
        SortGestureRecognizer old = this.getSortGestureRecognizer();
        this.sortGestureRecognizer = recognizer;
        this.firePropertyChange("sortGestureRecognizer", old, this.getSortGestureRecognizer());
    }

    @Deprecated
    protected SortGestureRecognizer createSortGestureRecognizer() {
        return new SortGestureRecognizer();
    }

    static {
        LookAndFeelAddons.contribute(new TableHeaderAddon());
    }

    @Deprecated
    public static class SortGestureRecognizer {
        public boolean isResetSortOrderGesture(MouseEvent e2) {
            return this.isSortOrderGesture(e2) && this.isResetModifier(e2);
        }

        public boolean isToggleSortOrderGesture(MouseEvent e2) {
            return this.isSortOrderGesture(e2) && !this.isResetModifier(e2);
        }

        public boolean isSortOrderGesture(MouseEvent e2) {
            return e2.getClickCount() == 1;
        }

        protected boolean isResetModifier(MouseEvent e2) {
            return (e2.getModifiersEx() & 0x40) == 64;
        }
    }

    private class HeaderListener
    implements MouseInputListener,
    Serializable {
        private TableColumn cachedResizingColumn;
        private SortOrder[] cachedSortOrderCycle;

        private HeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (this.shouldIgnore(e2)) {
                return;
            }
            this.doResize(e2);
            this.uncacheResizingColumn();
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.resetToggleSortOrder(e2);
            if (this.shouldIgnore(e2)) {
                return;
            }
            this.cacheResizingColumn(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this.shouldIgnore(e2)) {
                return;
            }
            this.cacheResizingColumn(e2);
            if (this.isInResizeRegion(e2) && e2.getClickCount() % 2 == 1) {
                this.disableToggleSortOrder(e2);
            }
        }

        private boolean shouldIgnore(MouseEvent e2) {
            return !SwingUtilities.isLeftMouseButton(e2) || !JXTableHeader.this.table.isEnabled();
        }

        private void doResize(MouseEvent e2) {
            if (e2.getClickCount() != 2) {
                return;
            }
            int column2 = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (column2 >= 0) {
                JXTableHeader.this.getXTable().packColumn(column2, 5);
            }
        }

        private void disableToggleSortOrder(MouseEvent e2) {
            if (!(JXTableHeader.this.getXTable().getRowSorter() instanceof SortController)) {
                return;
            }
            SortController controller = (SortController)((Object)JXTableHeader.this.getXTable().getRowSorter());
            this.cachedSortOrderCycle = controller.getSortOrderCycle();
            controller.setSortOrderCycle(new SortOrder[0]);
        }

        private void resetToggleSortOrder(MouseEvent e2) {
            if (this.cachedSortOrderCycle == null) {
                return;
            }
            ((SortController)((Object)JXTableHeader.this.getXTable().getRowSorter())).setSortOrderCycle(this.cachedSortOrderCycle);
            this.cachedSortOrderCycle = null;
        }

        private void cacheResizingColumn(MouseEvent e2) {
            TableColumn column2 = JXTableHeader.this.getResizingColumn();
            if (column2 != null) {
                this.cachedResizingColumn = column2;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent e2) {
            return this.cachedResizingColumn != null;
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            this.uncacheResizingColumn();
            this.resetToggleSortOrder(e2);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            this.uncacheResizingColumn();
            this.resetToggleSortOrder(e2);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            this.resetToggleSortOrder(e2);
        }
    }
}

