/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.jspecify.annotations.Nullable;

public class LocalComponentDependencyMetadata
implements LocalOriginDependencyMetadata {
    private final ComponentSelector selector;
    private final @Nullable String dependencyConfiguration;
    private final List<ExcludeMetadata> excludes;
    private final List<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final boolean constraint;
    private final boolean endorsing;
    private final boolean fromLock;
    private final @Nullable String reason;

    public LocalComponentDependencyMetadata(ComponentSelector selector, @Nullable String dependencyConfiguration, List<IvyArtifactName> artifactNames, List<ExcludeMetadata> excludes, boolean force, boolean changing, boolean transitive, boolean constraint, boolean endorsing, @Nullable String reason) {
        this(selector, dependencyConfiguration, artifactNames, excludes, force, changing, transitive, constraint, endorsing, false, reason);
    }

    public LocalComponentDependencyMetadata(ComponentSelector selector, @Nullable String dependencyConfiguration, List<IvyArtifactName> artifactNames, List<ExcludeMetadata> excludes, boolean force, boolean changing, boolean transitive, boolean constraint, boolean endorsing, boolean fromLock, @Nullable String reason) {
        this.selector = selector;
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = LocalComponentDependencyMetadata.asImmutable(artifactNames);
        this.excludes = excludes;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
        this.constraint = constraint;
        this.endorsing = endorsing;
        this.fromLock = fromLock;
        this.reason = reason;
    }

    private static List<IvyArtifactName> asImmutable(List<IvyArtifactName> artifactNames) {
        return artifactNames.isEmpty() ? Collections.emptyList() : (artifactNames instanceof ImmutableList ? artifactNames : ImmutableList.copyOf(artifactNames));
    }

    public String toString() {
        return "dependency: " + this.selector + " to-conf: " + this.dependencyConfiguration;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public @Nullable List<? extends VariantGraphResolveState> overrideVariantSelection(GraphVariantSelector variantSelector, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema) {
        if (this.dependencyConfiguration != null) {
            VariantGraphResolveState selected = variantSelector.selectVariantByConfigurationName(this.dependencyConfiguration, consumerAttributes, targetComponentState, consumerSchema);
            return Collections.singletonList(selected);
        }
        return null;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public boolean isConstraint() {
        return this.constraint;
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.endorsing;
    }

    @Override
    public @Nullable String getReason() {
        return this.reason;
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public LocalOriginDependencyMetadata withTarget(ComponentSelector target) {
        if (this.selector.equals(target)) {
            return this;
        }
        return this.copyWithTarget(target);
    }

    @Override
    public LocalOriginDependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts) {
        if (this.selector.equals(target) && artifacts.equals(this.getArtifacts())) {
            return this;
        }
        return this.copyWithTargetAndArtifacts(target, artifacts);
    }

    @Override
    public LocalOriginDependencyMetadata forced() {
        if (this.force) {
            return this;
        }
        return this.copyWithForce();
    }

    @Override
    public boolean isFromLock() {
        return this.fromLock;
    }

    @Override
    public DependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.reason)) {
            return this;
        }
        return this.copyWithReason(reason);
    }

    private LocalOriginDependencyMetadata copyWithTarget(ComponentSelector selector) {
        return new LocalComponentDependencyMetadata(selector, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, this.reason);
    }

    private LocalOriginDependencyMetadata copyWithTargetAndArtifacts(ComponentSelector selector, List<IvyArtifactName> artifactNames) {
        return new LocalComponentDependencyMetadata(selector, this.dependencyConfiguration, artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, this.reason);
    }

    private LocalOriginDependencyMetadata copyWithReason(String reason) {
        return new LocalComponentDependencyMetadata(this.selector, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, reason);
    }

    private LocalOriginDependencyMetadata copyWithForce() {
        return new LocalComponentDependencyMetadata(this.selector, this.dependencyConfiguration, this.artifactNames, this.excludes, true, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, this.reason);
    }
}

