/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJShellHolderMethodImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJShellImportHolderImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJShellRootClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.IJShellElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public interface JShellElementType {
    public static final IElementType ROOT_CLASS = new IJShellElementType("JSHELL_ROOT_CLASS"){
        private final AtomicInteger ourClassCounter = new AtomicInteger();

        @Override
        public PsiElement createPsi(ASTNode node) {
            return new PsiJShellRootClassImpl(node, this.ourClassCounter.getAndIncrement());
        }
    };
    public static final IElementType STATEMENTS_HOLDER = new IJShellElementType("JSHELL_STATEMENTS_HOLDER"){
        private final AtomicInteger ourMethodCounter = new AtomicInteger();

        @Override
        public PsiElement createPsi(ASTNode node) {
            return new PsiJShellHolderMethodImpl(node, this.ourMethodCounter.getAndIncrement());
        }
    };
    public static final IElementType IMPORT_HOLDER = new IJShellElementType("JSHELL_IMPORT_HOLDER"){

        @Override
        public PsiElement createPsi(ASTNode node) {
            return new PsiJShellImportHolderImpl(node);
        }
    };
}

