/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.RegularFile;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public final class MetadataRendererRegistry {
    private static final MetadataRenderer UNKNOWN_TYPE_RENDERER = new UnknownTypeRenderer();
    private final Set<MetadataRenderer> registeredRenderers = new HashSet<MetadataRenderer>();
    private final LoadingCache<String, MetadataRenderer> rendererLookupCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, MetadataRenderer>(){

        public MetadataRenderer load(String metadataTypeName) {
            Class<?> type;
            try {
                type = Class.forName(metadataTypeName);
            }
            catch (ClassNotFoundException e) {
                return UNKNOWN_TYPE_RENDERER;
            }
            return MetadataRendererRegistry.this.registeredRenderers.stream().filter(r -> r.getMetadataTypes().stream().anyMatch(t -> t.isAssignableFrom(type))).findFirst().orElse(UNKNOWN_TYPE_RENDERER);
        }
    });

    public MetadataRendererRegistry() {
        this.registerRenderer(new BasicRenderer());
        this.registerRenderer(new ClickableLinkRenderer());
    }

    public void registerRenderer(MetadataRenderer metadataRenderer) {
        this.registeredRenderers.add(metadataRenderer);
    }

    public MetadataRenderer getRenderer(String metadataTypeName) {
        return (MetadataRenderer)this.rendererLookupCache.getUnchecked((Object)metadataTypeName);
    }

    public static interface MetadataRenderer {
        public static final int MAX_DISPLAYABLE_LENGTH = 100;

        public Set<Class<?>> getMetadataTypes();

        public SimpleHtmlWriter render(Object var1, SimpleHtmlWriter var2) throws IOException;

        public static String trimIfNecessary(String input) {
            if (input.length() > 100) {
                return input.substring(0, 100) + "...";
            }
            return input;
        }
    }

    public static final class BasicRenderer
    implements MetadataRenderer {
        private final Set<Class<?>> metadataTypes = ImmutableSet.of(String.class, Number.class, Boolean.class);

        @Override
        public Set<Class<?>> getMetadataTypes() {
            return this.metadataTypes;
        }

        @Override
        public SimpleHtmlWriter render(Object metadata, SimpleHtmlWriter htmlWriter) throws IOException {
            return (SimpleHtmlWriter)htmlWriter.characters((CharSequence)MetadataRenderer.trimIfNecessary(metadata.toString()));
        }
    }

    public static final class ClickableLinkRenderer
    implements MetadataRenderer {
        private final Set<Class<?>> metadataTypes = ImmutableSet.of(URI.class, File.class, RegularFile.class);

        @Override
        public Set<Class<?>> getMetadataTypes() {
            return this.metadataTypes;
        }

        @Override
        public SimpleHtmlWriter render(Object metadata, SimpleHtmlWriter htmlWriter) throws IOException {
            String text;
            String link;
            if (metadata instanceof File) {
                link = ((File)metadata).toURI().toASCIIString();
                text = ((File)metadata).getName();
            } else if (metadata instanceof RegularFile) {
                link = ((RegularFile)metadata).getAsFile().toURI().toASCIIString();
                text = ((RegularFile)metadata).getAsFile().getName();
            } else if (((URI)metadata).getScheme().equals("file")) {
                link = metadata.toString();
                text = new File((URI)metadata).getName();
            } else {
                link = metadata.toString();
                text = metadata.toString();
            }
            return (SimpleHtmlWriter)htmlWriter.startElement("a").attribute("href", link).characters((CharSequence)MetadataRenderer.trimIfNecessary(text)).endElement();
        }
    }

    public static final class UnknownTypeRenderer
    implements MetadataRenderer {
        @Override
        public Set<Class<?>> getMetadataTypes() {
            return Collections.singleton(Object.class);
        }

        @Override
        public SimpleHtmlWriter render(Object metadata, SimpleHtmlWriter htmlWriter) throws IOException {
            return (SimpleHtmlWriter)htmlWriter.startElement("span").attribute("class", "unrenderable").characters((CharSequence)"[unrenderable type]").endElement();
        }
    }
}

