/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.IncubatingFeatureUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingIncubatingFeatureHandler
implements FeatureHandler<IncubatingFeatureUsage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingIncubatingFeatureHandler.class);
    private final Set<String> features = new HashSet<String>();

    @Override
    public void featureUsed(IncubatingFeatureUsage usage) {
        if (this.features.add(usage.getSummary())) {
            LOGGER.warn(String.format("%s is an incubating feature.", usage.getSummary()));
        }
    }

    public void reset() {
        this.features.clear();
    }
}

