/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.Unit;
import tim.prune.function.edit.PointAltitudeEdit;

public class EditAltitudeCmd
extends Command {
    private final List<PointAltitudeEdit> _editList;

    public EditAltitudeCmd(List<PointAltitudeEdit> list) {
        this(null, list);
    }

    protected EditAltitudeCmd(EditAltitudeCmd editAltitudeCmd, List<PointAltitudeEdit> list) {
        super(editAltitudeCmd);
        this._editList = list;
    }

    @Override
    public int getUpdateFlags() {
        return 2;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        return this.executeCommand(trackInfo.getTrack());
    }

    public boolean executeCommand(Track track) {
        for (PointAltitudeEdit pointAltitudeEdit : this._editList) {
            DataPoint dataPoint = track.getPoint(pointAltitudeEdit.getPointIndex());
            dataPoint.setAltitude(pointAltitudeEdit.getValue(), pointAltitudeEdit.getUnit(), this.isUndo());
        }
        track.requestRescale();
        return !this._editList.isEmpty();
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        return new EditAltitudeCmd(this, this.makeOppositeEdits(trackInfo.getTrack()));
    }

    private List<PointAltitudeEdit> makeOppositeEdits(Track track) {
        ArrayList<PointAltitudeEdit> arrayList = new ArrayList<PointAltitudeEdit>();
        for (PointAltitudeEdit pointAltitudeEdit : this._editList) {
            Unit unit;
            String string;
            DataPoint dataPoint = track.getPoint(pointAltitudeEdit.getPointIndex());
            if (dataPoint.hasAltitude()) {
                string = dataPoint.getFieldValue(Field.ALTITUDE);
                unit = dataPoint.getAltitude().getUnit();
            } else {
                string = null;
                unit = null;
            }
            arrayList.add(new PointAltitudeEdit(pointAltitudeEdit.getPointIndex(), string, unit));
        }
        return arrayList;
    }
}

