=begin
#InfluxDB OSS API Service

#The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech

=end

require 'date'
require 'set'
require 'time'

module InfluxDB2
  # Dialect are options to change the default CSV output format; https://www.w3.org/TR/2015/REC-tabular-metadata-20151217/#dialect-descriptions
  class Dialect
    # If true, the results will contain a header row
    attr_accessor :header

    # Separator between cells; the default is ,
    attr_reader :delimiter

    # https://www.w3.org/TR/2015/REC-tabular-data-model-20151217/#columns
    attr_accessor :annotations

    # Character prefixed to comment strings
    attr_reader :comment_prefix

    # Format of timestamps
    attr_reader :date_time_format

    class EnumAttributeValidator
      attr_reader :datatype
      attr_reader :allowable_values

      def initialize(datatype, allowable_values)
        @allowable_values = allowable_values.map do |value|
          case datatype.to_s
          when /Integer/i
            value.to_i
          when /Float/i
            value.to_f
          else
            value
          end
        end
      end

      def valid?(value)
        !value || allowable_values.include?(value)
      end
    end

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'header' => :'header',
        :'delimiter' => :'delimiter',
        :'annotations' => :'annotations',
        :'comment_prefix' => :'commentPrefix',
        :'date_time_format' => :'dateTimeFormat',
      }
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'header' => :'Boolean',
        :'delimiter' => :'String',
        :'annotations' => :'Array<String>',
        :'comment_prefix' => :'String',
        :'date_time_format' => :'String'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `InfluxDB2::Dialect` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `InfluxDB2::Dialect`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'header')
        self.header = attributes[:'header']
      else
        self.header = true
      end

      if attributes.key?(:'delimiter')
        self.delimiter = attributes[:'delimiter']
      else
        self.delimiter = ','
      end

      if attributes.key?(:'annotations')
        if (value = attributes[:'annotations']).is_a?(Array)
          self.annotations = value
        end
      end

      if attributes.key?(:'comment_prefix')
        self.comment_prefix = attributes[:'comment_prefix']
      else
        self.comment_prefix = '#'
      end

      if attributes.key?(:'date_time_format')
        self.date_time_format = attributes[:'date_time_format']
      else
        self.date_time_format = 'RFC3339'
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      invalid_properties = Array.new
      if !@delimiter.nil? && @delimiter.to_s.length > 1
        invalid_properties.push('invalid value for "delimiter", the character length must be smaller than or equal to 1.')
      end

      if !@delimiter.nil? && @delimiter.to_s.length < 1
        invalid_properties.push('invalid value for "delimiter", the character length must be great than or equal to 1.')
      end

      if !@comment_prefix.nil? && @comment_prefix.to_s.length > 1
        invalid_properties.push('invalid value for "comment_prefix", the character length must be smaller than or equal to 1.')
      end

      if !@comment_prefix.nil? && @comment_prefix.to_s.length < 0
        invalid_properties.push('invalid value for "comment_prefix", the character length must be great than or equal to 0.')
      end

      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      return false if !@delimiter.nil? && @delimiter.to_s.length > 1
      return false if !@delimiter.nil? && @delimiter.to_s.length < 1
      return false if !@comment_prefix.nil? && @comment_prefix.to_s.length > 1
      return false if !@comment_prefix.nil? && @comment_prefix.to_s.length < 0
      date_time_format_validator = EnumAttributeValidator.new('String', ["RFC3339", "RFC3339Nano"])
      return false unless date_time_format_validator.valid?(@date_time_format)
      true
    end

    # Custom attribute writer method with validation
    # @param [Object] delimiter Value to be assigned
    def delimiter=(delimiter)
      if !delimiter.nil? && delimiter.to_s.length > 1
        fail ArgumentError, 'invalid value for "delimiter", the character length must be smaller than or equal to 1.'
      end

      if !delimiter.nil? && delimiter.to_s.length < 1
        fail ArgumentError, 'invalid value for "delimiter", the character length must be great than or equal to 1.'
      end

      @delimiter = delimiter
    end

    # Custom attribute writer method with validation
    # @param [Object] comment_prefix Value to be assigned
    def comment_prefix=(comment_prefix)
      if !comment_prefix.nil? && comment_prefix.to_s.length > 1
        fail ArgumentError, 'invalid value for "comment_prefix", the character length must be smaller than or equal to 1.'
      end

      if !comment_prefix.nil? && comment_prefix.to_s.length < 0
        fail ArgumentError, 'invalid value for "comment_prefix", the character length must be great than or equal to 0.'
      end

      @comment_prefix = comment_prefix
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] date_time_format Object to be assigned
    def date_time_format=(date_time_format)
      validator = EnumAttributeValidator.new('String', ["RFC3339", "RFC3339Nano"])
      unless validator.valid?(date_time_format)
        fail ArgumentError, "invalid value for \"date_time_format\", must be one of #{validator.allowable_values}."
      end
      @date_time_format = date_time_format
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          header == o.header &&
          delimiter == o.delimiter &&
          annotations == o.annotations &&
          comment_prefix == o.comment_prefix &&
          date_time_format == o.date_time_format
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [header, delimiter, annotations, comment_prefix, date_time_format].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      new.build_from_hash(attributes)
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      self.class.openapi_types.each_pair do |key, type|
        if attributes[self.class.attribute_map[key]].nil? && self.class.openapi_nullable.include?(key)
          self.send("#{key}=", nil)
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[self.class.attribute_map[key]].is_a?(Array)
            self.send("#{key}=", attributes[self.class.attribute_map[key]].map { |v| _deserialize($1, v) })
          end
        elsif !attributes[self.class.attribute_map[key]].nil?
          self.send("#{key}=", _deserialize(type, attributes[self.class.attribute_map[key]]))
        end
      end

      self
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def _deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        InfluxDB2.const_get(type).build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end
        
        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end
end
