---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 特に複雑なシナリオにおいて、保護ブランチの保護ルールがGitLabでどのように機能するかについて説明します。
title: 保護ルールと権限
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

保護ルールはブランチへのアクセスを制御し、複数のルールが同じブランチに適用された場合に何が起こるかを決定します。これらは、リポジトリブランチに適切なセキュリティ対策を実装するのに役立ちます。これらのルールは以下を対象としています:

- 権限レベル、優先順位、およびルール間の競合。
- 複数のマッチングルールにわたる強制プッシュ権限。
- コードオーナーの承認。
- グループとプロジェクト間の保護設定。

## ルールの動作 {#rule-behaviors}

あるブランチが複数の保護ルールに一致する場合、以下の動作が適用されます:

- グループのルールは、グループ内のすべてのプロジェクトに適用され、プロジェクト設定から変更することはできません。詳細については、[グループとプロジェクトにまたがるルール](#rules-across-groups-and-projects)を参照してください。
- あるブランチが複数のルールに一致する場合、最も許可的なルールが適用されます。ただし、[コードオーナーの承認](#code-owner-approval)は、最も制限の厳しいルールを使用します。
- `main`のような正確なブランチ名は、`m*`のようなワイルドカードパターンをオーバーライドしません。

## プッシュとマージの権限 {#push-and-merge-permissions}

{{< history >}}

- ブランチのプッシュ権限が[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118532)され、GitLab 16.0では、管理者も**許可**権限を持つ必要になりました。

{{< /history >}}

ブランチが保護に設定されている場合、デフォルトの動作では、これらの制限が適用されます:

| アクション                   | 実行できるユーザー                           |
|:-------------------------|:----------------------------------------|
| ブランチを保護する         | メンテナー以上のロール。           |
| ブランチにプッシュする       | **許可**権限を持つすべてのユーザー。(1) |
| ブランチに強制プッシュする | なし。                                 |
| ブランチを削除する        | なし。(2)                             |

1. デベロッパーロールを持つユーザーは、グループ内にプロジェクトを作成できますが、最初は[デフォルトブランチ](default.md)へのプッシュが許可されない場合があります。
1. Gitコマンドを使用しても保護ブランチを削除できるユーザーはいませんが、メンテナー以上のロールを持つユーザーは、UIまたはAPIから[保護ブランチを削除](protected.md#delete-protected-branches)できます。

これらの権限を構成する際に、ロールを選択すると、そのロールとそれより上位のロールを持つユーザーにアクセス権が付与されます。例: 

- **メンテナー**を選択すると、メンテナーとオーナーのロールを持つユーザーにアクセス権が付与されます。
- **デベロッパー + メンテナー**を選択すると、デベロッパー、メンテナー、およびオーナーのロールを持つユーザーにアクセス権が付与されます。

この動作により、より高い権限を持つユーザーは、より低い権限を持つユーザーが利用できるアクセス権を保持できます。

## 強制プッシュ権限 {#force-push-permissions}

強制プッシュ権限は、最も許可的なルールが適用されるロジックに従います。たとえば、[ワイルドカード](protected.md#use-wildcard-rules)を含む次のルールを考えてみましょう:

| ブランチ名のパターン | 強制プッシュを許可する |
|---------------------|------------------|
| `v1.x`              | はい              |
| `v1.*`              | いいえ               |
| `v*`                | いいえ               |

`v1.x`という名前のブランチは、`v1.x`、`v1.*`、`v*`の3つのブランチ名パターンすべてに一致します。動作が最も寛容なオプションにより決定されるため、ブランチ`v1.x`の結果の権限は次のようになります:

- **強制プッシュを許可する**: 3つの設定のうち`Yes`が最も寛容であるため、ブランチの動作を制御します。ブランチが`v1.x`および`v*`（それぞれより厳格な権限を持つ）にも一致した場合でも、このブランチにプッシュできるユーザーは強制プッシュも実行できます。

## コードオーナーの承認 {#code-owner-approval}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

プッシュおよびマージの権限、強制プッシュ権限とは異なり、コードオーナーの承認は最も制限の厳しいルールを使用します。ブランチが複数のルールで保護されている場合、該当するルールのいずれかで**Required approval from code owners**（コードオーナーの承認が必要）が有効になっている場合、コードオーナーの承認が必要になります。詳細については、[コードオーナーの承認を必須にする](protected.md#require-code-owner-approval)を参照してください。

たとえば、次のルールを検討してください:

| ブランチ名のパターン | コードオーナーの承認を必須にする |
|---------------------|------------------------------|
| `v1.x`              | はい                          |
| `v1.*`              | いいえ                           |
| `v*`                | いいえ                           |

`v1.x`という名前のブランチは、`v1.x`、`v1.*`、`v*`の3つのブランチ名パターンすべてに一致します。少なくとも1つのルール（`v1.x`）がコードオーナーの承認を必要とするため、このブランチへのすべてのマージリクエストは、マージする前にコードオーナーによる承認が必要です。

## グループとプロジェクトにまたがるルール {#rules-across-groups-and-projects}

ブランチ保護ルールは、グループとプロジェクトの両方で設定できます:

- グループのルールは、グループ内のすべてのプロジェクトに適用され、プロジェクト設定から変更することはできません。
- プロジェクトのルールは、その特定のプロジェクトにのみ適用されます。

あるブランチに一致するグループとプロジェクトの両方のルールが存在する場合:

- 一致するすべてのルールがまとめて評価されます。
- ほとんどの設定には、最も許可的なルールが適用されます。
- [コードオーナーの承認](#code-owner-approval)の場合、最も制限の厳しいルールが適用されます。

プロジェクト設定からグループのルールを編集または削除することはできませんが、同じブランチに追加のプロジェクトルールを追加できます。例: 

- `main`のグループルールは、強制プッシュを禁止します。
- `main`に対して強制プッシュを許可するプロジェクトルールを追加できます。
- 両方のルールが存在しますが、より許可的なプロジェクトルールが強制プッシュ設定に適用されます。

## 複数のブランチルールの例 {#multiple-branch-rule-examples}

以下の例は、さまざまなルールがブランチ保護にどのように影響するかを示しています。

### マージを許可 {#allowed-to-merge}

正確なブランチ名が、より許可的なワイルドカードパターンをオーバーライドしない例。

| ブランチパターン | マージを許可する          |
|----------------|---------------------------|
| `release-v1.0` | なし                    |
| `release*`     | メンテナー                |
| `*`            | デベロッパー + メンテナー    |

- ブランチ`release-v1.0`は3つのパターンすべてに一致します。最も許可的なルールが適用されます:
  - **マージを許可**: デベロッパー + メンテナーは（`*`ルールから）マージできます。

### プッシュとマージを許可 {#allowed-to-push-and-merge}

複数のブランチルールが異なるブランチ名にどのように適用されるかの例。

| ブランチパターン | マージを許可する       | プッシュとマージを許可する |
|----------------|------------------------|---------------------------|
| `main`         | メンテナー             | なし                    |
| `m*`           | デベロッパー + メンテナー | デベロッパー + メンテナー    |
| `r*`           | なし                 | なし                    |

- ブランチ`main`は2つのパターン（`main`と`m*`）に一致します。最も許可的なルールが適用されます:
  - **マージを許可**: デベロッパー + メンテナーは（`m*`ルールから）マージできます。
  - **プッシュとマージを許可**: デベロッパー + メンテナーは（`m*`ルールから）プッシュできます。
- ブランチ`release-v1.0`は1つのパターンに一致します:
  - **マージを許可**: （`r*`ルールから）誰もマージできません。
  - **プッシュとマージを許可**: （`r*`ルールから）誰もプッシュできません。

### コードオーナーの要件 {#code-owner-requirements}

コードオーナーの承認は、他のブランチ保護設定とは異なる方法で機能します。複数のルールが一致する場合、最も許可的なルールではなく、最も制限の厳しいルールが適用されます。

| ブランチパターン | コードオーナーの承認を必須にする |
|----------------|------------------------------|
| `production`   | はい                          |
| `prod*`        | いいえ                           |
| `p*`           | はい                          |

- ブランチ`production`は3つのパターンすべてに一致します。最も制限の厳しいルールが適用されます:
  - **コードオーナーの承認**: （`production`および`p*`ルールから）必須。
- ブランチ`product-v1.0`は2つのパターン（`prod*`と`p*`）に一致します。最も制限の厳しいルールが適用されます:
  - **コードオーナーの承認**: （`p*`ルールから）必須。

### 厳格な保護の確保 {#ensure-strict-protection}

より許可的なパターンによってオーバーライドされない厳格な保護を確保するには、一致するすべてのパターンを同じ制限設定で構成します。

| ブランチパターン | マージを許可する | プッシュとマージを許可する |
|----------------|------------------|---------------------------|
| `production`   | メンテナー       | なし                    |
| `prod*`        | メンテナー       | なし                    |
| `p*`           | メンテナー       | なし                    |
| `*`            | メンテナー       | なし                    |

現在、ブランチ`production`には制限的なプッシュ権限があります。これは、一致するすべてのルールで**なし**がプッシュできることを指定しているためです。

## 関連トピック {#related-topics}

- [保護ブランチ](protected.md)
- [保護ブランチAPI](../../../../api/protected_branches.md)
- [ブランチルール](branch_rules.md)
- [GitLabコードオーナー](../../codeowners/_index.md#code-owners-and-protected-branches)
