---
stage: ModelOps
group: MLOps
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: モデルレジストリ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.8の[実験](../../../../policy/development_stages_support.md#experiment)リリースとして`model_registry`という名前の[フラグ付き](../../../../administration/feature_flags/_index.md)で[導入](https://gitlab.com/groups/gitlab-org/-/epics/9423)されました。デフォルトでは無効になっています。この機能を有効にするために、`model_registry`という名前の[機能フラグを有効](../../../../administration/feature_flags/_index.md)にできます。
- GitLab 17.1でベータに[変更](https://gitlab.com/groups/gitlab-org/-/epics/9423)されました。
- GitLab 17.6で一般公開に[変更](https://gitlab.com/groups/gitlab-org/-/epics/14998)されました。

{{< /history >}}

機械学習モデルレジストリは、機械学習モデルのライフサイクル全体を管理するための一元化されたリポジトリとして機能します。これは、パフォーマンスメトリクス、検証結果、データリネージ情報などの重要なメタデータとともに、モデルバージョンを保存する特殊なデータベースのように機能します。

GitLabモデルレジストリを使用して以下を行います:

- 機械学習モデルを体系的に登録してバージョニングする
- パフォーマンスメトリクス、パラメータ、データリネージなどの包括的なメタデータを追跡する
- モデルバージョンを比較し、経時的な進化を監視する
- モデルの動作と要件に関する明確なドキュメントを維持する

モデルレジストリの機能と性能について詳しくは、[エピック9423](https://gitlab.com/groups/gitlab-org/-/epics/9423)をご覧ください。

## モデルレジストリへのアクセス {#access-the-model-registry}

モデルレジストリは、パッケージレジストリ設定によって制御されます。モデルレジストリを使用する前に、[パッケージレジストリが有効になっている](../../../../administration/packages/_index.md#enable-or-disable-the-package-registry)ことを確認してください。

モデルレジストリにアクセスするには、左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。

**モデルレジストリ**が使用できない場合は、有効になっていることを確認してください。

モデルレジストリを有効にするか、[表示レベル](../../../public_access.md)を公開または非公開に設定するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **一般**を選択します。
1. **可視性、プロジェクトの機能、権限**を展開します。
1. **モデルレジストリ**で、切替がオンになっていることを確認し、アクセスを許可するユーザーを選択します。モデルとモデルバージョンを変更または削除するには、少なくとも[レポーターロール](../../../permissions.md#roles)が必要です。

## UIを使用して機械学習モデルを作成する {#create-machine-learning-models-by-using-the-ui}

GitLab UIを使用して新しい機械学習モデルを作成するには、次の手順を実行します:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. **モデルレジストリ**ページで、**Create/Import**（作成/インポート）を選択します。
1. ドロップダウンで、**新しいモデルを作成**を選択します。
1. フィールドに入力します:
   - モデル名に一意の名前を入力します。
   - オプション。モデルの説明を入力します（任意）。
1. **作成**を選択します。

これで、新しく作成したモデルをモデルレジストリで表示できるようになりました。

## UIを使用してモデルバージョンを作成する {#create-a-model-version-by-using-the-ui}

新しいモデルバージョンを作成するには、次の手順を実行します:

1. モデルの詳細ページで、**新しいバージョンの作成**を選択します。
1. フィールドに入力します:
   - セマンティックバージョニングに従って、一意のバージョン番号を入力します。
   - オプション。モデルバージョンの説明を入力します（任意）。
   - モデルバージョンに関連付けられているファイル、ログ、メトリクス、またはパラメータをアップロードします。
1. **作成とインポート**を選択します。

新しいモデルバージョンがモデルレジストリで使用できるようになりました。

### モデルを削除する {#delete-a-model}

モデルとその関連するすべてのバージョンを削除するには、次の手順を実行します:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. 削除するモデルを見つけます。
1. 一番右の列で、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**モデルを削除する**を選択します。

または、モデルの詳細ページからモデルを削除することもできます:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. 削除するモデルを見つけます。
1. モデル名を選択して詳細を表示します。
1. 縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**モデルを削除する**を選択します。
1. 削除を確認します。

### モデルバージョンを削除する {#delete-a-model-version}

モデルバージョンを削除するには、次の手順を実行します:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. 削除するバージョンを含むモデルを見つけます。
1. モデル名を選択して詳細を表示します。
1. **バージョン**タブを選択します。
1. 削除するモデルバージョンを見つけます
1. 一番右の列で、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、[モデル**Delete model version**（バージョン）を削除]を選択します。

または、モデルバージョンの詳細ページからモデルを削除することもできます:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. 削除するバージョンを含むモデルを見つけます。
1. モデル名を選択して詳細を表示します。
1. **バージョン**タブを選択します。
1. バージョン名を選択して詳細を表示します。
1. 縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、[モデル**Delete model version**（バージョン）を削除]を選択します。
1. 削除を確認します。

### モデルバージョンにアーティファクトを追加する {#add-artifacts-to-a-model-version}

モデルバージョンにアーティファクトを追加するには、次の手順を実行します:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. モデルを見つけます。
1. モデル名を選択して詳細を表示します。
1. **バージョン**タブを選択します。
1. バージョン名を選択して詳細を表示します。
1. **アーティファクト**タブを選択します。
1. オプション。アップロードするファイルのサブフォルダーパスを指定します（任意）。例: `config`。
1. **select**（選択）を使用して、アップロードするファイルを選択します。
1. **アップロード**を選択します。

または、ドロップエリアにファイルをドラッグアンドドロップすることもできます。アーティファクトは自動的にアップロードされます。

各ファイルのサイズ制限は5 GBであるため、より大きなモデルをパーティション分割する必要があります。

### モデルバージョンからアーティファクトを削除する {#delete-artifacts-from-a-model-version}

バージョンのアーティファクトを削除するには、次の手順を実行します:

1. 左側のサイドバーで**デプロイ** > **モデルレジストリ**を選択します。
1. モデルを見つけます。
1. モデル名を選択して詳細を表示します。
1. **バージョン**タブを選択します。
1. バージョン名を選択して詳細を表示します。
1. **アーティファクト**タブを選択します。
1. 削除する各アーティファクトの横にあるチェックボックスをオンにします。
1. **削除**を選択します。
1. 削除を確認します。

## MLflowを使用して機械学習モデルおよびモデルバージョンを作成する {#create-machine-learning-models-and-model-versions-by-using-mlflow}

モデルとモデルバージョンは、[MLflow](https://www.mlflow.org/docs/latest/tracking.html)クライアントの互換性を使用して作成できます。モデルおよびモデルバージョンの作成および管理方法について詳しくは、[MLflowクライアントの互換性](../experiment_tracking/mlflow_client.md#model-registry)をご覧ください。モデルレジストリページで**Create Model**（モデルを作成）を選択して、GitLabでモデルを直接作成することもできます。

### MLflowを使用してアーティファクト、メトリクス、およびパラメータをモデルバージョンに追加する {#add-artifacts-metrics-and-parameters-to-a-model-version-by-using-mlflow}

ファイルは、次のいずれかを使用してモデルバージョンにアップロードできます:

- パッケージレジストリ。この場合、モデルバージョンは、名前が`<model_name>/<model_version>`のパッケージに関連付けられます。
- MLflowクライアントの互換性。[詳細](../experiment_tracking/mlflow_client.md#logging-artifacts-to-a-model-version)を参照してください。

ユーザーは、MLflowクライアントの互換性を使用してモデルバージョンのメトリクスとパラメータをログに記録できます。[詳細](../experiment_tracking/mlflow_client.md#logging-metrics-and-parameters-to-a-model-version)をご覧ください

## CI/CDジョブにモデルバージョンをリンクする {#link-a-model-version-to-a-cicd-job}

GitLab CI/CDジョブを通じてモデルバージョンを作成するとき、モデルバージョンをジョブにリンクして、ジョブのログ、マージリクエスト、パイプラインに簡単にアクセスできるようにすることができます。これは、MLflowクライアントの互換性を通じて行うことができます。[詳細](../experiment_tracking/mlflow_client.md#linking-a-model-version-to-a-cicd-job)を参照してください。

## モデルバージョンとセマンティックバージョニング {#model-versions-and-semantic-versioning}

GitLabのモデルバージョンのバージョンは、[セマンティックバージョン仕様](https://semver.org/)に従う必要があります。セマンティックバージョニングを使用すると、アプリケーションを変更せずに新しいバージョンをデプロイできるかどうかを伝えることで、モデルのデプロイが容易になります:

- **Major (integer)**（メジャー（整数））: メジャーコンポーネントの変更は、モデルに破壊的な変更があることを意味し、モデルを使用するアプリケーションは、この新しいバージョンを適切に使用するために更新する必要があります。新しいアルゴリズム、または必須の機能列の追加は、主要コンポーネントのバンプを必要とする破壊的な変更の例です。

- **Minor (integer)**（マイナー（整数））: マイナーコンポーネントの変更は、破壊的な変更ではない変更を意味し、コンシューマーは破壊的な変更なしに新しいバージョンを安全に使用できますが、その新しい機能を使用するにはコンシューマーを更新する必要がある場合があります。たとえば、デフォルト値を持つ必須ではない機能列をモデルに追加することはマイナーなバンプです。これは、追加された列の値が渡されなくても、推論は引き続き機能するためです。

- **Patch (integer)**（パッチ（整数））: パッチコンポーネントの変更は、新しいバージョンがリリースされたことを意味しますが、アプリケーションによる操作は必要ありません。たとえば、モデルの毎日の再トレーニングでは、機能セットやアプリケーションがモデルバージョンを使用する方法は変更されません。新しいパッチへの自動更新は安全な更新です。

- **Prerelease (text)**（プレリリース（テキスト））: 本番環境で使用する準備がまだできていないバージョンを表します。モデルのアルファ、ベータ、またはリリース候補バージョンを識別するために使用されます。

### モデルバージョンの例 {#model-version-examples}

- 初回リリース: 1.0.0 - 変更またはパッチのない、モデルの最初のリリース。
- 新機能: 1.1.0 - 新しい破壊的な変更ではない機能がモデルに追加され、マイナーバージョンが増加しました。
- バグ修正: 1.1.1 - モデルでバグが修正され、パッチバージョンが増加しました。
- 破壊的な変更: 2.0.0 - モデルに破壊的な変更が加えられ、メジャーバージョンが増加しました。
- パッチリリース: 2.0.1 - モデルでバグが修正され、パッチバージョンが増加しました。
- プレリリース: 2.0.1-alpha1 - アルファリリースを含む、モデルのプレリリースバージョン。
- プレリリース: 2.0.1-rc2 - モデルのリリース候補バージョン。
- 新機能: 2.1.0 - 新しい機能がモデルに追加されたため、マイナーバージョンが増加しました。
