---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンのGitLab Kubernetesエージェントトークンの暴露'
---

## 説明 {#description}

応答本文には、Kubernetes向けGitLabエージェントのトークンのパターンに一致するコンテンツが含まれていることが判明しました。Kubernetesのアクセストークンは、Kubernetesクラスタで認証するためにKubernetes向けGitLabエージェントを認証するために使用されます。悪意のある第三者がこのトークンを使用して、エージェントの設定プロジェクトのコードにアクセスしたり、GitLabインスタンス上の任意のパブリックプロジェクトのコードにアクセスしたり、非常に特定の条件下でKubernetesマニフェストを取得したりする可能性があります。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。詳細については、[Kubernetesエージェントトークンのローテーションに関するGitLabドキュメント](../../../../../user/clusters/agent/work_with_agent.md#reset-the-agent-token)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.148 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
