---
type: reference, howto
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: DASTブラウザーベースアナライザー
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- [一般提供](https://gitlab.com/groups/gitlab-org/-/epics/9023)：GitLabバージョン15.7（GitLab DAST v3.0.50）。

{{< /history >}}

{{< alert type="warning" >}}

DASTバージョン4ブラウザーベースアナライザーは、GitLabバージョン17.0でDASTバージョン5に置き換えられました。DASTバージョン5への移行方法については、[移行ガイド](../browser_based_4_to_5_migration_guide.md)を参照してください。

{{< /alert >}}

ブラウザーベースのDASTは、ウェブアプリケーションのセキュリティの脆弱性（CWE）を特定するのに役立ちます。ウェブアプリケーションをデプロイすると、新たな種類の攻撃にさらされるようになりますが、その多くはデプロイ前に検出できません。たとえば、アプリケーションサーバーの設定ミスや、セキュリティ制御に関する誤った想定は、ソースコードからは見えない可能性がありますが、ブラウザーベースのDASTで検出できます。

動的アプリケーションセキュリティテスト（DAST）は、デプロイされた環境でこのような脆弱性がないかアプリケーションを調べます。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[Dynamic Application Security Testing (DAST) - Advanced Security Testing](https://www.youtube.com/watch?v=nbeDUoLZJTo)（動的アプリケーションセキュリティテスト（DAST）- 高度なセキュリティテスト）をご覧ください。

{{< alert type="warning" >}}

本番環境サーバーに対してDASTスキャンを実行しないでください。ユーザーが実行できる機能（ボタンのクリックやフォームの送信など）を実行できるだけでなく、バグをトリガーして、本番環境データの変更や損失につながる可能性もあります。テストサーバーに対してのみDASTスキャンを実行してください。

{{< /alert >}}

DASTブラウザーベースアナライザーは、最新のウェブアプリケーションの脆弱性をスキャンするためにGitLabによって構築されました。スキャンは、シングルページアプリケーションなど、JavaScriptに大きく依存するテストアプリケーションを最適化するためにブラウザーで実行されます。詳細については、[DASTがアプリケーションをスキャンする方法](#how-dast-scans-an-application)を参照してください。

アナライザーをCI/CDパイプラインに追加するには、[アナライザーの有効化](configuration/enabling_the_analyzer.md)を参照してください。

## はじめに {#getting-started}

DASTを初めて使用する場合は、プロジェクトで有効にすることから始めてください。

前提要件: 

- Linux/amd64上で、[`docker` executor](https://docs.gitlab.com/runner/executors/docker.html)を備えた[GitLab Runner](../../../../ci/runners/_index.md)が必要です。
- デプロイされたターゲットアプリケーションが必要です。詳細については、[デプロイオプション](application_deployment_options.md)を参照してください。
- `dast`ステージが、`deploy`ステージの後、CI/CDパイプライン定義に追加されます。例: 

  ```yaml
  stages:
    - build
    - test
    - deploy
    - dast
  ```

- Runnerとターゲットアプリケーション間のネットワーク接続が必要です。

  接続方法は、DASTの設定によって異なります:
  - `DAST_TARGET_URL`と`DAST_AUTH_URL`でポート番号を指定している場合は、それらのポートを使用します。
  - ポートが指定されていない場合は、HTTPおよびHTTPSの標準ポート番号を使用します。

  HTTPとHTTPSの両方のポートを開く必要がある場合があります。たとえば、ターゲットURLがHTTPを使用しているが、アプリケーションがHTTPSを使用してリソースにリンクしている場合などです。スキャンを設定するときは、常に接続をテストしてください。

プロジェクトでDASTを有効にするには、次の手順を実行します:

- [DASTジョブをCI/CDの設定に追加します](configuration/enabling_the_analyzer.md#create-a-dast-cicd-job)。

## 結果について理解する {#understanding-the-results}

パイプラインの脆弱性を確認できます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**ビルド** > **パイプライン**を選択します。
1. パイプラインを選択します。
1. **セキュリティ**タブを選択します。
1. 脆弱性を選択して、次の詳細を表示します:
   - ステータス: 脆弱性がトリアージされたか、解決されたかを示します。
   - 説明: 脆弱性の原因、潜在的な影響、推奨される修正手順について説明しています。
   - 重大度: 影響に基づいて6つのレベルに分類されます。[重大度レベルの詳細はこちらをご覧ください](../../vulnerabilities/severities.md)。
   - スキャナー: 脆弱性を検出したアナライザーを示します。
   - 方法: 脆弱性のあるサーバーのインタラクションタイプを確立します。
   - URL: 脆弱性の場所を示します。
   - 証拠: 特定の脆弱性の存在を証明するためのテストケースについて説明します。
   - 識別子: 脆弱性の分類に使用される参照のリストです（CWE識別子など）。

セキュリティスキャンの結果をダウンロードすることもできます:

- パイプラインの**セキュリティ**タブで、**結果をダウンロード**を選択します。

詳細については、[パイプラインセキュリティレポート](../../detect/security_scanning_results.md)を参照してください。

{{< alert type="note" >}}

発見がフィーチャーブランチ上に生成されます。その発見がデフォルトブランチにマージされると、脆弱性になります。この区別は、セキュリティ対策状況を評価する上で重要です。

{{< /alert >}}

## 最適化 {#optimization}

特定のアプリケーションまたは環境に対するDASTの設定については、[設定オプション](configuration/_index.md)を参照してください。

## ロールアウトする {#roll-out}

単一のプロジェクトに対してDASTを設定した後、設定を他のプロジェクトに拡張できます:

- パイプラインが各実行で同じウェブサーバーにデプロイするように設定されている場合は注意してください。サーバーの更新中にDASTスキャンを実行すると、不正確で非決定論的な結果になる可能性があります。
- Runnerが最新バージョンのアナライザーを実行するために[常にプルポリシー](https://docs.gitlab.com/runner/executors/docker.html#using-the-always-pull-policy)を使用するように設定します。
- デフォルトでは、DASTはパイプライン内の以前のジョブで定義されたすべてのアーティファクトをダウンロードします。DASTジョブがテスト対象のURLを定義するために`environment_url.txt`に依存していない場合、または以前のジョブで作成されたその他のファイルに依存していない場合は、アーティファクトをダウンロードしないでください。アーティファクトのダウンロードを回避するには、アナライザーのCI/CDジョブを拡張して、依存関係がないように指定します。たとえば、DASTプロキシーベースアナライザーの場合は、次の内容を`.gitlab-ci.yml`ファイルに追加します:

  ```yaml
  dast:
    dependencies: []
  ```

## DASTがアプリケーションをスキャンする方法 {#how-dast-scans-an-application}

スキャンでは、次の手順を実行します:

1. 設定されている場合は、[認証](configuration/authentication.md)します。
1. [クロール](#crawling-an-application)ターゲットアプリケーションで、リンクをたどったり、ボタンをクリックしたり、フォームに入力したりするなどのユーザー操作を実行して、アプリケーションの表面領域を検出します。
1. [パッシブスキャン](#passive-scans)を実行して、クロール中に検出されたHTTPメッセージとページに脆弱性がないか検索します。
1. [アクティブスキャン](#active-scans)を実行して、クロールフェーズ中に記録されたHTTPリクエストにペイロードを挿入して脆弱性がないか検索します。

### アプリケーションのクロール {#crawling-an-application}

「ナビゲーション」とは、ボタンのクリック、アンカーリンクのクリック、メニュー項目のオープン、フォームへの入力など、ユーザーがページ上で実行する可能性のあるアクションのことです。「ナビゲーションパス」とは、ユーザーがアプリケーションをどのように移動するかを表すナビゲーションアクションのシーケンスのことです。DASTは、ページとコンテンツをクロールし、ナビゲーションパスを特定することで、アプリケーションの表面領域を検出します。

クロールは、特別に計測されたChromiumブラウザーでターゲットアプリケーションURLを読み込む1つのナビゲーションを含むナビゲーションパスで初期化されます。DASTは、すべてがクロールされるまでナビゲーションパスをクロールします。

ナビゲーションパスをクロールするために、DASTはブラウザーウィンドウを開き、ナビゲーションパス内のすべてのナビゲーションアクションを実行するように指示します。ブラウザーが最後のアクションの結果の読み込みを終了すると、DASTはページを調べて、ユーザーが実行できるアクションを探し、見つかったアクションごとに新しいナビゲーションを作成し、それらをナビゲーションパスに追加して、新しいナビゲーションパスを形成します。例: 

1. DASTはナビゲーションパスを処理します`LoadURL[https://example.com]`。
1. DASTは2つのユーザーアクション、`LeftClick[class=menu]`および`LeftClick[id=users]`を見つけます。
1. DASTは2つの新しいナビゲーションパス、`LoadURL[https://example.com] -> LeftClick[class=menu]`および`LoadURL[https://example.com] -> LeftClick[id=users]`を作成します。
1. 2つの新しいナビゲーションパスでクロールが開始されます。

HTML要素が、すべてのページに表示されるメニューなど、アプリケーション内の複数の場所に存在することは一般的です。重複する要素があると、クローラーが同じページを再度クロールしたり、ループに陥ったりする可能性があります。DASTは、HTML属性に基づいて要素の一意性を計算し、以前にクロールした新しいナビゲーションアクションを破棄します。

### パッシブスキャン {#passive-scans}

パッシブスキャンは、スキャンのクロールフェーズ中に検出されたページに脆弱性がないかチェックします。パッシブスキャンは、通常のユーザーと同じ方法でサイトと対話しようと試みます。データ削除などの破壊的なアクションの実行も含まれます。ただし、パッシブスキャンは敵対的な動作をシミュレートしません。パッシブスキャンは、デフォルトで有効になっています。

チェックでは、HTTPメッセージ、Cookie、ストレージイベント、コンソールイベント、およびDOMに脆弱性がないか検索します。パッシブチェックの例としては、公開されているクレジットカード、公開されているシークレットトークン、コンテンツセキュリティポリシーの欠落、信頼できない場所へのリダイレクトの検索などがあります。

個々のチェックの詳細については、[チェック](checks/_index.md)を参照してください。

### アクティブスキャン {#active-scans}

アクティブスキャンは、スキャンのクロールフェーズ中に記録されたHTTPリクエストに攻撃ペイロードを挿入して脆弱性がないかチェックします。アクティブスキャンは、敵対的な動作をシミュレートするため、デフォルトで無効になっています。

DASTは、クエリ値、ヘッダー値、Cookie値、フォームポスト、JSON文字列値など、挿入場所がないか記録された各HTTPリクエストを分析します。攻撃ペイロードは挿入場所に挿入され、新しいリクエストを形成します。DASTはターゲットアプリケーションにリクエストを送信し、HTTP応答を使用して攻撃の成功を判断します。

アクティブスキャンは、2種類のアクティブチェックを実行します:

- 一致応答攻撃は、応答コンテンツを分析して攻撃の成功を判断します。たとえば、攻撃がシステムパスワードファイルの読み取りを試みる場合、応答本文にパスワードファイルの証拠が含まれている場合に、ファインディングが作成されます。
- タイミング攻撃は、応答時間を使用して攻撃の成功を判断します。たとえば、攻撃がターゲットアプリケーションを強制的にスリープさせようとする場合、アプリケーションがスリープ時間よりも長く応答した場合に、ファインディングが作成されます。タイミング攻撃は、誤検出を最小限に抑えるために、異なる攻撃ペイロードで複数回繰り返されます。

簡略化されたタイミング攻撃は、次のように機能します:

1. クロールフェーズは、HTTPリクエスト`https://example.com?search=people`を記録します。
1. DASTはURLを分析し、URLパラメータ挿入場所`https://example.com?search=[INJECT]`を見つけます。
1. アクティブチェックは、Linuxホストをスリープさせようとするペイロード`sleep 10`を定義します。
1. DASTは、挿入されたペイロード`https://example.com?search=sleep%2010`を使用して、ターゲットアプリケーションに新しいHTTPリクエストを送信します。
1. ターゲットアプリケーションが、検証なしにシステムコマンドとしてクエリパラメータ値を実行する場合、たとえば、`system(params[:search])`の場合、ターゲットアプリケーションは脆弱です。
1. 応答時間が10秒を超えると、DASTはファインディングを作成します。
