/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import io.sf.carte.doc.StringList;
import io.sf.carte.doc.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.UnaryOperator;

public class WrapperStringList
implements StringList,
Iterable<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<String> collection;

    public WrapperStringList(Collection<String> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.collection = c;
    }

    @Override
    public String item(int index) {
        if (index >= 0 && index < this.collection.size()) {
            return this.get(index);
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public boolean contains(String str) {
        return this.collection.contains(str);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public Iterator<String> iterator() {
        return new UnmodifiableIterator<String>(this.collection.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    @Override
    public boolean add(String e) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void replaceAll(UnaryOperator<String> operator) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void sort(Comparator<? super String> c) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public String get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        int i = 0;
        for (String s : this.collection) {
            if (i == index) {
                return s;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public String set(int index, String element) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void add(int index, String element) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public String remove(int index) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        for (String s : this.collection) {
            if (o == s) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = 0;
        int last = -1;
        for (String s : this.collection) {
            if (o == s) {
                last = i;
            }
            ++i;
        }
        return last;
    }

    @Override
    public ListIterator<String> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public StringList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        String[] a = this.collection.toArray(new String[0]);
        a = Arrays.copyOfRange(a, fromIndex, toIndex);
        return new WrapperStringList(Collections.unmodifiableList(Arrays.asList(a)));
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.collection.spliterator();
    }

    @Override
    public WrapperStringList clone() {
        return new WrapperStringList(this);
    }
}

