# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## IsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit
InstallMethod( AddIsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject
InstallMethod( AddIsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromLeftInternalCoHomToObject
InstallMethod( AddIsomorphismFromLeftInternalCoHomToObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftInternalCoHomToObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftInternalCoHomToObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftInternalCoHomToObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom
InstallMethod( AddIsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom,
                    "IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom by calling IsomorphismFromLeftInternalCoHomToObject with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromLeftInternalCoHomToObject, 1 ],
                    ],
  function( cat, a, s )
    
    return IsomorphismFromLeftInternalCoHomToObject( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromLeftInternalCoHomToObject,
                    "IsomorphismFromLeftInternalCoHomToObject by calling IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom, 1 ],
                        [ LeftInternalCoHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom( cat, a, LeftInternalCoHomOnObjects( cat, a, TensorUnit( cat ) ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromObjectToLeftInternalCoHom
InstallMethod( AddIsomorphismFromObjectToLeftInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToLeftInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToLeftInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToLeftInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom
InstallMethod( AddIsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom,
                    "IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom by calling IsomorphismFromObjectToLeftInternalCoHom with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromObjectToLeftInternalCoHom, 1 ],
                    ],
  function( cat, a, r )
    
    return IsomorphismFromObjectToLeftInternalCoHom( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromObjectToLeftInternalCoHom,
                    "IsomorphismFromObjectToLeftInternalCoHom by calling IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom, 1 ],
                        [ LeftInternalCoHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom( cat, a, LeftInternalCoHomOnObjects( cat, a, TensorUnit( cat ) ) );
    
end : is_with_given_derivation := true );

## LeftCoDualOnMorphisms
InstallMethod( AddLeftCoDualOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoDualOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddLeftCoDualOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoDualOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoDualOnMorphismsWithGivenLeftCoDuals
InstallMethod( AddLeftCoDualOnMorphismsWithGivenLeftCoDuals,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoDualOnMorphismsWithGivenLeftCoDuals", category, func, -1 );
    
end );

InstallMethod( AddLeftCoDualOnMorphismsWithGivenLeftCoDuals,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoDualOnMorphismsWithGivenLeftCoDuals", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoDualOnMorphismsWithGivenLeftCoDuals,
                    "LeftCoDualOnMorphismsWithGivenLeftCoDuals by calling LeftCoDualOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoDualOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, r )
    
    return LeftCoDualOnMorphisms( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoDualOnMorphisms,
                    "LeftCoDualOnMorphisms by calling LeftCoDualOnMorphismsWithGivenLeftCoDuals with the WithGiven object(s)",
                    [
                        [ LeftCoDualOnMorphismsWithGivenLeftCoDuals, 1 ],
                        [ LeftCoDualOnObjects, 2 ],
                    ],
  function( cat, alpha )
    
    return LeftCoDualOnMorphismsWithGivenLeftCoDuals( cat, LeftCoDualOnObjects( cat, Range( alpha ) ), alpha, LeftCoDualOnObjects( cat, Source( alpha ) ) );
    
end : is_with_given_derivation := true );

## LeftCoDualOnObjects
InstallMethod( AddLeftCoDualOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoDualOnObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftCoDualOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoDualOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoDualityTensorProductCompatibilityMorphism
InstallMethod( AddLeftCoDualityTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoDualityTensorProductCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftCoDualityTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoDualityTensorProductCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects
InstallMethod( AddLeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects,
                    "LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects by calling LeftCoDualityTensorProductCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoDualityTensorProductCompatibilityMorphism, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return LeftCoDualityTensorProductCompatibilityMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoDualityTensorProductCompatibilityMorphism,
                    "LeftCoDualityTensorProductCompatibilityMorphism by calling LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects, 1 ],
                        [ LeftCoDualOnObjects, 3 ],
                        [ TensorProductOnObjects, 2 ],
                    ],
  function( cat, a, b )
    
    return LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects( cat, LeftCoDualOnObjects( cat, TensorProductOnObjects( cat, a, b ) ), a, b, TensorProductOnObjects( cat, LeftCoDualOnObjects( cat, a ), LeftCoDualOnObjects( cat, b ) ) );
    
end : is_with_given_derivation := true );

## LeftCoclosedMonoidalCoevaluationMorphism
InstallMethod( AddLeftCoclosedMonoidalCoevaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalCoevaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalCoevaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalCoevaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource
InstallMethod( AddLeftCoclosedMonoidalCoevaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalCoevaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource,
                    "LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource by calling LeftCoclosedMonoidalCoevaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoclosedMonoidalCoevaluationMorphism, 1 ],
                    ],
  function( cat, a, b, s )
    
    return LeftCoclosedMonoidalCoevaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoclosedMonoidalCoevaluationMorphism,
                    "LeftCoclosedMonoidalCoevaluationMorphism by calling LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource with the WithGiven object(s)",
                    [
                        [ LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource, 1 ],
                        [ LeftInternalCoHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource( cat, a, b, LeftInternalCoHomOnObjects( cat, TensorProductOnObjects( cat, b, a ), a ) );
    
end : is_with_given_derivation := true );

## LeftCoclosedMonoidalEvaluationForLeftCoDual
InstallMethod( AddLeftCoclosedMonoidalEvaluationForLeftCoDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalEvaluationForLeftCoDual", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalEvaluationForLeftCoDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalEvaluationForLeftCoDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct
InstallMethod( AddLeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct,
                    "LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct by calling LeftCoclosedMonoidalEvaluationForLeftCoDual with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoclosedMonoidalEvaluationForLeftCoDual, 1 ],
                    ],
  function( cat, s, a, r )
    
    return LeftCoclosedMonoidalEvaluationForLeftCoDual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoclosedMonoidalEvaluationForLeftCoDual,
                    "LeftCoclosedMonoidalEvaluationForLeftCoDual by calling LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct, 1 ],
                        [ TensorUnit, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftCoDualOnObjects, 1 ],
                    ],
  function( cat, a )
    
    return LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct( cat, TensorUnit( cat ), a, TensorProductOnObjects( cat, LeftCoDualOnObjects( cat, a ), a ) );
    
end : is_with_given_derivation := true );

## LeftCoclosedMonoidalEvaluationMorphism
InstallMethod( AddLeftCoclosedMonoidalEvaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalEvaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalEvaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalEvaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalEvaluationMorphismWithGivenRange
InstallMethod( AddLeftCoclosedMonoidalEvaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalEvaluationMorphismWithGivenRange", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalEvaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalEvaluationMorphismWithGivenRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoclosedMonoidalEvaluationMorphismWithGivenRange,
                    "LeftCoclosedMonoidalEvaluationMorphismWithGivenRange by calling LeftCoclosedMonoidalEvaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoclosedMonoidalEvaluationMorphism, 1 ],
                    ],
  function( cat, a, b, r )
    
    return LeftCoclosedMonoidalEvaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoclosedMonoidalEvaluationMorphism,
                    "LeftCoclosedMonoidalEvaluationMorphism by calling LeftCoclosedMonoidalEvaluationMorphismWithGivenRange with the WithGiven object(s)",
                    [
                        [ LeftCoclosedMonoidalEvaluationMorphismWithGivenRange, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftInternalCoHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return LeftCoclosedMonoidalEvaluationMorphismWithGivenRange( cat, a, b, TensorProductOnObjects( cat, LeftInternalCoHomOnObjects( cat, b, a ), a ) );
    
end : is_with_given_derivation := true );

## LeftCoclosedMonoidalLambdaElimination
InstallMethod( AddLeftCoclosedMonoidalLambdaElimination,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalLambdaElimination", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalLambdaElimination,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalLambdaElimination", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalLambdaIntroduction
InstallMethod( AddLeftCoclosedMonoidalLambdaIntroduction,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalLambdaIntroduction", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalLambdaIntroduction,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalLambdaIntroduction", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalPostCoComposeMorphism
InstallMethod( AddLeftCoclosedMonoidalPostCoComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalPostCoComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalPostCoComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalPostCoComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects
InstallMethod( AddLeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects,
                    "LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects by calling LeftCoclosedMonoidalPostCoComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoclosedMonoidalPostCoComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return LeftCoclosedMonoidalPostCoComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoclosedMonoidalPostCoComposeMorphism,
                    "LeftCoclosedMonoidalPostCoComposeMorphism by calling LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects, 1 ],
                        [ LeftInternalCoHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects( cat, LeftInternalCoHomOnObjects( cat, a, c ), a, b, c, TensorProductOnObjects( cat, LeftInternalCoHomOnObjects( cat, a, b ), LeftInternalCoHomOnObjects( cat, b, c ) ) );
    
end : is_with_given_derivation := true );

## LeftCoclosedMonoidalPreCoComposeMorphism
InstallMethod( AddLeftCoclosedMonoidalPreCoComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalPreCoComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalPreCoComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalPreCoComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects
InstallMethod( AddLeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects,
                    "LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects by calling LeftCoclosedMonoidalPreCoComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftCoclosedMonoidalPreCoComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return LeftCoclosedMonoidalPreCoComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftCoclosedMonoidalPreCoComposeMorphism,
                    "LeftCoclosedMonoidalPreCoComposeMorphism by calling LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects, 1 ],
                        [ LeftInternalCoHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b, c )
    
    return LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects( cat, LeftInternalCoHomOnObjects( cat, a, c ), a, b, c, TensorProductOnObjects( cat, LeftInternalCoHomOnObjects( cat, b, c ), LeftInternalCoHomOnObjects( cat, a, b ) ) );
    
end : is_with_given_derivation := true );

## LeftInternalCoHomOnMorphisms
InstallMethod( AddLeftInternalCoHomOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms
InstallMethod( AddLeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms,
                    "LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms by calling LeftInternalCoHomOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ LeftInternalCoHomOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, beta, r )
    
    return LeftInternalCoHomOnMorphisms( cat, alpha, beta );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftInternalCoHomOnMorphisms,
                    "LeftInternalCoHomOnMorphisms by calling LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms with the WithGiven object(s)",
                    [
                        [ LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms, 1 ],
                        [ LeftInternalCoHomOnObjects, 2 ],
                    ],
  function( cat, alpha, beta )
    
    return LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms( cat, LeftInternalCoHomOnObjects( cat, Source( alpha ), Range( beta ) ), alpha, beta, LeftInternalCoHomOnObjects( cat, Range( alpha ), Source( beta ) ) );
    
end : is_with_given_derivation := true );

## LeftInternalCoHomOnObjects
InstallMethod( AddLeftInternalCoHomOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomOnObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalCoHomTensorProductCompatibilityMorphism
InstallMethod( AddLeftInternalCoHomTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomTensorProductCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomTensorProductCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomTensorProductCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects
InstallMethod( AddLeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects,
                    "LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects by calling LeftInternalCoHomTensorProductCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftInternalCoHomTensorProductCompatibilityMorphism, 1 ],
                    ],
  function( cat, source, list, range )
    
    return LeftInternalCoHomTensorProductCompatibilityMorphism( cat, list );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftInternalCoHomTensorProductCompatibilityMorphism,
                    "LeftInternalCoHomTensorProductCompatibilityMorphism by calling LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects, 1 ],
                        [ LeftInternalCoHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 3 ],
                    ],
  function( cat, list )
    
    return LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects( cat, LeftInternalCoHomOnObjects( cat, TensorProductOnObjects( cat, list[1], list[2] ), TensorProductOnObjects( cat, list[3], list[4] ) ), list, TensorProductOnObjects( cat, LeftInternalCoHomOnObjects( cat, list[1], list[3] ), LeftInternalCoHomOnObjects( cat, list[2], list[4] ) ) );
    
end : is_with_given_derivation := true );

## LeftInternalCoHomToTensorProductAdjunctMorphism
InstallMethod( AddLeftInternalCoHomToTensorProductAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomToTensorProductAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomToTensorProductAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomToTensorProductAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct
InstallMethod( AddLeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct,
                    "LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct by calling LeftInternalCoHomToTensorProductAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftInternalCoHomToTensorProductAdjunctMorphism, 1 ],
                    ],
  function( cat, a, c, f, t )
    
    return LeftInternalCoHomToTensorProductAdjunctMorphism( cat, a, c, f );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftInternalCoHomToTensorProductAdjunctMorphism,
                    "LeftInternalCoHomToTensorProductAdjunctMorphism by calling LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, c, f )
    
    return LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct( cat, a, c, f, TensorProductOnObjects( cat, Range( f ), c ) );
    
end : is_with_given_derivation := true );

## MorphismFromLeftCoBidual
InstallMethod( AddMorphismFromLeftCoBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromLeftCoBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromLeftCoBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromLeftCoBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromLeftCoBidualWithGivenLeftCoBidual
InstallMethod( AddMorphismFromLeftCoBidualWithGivenLeftCoBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromLeftCoBidualWithGivenLeftCoBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromLeftCoBidualWithGivenLeftCoBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromLeftCoBidualWithGivenLeftCoBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromLeftCoBidualWithGivenLeftCoBidual,
                    "MorphismFromLeftCoBidualWithGivenLeftCoBidual by calling MorphismFromLeftCoBidual with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromLeftCoBidual, 1 ],
                    ],
  function( cat, a, s )
    
    return MorphismFromLeftCoBidual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromLeftCoBidual,
                    "MorphismFromLeftCoBidual by calling MorphismFromLeftCoBidualWithGivenLeftCoBidual with the WithGiven object(s)",
                    [
                        [ MorphismFromLeftCoBidualWithGivenLeftCoBidual, 1 ],
                        [ LeftCoDualOnObjects, 2 ],
                    ],
  function( cat, a )
    
    return MorphismFromLeftCoBidualWithGivenLeftCoBidual( cat, a, LeftCoDualOnObjects( cat, LeftCoDualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );

## MorphismFromLeftInternalCoHomToTensorProduct
InstallMethod( AddMorphismFromLeftInternalCoHomToTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromLeftInternalCoHomToTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromLeftInternalCoHomToTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromLeftInternalCoHomToTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects
InstallMethod( AddMorphismFromLeftInternalCoHomToTensorProductWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromLeftInternalCoHomToTensorProductWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects,
                    "MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects by calling MorphismFromLeftInternalCoHomToTensorProduct with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromLeftInternalCoHomToTensorProduct, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return MorphismFromLeftInternalCoHomToTensorProduct( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromLeftInternalCoHomToTensorProduct,
                    "MorphismFromLeftInternalCoHomToTensorProduct by calling MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects, 1 ],
                        [ LeftInternalCoHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftCoDualOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects( cat, LeftInternalCoHomOnObjects( cat, a, b ), a, b, TensorProductOnObjects( cat, LeftCoDualOnObjects( cat, b ), a ) );
    
end : is_with_given_derivation := true );

## TensorProductToLeftInternalCoHomAdjunctMorphism
InstallMethod( AddTensorProductToLeftInternalCoHomAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToLeftInternalCoHomAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToLeftInternalCoHomAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToLeftInternalCoHomAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom
InstallMethod( AddTensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom,
                    "TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom by calling TensorProductToLeftInternalCoHomAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToLeftInternalCoHomAdjunctMorphism, 1 ],
                    ],
  function( cat, b, c, g, i )
    
    return TensorProductToLeftInternalCoHomAdjunctMorphism( cat, b, c, g );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToLeftInternalCoHomAdjunctMorphism,
                    "TensorProductToLeftInternalCoHomAdjunctMorphism by calling TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom with the WithGiven object(s)",
                    [
                        [ TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom, 1 ],
                        [ LeftInternalCoHomOnObjects, 1 ],
                    ],
  function( cat, b, c, g )
    
    return TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom( cat, b, c, g, LeftInternalCoHomOnObjects( cat, Source( g ), c ) );
    
end : is_with_given_derivation := true );

## UniversalPropertyOfLeftCoDual
InstallMethod( AddUniversalPropertyOfLeftCoDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalPropertyOfLeftCoDual", category, func, -1 );
    
end );

InstallMethod( AddUniversalPropertyOfLeftCoDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalPropertyOfLeftCoDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);
