/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.layout;

import java.util.Collection;
import java.util.function.Function;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildNodesLayout;
import org.freeplane.api.ChildrenSides;
import org.freeplane.api.LayoutOrientation;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.layout.LayoutBuilder;
import org.freeplane.features.layout.LayoutModel;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class LayoutController
implements IExtension {
    private static final String AUTOMATIC_SIDE_DISTRIBUTION_OPTION_NAME = "automaticSideDistribution";
    private final ExclusivePropertyChain<ChildNodesLayout, NodeModel> childrenLayoutHandlers;
    private final ModeController modeController = Controller.getCurrentModeController();
    public static final boolean[] BOTH_SIDES = new boolean[]{true, false};
    public static final boolean[] LEFT_SIDE = new boolean[]{true};
    public static final boolean[] RIGHT_SIDE = new boolean[]{false};

    public static LayoutController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return LayoutController.getController(modeController);
    }

    public static LayoutController getController(ModeController modeController) {
        return modeController.getExtension(LayoutController.class);
    }

    public static void install(LayoutController layoutController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(LayoutController.class, layoutController);
    }

    public LayoutController() {
        MapController mapController = this.modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        layoutBuilder.registerBy(readManager, writeManager);
        this.childrenLayoutHandlers = new ExclusivePropertyChain();
        this.childrenLayoutHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<ChildNodesLayout, NodeModel>(){

            @Override
            public ChildNodesLayout getProperty(NodeModel node, LogicalStyleController.StyleOption option, ChildNodesLayout currentValue) {
                ChildNodesLayout returnedAlignment = (ChildNodesLayout)LayoutController.this.getLayoutProperty(node, LayoutModel::getChildNodesLayout, ChildNodesLayout.NOT_SET);
                return returnedAlignment;
            }
        });
        this.childrenLayoutHandlers.addGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<ChildNodesLayout, NodeModel>(){

            @Override
            public ChildNodesLayout getProperty(NodeModel node, LogicalStyleController.StyleOption option, ChildNodesLayout currentValue) {
                return ChildNodesLayout.AUTO;
            }
        });
    }

    private <V> V getLayoutProperty(NodeModel node, Function<LayoutModel, V> getter, V defaultValue) {
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> styleKeys = styleController.getStyles(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        MapModel map = node.getMap();
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            V value;
            LayoutModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = styleNode.getExtension(LayoutModel.class)) == null || (value = getter.apply(styleModel)) == defaultValue) continue;
            return value;
        }
        return null;
    }

    public ChildNodesAlignment getChildNodesAlignment(NodeModel node) {
        return this.getEffectiveChildNodesLayout(node).childNodesAlignment();
    }

    public LayoutOrientation getLayoutOrientation(NodeModel node) {
        return this.getEffectiveChildNodesLayout(node).layoutOrientation();
    }

    public ChildNodesLayout getEffectiveChildNodesLayout(NodeModel node) {
        ChildNodesLayout layout = this.getChildNodesLayout(node);
        if (node.isRoot() && layout.childNodesAlignment() == ChildNodesAlignment.STACKED_AUTO) {
            return ChildNodesLayout.LEFTTORIGHT_BOTHSIDES_CENTERED;
        }
        return layout;
    }

    public ChildNodesLayout getChildNodesLayout(NodeModel node) {
        ChildNodesLayout layout = this.childrenLayoutHandlers.getProperty(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        return layout;
    }

    public void withNodeChangeEventOnLayoutChange(NodeModel node, Runnable runnable) {
        ChildNodesLayout oldLayout = this.getChildNodesLayout(node);
        runnable.run();
        ChildNodesLayout newLayout = this.getChildNodesLayout(node);
        if (oldLayout != newLayout) {
            Controller.getCurrentModeController().getMapController().refreshNodeLaterUndoable(node, ChildNodesLayout.class, oldLayout, newLayout);
        }
    }

    public LayoutOrientation getEffectiveLayoutOrientation(NodeModel node) {
        LayoutOrientation layoutOrientation = this.getLayoutOrientation(node);
        switch (layoutOrientation) {
            case TOP_TO_BOTTOM: 
            case LEFT_TO_RIGHT: {
                return layoutOrientation;
            }
        }
        NodeModel parentNode = node.getParentNode();
        if (parentNode != null) {
            return this.getEffectiveLayoutOrientation(parentNode);
        }
        return LayoutOrientation.TOP_TO_BOTTOM;
    }

    private boolean isTopOrLeft(NodeModel node, NodeModel root) {
        NodeModel.Side side;
        NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return false;
        }
        ChildrenSides childrenSides = this.getEffectiveChildNodesLayout(parentNode).childrenSides();
        switch (childrenSides) {
            case NOT_SET: 
            case DIAGONAL_ASCENDING: 
            case DIAGONAL_DESCENDING: 
            case AUTO: {
                break;
            }
            case BOTH_SIDES: {
                side = node.getSide();
                if (side == NodeModel.Side.TOP_OR_LEFT) {
                    return true;
                }
                if (side != NodeModel.Side.BOTTOM_OR_RIGHT) break;
                return false;
            }
            case BOTTOM_OR_RIGHT: {
                return false;
            }
            case TOP_OR_LEFT: {
                return true;
            }
        }
        if (parentNode == root) {
            side = node.getSide();
            if (side != NodeModel.Side.DEFAULT) {
                return side == NodeModel.Side.TOP_OR_LEFT;
            }
            return parentNode.isTopOrLeft(parentNode.getMap().getRootNode());
        }
        return childrenSides == ChildrenSides.DIAGONAL_ASCENDING != this.isTopOrLeft(parentNode, root);
    }

    public NodeModel.Side suggestNewChildSide(NodeModel parent, NodeModel root) {
        int childCount;
        if (parent != root || !ResourceController.getResourceController().getBooleanProperty(AUTOMATIC_SIDE_DISTRIBUTION_OPTION_NAME)) {
            return NodeModel.Side.DEFAULT;
        }
        int rightChildrenCount = 0;
        int childCountInTree = childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeModel child = parent.getChildAt(i);
            if (child.isHiddenSummary() || FreeNode.isFreeNode(child)) {
                --childCountInTree;
            } else if (!this.isTopOrLeft(child, parent)) {
                ++rightChildrenCount;
            }
            if (rightChildrenCount <= childCountInTree / 2) continue;
            return NodeModel.Side.TOP_OR_LEFT;
        }
        return NodeModel.Side.BOTTOM_OR_RIGHT;
    }

    public boolean[] sidesOf(NodeModel parentNode, NodeModel root) {
        if (parentNode == root) {
            return BOTH_SIDES;
        }
        ChildrenSides childrenSides = this.getEffectiveChildNodesLayout(parentNode).childrenSides();
        switch (childrenSides) {
            case BOTTOM_OR_RIGHT: {
                return RIGHT_SIDE;
            }
            case TOP_OR_LEFT: {
                return LEFT_SIDE;
            }
            case DIAGONAL_ASCENDING: 
            case DIAGONAL_DESCENDING: 
            case BOTH_SIDES: {
                return BOTH_SIDES;
            }
        }
        return parentNode.isTopOrLeft(root) ? LEFT_SIDE : RIGHT_SIDE;
    }
}

