/**
 * @file
 * Defines JavaScript behaviors for the block_content module.
 */

(function ($, Drupal) {
  /**
   * Sets summaries about revision and translation of entities.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches summary behavior entity form tabs.
   *
   *   Specifically, it updates summaries to the revision information and the
   *   translation options.
   */
  Drupal.behaviors.entityContentDetailsSummaries = {
    attach(context) {
      const $context = $(context);
      $context
        .find('.entity-content-form-revision-information')
        .drupalSetSummary((context) => {
          const $revisionContext = $(context);
          const revisionCheckbox = $revisionContext.find(
            '.js-form-item-revision input',
          );

          // Return 'New revision' if the 'Create new revision' checkbox is checked,
          // or if the checkbox doesn't exist, but the revision log does. For users
          // without the "Administer content" permission the checkbox won't appear,
          // but the revision log will if the content type is set to auto-revision.
          if (
            (revisionCheckbox.length && revisionCheckbox[0].checked) ||
            (!revisionCheckbox.length &&
              $revisionContext.find('.js-form-item-revision-log textarea')
                .length)
          ) {
            return Drupal.t('New revision');
          }

          return Drupal.t('No revision');
        });

      $context
        .find('details.entity-translation-options')
        .drupalSetSummary((context) => {
          const $translationContext = $(context);
          let translate;
          let $checkbox = $translationContext.find(
            '.js-form-item-translation-translate input',
          );

          if ($checkbox.length) {
            translate = $checkbox[0].checked
              ? Drupal.t('Needs to be updated')
              : Drupal.t('Does not need to be updated');
          } else {
            $checkbox = $translationContext.find(
              '.js-form-item-translation-retranslate input',
            );
            translate = $checkbox[0]?.checked
              ? Drupal.t('Flag other translations as outdated')
              : Drupal.t('Do not flag other translations as outdated');
          }

          return translate;
        });
    },
  };
})(jQuery, Drupal);
