/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.Pair;

final class SQLCommentScanner
implements Iterator<String> {
    private final String sql;
    private final String mlStart;
    private final String mlEnd;
    private final String[] slTokens;
    private int pos = 0;
    private String nextComment;

    SQLCommentScanner(@Nullable Pair<String, String> mlComments, @Nullable String[] slTokens, @NotNull String sql) {
        this.mlStart = mlComments != null ? (String)mlComments.getFirst() : null;
        this.mlEnd = mlComments != null ? (String)mlComments.getSecond() : null;
        this.slTokens = slTokens != null ? slTokens : new String[]{};
        this.sql = sql;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextComment != null;
    }

    @Override
    public String next() {
        if (this.nextComment == null) {
            throw new NoSuchElementException();
        }
        String result = this.nextComment;
        this.advance();
        return result;
    }

    private void advance() {
        this.nextComment = null;
        int len = this.sql.length();
        while (this.pos < len) {
            if (this.mlStart != null && this.sql.startsWith(this.mlStart, this.pos)) {
                int end;
                this.pos += this.mlStart.length();
                int n = end = this.mlEnd == null ? -1 : this.sql.indexOf(this.mlEnd, this.pos);
                if (end < 0) {
                    this.nextComment = this.sql.substring(this.pos).trim();
                    this.pos = len;
                } else {
                    this.nextComment = this.sql.substring(this.pos, end).trim();
                    this.pos = end + this.mlEnd.length();
                }
                return;
            }
            String slToken = SQLCommentScanner.findSingleLineToken(this.sql, this.pos, this.slTokens);
            if (slToken != null) {
                this.pos += slToken.length();
                int eol = SQLCommentScanner.findEol(this.sql, this.pos);
                this.nextComment = this.sql.substring(this.pos, eol).trim();
                this.pos = eol < len ? eol + 1 : len;
                return;
            }
            ++this.pos;
        }
    }

    private static String findSingleLineToken(String sql, int offset, String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.isEmpty() && sql.startsWith(token, offset)) {
                return token;
            }
            ++n2;
        }
        return null;
    }

    private static int findEol(String sql, int offset) {
        int nl = sql.indexOf(10, offset);
        return nl == -1 ? sql.length() : nl;
    }
}

