# Incident Response Process for **resolve**

## Reporting a Vulnerability

We take the security of **resolve** very seriously. If you believe you’ve found a security vulnerability, please inform us responsibly through coordinated disclosure.

### How to Report

> **Do not** report security vulnerabilities through public GitHub issues, discussions, or social media.

Instead, please use one of these secure channels:

1. **GitHub Security Advisories**
   Use the **Report a vulnerability** button in the Security tab of the [browserify/resolve repository](https://github.com/browserify/resolve).

2. **Email**
   Follow the posted [Security Policy](https://github.com/browserify/resolve/security/policy).

### What to Include

**Required Information:**
- Brief description of the vulnerability type
- Affected version(s) and components
- Steps to reproduce the issue
- Impact assessment (what an attacker could achieve)
- Confirm the issue is not present in test files (in other words, only via the official entry points in `exports`)

**Helpful Additional Details:**
- Full paths of affected source files
- Specific commit or branch where the issue exists
- Required configuration to reproduce
- Proof-of-concept code (if available)
- Suggested mitigation or fix

## Our Response Process

**Timeline Commitments:**
- **Initial acknowledgment**: Within 24 hours
- **Detailed response**: Within 3 business days
- **Status updates**: Every 7 days until resolved
- **Resolution target**: 90 days for most issues

**What We’ll Do:**
1. Acknowledge your report and assign a tracking ID
2. Assess the vulnerability and determine severity
3. Develop and test a fix
4. Coordinate disclosure timeline with you
5. Release a security update and publish an advisory and CVE
6. Credit you in our security advisory (if desired)

## Disclosure Policy

- **Coordinated disclosure**: We’ll work with you on timing
- **Typical timeline**: 90 days from report to public disclosure
- **Early disclosure**: If actively exploited
- **Delayed disclosure**: For complex issues

## Scope

**In Scope:**
- **resolve** package (all supported versions)
- Official examples and documentation
- Core resolution APIs
- Dependencies with direct security implications

**Out of Scope:**
- Third-party wrappers or extensions
- Bundler-specific integrations
- Social engineering or physical attacks
- Theoretical vulnerabilities without practical exploitation
- Issues in non-production files

## Security Measures

**Our Commitments:**
- Regular vulnerability scanning via `npm audit`
- Automated security checks in CI/CD (GitHub Actions)
- Secure coding practices and mandatory code review
- Prompt patch releases for critical issues

**User Responsibilities:**
- Keep **resolve** updated
- Monitor dependency vulnerabilities
- Follow secure configuration guidelines for module resolution

## Legal Safe Harbor

**We will NOT:**
- Initiate legal action
- Contact law enforcement
- Suspend or terminate your access

**You must:**
- Only test against your own installations
- Not access, modify, or delete user data
- Not degrade service availability
- Not publicly disclose before coordinated disclosure
- Act in good faith

## Recognition

- **Advisory Credits**: Credit in GitHub Security Advisories (unless anonymous)

## Security Updates

**Stay Informed:**
- Subscribe to npm updates for **resolve**
- Enable GitHub Security Advisory notifications

**Update Process:**
- Patch releases (e.g., 1.22.10 → 1.22.11)
- Out-of-band releases for critical issues
- Advisories via GitHub Security Advisories

## Contact Information

- **Security reports**: Security tab of [browserify/resolve](https://github.com/browserify/resolve/security)
- **General inquiries**: GitHub Discussions or Issues

